head	1.17;
access;
symbols;
locks;
comment	@ * @;


1.17
date	93.05.06.10.11.26;	author karn;	state Exp;
branches;
next	1.16;

1.16
date	93.02.22.00.48.44;	author karn;	state Exp;
branches;
next	1.15;

1.15
date	93.01.02.08.23.18;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	92.10.26.17.53.56;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	92.09.08.08.24.21;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.06.21.08.43.27;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.06.13.05.06.48;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.05.15.01.26.28;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.05.05.12.52.06;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.05.03.11.04.12;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.05.01.10.28.24;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.04.20.08.24.46;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.04.10.07.40.34;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.04.02.01.59.28;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.03.29.05.30.30;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.18.06.12.20;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.12.31.04;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.17
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* Internet Telnet client
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#ifdef	__TURBOC__
#include <io.h>
#include <fcntl.h>
#endif
#include "global.h"
#include "mbuf.h"
#include "socket.h"
#include "telnet.h"
#include "session.h"
#include "proc.h"
#include "tty.h"
#include "commands.h"
#include "internet.h"
#include "netuser.h"
#include "cmdparse.h"

int Refuse_echo = 0;
int Tn_cr_mode = 0;    /* if true turn <cr> to <cr-nul> */
int Topt = 0;

char *T_options[] = {
	"Transmit Binary",
	"Echo",
	"",
	"Suppress Go Ahead",
	"",
	"Status",
	"Timing Mark"
};

static int keychar(int c);

int
dotopt(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	setbool(&Topt,"Telnet option tracing",argc,argv);
	return 0;
}
/* Execute user telnet command */
int
dotelnet(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct session *sp;
	struct sockaddr_in fsocket;
	int s;

	/* Allocate a session descriptor */
	if((sp = newsession(Cmdline,TELNET,1)) == NULLSESSION){
		printf("Too many sessions\n");
		return 1;
	}
	sp->inproc = keychar;	/* Intercept ^C */
	fsocket.sin_family = AF_INET;
	if(argc < 3)
		fsocket.sin_port = IPPORT_TELNET;
	else
		fsocket.sin_port = atoi(argv[2]);

	if(SETSIG(EABORT)){
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}
	printf("Resolving %s...\n",argv[1]);
	if((fsocket.sin_addr.s_addr = resolve(argv[1])) == 0){
		printf(Badhost,argv[1]);
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}
	if((s = socket(AF_INET,SOCK_STREAM,0)) == -1){
		printf("Can't create socket\n");
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}
	settos(s,LOW_DELAY);
	sp->network = fdopen(s,"r+t");
	setvbuf(sp->network,NULLCHAR,_IOLBF,BUFSIZ);
	return tel_connect(sp,(char *)&fsocket,SOCKSIZE);
}
/* Generic interactive connect routine, used by Telnet, AX.25, NET/ROM */
int
tel_connect(sp,fsocket,len)
struct session *sp;
char *fsocket;
int len;
{
	struct telnet tn;

	memset((char *)&tn,0,sizeof(tn));
	tn.eolmode = Tn_cr_mode;
	tn.session = sp;	/* Upward pointer */
	sp->cb.telnet = &tn;	/* Downward pointer */

	printf("Trying %s...\n",psocket((struct sockaddr *)fsocket));
	if(connect(fileno(sp->network),fsocket,len) == -1){
		perror("connect failed");
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}
	printf("Connected\n");
	sp->inproc = NULL;	/* No longer respond to ^C */	
	tnrecv(&tn);
	return 0;
}

/* Telnet input routine, common to both telnet and ttylink */
void
tnrecv(tn)
struct telnet *tn;
{
	int c;
	struct session *sp;
	char *cp;
	FILE *network;

	sp = tn->session;
	network = sp->network;

	/* Fork off the transmit process */
	sp->proc1 = newproc("tel_out",1024,tel_output,0,tn,NULL,0);

	/* Process input on the connection */
	while((c = getc(network)) != EOF){
		if(c != IAC){
			/* Ordinary character */
			putchar((char)c);
			if(sp->record != NULLFILE)
				putc(c,sp->record);
			continue;
		}
		/* IAC received, get command sequence */
		c = getc(network);
		switch(c){
		case WILL:
			c = getc(network);
			willopt(tn,c);
			break;
		case WONT:
			c = getc(network);
			wontopt(tn,c);
			break;
		case DO:
			c = getc(network);
			doopt(tn,c);
			break;
		case DONT:
			c = getc(network);
			dontopt(tn,c);
			break;
		case IAC:	/* Escaped IAC */
			putchar(IAC);
			if(sp->record != NULLFILE)
				putc(IAC,sp->record);
			break;
		}
	}
quit:	/* A close was received from the remote host.
	 * Notify the user, kill the output task and wait for a response
	 * from the user before freeing the session.
	 */
	fmode(sp->output,STREAM_ASCII); /* Restore newline translation */
	setvbuf(sp->output,NULLCHAR,_IOLBF,BUFSIZ);
	cp = sockerr(fileno(network));
	printf("Closed: %s\n", cp != NULLCHAR ? cp : "EOF");
	killproc(sp->proc1);
	sp->proc1 = NULLPROC;
	fclose(sp->network);
	sp->network = NULLFILE;
	keywait(NULLCHAR,1);
	freesession(sp);
}

/* User telnet output task, started by user telnet command */
void
tel_output(unused,tn1,p)
int unused;
void *tn1;
void *p;
{
	struct session *sp;
	int c;
	struct telnet *tn;

	tn = (struct telnet *)tn1;
	sp = tn->session;

	/* Send whatever's typed on the terminal */
	while((c = getc(sp->input)) != EOF){
		putc(c,sp->network);
		if(!tn->remote[TN_ECHO] && sp->record != NULLFILE)
			putc(c,sp->record);

		/* By default, output is transparent in remote echo mode.
		 * If eolmode is set, turn a cr into cr-null.
		 * This can only happen when in remote echo (raw) mode, since
		 * the tty driver normally maps \r to \n in cooked mode.
		 */
		if(c == '\r' && tn->eolmode)
			putc('\0',sp->network);

		if(tn->remote[TN_ECHO])
			fflush(sp->network);
	}
	/* Make sure our parent doesn't try to kill us after we exit */
	sp->proc1 = NULLPROC;
}
int
doecho(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	if(argc < 2){
		if(Refuse_echo)
			printf("Refuse\n");
		else
			printf("Accept\n");
	} else {
		if(argv[1][0] == 'r')
			Refuse_echo = 1;
		else if(argv[1][0] == 'a')
			Refuse_echo = 0;
		else
			return -1;
	}
	return 0;
}
/* set for unix end of line for remote echo mode telnet */
int
doeol(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	if(argc < 2){
		if(Tn_cr_mode)
			printf("null\n");
		else
			printf("standard\n");
	} else {
		if(argv[1][0] == 'n')
			Tn_cr_mode = 1;
		else if(argv[1][0] == 's')
			Tn_cr_mode = 0;
		else {
			printf("Usage: %s [standard|null]\n",argv[0]);
			return -1;
		}
	}
	return 0;
}

/* The guts of the actual Telnet protocol: negotiating options */
void
willopt(tn,opt)
struct telnet *tn;
int opt;
{
	int ack;

	if(Topt){
		printf("recv: will ");
		if(uchar(opt) <= NOPTIONS)
			printf("%s\n",T_options[opt]);
		else
			printf("%u\n",opt);
	}
	switch(uchar(opt)){
	case TN_TRANSMIT_BINARY:
	case TN_ECHO:
	case TN_SUPPRESS_GA:
		if(tn->remote[uchar(opt)] == 1)
			return;		/* Already set, ignore to prevent loop */
		if(uchar(opt) == TN_ECHO){
			if(Refuse_echo){
				/* User doesn't want to accept */
				ack = DONT;
				break;
			} else {
				/* Put tty into raw mode */
				tn->session->ttystate.edit = 0;
				tn->session->ttystate.echo = 0;
				fmode(tn->session->network,STREAM_BINARY);
				setvbuf(tn->session->network,NULLCHAR,_IONBF,0);
				fmode(stdout,STREAM_BINARY);
				setvbuf(stdout,NULLCHAR,_IONBF,0);
			}
		}
		tn->remote[uchar(opt)] = 1;
		ack = DO;			
		break;
	default:
		ack = DONT;	/* We don't know what he's offering; refuse */
	}
	answer(tn,ack,opt);
}
void
wontopt(tn,opt)
struct telnet *tn;
int opt;
{
	if(Topt){
		printf("recv: wont ");
		if(uchar(opt) <= NOPTIONS)
			printf("%s\n",T_options[uchar(opt)]);
		else
			printf("%u\n",uchar(opt));
	}
	if(uchar(opt) <= NOPTIONS){
		if(tn->remote[uchar(opt)] == 0)
			return;		/* Already clear, ignore to prevent loop */
		tn->remote[uchar(opt)] = 0;
		if(uchar(opt) == TN_ECHO){
			/* Put tty into cooked mode */
			tn->session->ttystate.edit = 1;
			tn->session->ttystate.echo = 1;
			fmode(tn->session->network,STREAM_ASCII);
			setvbuf(tn->session->network,NULLCHAR,_IOLBF,BUFSIZ);
			fmode(stdout,STREAM_ASCII);
			setvbuf(stdout,NULLCHAR,_IOLBF,BUFSIZ);
		}
	}
	answer(tn,DONT,opt);	/* Must always accept */
}
void
doopt(tn,opt)
struct telnet *tn;
int opt;
{
	int ack;

	if(Topt){
		printf("recv: do ");
		if(uchar(opt) <= NOPTIONS)
			printf("%s\n",T_options[uchar(opt)]);
		else
			printf("%u\n",uchar(opt));
	}
	switch(uchar(opt)){
	case TN_SUPPRESS_GA:
		if(tn->local[uchar(opt)] == 1)
			return;		/* Already set, ignore to prevent loop */
		tn->local[uchar(opt)] = 1;
		ack = WILL;
		break;
	default:
		ack = WONT;	/* Don't know what it is */
	}
	answer(tn,ack,opt);
}
void
dontopt(tn,opt)
struct telnet *tn;
int opt;
{
	if(Topt){
		printf("recv: dont ");
		if(uchar(opt) <= NOPTIONS)
			printf("%s\n",T_options[uchar(opt)]);
		else
			printf("%u\n",uchar(opt));
	}
	if(uchar(opt) <= NOPTIONS){
		if(tn->local[uchar(opt)] == 0){
			/* Already clear, ignore to prevent loop */
			return;
		}
		tn->local[uchar(opt)] = 0;
	}
	answer(tn,WONT,opt);
}
void
answer(tn,r1,r2)
struct telnet *tn;
int r1,r2;
{
	if(Topt){
		switch(r1){
		case WILL:
			printf("sent: will ");
			break;
		case WONT:
			printf("sent: wont ");
			break;
		case DO:
			printf("sent: do ");
			break;
		case DONT:
			printf("sent: dont ");
			break;
		}
		if(r2 <= NOPTIONS)
			printf("%s\n",T_options[r2]);
		else
			printf("%u\n",r2);
	}
	fprintf(tn->session->network,"%c%c%c",IAC,r1,r2);
	fflush(tn->session->network);
}
static int
keychar(c)
int c;
{
	if(c != CTLC)
		return 1;	/* Ignore all but ^C */

	fprintf(Current->output,"^C\n");
	alert(Current->proc,EABORT);
	return 0;
}
@


1.16
log
@Add topt command to enable/disable tracing of Telnet option negotiation
@
text
@d35 1
a35 1
static int keychar __ARGS((int c));
@


1.15
log
@Call newsession with Cmdline
Tighten up connect and disconnect messages
@
text
@d19 1
d23 1
a24 1
#ifdef	DEBUG
a33 1
#endif
d37 9
d274 7
a280 8
#ifdef	DEBUG
	printf("recv: will ");
	if(uchar(opt) <= NOPTIONS)
		printf("%s ",T_options[opt]);
	else
		printf("%u ",opt);
#endif
	
d315 7
a321 7
#ifdef	DEBUG
	printf("recv: wont ");
	if(uchar(opt) <= NOPTIONS)
		printf("%s ",T_options[uchar(opt)]);
	else
		printf("%u ",uchar(opt));
#endif
d345 7
a351 7
#ifdef	DEBUG
	printf("recv: do ");
	if(uchar(opt) <= NOPTIONS)
		printf("%s ",T_options[uchar(opt)]);
	else
		printf("%u ",uchar(opt));
#endif
d369 7
a375 7
#ifdef	DEBUG
	printf("recv: dont ");
	if(uchar(opt) <= NOPTIONS)
		printf("%s ",T_options[uchar(opt)]);
	else
		printf("%u ",uchar(opt));
#endif
d390 19
a408 14
#ifdef	DEBUG
	switch(r1){
	case WILL:
		printf("sent: will ");
		break;
	case WONT:
		printf("sent: wont ");
		break;
	case DO:
		printf("sent: do ");
		break;
	case DONT:
		printf("sent: dont ");
		break;
a409 6
	if(r2 <= NOPTIONS)
		printf("%s ",T_options[r2]);
	else
		printf("%u ",r2);
#endif

@


1.14
log
@Remove newlines on option printfs to keep from scrolling them rapidly
off the screen
@
text
@d49 1
a49 1
	if((sp = newsession(argv[1],TELNET,1)) == NULLSESSION){
d65 3
a67 3
	printf("Resolving %s... ",sp->name);
	if((fsocket.sin_addr.s_addr = resolve(sp->name)) == 0){
		printf(Badhost,sp->name);
a98 1
  		printf("%s session %u ",Sestypes[sp->type], sp->index);
d104 1
a104 2
	printf("%s session ",Sestypes[sp->type]);
	printf("%u connected to %s\n",sp->index,sp->name);
d168 1
a168 2
	printf("%s session %u", Sestypes[sp->type],sp->index);
	printf(" closed: %s\n", cp != NULLCHAR ? cp : "EOF");
@


1.13
log
@Add ^C processing before connection is established
@
text
@d271 1
a271 1
		printf("%s\n",T_options[opt]);
d273 1
a273 1
		printf("%u\n",opt);
d313 1
a313 1
		printf("%s\n",T_options[uchar(opt)]);
d315 1
a315 1
		printf("%u\n",uchar(opt));
d343 1
a343 1
		printf("%s\n",T_options[uchar(opt)]);
d345 1
a345 1
		printf("%u\n",uchar(opt));
d367 1
a367 1
		printf("%s\n",T_options[uchar(opt)]);
d369 1
a369 1
		printf("%u\n",uchar(opt));
d401 1
a401 1
		printf("%s\n",T_options[r2]);
d403 1
a403 1
		printf("%u\n",r2);
@


1.12
log
@Remove parity stripping
@
text
@d35 2
d53 1
d60 5
d107 1
d408 11
@


1.11
log
@s920612
@
text
@a122 3
			if(!tn->remote[TN_TRANSMIT_BINARY])
				c &= 0x7f;

@


1.10
log
@src0514
@
text
@d127 2
d152 2
a160 1
	log(-1,"out of telnet receive loop");
a165 1
	log(-1,"telnet did closing printf");
a167 1
	log(-1,"telnet killed sender");
a169 1
	log(-1,"telnet closed network");
@


1.9
log
@src0505
@
text
@a50 1
	Current->flowmode = 0;
a81 1
	unsigned int index;
a83 1
	index = sp - Sessions;
d91 1
a91 1
  		printf("%s session %u ",Sestypes[sp->type], index);
d98 1
a98 1
	printf("%u connected to %s\n",index,sp->name);
d108 1
a108 1
	int c,index;
a115 2
	index = sp - Sessions;

d120 1
a120 1
	while((c = getc(network)) != -1){
d157 1
d159 1
d161 1
a161 1
	printf("%s session %u", Sestypes[sp->type],index);
d163 1
d166 1
d169 1
a286 2
				fmode(stdin,STREAM_BINARY);
				setvbuf(stdin,NULLCHAR,_IONBF,0);
a320 2
			fmode(stdin,STREAM_ASCII);
			setvbuf(stdin,NULLCHAR,_IOLBF,BUFSIZ);
@


1.8
log
@src0503
@
text
@d73 1
a73 1
	setvbuf(sp->network,NULLCHAR,BUFSIZ,_IOLBF);
d190 1
a190 1
		putc(c,sp->network);	fflush(sp->network);
d286 1
a286 1
				setvbuf(tn->session->network,NULLCHAR,0,_IONBF);
d288 1
a288 1
				setvbuf(stdin,NULLCHAR,0,_IONBF);
d290 1
a290 1
				setvbuf(stdout,NULLCHAR,0,_IONBF);
d322 1
a322 1
			setvbuf(tn->session->network,NULLCHAR,BUFSIZ,_IOLBF);
d324 1
a324 1
			setvbuf(stdin,NULLCHAR,BUFSIZ,_IOLBF);
d326 1
a326 1
			setvbuf(stdout,NULLCHAR,BUFSIZ,_IOLBF);
@


1.7
log
@src0501
@
text
@a19 2
#define	CTLZ	26

d72 2
a73 1
	sp->network = fdopen(s,"r+");
a90 1
	fmode(sp->network,STREAM_ASCII);	/* Default to ascii mode */
d94 2
a95 3
  		printf("%s session %u failed: %s errno %d\n",
		 Sestypes[sp->type], index, sockerr(fileno(sp->network)),errno);

d190 1
a190 1
		putc(c,sp->network);
d286 5
a290 3
				fmode(tn->session->input,STREAM_BINARY);
				fmode(tn->session->output,STREAM_BINARY);

d322 5
a326 2
			fmode(tn->session->input,STREAM_ASCII);
			fmode(tn->session->output,STREAM_ASCII);
a382 2
	char s[3];

d404 2
a405 4
	s[0] = IAC;
	s[1] = r1;
	s[2] = r2;
	fwrite(s,1,3,tn->session->network);
@


1.6
log
@src0419
@
text
@d46 1
d50 1
a50 1
		tprintf("Too many sessions\n");
d60 1
a60 1
	tprintf("Resolving %s... ",sp->name);
d62 1
a62 1
		tprintf(Badhost,sp->name);
d67 2
a68 2
	if((sp->s = socket(AF_INET,SOCK_STREAM,0)) == -1){
		tprintf("Can't create socket\n");
d73 2
a74 1
	settos(sp->s,LOW_DELAY);
d92 1
a92 1
	sockmode(sp->s,SOCK_ASCII);	/* Default to ascii mode */
d94 4
a97 4
	tprintf("Trying %s...\n",psocket((struct sockaddr *)fsocket));
	if(connect(sp->s,fsocket,len) == -1){
  		tprintf("%s session %u failed: %s errno %d\n",
		 Sestypes[sp->type], index, sockerr(sp->s),errno);
d103 2
a104 2
	tprintf("%s session ",Sestypes[sp->type]);
	tprintf("%u connected to %s\n",index,sp->name);
d114 1
a114 1
	int c,s,index;
d117 1
d120 1
a120 1
	s = sp->s;
d128 1
a128 1
	while((c = recvchar(s)) != -1){
d134 1
a134 1
			tputc((char)c);
d138 1
a138 1
		c = recvchar(s);
d141 1
a141 1
			c = recvchar(s);
d145 1
a145 1
			c = recvchar(s);
d149 1
a149 1
			c = recvchar(s);
d153 1
a153 1
			c = recvchar(s);
d157 1
a157 1
			tputc(IAC);
d165 4
a168 4
	sockmode(sp->output,SOCK_ASCII); /* Restore newline translation */
	cp = sockerr(s);
	tprintf("%s session %u", Sestypes[sp->type],index);
	tprintf(" closed: %s\n", cp != NULLCHAR ? cp : "EOF");
d171 2
a172 2
	close_s(sp->s);
	sp->s = -1;
d192 2
a193 2
	while((c = recvchar(sp->input)) != EOF){
		usputc(sp->s,(char)c);
d203 1
a203 1
			usputc(sp->s,'\0');
d206 1
a206 1
			usflush(sp->s);
d219 1
a219 1
			tprintf("Refuse\n");
d221 1
a221 1
			tprintf("Accept\n");
d241 1
a241 1
			tprintf("null\n");
d243 1
a243 1
			tprintf("standard\n");
d250 1
a250 1
			tprintf("Usage: %s [standard|null]\n",argv[0]);
d288 3
a290 3
				sockmode(tn->session->s,SOCK_BINARY);
				sockmode(tn->session->input,SOCK_BINARY);
				sockmode(tn->session->output,SOCK_BINARY);
d322 3
a324 3
			sockmode(tn->session->s,SOCK_ASCII);
			sockmode(tn->session->input,SOCK_ASCII);
			sockmode(tn->session->output,SOCK_ASCII);
d407 1
a407 1
	send(tn->session->s,s,3,0);
@


1.5
log
@src0410
@
text
@a19 1
static int filemode __ARGS((FILE *fp,int mode));
a287 2
				if(tn->session->record != NULLFILE)
					filemode(tn->session->record,SOCK_BINARY);
a321 2
			if(tn->session->record != NULLFILE)
				filemode(tn->session->record,SOCK_ASCII);
a405 38
#ifdef	__TURBOC__
/* Set end-of-line translation mode on file */
static int
filemode(fp,mode)
FILE *fp;
int mode;
{
	int omode;

	if(fp == NULLFILE)
		return -1;

	if(fp->flags & _F_BIN)
		omode = SOCK_BINARY;
	else
		omode = SOCK_ASCII;

	switch(mode){
	case SOCK_BINARY:
		fp->flags = _F_BIN;
		setmode(fileno(fp),O_BINARY);
		break;
	case SOCK_ASCII:
		fp->flags &= ~_F_BIN;
		setmode(fileno(fp),O_TEXT);
		break;
	}
	return omode;
}
#else
static int
filemode(fp,mode)
FILE *fp;
int mode;
{
	return 0;
}
#endif
@


1.4
log
@src0401
@
text
@d53 1
@


1.3
log
@src0331
@
text
@d72 1
a72 1
	settos(sp->s,PRIORITY|LOW_DELAY);
@


1.2
log
@src0318
@
text
@d17 1
d49 1
a49 1
	if((sp = newsession(argv[1],TELNET)) == NULLSESSION){
d72 1
@


1.1
log
@Initial revision
@
text
@d343 1
a343 1
#ifdef	FUTURE	/* Use when local options are implemented */
a348 1
#endif
@
