head	1.10;
access;
symbols;
locks;
comment	@ * @;


1.10
date	93.05.06.10.10.57;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	93.03.15.05.08.07;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	93.03.08.00.48.26;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	93.02.23.23.13.50;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	93.02.22.00.49.29;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	93.01.26.20.20.46;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	93.01.18.22.43.35;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.10.26.17.54.31;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	92.05.19.22.14.56;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.12.19.22;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.10
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* Miscellaneous Internet servers: discard, echo and remote
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "socket.h"
#include "proc.h"
#include "remote.h"
#include "smtp.h"
#include "tcp.h"
#include "commands.h"
#include "hardware.h"
#include "mailbox.h"
#include "asy.h"
#include "n8250.h"
#include "devparam.h"

char *Rempass = "";	/* Remote access password */

static int chkrpass(struct mbuf *bp);
static void discserv(int s,void *unused,void *p);
static void echoserv(int s,void *unused,void *p);
static void termserv(int s,void *unused,void *p);
static void termrx(int s,void *p1,void *p2);
static void tunregister(struct iface *,int);
static void tregister(struct iface *);

static int Rem = -1;
static int Bsr = -1;

struct tserv {
	struct tserv *next;
	struct proc *proc;
	struct iface *ifp;
};
struct tserv *Tserv;

/* Start up TCP discard server */
int
dis1(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	uint16 port;

	if(argc < 2)
		port = IPPORT_DISCARD;
	else
		port = atoi(argv[1]);
	return start_tcp(port,"Discard Server",discserv,576);
}
static void
discserv(s,unused,p)
int s;
void *unused;
void *p;
{
	struct mbuf *bp;

	sockowner(s,Curproc);
	log(s,"open discard");
	if(availmem() == 0){
		while(recv_mbuf(s,&bp,0,NULLCHAR,NULL) > 0)
			free_p(bp);
	}
	log(s,"close discard");
	close_s(s);
}
/* Stop discard server */
int
dis0(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	uint16 port;

	if(argc < 2)
		port = IPPORT_DISCARD;
	else
		port = atoi(argv[1]);
	return stop_tcp(port);
}
/* Start up TCP echo server */
int
echo1(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	uint16 port;

	if(argc < 2)
		port = IPPORT_ECHO;
	else
		port = atoi(argv[1]);
	return start_tcp(port,"Echo Server",echoserv,512);
}
static void
echoserv(s,unused,p)
int s;
void *unused;
void *p;
{
	struct mbuf *bp;

	sockowner(s,Curproc);
	log(s,"open echo");
	if(availmem() == 0){
		while(recv_mbuf(s,&bp,0,NULLCHAR,NULL) > 0)
			send_mbuf(s,bp,0,NULLCHAR,0);
	}
	log(s,"close echo");
	close_s(s);
}
/* stop echo server */
int
echo0(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	uint16 port;

	if(argc < 2)
		port = IPPORT_ECHO;
	else
		port = atoi(argv[1]);
	return stop_tcp(port);
}
/* Start remote exit/reboot server */
int
rem1(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct sockaddr_in lsocket,fsock;
	int i;
	int command;
	struct mbuf *bp;
	int32 addr;
	int (*kp)(int32);

	if(Rem != -1){
		return 0;
	}
	psignal(Curproc,0);
	chname(Curproc,"Remote listener");
	lsocket.sin_family = AF_INET;
	lsocket.sin_addr.s_addr = INADDR_ANY;
	if(argc < 2)
		lsocket.sin_port = IPPORT_REMOTE;
	else
		lsocket.sin_port = atoi(argv[1]);
	
	Rem = socket(AF_INET,SOCK_DGRAM,0);
	bind(Rem,(char *)&lsocket,sizeof(lsocket));
	for(;;){
		i = sizeof(fsock);
		if(recv_mbuf(Rem,&bp,0,(char *)&fsock,&i) == -1)
			break;
		command = PULLCHAR(&bp);

		switch(command){
#ifdef	MSDOS	/* Only present on PCs running MSDOS */
		case SYS_RESET:
			i = chkrpass(bp);
			log(Rem,"%s - Remote reset %s",
			 psocket((struct sockaddr *)&fsock),
			 i == 0 ? "PASSWORD FAIL" : "" );
			if(i != 0){
				iostop();
				sysreset();	/* No return */
			}
			break;
#endif
		case SYS_EXIT:
			i = chkrpass(bp);
			log(Rem,"%s - Remote exit %s",
			 psocket((struct sockaddr *)&fsock),
			 i == 0 ? "PASSWORD FAIL" : "" );
			if(i != 0){
				iostop();
				exit(0);
			}
			break;
		case KICK_ME:
			if(len_p(bp) >= sizeof(int32))
				addr = pull32(&bp);
			else
				addr = fsock.sin_addr.s_addr;
			for(i=0;(kp = Kicklist[i]) != NULL;i++)
				(*kp)(addr);
			break;
		}
		free_p(bp);
	}
	close_s(Rem);
	Rem = -1;
	return 0;
}
/* Check remote password */
static int
chkrpass(bp)
struct mbuf *bp;
{
	char *lbuf;
	uint16 len;
	int rval = 0;

	len = len_p(bp);
	if(strlen(Rempass) != len)
		return rval;
	lbuf = mallocw(len);
	pullup(&bp,lbuf,len);
	if(strncmp(Rempass,lbuf,len) == 0)
		rval = 1;
	free(lbuf);
	return rval;
}
int
rem0(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	close_s(Rem);
	return 0;
}

/* Start up TCP term server */
int
term1(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	uint16 port;

	if(argc < 2)
		port = IPPORT_TERM;
	else
		port = atoi(argv[1]);
	return start_tcp(port,"Term Server",termserv,576);
}
static void
termserv(s,unused,p)
int s;
void *unused;
void *p;
{
	FILE *network = NULLFILE;
	FILE *asy;
	char *buf = NULLCHAR;
	struct iface *ifp;
	struct route *rp;
	struct sockaddr_in fsocket;
	struct proc *rxproc = NULLPROC;
	int i;
	
	sockowner(s,Curproc);
	log(s,"open term");
	network = fdopen(s,"r+");

	if(network == NULLFILE || (buf = malloc(BUFSIZ)) == NULLCHAR)
		goto quit;

	if(SETSIG(EABORT)){
		fprintf(network,"Abort\r\n");
		goto quit;
	}
	/* Prompt for and check remote password */
	fprintf(network,"Password: ");
	fgets(buf,BUFSIZ,network);
	rip(buf);
	if(strcmp(buf,Rempass) != 0){
		fprintf(network,"Login incorrect\n");
		goto quit;
	}
	/* Prompt for desired interface. Verify that it exists, that
	 * we're not using it for our TCP connection, that it's an
	 * asynch port, and that there isn't already another tip, term
	 * or dialer session active on it.
	 */
	for(;;){
		fprintf(network,"Interface: ");
		fgets(buf,BUFSIZ,network);
		rip(buf);
		if((ifp = if_lookup(buf)) == NULLIF){
			fprintf(network,"Interface %s does not exist\n",buf);
			continue;
		}
		if(getpeername(s,(char *)&fsocket,&i) != -1
		 && !ismyaddr(fsocket.sin_addr.s_addr)
		 && (rp = rt_lookup(fsocket.sin_addr.s_addr)) != NULLROUTE
		 && rp->iface == ifp){
			fprintf(network,"You're using interface %s!\n",ifp->name);
			continue;
		}
		if((asy = asyopen(buf,"r+b")) != NULLFILE)
			break;
		fprintf(network,"Can't open interface %s\n",buf);
		fprintf(network,"Try to bounce current user? ");
		fgets(buf,BUFSIZ,network);
		if(buf[0] == 'y' || buf[0] == 'Y'){
			tunregister(ifp,1);
			pwait(NULL);
		}
	}
	setvbuf(asy,NULLBUF,_IONBF,0);
	tregister(ifp);
	fprintf(network,"Wink DTR? ");
	fgets(buf,BUFSIZ,network);
	if(buf[0] == 'y' || buf[0] == 'Y'){
		asy_ioctl(ifp,PARAM_DTR,1,0);	/* drop DTR */
		pause(1000L);
		asy_ioctl(ifp,PARAM_DTR,1,1);	/* raise DTR */
	}
	fmode(network,STREAM_BINARY);	/* Switch to raw mode */
	setvbuf(network,NULLBUF,_IONBF,0);
	fprintf(network,"Turn off local echo? ");
	fgets(buf,BUFSIZ,network);
	if(buf[0] == 'y' || buf[0] == 'Y'){
		fprintf(network,"%c%c%c",IAC,WILL,TN_ECHO);
		/* Eat the response */
		for(i=0;i<3;i++)
			(void)fgetc(network);
	}
#ifdef	notdef
	free(buf);
	buf = NULLCHAR;
#endif
	/* Now fork into receive and transmit processes */
	rxproc = newproc("term rx",1500,termrx,s,network,asy,0);

	/* We continue to handle the TCP->asy direction */
	fblock(network,PART_READ);
	while((i = fread(buf,1,BUFSIZ,network)) > 0)
		fwrite(buf,1,i,asy);
quit:	fclose(network);
	fclose(asy);
	killproc(rxproc);
	log(s,"close term");
	free(buf);
	close_s(s);
	tunregister(ifp,0);
}
void
termrx(s,p1,p2)
int s;
void *p1,*p2;
{
	int i;
	FILE *network = (FILE *)p1;
	FILE *asy = (FILE *)p2;
	char buf[BUFSIZ];
	
	fblock(asy,PART_READ);
	while((i = fread(buf,1,BUFSIZ,asy)) > 0){
		fwrite(buf,1,i,network);
		pwait(NULL);
	}
}
void
tregister(ifp)
struct iface *ifp;
{
	struct tserv *tserv;

	tserv = (struct tserv *)calloc(1,sizeof(struct tserv));
	tserv->ifp = ifp;
	tserv->proc = Curproc;
	tserv->next = Tserv;
	Tserv = tserv;
}
void
tunregister(ifp,kill)
struct iface *ifp;
int kill;
{
	struct tserv *tserv;
	struct tserv *prev = NULL;

	for(tserv = Tserv;tserv != NULL;prev = tserv,tserv = tserv->next){
		if(tserv->ifp == ifp)
			break;
	}
	if(tserv == NULL)
		return;
	if(kill)
		alert(tserv->proc,EABORT);

	if(prev == NULL)
		Tserv = tserv->next;
	else
		prev->next = tserv->next;
	free(tserv);
}


/* Stop term server */
int
term0(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	uint16 port;

	if(argc < 2)
		port = IPPORT_TERM;
	else
		port = atoi(argv[1]);
	return stop_tcp(port);
}
/* Start BSR server */
int
bsr1(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct sockaddr_in lsocket,fsock;
	int i,c;
	struct mbuf *bp;
	char *cp;
	FILE *asy;

	if(Bsr != -1)
		return 1;

	psignal(Curproc,0);
	chname(Curproc,"BSR listener");

	if((asy = asyopen(argv[1],"r+b")) == NULLFILE){
		printf("Can't open interface %s\n",argv[1]);
		return 1;
	}
	/* Set up the UDP socket where we'll take commands */
	lsocket.sin_family = AF_INET;
	lsocket.sin_addr.s_addr = INADDR_ANY;
	if(argc < 3)
		lsocket.sin_port = IPPORT_BSR;
	else
		lsocket.sin_port = atoi(argv[2]);
	
	Bsr = socket(AF_INET,SOCK_DGRAM,0);
	bind(Bsr,(char *)&lsocket,sizeof(lsocket));

	/* Process commands */
	for(;;){
		i = sizeof(fsock);
		if(recv_mbuf(Bsr,&bp,0,(char *)&fsock,&i) == -1)
			break;
		/* Check password */
		for(cp = Rempass;;cp++){
			c = PULLCHAR(&bp);
			if(c == -1 || *cp != c)
				goto endcmd;
			if(*cp == 0)
				break;
		}
		/* Send remainder of packet to BSR */
		while((c = PULLCHAR(&bp)) != -1){
			fputc(c,asy);
		}
		free_p(bp);	/* Shouldn't be necessary */

		/* Now generate response */
		bp = ambufw(512);	/* Larger than max response */
		cp = bp->data;
		alarm(500L);	/* Allow BSR time to respond */
		while((c = fgetc(asy)) != -1){
			alarm(100L);	/* Reset timer */
			*cp++ = c;
			bp->cnt++;
		}
		alarm(0L);
		/* Send response */
		send_mbuf(Bsr,bp,0,(char *)&fsock,sizeof(fsock));
		bp = NULLBUF;
endcmd:
		free_p(bp);
	}
	fclose(asy);
	close_s(Bsr);
	Bsr = -1;
	return 0;
}

int
bsr0(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	close_s(Bsr);
	return 0;
}
@


1.9
log
@Change terminal server to use new stdio facility for asynch ports
@
text
@d21 7
a27 7
static int chkrpass __ARGS((struct mbuf *bp));
static void discserv __ARGS((int s,void *unused,void *p));
static void echoserv __ARGS((int s,void *unused,void *p));
static void termserv __ARGS((int s,void *unused,void *p));
static void termrx __ARGS((int s,void *p1,void *p2));
static void tunregister __ARGS((struct iface *,int));
static void tregister __ARGS((struct iface *));
d46 1
a46 1
	int16 port;
d78 1
a78 1
	int16 port;
d93 1
a93 1
	int16 port;
d125 1
a125 1
	int16 port;
d145 1
a145 1
	int (*kp) __ARGS((int32));
d211 1
a211 1
	int16 len;
d241 1
a241 1
	int16 port;
d411 1
a411 1
	int16 port;
@


1.8
log
@Add prototype to function pointer
@
text
@a254 2
	int c;
	char c1;
d256 2
a257 1
	char *cmdbuf = NULLCHAR;
a261 2
	int (*rawsave) __ARGS((struct iface *,struct mbuf *)) = NULL;
	int dev;
a262 1
	int otrigchar;
d268 1
a268 1
	if(network == NULLFILE || (cmdbuf = malloc(128)) == NULLCHAR)
d277 3
a279 3
	fgets(cmdbuf,128,network);
	rip(cmdbuf);
	if(strcmp(cmdbuf,Rempass) != 0){
d290 4
a293 4
		fgets(cmdbuf,128,network);
		rip(cmdbuf);
		if((ifp = if_lookup(cmdbuf)) == NULLIF){
			fprintf(network,"Interface %s does not exist\n",cmdbuf);
d303 6
a308 11
		dev = ifp->dev;
		if(dev >= ASY_MAX || Asy[dev].iface != ifp ){
			fprintf(network,"Interface %s not asy port\n",ifp->name);
			continue;
		}
		if(ifp->raw == bitbucket){
			fprintf(network,"port %s in use\n",ifp->name);
			fprintf(network,"bounce current user? ");
			fgets(cmdbuf,128,network);
			if(cmdbuf[0] == 'n' || cmdbuf[0] == 'N')
				continue;
a311 1
		break;
d313 1
d316 2
a317 2
	fgets(cmdbuf,128,network);
	if(cmdbuf[0] == 'y' || cmdbuf[0] == 'Y'){
d320 1
a321 1
	asy_ioctl(ifp,PARAM_DTR,1,1);	/* raise DTR */
d325 2
a326 2
	fgets(cmdbuf,128,network);
	if(cmdbuf[0] == 'y' || cmdbuf[0] == 'Y'){
d332 4
a335 17

	free(cmdbuf);	/* No longer needed */
	cmdbuf = NULLCHAR;

	/* Save output handler and temporarily redirect output to null */
	rawsave = ifp->raw;
	ifp->raw = bitbucket;

	/* Suspend the packet input driver. Note that the transmit driver
	 * is left running since we use it to send buffers to the line.
	 */
	suspend(ifp->rxproc);

	/* Temporarily change the trigger character */
	otrigchar = Asy[dev].trigchar;
	Asy[dev].trigchar = -1;

d337 1
a337 1
	rxproc = newproc("term rx",384,termrx,s,network,ifp,0);
d340 3
a342 5
	while((c = getc(network)) != EOF){
		c1 = c;
		asy_write(dev,&c1,1);
		ifp->lastsent = secclock();
	}
d344 1
a344 1
	Asy[dev].trigchar = otrigchar;
a345 4
	if(rawsave != NULL){
		ifp->raw = rawsave;
		resume(ifp->rxproc);
	}
d347 1
a347 1
	free(cmdbuf);
d356 8
a363 6
	int c;
	struct iface *ifp = (struct iface *)p2;
	FILE *fp = (FILE *)p1;

	while((c = get_asy(ifp->dev)) != -1){
		fputc(c,fp);
d427 1
a427 1
	int i;
d429 2
a430 5
	int c;
	char c1,*cp;
	struct iface *ifp;
	int dev;
	int (*rawsave) __ARGS((struct iface *,struct mbuf *)) = NULL;
d438 2
a439 7
	if((ifp = if_lookup(argv[1])) == NULLIF){
		printf("Interface %s does not exist\n",argv[1]);
		return 1;
	}
	dev = ifp->dev;
	if(dev >= ASY_MAX || Asy[dev].iface != ifp){
		printf("Interface %s not asy port\n",ifp->name);
a441 13
	if(ifp->raw == bitbucket){
		printf("term or dialer session already active on %s\n",ifp->name);
		return 1;
	}
	/* Save output handler and temporarily redirect output to null */
	rawsave = ifp->raw;
	ifp->raw = bitbucket;

	/* Suspend the packet input driver. Note that the transmit driver
	 * is left running since we use it to send buffers to the line.
	 */
	suspend(ifp->rxproc);

d468 1
a468 2
			c1 = c;
			asy_write(dev,&c1,1);
a470 1
		ifp->lastsent = secclock();
d476 1
a476 1
		while((c = get_asy(ifp->dev)) != -1){
d488 1
a488 4
	if(rawsave != NULL){
		ifp->raw = rawsave;
		resume(ifp->rxproc);
	}
@


1.7
log
@Improve terminal server - give user another chance if he enters an
invalid or busy com port, give him chance to bump current user of port
@
text
@d145 1
a145 1
	int (*kp)();
@


1.6
log
@Add prompt to wink DTR in terminal server
@
text
@d26 2
d32 7
d275 4
d292 30
a321 23
	fprintf(network,"Interface: ");
	fgets(cmdbuf,128,network);
	rip(cmdbuf);
	ifp = if_lookup(cmdbuf);
	if(ifp == NULLIF){
		fprintf(network,"Interface %s does not exist\n",cmdbuf);
		goto quit;
	}
	if(getpeername(s,(char *)&fsocket,&i) != -1
	 && !ismyaddr(fsocket.sin_addr.s_addr)
	 && (rp = rt_lookup(fsocket.sin_addr.s_addr)) != NULLROUTE
	 && rp->iface == ifp){
		fprintf(network,"You're using interface %s!\n",ifp->name);
		goto quit;
	}
	dev = ifp->dev;
	if(dev >= ASY_MAX || Asy[dev].iface != ifp ){
		fprintf(network,"Interface %s not asy port\n",ifp->name);
		goto quit;
	}
	if(ifp->raw == bitbucket){
		fprintf(network,"term or dialer session already active on %s\n",ifp->name);
		goto quit;
d323 1
d369 1
a370 1
		killproc(rxproc);
d377 1
d393 36
a554 2


@


1.5
log
@Rewrite to use start_tcp/stop_tcp
@
text
@d17 1
d303 7
@


1.4
log
@Increase stack for termrx
Remove kicked functions, place in config.c
Allow loopback connections to term server
@
text
@a26 3
static int Sdisc = -1;
static int Secho = -1;
static int Sterm = -1;
d36 1
a36 2
	struct sockaddr_in lsocket;
	int s;
a37 8
	if(Sdisc != -1){
		return 0;
	}
	psignal(Curproc,0); 	/* Don't keep the parser waiting */
	chname(Curproc,"Discard listener");

	lsocket.sin_family = AF_INET;
	lsocket.sin_addr.s_addr = INADDR_ANY;
d39 1
a39 1
		lsocket.sin_port = IPPORT_DISCARD;
d41 2
a42 15
		lsocket.sin_port = atoi(argv[1]);
	Sdisc = socket(AF_INET,SOCK_STREAM,0);
	bind(Sdisc,(char *)&lsocket,sizeof(lsocket));
	listen(Sdisc,1);
	for(;;){
		if((s = accept(Sdisc,NULLCHAR,(int *)NULL)) == -1)
			break;	/* Service is shutting down */

		if(availmem() != 0){
			shutdown(s,1);
		} else
			/* Spawn a server */
			newproc("Discard server",576,discserv,s,NULL,NULL,0);
	}
	return 0;
d54 4
a57 2
	while(recv_mbuf(s,&bp,0,NULLCHAR,NULL) > 0)
		free_p(bp);
d68 7
a74 3
	close_s(Sdisc);
	Sdisc = -1;
	return 0;
d83 1
a83 8
	struct sockaddr_in lsocket;
	int s;

	if(Secho != -1){
		return 0;
	}
	psignal(Curproc,0); 	/* Don't keep the parser waiting */
	chname(Curproc,"Echo listener");
a84 2
	lsocket.sin_family = AF_INET;
	lsocket.sin_addr.s_addr = INADDR_ANY;
d86 1
a86 1
		lsocket.sin_port = IPPORT_ECHO;
d88 2
a89 15
		lsocket.sin_port = atoi(argv[1]);
	Secho = socket(AF_INET,SOCK_STREAM,0);
	bind(Secho,(char *)&lsocket,sizeof(lsocket));
	listen(Secho,1);
	for(;;){
		if((s = accept(Secho,NULLCHAR,(int *)NULL)) == -1)
			break;	/* Service is shutting down */

		if(availmem() != 0){
			shutdown(s,1);
		} else
			/* Spawn a server */
			newproc("Echo server",2048,echoserv,s,NULL,NULL,0);
	}
	return 0;
d101 4
a104 3
	while(recv_mbuf(s,&bp,0,NULLCHAR,NULL) > 0)
		send_mbuf(s,bp,0,NULLCHAR,0);

d115 7
a121 3
	close_s(Secho);
	Secho = -1;
	return 0;
d231 1
a231 8
	struct sockaddr_in lsocket;
	int s;

	if(Sterm != -1){
		return 0;
	}
	psignal(Curproc,0); 	/* Don't keep the parser waiting */
	chname(Curproc,"term listener");
a232 2
	lsocket.sin_family = AF_INET;
	lsocket.sin_addr.s_addr = INADDR_ANY;
d234 1
a234 1
		lsocket.sin_port = IPPORT_TERM;
d236 2
a237 15
		lsocket.sin_port = atoi(argv[1]);
	Sterm = socket(AF_INET,SOCK_STREAM,0);
	bind(Sterm,(char *)&lsocket,sizeof(lsocket));
	listen(Sterm,1);
	for(;;){
		if((s = accept(Sterm,NULLCHAR,(int *)NULL)) == -1)
			break;	/* Service is shutting down */

		if(availmem() != 0){
			shutdown(s,1);
		} else
			/* Spawn a server */
			newproc("term server",576,termserv,s,NULL,NULL,0);
	}
	return 0;
d256 1
a272 1

d302 2
a305 2
	fmode(network,STREAM_BINARY);	/* Switch to raw mode */
	setvbuf(network,NULLBUF,_IONBF,0);
d312 2
a314 1
	free(cmdbuf);	/* No longer needed */
d325 4
d339 1
d371 7
a377 3
	close_s(Sterm);
	Sterm = -1;
	return 0;
@


1.3
log
@Add terminal, bsr servers (should move to separate files)
@
text
@d171 1
d221 2
a222 2
			kick(addr);
			smtptick((void *)addr);
d345 1
d383 1
a383 1
	rxproc = newproc("term rx",256,termrx,s,network,ifp,0);
d412 1
@


1.2
log
@src0519
@
text
@d15 2
d23 2
d29 2
d258 277
@


1.1
log
@Initial revision
@
text
@d55 1
a55 1
		if(availmem() < Memthresh){
d118 1
a118 1
		if(availmem() < Memthresh){
@
