head	1.13;
access;
symbols;
locks;
comment	@ * @;


1.13
date	93.05.06.10.10.55;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	93.02.23.02.00.42;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.11.14.01.48.39;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.10.07.19.27.11;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.05.03.03.26.20;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.05.01.08.23.46;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.04.29.10.38.58;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.04.06.12.41.42;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.04.01.13.33.28;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.03.26.11.31.12;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.09.17.22.38.56;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.08.00.00.40;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.14.14.58;	author karn;	state Exp;
branches
	1.1.2.1;
next	;

1.1.2.1
date	91.03.08.11.19.58;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.13
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* SLIP (Serial Line IP) encapsulation and control routines.
 * Copyright 1991 Phil Karn
 *
 * Van Jacobsen header compression hooks added by Katie Stevens, UC Davis
 *
 *	- Feb 1991	Bill_Simpson@@um.cc.umich.edu
 *			reflect changes to header compression calls
 *			revise status display
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "ip.h"
#include "slhc.h"
#include "asy.h"
#include "slip.h"
#include "trace.h"
#include "pktdrvr.h"

static struct mbuf *slip_decode(struct slip *sp,char c);
static struct mbuf *slip_encode(struct mbuf *bp);

/* Slip level control structure */
struct slip Slip[SLIP_MAX];

int
slip_init(ifp)
struct iface *ifp;
{
	int xdev;
	struct slip *sp;
	char *ifn;

	for(xdev = 0;xdev < SLIP_MAX;xdev++){
		sp = &Slip[xdev];
		if(sp->iface == NULLIF)
			break;
	}
	if(xdev >= SLIP_MAX) {
		printf("Too many slip devices\n");
		return -1;
	}
	ifp->ioctl = asy_ioctl;
	ifp->raw = slip_raw;
	ifp->show = slip_status;
	ifp->xdev = xdev;

	sp->iface = ifp;
	sp->send = asy_send;
	sp->get = get_asy;
	sp->type = CL_SERIAL_LINE;
	if(ifp->send == vjslip_send){
		sp->slcomp = slhc_init(16,16);
	}
	ifp->rxproc = newproc( ifn = if_name( ifp, " rx" ),
		512,slip_rx,xdev,NULL,NULL,0);
	free(ifn);
	return 0;
}
int
slip_free(ifp)
struct iface *ifp;
{
	struct slip *sp;

	sp = &Slip[ifp->xdev];
	if(sp->slcomp != NULLSLCOMPR){
		slhc_free(sp->slcomp);
		sp->slcomp = NULLSLCOMPR;
	}
	sp->iface = NULLIF;
	return 0;
}
/* Send routine for point-to-point slip, no VJ header compression */
int
slip_send(bp,iface,gateway,tos)
struct mbuf *bp;	/* Buffer to send */
struct iface *iface;	/* Pointer to interface control block */
int32 gateway;		/* Ignored (SLIP is point-to-point) */
int tos;
{
	if(iface == NULLIF){
		free_p(bp);
		return -1;
	}
	return (*iface->raw)(iface,bp);
}
/* Send routine for point-to-point slip, with VJ header compression */
int
vjslip_send(bp,iface,gateway,tos)
struct mbuf *bp;	/* Buffer to send */
struct iface *iface;	/* Pointer to interface control block */
int32 gateway;		/* Ignored (SLIP is point-to-point) */
int tos;
{
	register struct slip *sp;
	int type;

	if(iface == NULLIF){
		free_p(bp);
		return -1;
	}
	sp = &Slip[iface->xdev];
	/* Attempt IP/ICP header compression */
	type = slhc_compress(sp->slcomp,&bp,TRUE);
	bp->data[0] |= type;
	return (*iface->raw)(iface,bp);
}
/* Send a raw slip frame */
int
slip_raw(iface,bp)
struct iface *iface;
struct mbuf *bp;
{
	struct mbuf *bp1;

	dump(iface,IF_TRACE_OUT,bp);
	iface->rawsndcnt++;
	iface->lastsent = secclock();
	if((bp1 = slip_encode(bp)) == NULLBUF){
		return -1;
	}
	if (iface->trace & IF_TRACE_RAW)
		raw_dump(iface,-1,bp1);
	return Slip[iface->xdev].send(iface->dev,bp1);
}
/* Encode a packet in SLIP format */
static
struct mbuf *
slip_encode(bp)
struct mbuf *bp;
{
	struct mbuf *lbp;	/* Mbuf containing line-ready packet */
	register char *cp;
	int c;

	/* Allocate output mbuf that's twice as long as the packet.
	 * This is a worst-case guess (consider a packet full of FR_ENDs!)
	 */
	lbp = alloc_mbuf((uint16)(2*len_p(bp) + 2));
	if(lbp == NULLBUF){
		/* No space; drop */
		free_p(bp);
		return NULLBUF;
	}
	cp = lbp->data;

	/* Flush out any line garbage */
	*cp++ = FR_END;

	/* Copy input to output, escaping special characters */
	while((c = PULLCHAR(&bp)) != -1){
		switch(c){
		case FR_ESC:
			*cp++ = FR_ESC;
			*cp++ = T_FR_ESC;
			break;
		case FR_END:
			*cp++ = FR_ESC;
			*cp++ = T_FR_END;
			break;
		default:
			*cp++ = c;
		}
	}
	*cp++ = FR_END;
	lbp->cnt = cp - lbp->data;
	return lbp;
}
/* Process incoming bytes in SLIP format
 * When a buffer is complete, return it; otherwise NULLBUF
 */
static
struct mbuf *
slip_decode(sp,c)
register struct slip *sp;
char c;		/* Incoming character */
{
	struct mbuf *bp;

	switch(uchar(c)){
	case FR_END:
		bp = sp->rbp_head;
		sp->rbp_head = NULLBUF;
		if(sp->escaped){
			/* Treat this as an abort - discard frame */
			free_p(bp);
			bp = NULLBUF;
		}
		sp->escaped &= ~SLIP_FLAG;
		return bp;	/* Will be NULLBUF if empty frame */
	case FR_ESC:
		sp->escaped |= SLIP_FLAG;
		return NULLBUF;
	}
	if(sp->escaped & SLIP_FLAG){
		/* Translate 2-char escape sequence back to original char */
		sp->escaped &= ~SLIP_FLAG;
		switch(uchar(c)){
		case T_FR_ESC:
			c = FR_ESC;
			break;
		case T_FR_END:
			c = FR_END;
			break;
		default:
			sp->errors++;
			break;
		}
	}
	/* We reach here with a character for the buffer;
	 * make sure there's space for it
	 */
	if(sp->rbp_head == NULLBUF){
		/* Allocate first mbuf for new packet */
		if((sp->rbp_tail = sp->rbp_head = alloc_mbuf(SLIP_ALLOC)) == NULLBUF)
			return NULLBUF; /* No memory, drop */
		sp->rcp = sp->rbp_head->data;
	} else if(sp->rbp_tail->cnt == SLIP_ALLOC){
		/* Current mbuf is full; link in another */
		if((sp->rbp_tail->next = alloc_mbuf(SLIP_ALLOC)) == NULLBUF){
			/* No memory, drop whole thing */
			free_p(sp->rbp_head);
			sp->rbp_head = NULLBUF;
			return NULLBUF;
		}
		sp->rbp_tail = sp->rbp_tail->next;
		sp->rcp = sp->rbp_tail->data;
	}
	/* Store the character, increment fragment and total
	 * byte counts
	 */
	*sp->rcp++ = c;
	sp->rbp_tail->cnt++;
	return NULLBUF;
}


/* Process SLIP line input */
void
slip_rx(xdev,p1,p2)
int xdev;
void *p1;
void *p2;
{
	int c;
	struct mbuf *bp;
	register struct slip *sp;
	int cdev;

	sp = &Slip[xdev];
	cdev = sp->iface->dev;

	while ( (c = sp->get(cdev)) != -1 ) {
		if((bp = slip_decode(sp,(char)c)) == NULLBUF)
			continue;	/* More to come */

		if (sp->iface->trace & IF_TRACE_RAW)
			raw_dump(sp->iface,IF_TRACE_IN,bp);

		if ((c = bp->data[0]) & SL_TYPE_COMPRESSED_TCP) {
			if ( slhc_uncompress(sp->slcomp, &bp) <= 0 ) {
				free_p(bp);
				sp->errors++;
				continue;
			}
		} else if (c >= SL_TYPE_UNCOMPRESSED_TCP) {
			bp->data[0] &= 0x4f;
			if ( slhc_remember(sp->slcomp, &bp) <= 0 ) {
				free_p(bp);
				sp->errors++;
				continue;
			}
		}
		net_route( sp->iface, bp);
		/* Especially on slow machines, serial I/O can be quite
		 * compute intensive, so release the machine before we
		 * do the next packet.  This will allow this packet to
		 * go on toward its ultimate destination. [Karn]
		 */
		pwait(NULL);
	}
	if(sp->iface->rxproc == Curproc)
		sp->iface->rxproc = NULLPROC;
}



/* Show serial line status */
void
slip_status(iface)
struct iface *iface;
{
	struct slip *sp;

	if (iface->xdev > SLIP_MAX)
		/* Must not be a SLIP device */
		return;

	sp = &Slip[iface->xdev];
	if (sp->iface != iface)
		/* Must not be a SLIP device */
		return;

	slhc_i_status(sp->slcomp);
	slhc_o_status(sp->slcomp);
}
@


1.12
log
@Increase stack size for slip receive process
@
text
@d21 2
a22 2
static struct mbuf *slip_decode __ARGS((struct slip *sp,char c));
static struct mbuf *slip_encode __ARGS((struct mbuf *bp));
d141 1
a141 1
	lbp = alloc_mbuf((int16)(2*len_p(bp) + 2));
@


1.11
log
@Add notion of "frame abort" to slip_decode()
@
text
@d57 1
a57 1
		256,slip_rx,xdev,NULL,NULL,0);
@


1.10
log
@Get rid of vj argument to slip_init and replace with separate
functions for SLIP in conventional and VJ mode
@
text
@d186 6
@


1.9
log
@src0503
@
text
@d28 1
a28 1
slip_init(ifp,vj)
a29 1
int vj;
a46 1
	ifp->flags = 0;
d53 1
a53 2
	if(vj){
		sp->escaped |= SLIP_VJCOMPR;
d55 1
a55 4
		setencap(ifp,"VJSLIP");
	} else 
		setencap(ifp,"SLIP");

d75 1
a75 1
/* Send routine for point-to-point slip */
d83 14
d105 3
a107 5
	if (sp->escaped & SLIP_VJCOMPR) {
		/* Attempt IP/ICP header compression */
		type = slhc_compress(sp->slcomp,&bp,TRUE);
		bp->data[0] |= type;
	}
d256 12
a267 14
		if (sp->escaped & SLIP_VJCOMPR) {
			if ((c = bp->data[0]) & SL_TYPE_COMPRESSED_TCP) {
				if ( slhc_uncompress(sp->slcomp, &bp) <= 0 ) {
					free_p(bp);
					sp->errors++;
					continue;
				}
			} else if (c >= SL_TYPE_UNCOMPRESSED_TCP) {
				bp->data[0] &= 0x4f;
				if ( slhc_remember(sp->slcomp, &bp) <= 0 ) {
					free_p(bp);
					sp->errors++;
					continue;
				}
@


1.8
log
@src0501
@
text
@d63 1
a63 1
		256,asy_rx,xdev,NULL,NULL,0);
d230 1
a230 1
asy_rx(xdev,p1,p2)
d274 2
a275 1
	free_p(bp);
@


1.7
log
@src0429a
@
text
@d42 1
a42 1
		tprintf("Too many slip devices\n");
@


1.6
log
@src0406
@
text
@a44 1
	setencap(ifp,"SLIP");
d58 4
a61 1
	}
d112 1
a112 1
	dump(iface,IF_TRACE_OUT,Slip[iface->xdev].type,bp);
d266 1
a266 1
		net_route( sp->iface, sp->type, bp );
@


1.5
log
@src0401
@
text
@a11 1
#include "config.h"
d19 1
d25 1
a25 1
struct slip Slip[ASY_MAX];
d27 52
a86 1
#ifdef VJCOMPRESS
d89 1
a89 1
#endif
a93 1
#ifdef VJCOMPRESS
a99 1
#endif
a244 1
#ifdef VJCOMPRESS
a263 1
#endif
a292 2
	tprintf("  IN:\t%lu pkts\n", iface->rawrecvcnt);
#ifdef VJCOMPRESS
a293 3
#endif
	tprintf("  OUT:\t%lu pkts\n", iface->rawsndcnt);
#ifdef VJCOMPRESS
a294 1
#endif
a295 2


@


1.4
log
@src0327
@
text
@d217 7
a223 3
		if ( net_route( sp->iface, sp->type, bp ) != 0 ) {
			free_p(bp);
		}
@


1.3
log
@src0922
@
text
@d29 1
a29 1
slip_send(bp,iface,gateway,prec,del,tput,rel)
d33 1
a33 4
int prec;
int del;
int tput;
int rel;
@


1.2
log
@src0318
@
text
@a67 1
		free_p(bp);
a131 1
		sp->rcnt = 0;
a165 1
			sp->rcnt = 0;
a175 1
	sp->rcnt++;
d228 1
d230 1
a230 1
int
d238 1
a238 1
		return 1;
d243 1
a243 1
		return 1;
a252 1
	return 0;
@


1.1
log
@Initial revision
@
text
@d3 1
d5 4
d12 1
d15 3
a17 1
#include "ax25.h"
a18 1
#include "asy.h"
a19 4
#include "config.h"
#include "internet.h"
#include "ip.h"
#include "slcompre.h"
d50 1
a50 1
		type = sl_compress_tcp(&bp,sp->slcomp,1);
d131 2
a132 2
		bp = sp->rbp;
		sp->rbp = NULLBUF;
d157 1
a157 1
	if(sp->rbp == NULLBUF){
d159 1
a159 1
		if((sp->rbp1 = sp->rbp = alloc_mbuf(SLIP_ALLOC)) == NULLBUF)
d161 2
a162 2
		sp->rcp = sp->rbp->data;
	} else if(sp->rbp1->cnt == SLIP_ALLOC){
d164 1
a164 1
		if((sp->rbp1->next = alloc_mbuf(SLIP_ALLOC)) == NULLBUF){
d166 2
a167 2
			free_p(sp->rbp);
			sp->rbp = NULLBUF;
d171 2
a172 2
		sp->rbp1 = sp->rbp1->next;
		sp->rcp = sp->rbp1->data;
d178 1
a178 1
	sp->rbp1->cnt++;
d182 2
d192 1
a192 2
	struct mbuf *bp,*nbp;
	struct phdr phdr;
a193 3
#ifdef VJCOMPRESS
	int16 len;
#endif
d197 1
a197 1
	cdev = sp->iface->xdev;
d199 1
a199 2
	for(;;){
		c = sp->get(cdev);
d206 11
a216 15
		if ((len = len_p(bp)) >= 3) {
			/* Got a packet at least minimum length
			 * of a compressed packet
			 */
			if ((sp->escaped & SLIP_VJCOMPR) &&
			    ((c = (bp->data[0] & 0xf0)) != (IPVERSION << 4))) {
				/* Got a compressed TCP packet */
				if (c & 0x80)
					c = SL_TYPE_COMPRESSED_TCP;
				else if (c == SL_TYPE_UNCOMPRESSED_TCP)
					bp->data[0] &= 0x4f;
				len = sl_uncompress_tcp(&bp, len,
					(int16)(c & 0x00ff),
					sp->slcomp);
				if (len <= 0) {
d224 1
a224 2

		if((nbp = pushdown(bp,sizeof(phdr))) == NULLBUF){
a225 1
			continue;
a226 10
		phdr.iface = sp->iface;
		phdr.type = sp->type;
		memcpy(&nbp->data[0],(char *)&phdr,sizeof(phdr));
		enqueue(&Hopper,nbp);
		/* Especially on slow machines, serial I/O can be quite
		 * compute intensive, so release the machine before we
		 * go for the next packet. This will allow this packet to
		 * go on to its ultimate destination, helping pipelining
		 */
		pwait(NULL);
d228 1
a229 8
#ifdef VJCOMPRESS
/* Show VJ stats if async interface is SLIP with VJ TCP compression */
void
doslstat(iface)
struct iface *iface;
{
	struct slip *sp;
	struct slcompress *slp;
a230 3
	if (iface->xdev > SLIP_MAX)
		/* Must not be a SLIP device */
		return;
d232 3
a234 28
	sp = &Slip[iface->xdev];
	if (sp->iface != iface)
		/* Must not be a SLIP device */
		return;

	if ((sp->escaped & SLIP_VJCOMPR) == 0)
		/* SLIP device, but not doing VJ TCP header compression */
		return;

	slp = sp->slcomp;
	tprintf("  Link encap SLIP::VJ Compress\n");
	tprintf("  IN:  pkt %lu comp %lu",
		 iface->rawrecvcnt, slp->sls_compressedin);
	tprintf(" uncomp %lu err %lu toss %lu ip %lu\n",
		 slp->sls_uncompressedin, slp->sls_errorin,
		 slp->sls_tossed, iface->rawrecvcnt -
		 slp->sls_uncompressedin - slp->sls_compressedin);
	tprintf("  OUT: pkt %lu comp %lu uncomp %lu",
		 iface->rawsndcnt, slp->sls_compressed,
		 slp->sls_uncompressed);
	tprintf(" ip %lu search %lu miss %lu",
		 (slp->sls_nontcp + slp->sls_asistcp),
		 slp->sls_searches, slp->sls_misses);
	tprintf("\n");
}
#else
void
doslstat(iface)
d241 1
a241 1
		return;
d246 1
a246 1
		return;
d248 9
a256 3
	tprintf("  Link encap SLIP\n");
	tprintf("  IN:  pkt %lu", iface->rawrecvcnt);
	tprintf("  OUT: pkt %lu\n", iface->rawsndcnt);
d258 1
a258 1
#endif
@


1.1.2.1
log
@src0308
@
text
@d16 1
a16 1
#include "slcomp.h"
@
