head	1.6;
access;
symbols;
locks;
comment	@# @;


1.6
date	93.03.11.08.06.32;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	93.01.05.19.58.06;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	93.01.02.00.00.08;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.06.29.08.04.44;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.27.15.13.42;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.13.03.04;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.6
log
@Clear direction flag at interrupt entry
@
text
@; Packet driver interrupt hooks

include	asmglobal.h
	extrn	pkint:proc

	.DATA
	extrn	Stktop

	.CODE
sssave	dw	?
spsave	dw	?
dbase	dw	@@Data

if	@@Cpu AND 8	; temp storage for POPAD operations
disave	dw	?
endif

; pkvec0 - Packet driver receive call handler #0
	public	pkvec0
	label	pkvec0	far
	pushf			; save his interrupt state
	cld
	cli			; no distractions
	mov	cs:sssave,ss	; stash user stack context
	mov	cs:spsave,sp

	mov	ss,cs:dbase	; set up interrupt stack
	lea	sp,Stktop
	if @@Cpu AND 8
		PUSHALL		; Protect 32-bit regs
	endif
	push	ds		; save for caller
	mov	ds,cs:dbase
	push	ax
	push	cx
	mov	ax,0	; device #0
	push	ax
	call	pkint
	jmp	pkret

; pkvec1 - Packet driver receive call handler #1
	public	pkvec1
	label	pkvec1	far
	pushf			; save his interrupt state
	cld
	cli			; no distractions
	mov	cs:sssave,ss	; stash user stack context
	mov	cs:spsave,sp

	mov	ss,cs:dbase	; set up interrupt stack
	lea	sp,Stktop
	if @@Cpu AND 8
		PUSHALL		; Protect 32-bit regs
	endif
	push	ds		; save for caller
	mov	ds,cs:dbase
	push	ax
	push	cx
	mov	ax,1	; device #1
	push	ax
	call	pkint
	jmp	pkret


; pkvec2 - Packet driver receive call handler #2
	public	pkvec2
	label	pkvec2	far
	pushf			; save his interrupt state
	cld
	cli			; no distractions
	mov	cs:sssave,ss	; stash user stack context
	mov	cs:spsave,sp

	mov	ss,cs:dbase	; set up interrupt stack
	lea	sp,Stktop
	if @@Cpu AND 8
		PUSHALL		; Protect 32-bit regs
	endif
	push	ds		; save for caller
	mov	ds,cs:dbase
	push	ax
	push	cx
	mov	ax,2	; device #2
	push	ax
	call	pkint
	jmp	pkret


; common return for all packet drivers
	label	pkret	near
	mov	es,dx	; move returned pointer from DX:AX to ES:DI
	mov	di,ax
	pop	ax	; pop dev # arg	
	pop	cx
	pop	ax
	pop	ds		; restore for caller
	if	@@Cpu AND 8	; POPAD available
		mov cs:disave,di
		POPALL		; restore all regs but DI 
		mov di,cs:disave
	endif

	mov	ss,cs:sssave
	mov	sp,cs:spsave	; restore original stack context
	POPFLAGS
	retf

	end
@


1.5
log
@Use POPFLAGS
@
text
@d22 1
d45 1
d69 1
@


1.4
log
@Significant changes to support BCC -3 flag to use 32 bit registers
Since pkint() is no longer an interrupt function, we save the
registers ourselves (in 32 bit mode) and pass only those registers
actually needed as args to pkint(), which now returns its buffer
addresses in dx:ax instead of modifying its arguments.
Use the PUSHALL/POPALL macros to save and restore registers,
taking care to protect the high order 16 bits of the 32-bit registers
since this all gets executed at interrupt time, and the main program
might be using 32 bit registers.
@
text
@d102 1
a102 1
	popf
@


1.3
log
@Fixed for TASM 3.0
@
text
@d3 1
a3 2
include	asmmodel.h
	%MACS
a11 1
axsave	dw	?
d14 4
a24 1
	mov	cs:axsave,ax	; save our AX register
d28 3
d32 3
a34 3

	mov	ax,ss
	mov	ds,ax
a36 2
	mov	ax,cs:axsave	; Restore AX
	pushf		; make it look like an INTERRUPT
a46 1
	mov	cs:axsave,ax	; save our AX register
d50 3
d54 3
a56 3

	mov	ax,ss
	mov	ds,ax
a58 2
	mov	ax,cs:axsave	; Restore AX
	pushf		; make it look like an INTERRUPT
d62 1
a69 1
	mov	cs:axsave,ax	; save our AX register
d73 3
d77 3
a79 3

	mov	ax,ss
	mov	ds,ax
a81 2
	mov	ax,cs:axsave	; Restore AX
	pushf		; make it look like an INTERRUPT
d85 1
d88 11
a98 2
	pop	ax	; pop dev # arg
	pop	ds	; restore for caller
@


1.2
log
@src0420
@
text
@d3 1
a3 1
	.MODEL	MEMMOD,C
@


1.1
log
@Initial revision
@
text
@d13 1
d23 1
d27 1
a28 11
	; save regs, making them available to pkint()
	push	es
	push	ds
	push	ax
	push	bx
	push	cx
	push	dx
	push	bp
	push	si
	push	di

d33 2
d45 1
d49 1
a49 11

	; save regs, making them available to pkint()
	push	es
	push	ds
	push	ax
	push	bx
	push	cx
	push	dx
	push	bp
	push	si
	push	di
d55 2
d67 1
d71 1
a71 11

	; save regs, making them available to pkint()
	push	es
	push	ds
	push	ax
	push	bx
	push	cx
	push	dx
	push	bp
	push	si
	push	di
d77 2
d85 1
a85 9
	pop	di
	pop	si
	pop	bp
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	ds
	pop	es
@
