head	1.9;
access;
symbols;
locks;
comment	@ * @;


1.9
date	93.05.06.10.08.39;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	93.01.02.08.25.08;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.09.08.08.25.54;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.05.13.02.27.00;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.05.01.11.15.06;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.04.15.11.40.20;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.03.29.03.31.32;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.07.22.03.40.16;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.11.51.48;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.9
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/*
 *	HOP.C   -- trace route packets take to a remote host
 *
 *	02-90	-- Katie Stevens (dkstevens@@ucdavis.edu)
 *		   UC Davis, Computing Services
 *		   Davis, CA
 *	04-90	-- Modified by Phil Karn to use raw IP sockets to read replies
 *	08-90	-- Modified by Bill Simpson to display domain names
 */

#include <stdio.h>
#include <string.h>
#include "global.h"
#include "mbuf.h"
#include "usock.h"
#include "socket.h"
#include "session.h"
#include "timer.h"
#include "proc.h"
#include "netuser.h"
#include "domain.h"
#include "commands.h"
#include "tty.h"
#include "cmdparse.h"
#include "ip.h"
#include "icmp.h"
#include "udp.h"
#include "hardware.h"

#define HOPMAXQUERY	5		/* Max# queries each TTL value */
static uint16 Hoprport = 32768+666;	/* funny port for udp probes */
#define HOP_HIGHBIT	32768		/* Mask to check ICMP msgs */


#define HOPTRACE	1		/* Enable HOP tracing */
#ifdef HOPTRACE
static int Hoptrace = 0;
static int hoptrace(int argc,char *argv[],void *p);
#endif


static unsigned  short Hopmaxttl  = 30;		/* max attempts */
static unsigned  short Hopmaxwait = 5;		/* secs timeout each attempt */
static unsigned  short Hopquery   = 3;		/* #probes each attempt */

static int hopcheck(int argc,char *argv[],void *p);
static int hopttl(int argc,char *argv[],void *p);
static int hopwait(int argc,char *argv[],void *p);
static int hopnum(int argc,char *argv[],void *p);
static int geticmp(int s,uint16 lport,uint16 fport,
	int32 *sender,char *type,char *code);
static int keychar(int c);

static struct cmds Hopcmds[] = {
	"check",	hopcheck,	2048,	2,	"check <host>",
	"maxttl",	hopttl,		0,	0,	NULLCHAR,
	"maxwait",	hopwait,	0,	0,	NULLCHAR,
	"queries",	hopnum,		0,	0,	NULLCHAR,
#ifdef HOPTRACE
	"trace",	hoptrace,	0,	0,	NULLCHAR,
#endif
	NULLCHAR,
};

/* attempt to trace route to a remote host */
int
dohop(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(Hopcmds,argc,argv,p);
}

/* Set/show # queries sent each TTL value */
static int
hopnum(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	uint16 r;
	uint16 x = Hopquery;
	r = setshort(&x,"# queries each attempt",argc,argv);
	if ((x <= 0)||(x > HOPMAXQUERY)) {
		printf("Must be  0 < x <= %d\n",HOPMAXQUERY);
		return 0;
	} else {
		Hopquery = x;
	}
    return (int)r;
}
#ifdef HOPTRACE
/* Set/show tracelevel */
static int
hoptrace(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setbool(&Hoptrace,"HOPCHECK tracing",argc,argv);
}
#endif
/* Set/show maximum TTL value for a traceroute query */
static int
hopttl(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	uint16 r;
	uint16 x = Hopmaxttl;
	r = setshort(&x,"Max attempts to reach host",argc,argv);
	if ((x <= 0)||(x > 255)) {
		printf("Must be  0 < x <= 255\n");
		return 0;
	} else {
		Hopmaxttl = x;
	}
    return (int)r;
}
/* Set/show #secs until timeout for a traceroute query */
static int
hopwait(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	uint16 r;
	uint16 x = Hopmaxwait;
	r = setshort(&x,"# secs to wait for reply to query",argc,argv);
	if (x <= 0) {
		printf("Must be >= 0\n");
		return 0;
	} else {
		Hopmaxwait = x;
	}
    return (int)r;
}

/* send probes to trace route of a remote host */
static int
hopcheck(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct session *sp;		/* Session for trace output */
	int s;				/* Socket for queries */
	int s1;				/* Raw socket for replies */
	struct socket lsocket;		/* Local socket sending queries */
	struct socket rsocket;		/* Final destination of queries */
	int32 cticks;			/* Timer for query replies */
	int32 icsource;			/* Sender of last ICMP reply */
	char ictype;			/* ICMP type last ICMP reply */
	char iccode;			/* ICMP code last ICMP reply */
	int32 lastaddr;			/* Sender of previous ICMP reply */
	struct sockaddr_in sock;
	register struct usock *usp;
	register struct sockaddr_in *sinp;
	unsigned char sndttl, q;
	int tracedone = 0;
	int ilookup = 1;		/* Control of inverse domain lookup */
	int c;
	extern int optind;
	char *hostname;
	int save_trace;
	int user_reset = 0;

	optind = 1;
	while((c = getopt(argc,argv,"n")) != EOF){
		switch(c){
		case 'n':
			ilookup = 0;
			break;
		}
	}
	hostname = argv[optind];
	/* Allocate a session descriptor */
	if((sp = newsession(Cmdline,HOP,1)) == NULLSESSION){
		printf("Too many sessions\n");
		keywait(NULLCHAR,1);
		return 1;
	}
	sp->inproc = keychar;
	s = -1;

	/* Setup UDP socket to remote host */
	sock.sin_family = AF_INET;
	sock.sin_port = Hoprport;
	printf("Resolving %s... ",hostname);
	if((sock.sin_addr.s_addr = resolve(hostname)) == 0){
		printf("unknown\n",hostname);
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}

	/* Open socket to remote host */
	printf("%s ",psocket((struct sockaddr *)&sock));
	if((s = socket(AF_INET,SOCK_DGRAM,0)) == -1){
		printf("Can't create udp socket\n");
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}
	if(connect(s,(char *)&sock,sizeof(sock)) == -1){
		printf("Connect failed\n");
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}
	if((s1 = socket(AF_INET,SOCK_RAW,ICMP_PTCL)) == -1){
		printf("Can't create raw socket\n");
		keywait(NULLCHAR,1);
		close(s);
		freesession(sp);
		return 1;
	}
	printf("\n");
	/* turn off icmp tracing while hop-checking */
	save_trace = Icmp_trace;
	Icmp_trace = 0;

	/* Setup structures to send queries */
	/* Retrieve socket details for user socket control block */
	usp = itop(s);
	sinp = (struct sockaddr_in *)usp->name;
	lsocket.address = sinp->sin_addr.s_addr;
	lsocket.port = sinp->sin_port;
	sinp = (struct sockaddr_in *)usp->peername;
	rsocket.address = sinp->sin_addr.s_addr;

	/* Send queries with increasing TTL; start with TTL=1 */
	if (Hoptrace)
		log(s,"HOPCHECK start trace to %s\n",sp->name);
	for (sndttl=1; (sndttl < Hopmaxttl); ++sndttl, sinp->sin_port++) {
		/* Increment funny UDP port number each round */
		rsocket.port = sinp->sin_port;
		printf("%3d:",sndttl);
		lastaddr = (int32)0;
		/* Send a round of queries */
		for (q=0; (q < Hopquery); ++q) {
			send_udp(&lsocket,&rsocket,0,sndttl,NULLBUF,0,0,0);
			cticks = msclock();
			alarm( ((long)Hopmaxwait*1000L) );

			/* Wait for a reply to our query */
			if(geticmp(s1,lsocket.port,rsocket.port,
			 &icsource,&ictype,&iccode) == -1){
				if(errno != EALARM){
					user_reset = 1;
					goto done;	/* User reset */
				}
				/* Alarm rang, give up waiting for replies */
				printf(" ***");
				continue;
			}
			/* Save #ticks taken for reply */
                        cticks = msclock() - cticks;
			/* Report ICMP reply */
			if (icsource != lastaddr) {
				struct rr *save_rrlp, *rrlp;

				if(lastaddr != (int32)0)
					printf("\n    ");
				printf(" %-15s",inet_ntoa(icsource));
				if(ilookup){
					for(rrlp = save_rrlp = inverse_a(icsource);
					    rrlp != NULLRR;
					    rrlp = rrlp->next){
						if(rrlp->rdlength > 0){
							switch(rrlp->type){
							case TYPE_PTR:
								printf(" %s", rrlp->rdata.name);
								goto got_name;
							case TYPE_A:
								printf(" %s", rrlp->name);
								goto got_name;
							}
#ifdef notdef
							if(rrlp->next != NULLRR)
								printf("\n%20s"," ");
#endif
						}
					}
					got_name: ;
					free_rr(save_rrlp);

				}
				lastaddr = icsource;
			}
                        printf(" (%ld ms)",cticks);
#ifdef HOPTRACE
			if (Hoptrace)
				log(s,
				    "(hopcheck) ICMP from %s (%ldms) %s %s",
				    inet_ntoa(icsource),
				    cticks,
				    Icmptypes[ictype],
				    ((ictype == ICMP_TIME_EXCEED)?Exceed[iccode]:Unreach[iccode]));
#endif

			/* Check type of reply */
			if (ictype == ICMP_TIME_EXCEED)
				continue;
			/* Reply was: destination unreachable */
			switch(iccode) {
			case ICMP_PORT_UNREACH:
				++tracedone;
				break;
			case ICMP_NET_UNREACH:
				++tracedone;
				printf(" !N");
				break;
			case ICMP_HOST_UNREACH:
				++tracedone;
				printf(" !H");
				break;
			case ICMP_PROT_UNREACH:
				++tracedone;
				printf(" !P");
				break;
			case ICMP_FRAG_NEEDED:
				++tracedone;
				printf(" !F");
				break;
			case ICMP_ROUTE_FAIL:
				++tracedone;
				printf(" !S");
				break;
                        case ICMP_ADMIN_PROHIB:
                                ++tracedone;
                                printf(" !A");
                                break;
                        default:
                                printf(" !?");
                                break;
			}
		}
		/* Done with this round of queries */
		alarm((long)0);
		printf("\n");
		/* Check if we reached remote host this round */
		if (tracedone != 0)
			break;
	}

	/* Done with traceroute */
done:	close(s);
	s = -1;
	close(s1);
	if(user_reset)
		printf("\n");	/* May have been in middle of line */
	printf("traceroute done: ");
	Icmp_trace = save_trace;
	if(user_reset){
		printf("user abort\n");
	} else if (sndttl >= Hopmaxttl) {
		printf("!! maximum TTL exceeded\n");
	} else if ((icsource == rsocket.address)
		    &&(iccode == ICMP_PORT_UNREACH)) {
		printf("normal (%s %s)\n",
			Icmptypes[ictype],Unreach[iccode]);
	} else {
		printf("!! %s %s\n",
			Icmptypes[ictype],Unreach[iccode]);
	}
#ifdef HOPTRACE
	if (Hoptrace)
		log(s,"HOPCHECK to %s done",sp->name);
#endif
	keywait(NULLCHAR,1);
	freesession(sp);
	return 0;
}

/* Hop check session keyboard upcall routine -- handles ^C */
static int
keychar(c)
int c;
{
	switch(c){
	case CTLC:
		alert(Current->proc,EABORT);
		return 0;
	}
	return 1;
}

/* Read raw network socket looking for ICMP messages in response to our
 * UDP probes
 */
static int
geticmp(s,lport,fport,sender,type,code)
int s;
uint16 lport;
uint16 fport;
int32 *sender;
char *type,*code;
{
	int size;
	struct icmp icmphdr;
	struct ip iphdr;
	struct udp udphdr;
	struct mbuf *bp;
	struct sockaddr_in sock;

	for(;;){
		size = sizeof(sock);
		if(recv_mbuf(s,&bp,0,(char *)&sock,&size) == -1)
			return -1;
		/* It's an ICMP message, let's see if it's interesting */
		ntohicmp(&icmphdr,&bp);
		if((icmphdr.type != ICMP_TIME_EXCEED ||
		 icmphdr.code != ICMP_TTL_EXCEED)
		 && icmphdr.type != ICMP_DEST_UNREACH){
			/* We're not interested in these */
			free_p(bp);
			continue;
		}
		ntohip(&iphdr,&bp);
		if(iphdr.protocol != UDP_PTCL){
			/* Not UDP, so can't be interesting */
			free_p(bp);
			continue;
		}
		ntohudp(&udphdr,&bp);
		if(udphdr.dest != fport || udphdr.source != lport){
			/* Not from our hopcheck session */
			free_p(bp);
			continue;
		}
		/* Passed all of our checks, so return it */
		*sender = sock.sin_addr.s_addr;
		*type = icmphdr.type;
		*code = icmphdr.code;
		free_p(bp);
		return 0;
	}
}
@


1.8
log
@Call newsession with Cmdline
Tighten startup messages
@
text
@d31 1
a31 1
static int16 Hoprport = 32768+666;	/* funny port for udp probes */
d38 1
a38 1
static int hoptrace __ARGS((int argc,char *argv[],void *p));
d46 7
a52 7
static int hopcheck __ARGS((int argc,char *argv[],void *p));
static int hopttl __ARGS((int argc,char *argv[],void *p));
static int hopwait __ARGS((int argc,char *argv[],void *p));
static int hopnum __ARGS((int argc,char *argv[],void *p));
static int geticmp __ARGS((int s,int16 lport,int16 fport,
	int32 *sender,char *type,char *code));
static int keychar __ARGS((int c));
d82 2
a83 2
	int16 r;
	int16 x = Hopquery;
d111 2
a112 2
	int16 r;
	int16 x = Hopmaxttl;
d129 2
a130 2
	int16 r;
	int16 x = Hopmaxwait;
d397 2
a398 2
int16 lport;
int16 fport;
@


1.7
log
@Add ^C processing in hop check command
@
text
@d180 1
a180 1
	if((sp = newsession(hostname,HOP,1)) == NULLSESSION){
d193 1
a193 1
		printf("Host %s unknown\n",hostname);
d200 1
a200 1
	printf("traceroute to %s\n",psocket((struct sockaddr *)&sock));
d220 1
@


1.6
log
@src0514
@
text
@d52 1
d168 1
d185 1
d250 2
a251 1
				if(errno != EALARM)
d253 1
d352 2
d356 3
a358 1
	if (sndttl >= Hopmaxttl) {
d375 13
@


1.5
log
@src0501
@
text
@a183 1
	sp->flowmode = 1;
d213 1
a213 1
		close_s(s);
d344 1
a344 1
done:	close_s(s);
d346 1
a346 1
	close_s(s1);
@


1.4
log
@src0415
@
text
@d179 1
a179 1
		tprintf("Too many sessions\n");
d183 1
a183 1
	sp->s = s = -1;
d189 1
a189 1
	tprintf("Resolving %s... ",hostname);
d191 1
a191 1
		tprintf("Host %s unknown\n",hostname);
d198 3
a200 3
	tprintf("traceroute to %s\n",psocket((struct sockaddr *)&sock));
	if((sp->s = s = socket(AF_INET,SOCK_DGRAM,0)) == -1){
		tprintf("Can't create udp socket\n");
d206 1
a206 1
		tprintf("Connect failed\n");
d212 1
a212 1
		tprintf("Can't create raw socket\n");
d214 1
d233 1
a233 1
		log(sp->s,"HOPCHECK start trace to %s\n",sp->name);
d237 1
a237 1
		tprintf("%3d:",sndttl);
d251 1
a251 1
				tprintf(" ***");
d261 2
a262 2
					tprintf("\n    ");
				tprintf(" %-15s",inet_ntoa(icsource));
d270 1
a270 1
								tprintf(" %s", rrlp->rdata.name);
d273 1
a273 1
								tprintf(" %s", rrlp->name);
d278 1
a278 1
								tprintf("\n%20s"," ");
d288 1
a288 1
                        tprintf(" (%ld ms)",cticks);
d291 1
a291 1
				log(sp->s,
d309 1
a309 1
				tprintf(" !N");
d313 1
a313 1
				tprintf(" !H");
d317 1
a317 1
				tprintf(" !P");
d321 1
a321 1
				tprintf(" !F");
d325 1
a325 1
				tprintf(" !S");
d329 1
a329 1
                                tprintf(" !A");
d332 1
a332 1
                                tprintf(" !?");
d338 1
a338 1
		tprintf("\n");
d346 1
a346 1
	sp->s = -1;
d348 1
a348 1
	tprintf("traceroute done: ");
d351 1
a351 1
		tprintf("!! maximum TTL exceeded\n");
d354 1
a354 1
		tprintf("normal (%s %s)\n",
d357 1
a357 1
		tprintf("!! %s %s\n",
d362 1
a362 1
		log(sp->s,"HOPCHECK to %s done",sp->name);
@


1.3
log
@src0331
@
text
@d270 1
a270 1
								break;
d273 1
a273 1
								break;
d275 1
d278 1
d281 1
@


1.2
log
@src0922
@
text
@d178 1
a178 1
	if((sp = newsession(hostname,HOP)) == NULLSESSION){
@


1.1
log
@Initial revision
@
text
@d166 1
d217 4
d323 7
d345 1
@
