head	1.9;
access;
symbols;
locks;
comment	@ * @;


1.9
date	93.02.01.10.06.43;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.12.28.08.59.31;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.12.21.21.26.47;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.09.09.01.30.37;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.08.11.13.11.57;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.07.10.01.57.32;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.05.01.11.59.38;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.12.16.16.05.50;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.11.51.04;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.9
log
@Add casts to MD5Update() args
@
text
@/* Routines common to both the FTP client and server
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "socket.h"
#include "proc.h"
#include "ftp.h"
#include "cmdparse.h"
#include "md5.h"

#define	MD5BLOCK	64	/* Preferred MD5 block size */

/* Send a file (opened by caller) on a network socket.
 * Normal return: count of bytes sent
 * Error return: -1
 */
long
sendfile(fp,network,mode,verb)
FILE *fp;	/* File to be sent */
FILE *network;	/* Network stream to be sent on */
int mode;	/* Transfer mode */
int verb;	/* Verbosity level */
{
	long total = 0;
	long hmark = 0;
	char *buf;
	int cnt;
	char cmdbuf[50];

	if(verb >= V_STAT){
		sprintf(cmdbuf,"repeat socket %d",fileno(network));
		cmdparse(Cmds,cmdbuf,NULL);
	}
	switch(mode){
	default:
	case LOGICAL_TYPE:
	case IMAGE_TYPE:
		fmode(network,STREAM_BINARY);
		break;
	case ASCII_TYPE:
		fmode(network,STREAM_ASCII);
		break;
	}
	buf = mallocw(BUFSIZ);
	for(;;){
		if((cnt = fread(buf,1,BUFSIZ,fp)) == 0){
			break;
		}
		total += cnt;
		if(fwrite(buf,1,cnt,network) != cnt){
			total = -1;
			break;
		}
		while(verb == V_HASH && total >= hmark+1000){
			putchar('#');
			hmark += 1000;
		}
	}
	free(buf);
	if(verb == V_HASH)
		putchar('\n');
	return total;
}
/* Receive a file (opened by caller) from a network stream
 * Normal return: count of bytes received
 * Error return: -1
 */
long
recvfile(fp,network,mode,verb)
FILE *fp;
FILE *network;
int mode;
int verb;
{
	int cnt;
	long total = 0;
	long hmark = 0;
	char *buf;
	char cmdbuf[50];

	if(verb >= V_STAT){
		sprintf(cmdbuf,"repeat socket %d",fileno(network));
		cmdparse(Cmds,cmdbuf,NULL);
	}
	if(fp == NULLFILE)
		fp = stdout;	/* Default */
	switch(mode){
	default:
	case LOGICAL_TYPE:
	case IMAGE_TYPE:
		fmode(network,STREAM_BINARY);
		break;
	case ASCII_TYPE:
		fmode(network,STREAM_ASCII);
		break;
	}
	buf = mallocw(BUFSIZ);
	while((cnt = fread(buf,1,BUFSIZ,network)) != 0){
		total += cnt;
		while(verb == V_HASH && total >= hmark+1000){
			putchar('#');
			hmark += 1000;
		}
		if(fwrite(buf,1,cnt,fp) != cnt){
			total = -1;
			break;
		}
		/* Detect an abnormal close */
		if(socklen(fileno(network),0) == -1){
			total = -1;
			break;
		}
	}
	free(buf);
	if(verb == V_HASH)
		putchar('\n');
	return total;
}
/* Determine if a file appears to be binary (i.e., non-text).
 * Return 1 if binary, 0 if ascii text after rewinding the file pointer.
 *
 * Used by FTP to warn users when transferring a binary file in text mode.
 */
int
isbinary(fp)
FILE *fp;
{
	int c,i;
	int rval;

	rval = 0;
	for(i=0;i<512;i++){
		if((c = getc(fp)) == EOF)
			break;
		if(c & 0x80){
			/* High bit is set, probably not text */
			rval = 1;
			break;
		}
	}
	/* Assume it was at beginning */
	fseek(fp,0L,SEEK_SET);
	return rval;
}
/* Compute MD5 hash of local file */
int
md5hash(fp,hash,ascii)
FILE *fp;
char hash[16];
int ascii;
{
	MD5_CTX md;
	char *buf;
	int len;

	MD5Init(&md);

	if(ascii){
		/* Text file, hash canonical form (newlines = crlf) */
		char *cp;
		int c;

		cp = buf = malloc(MD5BLOCK);
		len = 0;
		while((c = fgetc(fp)) != EOF){
			if(c == '\n'){
				*cp++ = '\r';
				if(++len == MD5BLOCK){
					MD5Update(&md,(unsigned char *)buf,len);
					pwait(NULL);
					cp = buf;
					len = 0;
				}
			}
			*cp++ = c;
			if(++len == MD5BLOCK){
				MD5Update(&md,(unsigned char *)buf,len);
				pwait(NULL);
				cp = buf;
				len = 0;
			}
		}
		if(len != 0)
			MD5Update(&md,(unsigned char *)buf,len);
		free(buf);
	} else {
		buf = malloc(BUFSIZ);
		while((len = fread(buf,1,BUFSIZ,fp)) != 0){
			MD5Update(&md,(unsigned char *)buf,len);
			pwait(NULL);
		}
		free(buf);
	}
	MD5Final(&md);
	memcpy(hash,md.digest,16);
	return 0;
}
@


1.8
log
@Translate ascii files to canonical form for MD5 hashing
@
text
@d171 1
a171 1
					MD5Update(&md,buf,len);
d179 1
a179 1
				MD5Update(&md,buf,len);
d186 1
a186 1
			MD5Update(&md,buf,len);
d191 1
a191 1
			MD5Update(&md,buf,len);
@


1.7
log
@Add md5hash() function
@
text
@d13 2
d149 1
a149 1
md5hash(fp,hash)
d152 1
d159 36
a194 4
	buf = malloc(BUFSIZ);
	while((len = fread(buf,1,BUFSIZ,fp)) != 0){
		MD5Update(&md,buf,len);
		pwait(NULL);
a195 1
	free(buf);
@


1.6
log
@Add new verbosity level, 4, to spawn an autorepeat display of the
data TCP connection control block during the transfer
@
text
@d11 1
d145 9
d155 11
@


1.5
log
@BLKSIZE (2K) replaced with BUFSIZ (1K)
@
text
@d10 1
d17 1
a17 1
sendfile(fp,network,mode,hash)
d21 1
a21 1
int hash;	/* Print hash marks every 1000 bytes */
d27 1
d29 4
d53 1
a53 1
		while(hash && total >= hmark+1000){
d59 1
a59 1
	if(hash)
d68 1
a68 1
recvfile(fp,network,mode,hash)
d72 1
a72 1
int hash;
d78 1
d80 4
d99 1
a99 1
		while(hash && total >= hmark+1000){
d114 1
a114 1
	if(hash)
@


1.4
log
@Fix memory leak in recvfile()
@
text
@d20 1
a20 1
int hash;	/* Print hash marks every BLKSIZE bytes */
d37 1
a37 1
	buf = mallocw(BLKSIZE);
d39 1
a39 1
		if((cnt = fread(buf,1,BLKSIZE,fp)) == 0){
@


1.3
log
@src0501
@
text
@d102 1
@


1.2
log
@src1216
@
text
@d16 1
a16 1
sendfile(fp,s,mode,hash)
d18 1
a18 1
int s;		/* Socket to be sent on */
a21 2
	register struct mbuf *bp;
	int c,oldf;
d24 2
d31 1
a31 17
		sockmode(s,SOCK_BINARY);
		for(;;){
			bp = ambufw(BLKSIZE);
			if((bp->cnt = fread(bp->data,1,BLKSIZE,fp)) == 0){
				free_p(bp);
				break;
			}
			total += bp->cnt;
			if(send_mbuf(s,bp,0,NULLCHAR,0) == -1){
				total = -1;
				break;
			}
			while(hash && total >= hmark+1000){
				tputc('#');
				hmark += 1000;
			}
		}
d34 16
a49 22
		oldf = setflush(s,-1);
		/* Let the newline mapping code in usputc() do the work */
		sockmode(s,SOCK_ASCII);
		while((c = getc(fp)) != EOF){
#if !defined(UNIX) && !defined(__TURBOC__)
			if(c == '\r'){
				/* Needed only if the OS uses a CR/LF
				 * convention and getc doesn't do
				 * an automatic translation
				 */
				continue;
			}
#endif
			if(usputc(s,(char)c) == -1){
				total = -1;
				break;
			}
			total++;
			while(hash && total >= hmark+1000){
				tputc('#');
				hmark += 1000;
			}
a50 3
		usflush(s);
		setflush(s,oldf);		
		break;
d52 1
d54 1
a54 1
		tputc('\n');
d57 1
a57 1
/* Receive a file (opened by caller) from a network socket.
d62 1
a62 1
recvfile(fp,s,mode,hash)
d64 1
a64 1
int s;
d68 1
a68 2
	int cnt,c;
	struct mbuf *bp;
d71 1
d73 2
d79 1
a79 22
		sockmode(s,SOCK_BINARY);
		while((cnt = recv_mbuf(s,&bp,0,NULLCHAR,0)) != 0){
			if(cnt == -1){
				total = -1;
				break;
			}
			total += cnt;
			while(hash && total >= hmark+1000){
				tputc('#');
				hmark += 1000;
			}
			if(fp != NULLFILE){
				if(write_p(fp,bp) == -1){
					free_p(bp);
					total = -1;
					break;
				}
				free_p(bp);
			} else {
				send_mbuf(Curproc->output, bp, 0, NULLCHAR, 0);
			}
		}
d82 13
a94 24
		sockmode(s,SOCK_ASCII);
		while((c = recvchar(s)) != EOF){
			if(fp != NULLFILE){
#if !defined(UNIX) && !defined(__TURBOC__) && !defined(AMIGA)
				if(c == '\n'){
					/* Needed only if the OS uses a CR/LF
					 * convention and putc doesn't do
					 * an automatic translation
					 */
					putc('\r',fp);
				}
#endif
				if(putc(c,fp) == EOF){
					total = -1;
					break;
				}
			} else {
				tputc((char)c);
			}
			total++;
			while(hash && total >= hmark+1000){
				tputc('#');
				hmark += 1000;
			}
d97 1
a97 1
		if(socklen(s,0) == -1)
d99 2
a100 1
		break;
d103 1
a103 1
		tputc('\n');
@


1.1
log
@Initial revision
@
text
@d40 2
a41 1
				return -1;
d103 4
a106 3
			if(cnt == -1)
				return -1;

d115 2
a116 1
					return -1;
@
