head	1.20;
access;
symbols;
locks;
comment	@ * @;


1.20
date	93.05.06.10.08.28;	author karn;	state Exp;
branches;
next	1.19;

1.19
date	93.01.04.10.18.12;	author karn;	state Exp;
branches;
next	1.18;

1.18
date	93.01.02.08.23.46;	author karn;	state Exp;
branches;
next	1.17;

1.17
date	92.12.29.21.29.32;	author karn;	state Exp;
branches;
next	1.16;

1.16
date	92.12.28.09.00.18;	author karn;	state Exp;
branches;
next	1.15;

1.15
date	92.12.21.21.25.05;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	92.09.09.01.31.42;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	92.09.08.08.29.06;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.09.07.21.04.43;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.07.09.07.35.40;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.06.01.21.44.54;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.05.18.09.34.14;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.05.11.04.00.36;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.05.03.11.01.04;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.05.01.10.40.30;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.04.01.14.55.46;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.03.29.03.31.26;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.12.18.07.22.10;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.12.16.15.38.46;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.11.50.10;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.20
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* Internet FTP client (interactive user)
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "session.h"
#include "cmdparse.h"
#include "proc.h"
#include "tty.h"
#include "socket.h"
#include "ftp.h"
#include "ftpcli.h"
#include "commands.h"
#include "netuser.h"
#include "dirutil.h"
#include "internet.h"

#define	POLLRATE	500	/* 500ms between more file polls */
#define	DIRBUF	256

static int doascii(int argc,char *argv[],void *p);
static int dobatch(int argc,char *argv[],void *p);
static int dobinary(int argc,char *argv[],void *p);
static int docompare(int argc,char *argv[],void *p);
static int doftpcd(int argc,char *argv[],void *p);
static int doget(int argc,char *argv[],void *p);
static int dohash(int argc,char *argv[],void *p);
static int doverbose(int argc,char *argv[],void *p);
static int dolist(int argc,char *argv[],void *p);
static int dols(int argc,char *argv[],void *p);
static int domd5(int argc,char *argv[],void *p);
static int domkdir(int argc,char *argv[],void *p);
static int domcompare(int argc,char *argv[],void *p);
static int domget(int argc,char *argv[],void *p);
static int domput(int argc,char *argv[],void *p);
static int doput(int argc,char *argv[],void *p);
static int doquit(int argc,char *argv[],void *p);
static int doread(int argc,char *argv[],void *p);
static int dormdir(int argc,char *argv[],void *p);
static int dotype(int argc,char *argv[],void *p);
static int doupdate(int argc,char *argv[],void *p);
static int getline(struct session *sp,char *prompt,char *buf,int n);
static int getresp(struct ftpcli *ftp,int mincode);
static long getsub(struct ftpcli *ftp,char *command,char *remotename,
	FILE *fp);
static long putsub(struct ftpcli *ftp,char *remotename,char *localname);
static int compsub(struct ftpcli *ftp,char *localname,char *remotename);
static void sendport(FILE *fp,struct sockaddr_in *socket);
static int keychar(int c);

static char Notsess[] = "Not an FTP session!\n";

static struct cmds Ftpcmds[] = {
	"",		donothing,	0, 0, NULLCHAR,
	"ascii",	doascii,	0, 0, NULLCHAR,
	"batch",	dobatch,	0, 0, NULLCHAR,
	"binary",	dobinary,	0, 0, NULLCHAR,
	"cd",		doftpcd,	0, 2, "cd <directory>",
	"compare",	docompare,	0, 2, "compare <remotefile> [<localfile>]",
	"dir",		dolist,		0, 0, NULLCHAR,
	"list",		dolist,		0, 0, NULLCHAR,
	"get",		doget,		0, 2, "get <remotefile> <localfile>",
	"hash",		dohash,		0, 0, NULLCHAR,
	"ls",		dols,		0, 0, NULLCHAR,
	"mcompare",	domcompare,	0, 2, "mcompare <file> [<file> ...]",
	"md5",		domd5,		0, 2, "md5 <file>",
	"mget",		domget,		0, 2, "mget <file> [<file> ...]",
	"mkdir",	domkdir,	0, 2, "mkdir <directory>",
	"mput",		domput,		0, 2, "mput <file> [<file> ...]",
	"nlst",		dols,		0, 0, NULLCHAR,
	"quit",		doquit,		0, 0, NULLCHAR,
	"read",		doread,		0, 2, "read <remotefile>",
	"rmdir",	dormdir,	0, 2, "rmdir <directory>",
	"put",		doput,		0, 2, "put <localfile> <remotefile>",
	"type",		dotype,		0, 0, NULLCHAR,
	"update",	doupdate,	0, 0, NULLCHAR,
	"verbose",	doverbose,	0, 0, NULLCHAR,
	NULLCHAR,	NULLFP,		0, 0, NULLCHAR,
};

/* Handle top-level FTP command */
int
doftp(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct session *sp;
	struct ftpcli ftp;
	struct sockaddr_in fsocket;
	int resp,vsave;
	char *bufsav,*cp;
	FILE *control;
	int s;

	/* Allocate a session control block */
	if((sp = newsession(Cmdline,FTP,1)) == NULLSESSION){
		printf("Too many sessions\n");
		return 1;
	}
	sp->inproc = keychar;
	memset((char *)&ftp,0,sizeof(ftp));
	ftp.control = ftp.data = NULLFILE;
	ftp.verbose = V_NORMAL;

	sp->cb.ftp = &ftp;	/* Downward link */
	ftp.session = sp;	/* Upward link */

	fsocket.sin_family = AF_INET;
	if(argc < 3)
		fsocket.sin_port = IPPORT_FTP;
	else
		fsocket.sin_port = atoi(argv[2]);

	if(SETSIG(EABORT)){
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}
	printf("Resolving %s...\n",argv[1]);
	if((fsocket.sin_addr.s_addr = resolve(argv[1])) == 0){
		printf(Badhost,argv[1]);
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}
	/* Open the control connection */
	if((s = socket(AF_INET,SOCK_STREAM,0)) == -1){
		printf("Can't create socket\n");
		keywait(NULLCHAR,1);
		freesession(sp);
		return 1;
	}
	if(SETSIG(EABORT)){
		goto quit;
	}
	sp->network = control = ftp.control = fdopen(s,"r+t");
	settos(s,LOW_DELAY);
	printf("Trying %s...\n",psocket((struct sockaddr *)&fsocket));
	if(connect(s,(char *)&fsocket,sizeof(fsocket)) == -1){
		perror("Connect failed");
		goto quit;
	}
	printf("Connected\n");

	/* Wait for greeting from server */
	resp = getresp(&ftp,200);

	if(resp >= 400)
		goto quit;
	/* Now process responses and commands */

	if(SETSIG(EABORT)){
		/* Come back here after a ^C in command state */
		resp = 200;
	}
	while(resp != -1){
		switch(resp){
		case 220:
			/* Sign-on banner; prompt for and send USER command */
			getline(sp,"Enter user name: ",ftp.buf,LINELEN);
			/* Send the command only if the user response
			 * was non-null
			 */
			if(ftp.buf[0] != '\n'){
				fprintf(control,"USER %s",ftp.buf);
				resp = getresp(&ftp,200);
			} else
				resp = 200;	/* dummy */
			break;
		case 331:
			/* turn off echo */
			sp->ttystate.echo = 0;
			getline(sp,"Password: ",ftp.buf,LINELEN);
			printf("\n");
			/* Turn echo back on */
			sp->ttystate.echo = 1;
			/* Send the command only if the user response
			 * was non-null
			 */
			if(ftp.buf[0] != '\n'){
				fprintf(control,"PASS %s",ftp.buf);
				resp = getresp(&ftp,200);
			} else
				resp = 200;	/* dummy */
			break;
		case 230:	/* Successful login */
			/* Find out what type of system we're talking to */
			printf("ftp> syst\n");
			fprintf(control,"SYST\n");
			resp = getresp(&ftp,200);
			break;
		case 215:
			/* Response to SYST command */
			cp = strchr(ftp.line,' ');
			if(cp != NULLCHAR && strnicmp(cp+1,System,strlen(System)) == 0){
				ftp.type = IMAGE_TYPE;
				printf("Defaulting to binary mode\n");
			}
			resp = 200;	/* dummy */
			break;
		default:
			/* Test the control channel first */
			if(sockstate(fileno(control)) == NULLCHAR){
				resp = -1;
				break;
			}
			getline(sp,"ftp> ",ftp.buf,LINELEN);

			/* Copy because cmdparse modifies the original */
			bufsav = strdup(ftp.buf);
			if((resp = cmdparse(Ftpcmds,ftp.buf,&ftp)) != -1){
				/* Valid command, free buffer and get another */
				free(bufsav);
			} else {
				/* Not a local cmd, send to remote server */
				fputs(bufsav,control);
				free(bufsav);

				/* Enable display of server response */
				vsave = ftp.verbose;
				ftp.verbose = V_NORMAL;
				resp = getresp(&ftp,200);
				ftp.verbose = vsave;
			}
		}
	}
quit:	cp = sockerr(fileno(control));
	printf("Closed: %s\n",cp != NULLCHAR ? cp : "EOF");

	if(ftp.fp != NULLFILE && ftp.fp != stdout)
		fclose(ftp.fp);
	if(ftp.data != NULLFILE)
		fclose(ftp.data);
	if(ftp.control != NULLFILE){
		fclose(ftp.control);
		ftp.control = NULLFILE;
		sp->network = NULLFILE;
	}
	keywait(NULLCHAR,1);
	if(ftp.session != NULLSESSION)
		freesession(ftp.session);
	return 0;
}

/* Control verbosity level */
static int
doverbose(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;

	if((ftp = (struct ftpcli *)p) == NULLFTP)
		return -1;
	return setshort(&ftp->verbose,"Verbose",argc,argv);
}
/* Enable/disable command batching */
static int
dobatch(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;

	if((ftp = (struct ftpcli *)p) == NULLFTP)
		return -1;
	return setbool(&ftp->batch,"Command batching",argc,argv);
}
/* Enable/disable update flag */
static int
doupdate(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;

	if((ftp = (struct ftpcli *)p) == NULLFTP)
		return -1;
	return setbool(&ftp->update,"Update with MD5",argc,argv);
}
/* Set verbosity to high (convenience command) */
static int
dohash(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;

	if((ftp = (struct ftpcli *)p) == NULLFTP)
		return -1;
	ftp->verbose = V_HASH;
	return 0;
}
	
/* Close session */
static int
doquit(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;

	ftp = (struct ftpcli *)p;
	if(ftp == NULLFTP)
		return -1;
	fprintf(ftp->control,"QUIT\n");
	getresp(ftp,200);	/* Get the closing message */
	getresp(ftp,200);	/* Wait for the server to close */
	return -1;
}

/* Translate 'cd' to 'cwd' for convenience */
static int
doftpcd(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;

	ftp = (struct ftpcli *)p;
	if(ftp == NULLFTP)
		return -1;
	fprintf(ftp->control,"CWD %s\n",argv[1]);
	return getresp(ftp,200);
}
/* Translate 'mkdir' to 'xmkd' for convenience */
static int
domkdir(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;

	ftp = (struct ftpcli *)p;
	if(ftp == NULLFTP)
		return -1;
	fprintf(ftp->control,"XMKD %s\n",argv[1]);
	return getresp(ftp,200);
}
/* Translate 'rmdir' to 'xrmd' for convenience */
static int
dormdir(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;

	ftp = (struct ftpcli *)p;
	if(ftp == NULLFTP)
		return -1;
	fprintf(ftp->control,"XRMD %s\n",argv[1]);
	return getresp(ftp,200);
}
static int
dobinary(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	char *args[2];

	args[1] = "I";
	return dotype(2,args,p);
}
static int
doascii(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	char *args[2];

	args[1] = "A";
	return dotype(2,args,p);
}

/* Handle "type" command from user */
static int
dotype(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;

	ftp = (struct ftpcli *)p;
	if(ftp == NULLFTP)
		return -1;
	if(argc < 2){
		switch(ftp->type){
		case IMAGE_TYPE:
			printf("Image\n");
			break;
		case ASCII_TYPE:
			printf("Ascii\n");
			break;
		case LOGICAL_TYPE:
			printf("Logical bytesize %u\n",ftp->logbsize);
			break;
		}
		return 0;
	}
	switch(*argv[1]){
	case 'i':
	case 'I':
	case 'b':
	case 'B':
		ftp->type = IMAGE_TYPE;
		break;
	case 'a':
	case 'A':
		ftp->type = ASCII_TYPE;
		break;
	case 'L':
	case 'l':
		ftp->type = LOGICAL_TYPE;
		ftp->logbsize = atoi(argv[2]);
		break;
	default:
		printf("Invalid type %s\n",argv[1]);
		return 1;
	}
	return 0;
}
/* Start receive transfer. Syntax: get <remote name> [<local name>] */
static int
doget(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	char *remotename,*localname;
	register struct ftpcli *ftp;
	FILE *fp;
	char *mode;

	ftp = (struct ftpcli *)p;
	if(ftp == NULLFTP){
		printf(Notsess);
		return 1;
	}
	remotename = argv[1];
	if(argc < 3)
		localname = remotename;
	else
		localname = argv[2];

	switch(ftp->type){
	case IMAGE_TYPE:
	case LOGICAL_TYPE:
		mode = WRITE_BINARY;
		break;
	case ASCII_TYPE:
		mode = WRITE_TEXT;
		break;
	}
	if((fp = fopen(localname,mode)) == NULLFILE){
		printf("Can't write %s",localname);
		perror("");
		return 1;
	}
	getsub(ftp,"RETR",remotename,fp);
	fclose(fp);
	return 0;
}
/* Read file direct to screen. Syntax: read <remote name> */
static int
doread(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;

	if((ftp = (struct ftpcli *)p) == NULLFTP){
		printf(Notsess);
		return 1;
	}
	getsub(ftp,"RETR",argv[1],stdout);
	return 0;
}
/* Get a collection of files */
static int
domget(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;
	FILE *files,*fp;
	char *buf,*mode;
	int i;
	long r;

	if((ftp = (struct ftpcli *)p) == NULLFTP){
		printf(Notsess);
		return 1;
	}
	switch(ftp->type){
	case IMAGE_TYPE:
	case LOGICAL_TYPE:
		mode = WRITE_BINARY;
		break;
	case ASCII_TYPE:
		mode = WRITE_TEXT;
		break;
	}
	buf = mallocw(DIRBUF);
	ftp->state = RECEIVING_STATE;
	for(i=1;i<argc;i++){
		files = tmpfile();
		r = getsub(ftp,"NLST",argv[i],files);
		if(ftp->abort)
			break;	/* Aborted */
		if(r == -1){
			printf("Can't NLST %s\n",argv[i]);
			continue;
		}
		/* The tmp file now contains a list of the remote files, so
		 * go get 'em. Break out if the user signals an abort.
		 */
		rewind(files);
		while(fgets(buf,DIRBUF,files) != NULLCHAR){
			rip(buf);
			if(!ftp->update || compsub(ftp,buf,buf) != 0){
				if((fp = fopen(buf,mode)) == NULLFILE){
					printf("Can't write %s",buf);
					perror("");
					continue;
				}
				getsub(ftp,"RETR",buf,fp);
				fclose(fp);
			}
			if(ftp->abort){
				/* User abort */
				ftp->abort = 0;
				fclose(files);
				free(buf);
				ftp->state = COMMAND_STATE;
				return 1;
			}
		}
		fclose(files);
	}
	free(buf);
	ftp->state = COMMAND_STATE;
	ftp->abort = 0;
	return 0;
}
/* List remote directory. Syntax: dir <remote files> [<local name>] */
static int
dolist(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;
	FILE *fp;

	ftp = (struct ftpcli *)p;
	if(ftp == NULLFTP){
		printf(Notsess);
		return 1;
	}

	if(argc > 2)
		fp = fopen(argv[2],WRITE_TEXT);

	else
		fp = stdout;

	if(fp == NULLFILE){
		printf("Can't write local file");
		perror("");
		return 1;
	}

	getsub(ftp,"LIST",argv[1],fp);
	return 0;
}
/* Remote directory list, short form. Syntax: ls <remote files> [<local name>] */
static int
dols(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;
	FILE *fp;

	if((ftp = (struct ftpcli *)p) == NULLFTP){
		printf(Notsess);
		return 1;
	}
	if(argc > 2)
		fp = fopen(argv[2],WRITE_TEXT);

	else
		fp = stdout;

	if(fp == NULLFILE){
		printf("Can't write local file");
		perror("");
		return 1;
	}
	getsub(ftp,"NLST",argv[1],fp);
	return 0;
}
static int
domd5(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	char *remotename;
	register struct ftpcli *ftp;
	FILE *control;
	int resp;
	int typewait = 0;

	ftp = (struct ftpcli *)p;
	if(ftp == NULLFTP){
		printf(Notsess);
		return 1;
	}
	control = ftp->control;
	remotename = argv[1];
	if(ftp->typesent != ftp->type){
		switch(ftp->type){
		case ASCII_TYPE:
			fprintf(control,"TYPE A\n");
			break;
		case IMAGE_TYPE:
			fprintf(control,"TYPE I\n");
			break;
		case LOGICAL_TYPE:
			fprintf(control,"TYPE L %d\n",ftp->logbsize);
			break;
		}
		ftp->typesent = ftp->type;
		if(!ftp->batch){
			resp = getresp(ftp,200);
			if(resp == -1 || resp > 299)
				goto failure;
		} else
			typewait = 1;

	}
	fprintf(control,"XMD5 %s\n",remotename);
	if(typewait)
		(void)getresp(ftp,200);
	(void)getresp(ftp,200);
failure:;
	return 0;
}
static int
docompare(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	char *remotename,*localname;
	register struct ftpcli *ftp;

	ftp = (struct ftpcli *)p;
	if(ftp == NULLFTP){
		printf(Notsess);
		return 1;
	}
	remotename = argv[1];
	if(argc > 2)
		localname = argv[2];
	else
		localname = remotename;

	if(compsub(ftp,localname,remotename) == 0)
		printf("Same\n");
	else
		printf("Different\n");
	return 0;
}
/* Compare a collection of files */
static int
domcompare(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;
	FILE *files;
	char *buf;
	int i;
	long r;

	if((ftp = (struct ftpcli *)p) == NULLFTP){
		printf(Notsess);
		return 1;
	}
	buf = mallocw(DIRBUF);
	ftp->state = RECEIVING_STATE;
	for(i=1;i<argc;i++){
		files = tmpfile();
		r = getsub(ftp,"NLST",argv[i],files);
		if(ftp->abort)
			break;	/* Aborted */
		if(r == -1){
			printf("Can't NLST %s\n",argv[i]);
			continue;
		}
		/* The tmp file now contains a list of the remote files, so
		 * go get 'em. Break out if the user signals an abort.
		 */
		rewind(files);
		while(fgets(buf,DIRBUF,files) != NULLCHAR){
			rip(buf);
			if(compsub(ftp,buf,buf) == 0)
				printf("%s - Same\n",buf);
			else
				printf("%s - Different\n",buf);

			if(ftp->abort){
				/* User abort */
				ftp->abort = 0;
				fclose(files);
				free(buf);
				ftp->state = COMMAND_STATE;
				return 1;
			}
		}
		fclose(files);
	}
	free(buf);
	ftp->state = COMMAND_STATE;
	ftp->abort = 0;
	return 0;
}
/* Common subroutine to compare a local with a remote file
 * Return 1 if files are different, 0 if they are the same
 */
static int
compsub(ftp,localname,remotename)
struct ftpcli *ftp;
char *localname;
char *remotename;
{
	char *mode,*cp;
	FILE *control,*fp;
	int resp,i;
	int typewait = 0;
	char remhash[16];
	char lochash[16];

	control = ftp->control;

	switch(ftp->type){
	case IMAGE_TYPE:
	case LOGICAL_TYPE:
		mode = READ_BINARY;
		break;
	case ASCII_TYPE:
		mode = READ_TEXT;
		break;
	}
	if((fp = fopen(localname,mode)) == NULLFILE){
		printf("Can't read local file %s\n",localname);
		return 1;
	}
	if(ftp->typesent != ftp->type){
		switch(ftp->type){
		case ASCII_TYPE:
			fprintf(control,"TYPE A\n");
			break;
		case IMAGE_TYPE:
			fprintf(control,"TYPE I\n");
			break;
		case LOGICAL_TYPE:
			fprintf(control,"TYPE L %d\n",ftp->logbsize);
			break;
		}
		ftp->typesent = ftp->type;
		if(!ftp->batch){
			resp = getresp(ftp,200);
			if(resp == -1 || resp > 299)
				goto failure;
		} else
			typewait = 1;
	}
	fprintf(control,"XMD5 %s\n",remotename);
	/* Try to overlap the two MD5 operations */
	md5hash(fp,lochash,ftp->type == ASCII_TYPE);
	fclose(fp);
	if(typewait && (resp = getresp(ftp,200)) > 299)
		goto failure;
	if((resp = getresp(ftp,200)) > 299){
		if(resp == 500)
			ftp->update = 0;	/* XMD5 not supported */
		goto failure;
	}	
	if((cp = strchr(ftp->line,' ')) == NULLCHAR){
		printf("Error in response\n");
		goto failure;
	}
	/* Convert ascii/hex back to binary */
	readhex(remhash,cp,sizeof(remhash));
	if(ftp->verbose > 1){
		printf("Loc ");
		for(i=0;i<sizeof(lochash);i++)
			printf("%02x",lochash[i] & 0xff);
		printf(" %s\n",localname);
	}
	if(memcmp(lochash,remhash,sizeof(remhash)) == 0)
		return 0;
	else
		return 1;
failure:;
	return 1;
}


/* Common code to LIST/NLST/RETR and mget
 * Returns number of bytes received if successful
 * Returns -1 on error
 */
static long
getsub(ftp,command,remotename,fp)
register struct ftpcli *ftp;
char *command,*remotename;
FILE *fp;
{
	unsigned long total;
	FILE *control;
	int cnt,resp,i,savmode;
	struct sockaddr_in lsocket;
	struct sockaddr_in lcsocket;
	int32 startclk,rate;
	int vsave;
	int typewait = 0;
	int prevstate;
	int d;

	if(ftp == NULLFTP)
		return -1;
	savmode = ftp->type;
	control = ftp->control;

	/* Open the data connection */
	d = socket(AF_INET,SOCK_STREAM,0);
	listen(d,0);	/* Accept only one connection */

	switch(ftp->type){
	case IMAGE_TYPE:
	case LOGICAL_TYPE:
		ftp->data = fdopen(d,"r+b");
		break;
	case ASCII_TYPE:
		ftp->data = fdopen(d,"r+t");
		break;
	}
	prevstate = ftp->state;
	ftp->state = RECEIVING_STATE;

	/* Send TYPE message, if necessary */
	if(strcmp(command,"LIST") == 0 || strcmp(command,"NLST") == 0){
		/* Directory listings are always in ASCII */
		ftp->type = ASCII_TYPE;
	}
	if(ftp->typesent != ftp->type){
		switch(ftp->type){
		case ASCII_TYPE:
			fprintf(control,"TYPE A\n");
			break;
		case IMAGE_TYPE:
			fprintf(control,"TYPE I\n");
			break;
		case LOGICAL_TYPE:
			fprintf(control,"TYPE L %d\n",ftp->logbsize);
			break;
		}
		ftp->typesent = ftp->type;
		if(!ftp->batch){
			resp = getresp(ftp,200);
			if(resp == -1 || resp > 299)
				goto failure;
		} else
			typewait = 1;
	}
	/* Send the PORT message. Use the IP address
	 * on the local end of our control connection.
	 */
	i = SOCKSIZE;
	getsockname(d,(char *)&lsocket,&i); /* Get port number */
	i = SOCKSIZE;
	getsockname(fileno(ftp->control),(char *)&lcsocket,&i);
	lsocket.sin_addr.s_addr = lcsocket.sin_addr.s_addr;
	sendport(control,&lsocket);
	if(!ftp->batch){
		/* Get response to PORT command */
		resp = getresp(ftp,200);
		if(resp == -1 || resp > 299)
			goto failure;
	}

	/* Generate the command to start the transfer */
	if(remotename != NULLCHAR)
		fprintf(control,"%s %s\n",command,remotename);
	else
		fprintf(control,"%s\n",command);

	if(ftp->batch){
		/* Get response to TYPE command, if sent */
		if(typewait){
			resp = getresp(ftp,200);
			if(resp == -1 || resp > 299)
				goto failure;
		}
		/* Get response to PORT command */
		resp = getresp(ftp,200);
		if(resp == -1 || resp > 299)
			goto failure;
	}
	/* Get the intermediate "150" response */
	resp = getresp(ftp,100);
	if(resp == -1 || resp >= 400)
		goto failure;

	/* Wait for the server to open the data connection */
	cnt = 0;
	d = accept(d,NULLCHAR,&cnt);
	startclk = msclock();

	/* If output is to the screen, temporarily disable hash marking */
	vsave = ftp->verbose;
	if(vsave >= V_HASH && fp == NULLFILE)
		ftp->verbose = V_NORMAL;
	total = recvfile(fp,ftp->data,ftp->type,ftp->verbose);
	/* Immediately close the data connection; some servers (e.g., TOPS-10)
	 * wait for the data connection to close completely before returning
	 * the completion message on the control channel
	 */
	fclose(ftp->data);
	ftp->data = NULLFILE;

#ifdef	CPM
	if(fp != NULLFILE && ftp->type == ASCII_TYPE)
		putc(CTLZ,fp);
#endif
	if(remotename == NULLCHAR)
		remotename = "";
	if(total == -1){
		printf("%s %s: Error/abort during data transfer\n",command,remotename);
	} else if(ftp->verbose >= V_SHORT){
		startclk = msclock() - startclk;
		rate = 0;
		if(startclk != 0){	/* Avoid divide-by-zero */
			if(total < 4294967L) {
				rate = (total*1000)/startclk;
			} else {	/* Avoid overflow */
				rate = total/(startclk/1000);
			}
		}
		printf("%s %s: %lu bytes in %lu sec (%lu/sec)\n",
		 command,remotename, total,startclk/1000,rate);
	}
	/* Get the "Sent" message */
	getresp(ftp,200);

	ftp->state = prevstate;
	ftp->verbose = vsave;
	ftp->type = savmode;
	return total;

failure:
	/* Error, quit */
	if(fp != NULLFILE && fp != stdout)
		fclose(fp);
	fclose(ftp->data);
	ftp->data = NULLFILE;
	ftp->state = prevstate;
	ftp->type = savmode;
	return -1;
}
/* Send a file. Syntax: put <local name> [<remote name>] */
static int
doput(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;
	char *remotename,*localname;

	if((ftp = (struct ftpcli *)p) == NULLFTP){
		printf(Notsess);
		return 1;
	}
	localname = argv[1];
	if(argc < 3)
		remotename = localname;
	else
		remotename = argv[2];

	putsub(ftp,remotename,localname);
	return 0;
}
/* Put a collection of files */
static int
domput(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct ftpcli *ftp;
	FILE *files;
	int i;
	char *buf;

	if((ftp = (struct ftpcli *)p) == NULLFTP){
		printf(Notsess);
		return 1;
	}
	if((files = tmpfile()) == NULLFILE){
		printf("Can't list local files\n");
		return 1;
	}
	for(i=1;i<argc;i++)
		getdir(argv[i],0,files);

	rewind(files);
	buf = mallocw(DIRBUF);
	ftp->state = SENDING_STATE;
	while(fgets(buf,DIRBUF,files) != NULLCHAR){
		rip(buf);
		if(!ftp->update || compsub(ftp,buf,buf) != 0)
			putsub(ftp,buf,buf);
		if(ftp->abort)
			break;		/* User abort */
	}
	fclose(files);
	free(buf);
	ftp->state = COMMAND_STATE;
	ftp->abort = 0;
	return 0;
}
/* Common code to put, mput.
 * Returns number of bytes sent if successful
 * Returns -1 on error
 */
static long
putsub(ftp,remotename,localname)
register struct ftpcli *ftp;
char *remotename,*localname;
{
	char *mode;
	int i,resp,d;
	unsigned long total;
	FILE *fp,*control;
	struct sockaddr_in lsocket,lcsocket;
	int32 startclk,rate;
	int typewait = 0;
	int prevstate;

	control = ftp->control;
	if(ftp->type == IMAGE_TYPE)
		mode = READ_BINARY;
	else
		mode = READ_TEXT;

	/* Open the file */
	if((fp = fopen(localname,mode)) == NULLFILE){
		printf("Can't read %s: %s\n",localname,sys_errlist[errno]);
		return -1;
	}
	if(ftp->type == ASCII_TYPE && isbinary(fp)){
		printf("Warning: type is ASCII and %s appears to be binary\n",localname);
	}
	/* Open the data connection */
	d = socket(AF_INET,SOCK_STREAM,0);
	ftp->data = fdopen(d,"w+");
	listen(d,0);
	prevstate = ftp->state;
	ftp->state = SENDING_STATE;

	/* Send TYPE message, if necessary */
	if(ftp->typesent != ftp->type){
		switch(ftp->type){
		case ASCII_TYPE:
			fprintf(control,"TYPE A\n");
			break;
		case IMAGE_TYPE:
			fprintf(control,"TYPE I\n");
			break;
		case LOGICAL_TYPE:
			fprintf(control,"TYPE L %d\n",ftp->logbsize);
			break;
		}
		ftp->typesent = ftp->type;

		/* Get response to TYPE command */
		if(!ftp->batch){
			resp = getresp(ftp,200);
			if(resp == -1 || resp > 299){
				goto failure;
			}
		} else
			typewait = 1;
	}
	/* Send the PORT message. Use the IP address
	 * on the local end of our control connection.
	 */
	i = SOCKSIZE;
	getsockname(d,(char *)&lsocket,&i);
	i = SOCKSIZE;
	getsockname(fileno(ftp->control),(char *)&lcsocket,&i);
	lsocket.sin_addr.s_addr = lcsocket.sin_addr.s_addr;
	sendport(control,&lsocket);
	if(!ftp->batch){
		/* Get response to PORT command */
		resp = getresp(ftp,200);
		if(resp == -1 || resp > 299){
			goto failure;
		}
	}
	/* Generate the command to start the transfer */
	fprintf(control,"STOR %s\n",remotename);

	if(ftp->batch){
		/* Get response to TYPE command, if sent */
		if(typewait){
			resp = getresp(ftp,200);
			if(resp == -1 || resp > 299){
				goto failure;
			}
		}
		/* Get response to PORT command */
		resp = getresp(ftp,200);
		if(resp == -1 || resp > 299){
			goto failure;
		}
	}
	/* Get the intermediate "150" response */
	resp = getresp(ftp,100);
	if(resp == -1 || resp >= 400){
		goto failure;
	}

	/* Wait for the data connection to open. Otherwise the first
	 * block of data would go out with the SYN, and this may confuse
	 * some other TCPs
	 */
	accept(d,NULLCHAR,(int *)NULL);

	startclk = msclock();

	total = sendfile(fp,ftp->data,ftp->type,ftp->verbose);
	fflush(ftp->data);
	shutdown(fileno(ftp->data),1);	/* Send EOF (FIN) */
	fclose(fp);

	/* Wait for control channel ack before calculating transfer time;
	 * this accounts for transmitted data in the pipe
	 */
	getresp(ftp,200);
	fclose(ftp->data);
	ftp->data = NULLFILE;

	if(total == -1){
		printf("STOR %s: Error/abort during data transfer\n",remotename);
	} else if(ftp->verbose >= V_SHORT){
		startclk = msclock() - startclk;
		rate = 0;
		if(startclk != 0){	/* Avoid divide-by-zero */
			if(total < 4294967L) {
				rate = (total*1000)/startclk;
			} else {	/* Avoid overflow */
				rate = total/(startclk/1000);
			}
		}
		printf("STOR %s: %lu bytes in %lu sec (%lu/sec)\n",
		 remotename,total,startclk/1000,rate);
	}
	ftp->state = prevstate;
	return total;

failure:
	/* Error, quit */
	fclose(fp);
	fclose(ftp->data);
	ftp->data = NULLFILE;
	ftp->state = prevstate;
	return -1;
}
/* send PORT message */
static void
sendport(fp,socket)
FILE *fp;
struct sockaddr_in *socket;
{
	/* Send PORT a,a,a,a,p,p message */
	fprintf(fp,"PORT %u,%u,%u,%u,%u,%u\n",
		hibyte(hiword(socket->sin_addr.s_addr)),
		lobyte(hiword(socket->sin_addr.s_addr)),
		hibyte(loword(socket->sin_addr.s_addr)),
		lobyte(loword(socket->sin_addr.s_addr)),
		hibyte(socket->sin_port),
		lobyte(socket->sin_port));
}

/* Wait for, read and display response from FTP server. Return the result code.
 */
static int
getresp(ftp,mincode)
struct ftpcli *ftp;
int mincode;	/* Keep reading until at least this code comes back */
{
	int rval;

	fflush(ftp->control);
	for(;;){
		/* Get line */
		if(fgets(ftp->line,LINELEN,ftp->control) == NULLCHAR){
			rval = -1;
			break;
		}
		rip(ftp->line);		/* Remove cr/lf */
		rval = atoi(ftp->line);
		if(rval >= 400 || ftp->verbose >= V_NORMAL)
			printf("%s\n",ftp->line);	/* Display to user */

		/* Messages with dashes are continued */
		if(ftp->line[3] != '-' && rval >= mincode)
			break;
	}
	return rval;
}

/* Issue a prompt and read a line from the user */
static int
getline(sp,prompt,buf,n)
struct session *sp;
char *prompt;
char *buf;
int n;
{
	printf(prompt);
	fflush(stdout);
	fgets(buf,n,stdin);
	return strlen(buf);
}
static int
keychar(c)
int c;
{
	struct ftpcli *ftp;

	if(c != CTLC)
		return 1;	/* Ignore all but ^C */

	fprintf(Current->output,"^C\n");
	ftp = Current->cb.ftp;
	switch(ftp->state){
	case COMMAND_STATE:
		alert(Current->proc,EABORT);
		break;
	case SENDING_STATE:
		/* Send a premature EOF.
		 * Unfortunately we can't just reset the connection
		 * since the remote side might end up waiting forever
		 * for us to send something.
		 */
		shutdown(fileno(ftp->data),1);	/* Note fall-thru */
		ftp->abort = 1;
		break;
	case RECEIVING_STATE:
		/* Just blow away the receive socket */
		shutdown(fileno(ftp->data),2);	/* Note fall-thru */
		ftp->abort = 1;
		break;
	}
	return 0;
}
@


1.19
log
@Use readhex() to scan MD5 hash responses
Get rid of a few hardwired 16's
@
text
@d22 29
a50 29
static int doascii __ARGS((int argc,char *argv[],void *p));
static int dobatch __ARGS((int argc,char *argv[],void *p));
static int dobinary __ARGS((int argc,char *argv[],void *p));
static int docompare __ARGS((int argc,char *argv[],void *p));
static int doftpcd __ARGS((int argc,char *argv[],void *p));
static int doget __ARGS((int argc,char *argv[],void *p));
static int dohash __ARGS((int argc,char *argv[],void *p));
static int doverbose __ARGS((int argc,char *argv[],void *p));
static int dolist __ARGS((int argc,char *argv[],void *p));
static int dols __ARGS((int argc,char *argv[],void *p));
static int domd5 __ARGS((int argc,char *argv[],void *p));
static int domkdir __ARGS((int argc,char *argv[],void *p));
static int domcompare __ARGS((int argc,char *argv[],void *p));
static int domget __ARGS((int argc,char *argv[],void *p));
static int domput __ARGS((int argc,char *argv[],void *p));
static int doput __ARGS((int argc,char *argv[],void *p));
static int doquit __ARGS((int argc,char *argv[],void *p));
static int doread __ARGS((int argc,char *argv[],void *p));
static int dormdir __ARGS((int argc,char *argv[],void *p));
static int dotype __ARGS((int argc,char *argv[],void *p));
static int doupdate __ARGS((int argc,char *argv[],void *p));
static int getline __ARGS((struct session *sp,char *prompt,char *buf,int n));
static int getresp __ARGS((struct ftpcli *ftp,int mincode));
static long getsub __ARGS((struct ftpcli *ftp,char *command,char *remotename,
	FILE *fp));
static long putsub __ARGS((struct ftpcli *ftp,char *remotename,char *localname));
static int compsub __ARGS((struct ftpcli *ftp,char *localname,char *remotename));
static void sendport __ARGS((FILE *fp,struct sockaddr_in *socket));
static int keychar __ARGS((int c));
@


1.18
log
@Call newsession with Cmdline
Tighten up connect/disconnect messages
@
text
@d814 1
a814 8
	for(i=0;*cp != '\0' && i < 32;cp++,i++){
		while(*cp == ' ')
			cp++;	/* Skip imbedded white space */
		if((i & 1) == 0)
			remhash[i/2] = htob(*cp) << 4;	/* first nybble */
		else
			remhash[i/2] += htob(*cp);	/* second nybble */
	}
d817 1
a817 1
		for(i=0;i<16;i++)
d821 1
a821 1
	if(memcmp(lochash,remhash,16) == 0)
@


1.17
log
@In compsub(), try to overlap hash computation on server and client.
Add "update" flag to FTP client. When set, mput and mget will first
compare each file's MD5 hash. If they're the same, the transfer is skipped.
Also, compsub() tries to recognize a remote server that doesn't support
XMD5 and it turns off the update flag. Hopefully all FTP servers return
code 500 for unimplemented commands, and something else for "unknown file".
@
text
@d98 1
a98 1
	if((sp = newsession(argv[1],FTP,1)) == NULLSESSION){
d121 3
a123 3
	printf("Resolving %s... ",sp->name);
	if((fsocket.sin_addr.s_addr = resolve(sp->name)) == 0){
		printf(Badhost,sp->name);
d145 1
a145 1
	printf("FTP session %u connected to %s\n",sp->index,sp->name);
d230 1
a230 2
	printf("FTP session %u closed: %s\n",sp->index,
		cp != NULLCHAR ? cp : "EOF");
@


1.16
log
@Remove now obsolete creation of separate sessions for directory
listings, file viewing (replaced by general purpose session scrollback).
General cleanup of orphaned stuff
Pass ascii flag to md5hash()
@
text
@d42 1
d77 1
d274 13
d536 8
a543 4
			if((fp = fopen(buf,mode)) == NULLFILE){
				printf("Can't write %s",buf);
				perror("");
				continue;
a544 2
			getsub(ftp,"RETR",buf,fp);
			fclose(fp);
d800 3
d805 3
a807 1
	if((resp = getresp(ftp,200)) > 299)
d809 1
a809 3
	
	md5hash(fp,lochash,ftp->type == ASCII_TYPE);
	fclose(fp);
d1051 2
a1052 1
		putsub(ftp,buf,buf);
@


1.15
log
@Add md5, compare and mcompare commands
@
text
@a48 1
static char *cat3 __ARGS((char *a,char *b,char *c));
a469 2
	FILE *fp,*fptmp;
	char *name;
d475 1
a475 7
	fp = tmpfile();
	name = cat3(ftp->session->name,NULLCHAR,argv[1]);
	newproc("view",512,view,POLLRATE,(void *)fp,(void *)name,0);

	fptmp = fdup(fp);
	getsub(ftp,"RETR",argv[1],fptmp);
	fclose(fptmp);
d552 1
a552 2
	FILE *fp,*fptmp;
	char *name;
d559 1
d562 1
d564 1
a564 1
		fp = tmpfile();
d572 1
a572 7
	name = cat3(ftp->session->name,"dir",argv[1]);
	newproc("view",512,view,POLLRATE,(void *)fp,(void *)name,0);

	fptmp = fdup(fp);
	getsub(ftp,"LIST",argv[1],fptmp);
	fclose(fptmp);

a581 1
	char *name;
d583 1
a583 1
	FILE *fp,*fptmp;
d591 1
d593 1
a593 1
		fp = tmpfile();
d600 1
a600 6
	name = cat3(ftp->session->name,"ls",argv[1]);
	newproc("view",512,view,POLLRATE,(void *)fp,(void *)name,0);

	fptmp = fdup(fp);
	getsub(ftp,"NLST",argv[1],fptmp);
	fclose(fptmp);
d788 1
a788 1
	md5hash(fp,lochash);
a1240 4
/*	int (*inproc)(); */

/*	inproc = sp->inproc;
	sp->inproc = NULL; */
a1243 1
/*	sp->inproc = inproc; */
a1244 18
}
static char *
cat3(a,b,c)
char *a,*b,*c;
{
	char *ret;
	int len = 5;

	if(a != NULLCHAR)
		len += strlen(a);
	if(b != NULLCHAR)
		len += strlen(b);
	if(c != NULLCHAR)
		len += strlen(c);
	ret = malloc(len);
	sprintf(ret,"%s %s %s",(a != NULLCHAR) ? a : "",
	 (b != NULLCHAR) ? b : "", (c != NULLCHAR) ? c : "");
	return ret;
@


1.14
log
@Pass verbose flag to sendfile, recvfile, also shutdown data connection
at end of ftp put to prevent early disappearance of repeated socket
display on data connection
@
text
@d25 1
d32 1
d34 1
d47 1
d60 1
d66 2
d622 215
@


1.13
log
@Remove "abort" command, add ^C processing
Move command buffer into ftp structure (instead of mallocing
from heap).
@
text
@d730 1
a730 1
	total = recvfile(fp,ftp->data,ftp->type,ftp->verbose >= V_HASH);
d948 3
a950 3
	total = sendfile(fp,ftp->data,ftp->type,ftp->verbose >= V_HASH);
	fclose(ftp->data);
	ftp->data = NULLFILE;
d957 2
@


1.12
log
@Implement automatic SYST query after login, set transfer type to image
(binary) if same as local system. Also modify getresp to use server
response buffer in ftp structure instead of using local buffer.
@
text
@d46 1
d85 1
a85 1
	char *buf,*bufsav,*cp;
d94 1
d108 5
d127 3
d145 5
a149 1
	buf = mallocw(LINELEN);
d154 1
a154 1
			getline(sp,"Enter user name: ",buf,LINELEN);
d158 2
a159 2
			if(buf[0] != '\n'){
				fprintf(control,"USER %s",buf);
d167 1
a167 1
			getline(sp,"Password: ",buf,LINELEN);
d174 2
a175 2
			if(buf[0] != '\n'){
				fprintf(control,"PASS %s",buf);
d201 1
a201 1
			getline(sp,"ftp> ",buf,LINELEN);
d204 2
a205 2
			bufsav = strdup(buf);
			if((resp = cmdparse(Ftpcmds,buf,&ftp)) != -1){
a220 1
	free(buf);
a983 48
/* Abort a GET or PUT operation in progress. Note: this will leave
 * the partial file on the local or remote system
 */
int
doabort(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct session *sp;
	register struct ftpcli *ftp;

	sp = (struct session *)p;
	if(sp == NULLSESSION)
		return -1;

	/* Default is the current session, but it can be overridden with
	 * an argument.
	 */
	if(argc > 1)
		sp = sessptr(argv[1]);

	if(sp == NULLSESSION || sp->type != FTP){
		printf("Not an active FTP session\n");
		return 1;
	}
	ftp = sp->cb.ftp;
	switch(ftp->state){
	case COMMAND_STATE:
		printf("No active transfer\n");
		return 1;
	case SENDING_STATE:
		/* Send a premature EOF.
		 * Unfortunately we can't just reset the connection
		 * since the remote side might end up waiting forever
		 * for us to send something.
		 */
		shutdown(fileno(ftp->data),1);	/* Note fall-thru */
		ftp->abort = 1;
		break;
	case RECEIVING_STATE:
		/* Just blow away the receive socket */
		shutdown(fileno(ftp->data),2);	/* Note fall-thru */
		ftp->abort = 1;
		break;
	}
	return 0;
}
d1036 4
d1043 1
d1063 32
@


1.11
log
@Fix bug in mget, use tmpfile()
@
text
@d137 2
a138 1
		if(resp == 220){
d149 2
a150 1
		} else if(resp == 331){
d165 17
a181 1
		} else {
d183 2
a184 1
			if(sockstate(fileno(control)) == NULLCHAR)
d186 1
a186 1

a1041 1
	register char *line;
a1044 1
	line = mallocw(LINELEN);
d1047 1
a1047 1
		if(fgets(line,LINELEN,ftp->control) == NULLCHAR){
d1051 2
a1052 2
		rip(line);		/* Remove cr/lf */
		rval = atoi(line);
d1054 1
a1054 1
			printf("%s\n",line);	/* Display to user */
d1057 1
a1057 1
		if(line[3] != '-' && rval >= mincode)
a1059 1
	free(line);
@


1.10
log
@s920601
@
text
@a473 1
	files = tmpfile();
d477 1
a777 1
	char tmpname[L_tmpnam+1];	
d784 1
a784 2
	tmpnam(tmpname);
	if((files = fopen(tmpname,"w+")) == NULLFILE){
a785 1
		unlink(tmpname);
a800 1
	unlink(tmpname);
@


1.9
log
@src0518
@
text
@d441 1
a441 1
	newproc("more",512,more,POLLRATE,(void *)fp,(void *)name,0);
d443 1
a443 1
	fptmp = fopen(fpname(fp),"w");
d542 1
a542 1
	newproc("more",512,more,POLLRATE,(void *)fp,(void *)name,0);
d544 1
a544 1
	fptmp = fopen(fpname(fp),"w");
d576 1
a576 1
	newproc("more",512,more,POLLRATE,(void *)fp,(void *)name,0);
d578 1
a578 1
	fptmp = fopen(fpname(fp),"w");
@


1.8
log
@src0514
@
text
@d19 1
d36 1
d42 1
a42 1
	char *localname));
d45 1
d65 1
d392 2
d406 40
a445 1
	getsub(ftp,"RETR",remotename,localname);
d456 2
a457 3
	FILE *files;
	char tmpname[L_tmpnam+1];
	char *buf;
d465 10
a474 1
	tmpnam(tmpname);
d478 1
a478 1
		r = getsub(ftp,"NLST",argv[i],tmpname);
d481 1
a481 1
		if(r == -1 || (files = fopen(tmpname,"r")) == NULLFILE){
a482 1
			unlink(tmpname);
d488 1
d491 7
a497 1
			getsub(ftp,"RETR",buf,buf);
a501 1
				unlink(tmpname);
a507 1
		unlink(tmpname);
a520 1
	char *remotename,*localname;
d522 2
a529 1
	remotename = argv[1];
d531 1
a531 1
		localname = argv[2];
d533 14
a546 1
		localname = NULLCHAR;
a547 1
	getsub(ftp,"LIST",remotename,localname);
d557 1
a557 1
	char *remotename,*localname;
d559 1
d561 1
a561 2
	ftp = (struct ftpcli *)p;
	if(ftp == NULLFTP){
a564 1
	remotename = argv[1];
d566 1
a566 1
		localname = argv[2];
d568 9
a576 1
		localname = NULLCHAR;
d578 3
a580 1
	getsub(ftp,"NLST",remotename,localname);
d588 1
a588 1
getsub(ftp,command,remotename,localname)
d590 2
a591 1
char *command,*remotename,*localname;
d594 1
a594 1
	FILE *fp,*control;
a595 1
	char *mode;
d609 4
d616 1
a616 1
		mode = WRITE_BINARY;
d619 1
a619 1
		mode = WRITE_TEXT;
a621 11
	/* Open the file */
	if(localname == NULLCHAR){
		fp = NULLFILE;
	} else if((fp = fopen(localname,mode)) == NULLFILE){
		printf("Can't write %s: %s\n",localname,sys_errlist[errno]);
		return -1;
	}
	/* Open the data connection */
	d = socket(AF_INET,SOCK_STREAM,0);
	ftp->data = fdopen(d,"r+");
	listen(d,0);	/* Accept only one connection */
d665 1
a709 2
	if(fp != NULLFILE && fp != stdout)
		fclose(fp);
d1063 18
@


1.7
log
@src0503
@
text
@d123 1
a123 2
	printf("FTP session %u connected to %s\n",(unsigned)(sp-Sessions),
		sp->name);
d186 2
a187 2
	printf("FTP session %u closed: %s\n",(unsigned)(sp - Sessions),
	 cp != NULLCHAR ? cp : "EOF");
@


1.6
log
@src0501
@
text
@d116 1
a116 1
	control = ftp.control = fdopen(s,"r+");
d119 2
a120 1
	if(connect(s,(char *)&fsocket,sizeof(fsocket)) == -1)
d122 1
d194 1
a194 1
	if(ftp.control != NULLFILE)
d196 3
a620 1
	ftp->data = fdopen(d,"r+");
d775 1
a775 1
	ftp->data = fdopen(d,"r+");
d991 2
a992 2
	fflush(sp->output);
	fgets(buf,n,sp->input);
@


1.5
log
@src0401
@
text
@d42 1
a42 1
static void sendport __ARGS((int s,struct sockaddr_in *socket));
d81 2
a82 1
	int control;
d86 1
a86 1
		tprintf("Too many sessions\n");
d90 1
a90 1
	ftp.control = ftp.data = -1;
d102 1
a102 1
	tprintf("Resolving %s... ",sp->name);
d104 1
a104 1
		tprintf(Badhost,sp->name);
d110 2
a111 2
	if((control = sp->s = ftp.control = socket(AF_INET,SOCK_STREAM,0)) == -1){
		tprintf("Can't create socket\n");
d116 4
a119 5
	settos(sp->s,LOW_DELAY);
	sockmode(sp->s,SOCK_ASCII);
	setflush(sp->s,-1);	/* Flush output only when we call getresp() */
	tprintf("Trying %s...\n",psocket((struct sockaddr *)&fsocket));
	if(connect(control,(char *)&fsocket,sizeof(fsocket)) == -1)
d121 1
a121 1
	tprintf("FTP session %u connected to %s\n",(unsigned)(sp-Sessions),
d139 1
a139 1
				usprintf(control,"USER %s",buf);
d147 1
a147 1
			tprintf("\n");
d154 1
a154 1
				usprintf(control,"PASS %s",buf);
d160 1
a160 1
			if(sockstate(control) == NULLCHAR)
d172 1
a172 1
				usputs(control,bufsav);
d184 2
a185 2
quit:	cp = sockerr(control);
	tprintf("FTP session %u closed: %s\n",(unsigned)(sp - Sessions),
d190 4
a193 4
	if(ftp.data != -1)
		close_s(ftp.data);
	if(ftp.control != -1)
		close_s(ftp.control);
d253 1
a253 1
	usprintf(ftp->control,"QUIT\n");
d271 1
a271 1
	usprintf(ftp->control,"CWD %s\n",argv[1]);
d286 1
a286 1
	usprintf(ftp->control,"XMKD %s\n",argv[1]);
d301 1
a301 1
	usprintf(ftp->control,"XRMD %s\n",argv[1]);
d342 1
a342 1
			tprintf("Image\n");
d345 1
a345 1
			tprintf("Ascii\n");
d348 1
a348 1
			tprintf("Logical bytesize %u\n",ftp->logbsize);
d370 1
a370 1
		tprintf("Invalid type %s\n",argv[1]);
d387 1
a387 1
		tprintf(Notsess);
d414 1
a414 1
		tprintf(Notsess);
d425 1
a425 1
			tprintf("Can't NLST %s\n",argv[i]);
d465 1
a465 1
		tprintf(Notsess);
d489 1
a489 1
		tprintf(Notsess);
d511 2
a512 2
	FILE *fp;
	int cnt,resp,i,control,savmode;
d520 1
d524 1
a525 1
	savmode = ftp->type;
d540 1
a540 1
		tprintf("Can't write %s: %s\n",localname,sys_errlist[errno]);
d544 3
a546 2
	ftp->data = socket(AF_INET,SOCK_STREAM,0);
	listen(ftp->data,0);	/* Accept only one connection */
d558 1
a558 1
			usprintf(control,"TYPE A\n");
d561 1
a561 1
			usprintf(control,"TYPE I\n");
d564 1
a564 1
			usprintf(control,"TYPE L %d\n",ftp->logbsize);
d579 1
a579 1
	getsockname(ftp->data,(char *)&lsocket,&i); /* Get port number */
d581 1
a581 1
	getsockname(ftp->control,(char *)&lcsocket,&i);
d592 1
a592 1
		usprintf(control,"%s %s\n",command,remotename);
d594 1
a594 1
		usprintf(control,"%s\n",command);
d615 2
a616 1
	ftp->data = accept(ftp->data,NULLCHAR,&cnt);
d628 2
a629 2
	close_s(ftp->data);
	ftp->data = -1;
d640 1
a640 1
		tprintf("%s %s: Error/abort during data transfer\n",command,remotename);
d651 1
a651 1
		tprintf("%s %s: %lu bytes in %lu sec (%lu/sec)\n",
d666 2
a667 2
	close_s(ftp->data);
	ftp->data = -1;
d683 1
a683 1
		tprintf(Notsess);
d709 1
a709 1
		tprintf(Notsess);
d714 1
a714 1
		tprintf("Can't list local files\n");
d747 1
a747 1
	int i,resp,control;
d749 1
a749 1
	FILE *fp;
d763 1
a763 1
		tprintf("Can't read %s: %s\n",localname,sys_errlist[errno]);
d767 1
a767 1
		tprintf("Warning: type is ASCII and %s appears to be binary\n",localname);
d770 3
a772 2
	ftp->data = socket(AF_INET,SOCK_STREAM,0);
	listen(ftp->data,0);
d780 1
a780 1
			usprintf(control,"TYPE A\n");
d783 1
a783 1
			usprintf(control,"TYPE I\n");
d786 1
a786 1
			usprintf(control,"TYPE L %d\n",ftp->logbsize);
d804 1
a804 1
	getsockname(ftp->data,(char *)&lsocket,&i);
d806 1
a806 1
	getsockname(ftp->control,(char *)&lcsocket,&i);
d817 1
a817 1
	usprintf(control,"STOR %s\n",remotename);
d843 1
a843 1
	accept(ftp->data,NULLCHAR,(int *)NULL);
d848 2
a849 2
	close_s(ftp->data);
	ftp->data = -1;
d858 1
a858 1
		tprintf("STOR %s: Error/abort during data transfer\n",remotename);
d869 1
a869 1
		tprintf("STOR %s: %lu bytes in %lu sec (%lu/sec)\n",
d878 2
a879 2
	close_s(ftp->data);
	ftp->data = -1;
d906 1
a906 1
		tprintf("Not an active FTP session\n");
d912 1
a912 1
		tprintf("No active transfer\n");
d920 1
a920 1
		shutdown(ftp->data,1);	/* Note fall-thru */
d925 1
a925 1
		shutdown(ftp->data,2);	/* Note fall-thru */
d933 2
a934 2
sendport(s,socket)
int s;
d938 1
a938 1
	usprintf(s,"PORT %u,%u,%u,%u,%u,%u\n",
d957 1
a957 1
	usflush(ftp->control);
d961 1
a961 1
		if(recvline(ftp->control,line,LINELEN) == -1){
d968 1
a968 1
			tprintf("%s\n",line);	/* Display to user */
d986 4
a989 6
	/* If there's something already there, don't issue prompt */
	if(socklen(sp->input,0) == 0)
		tprintf(prompt);

	usflush(sp->output);
	return recvline(sp->input,buf,n);
@


1.4
log
@src0331
@
text
@d17 1
d115 1
@


1.3
log
@src1217
@
text
@d83 1
a83 1
	if((sp = newsession(argv[1],FTP)) == NULLSESSION){
@


1.2
log
@src1216
@
text
@a631 6
	startclk = msclock() - startclk;
	if(startclk != 0)
		rate = (total*1000)/startclk;
	else
		rate = 0;

d637 9
d855 8
a862 5
		if(startclk != 0)
			rate = (total*1000)/startclk;
		else
			rate = 0;

@


1.1
log
@Initial revision
@
text
@d843 5
a847 5
	startclk = msclock() - startclk;
	if(startclk != 0)
		rate = (total*1000)/startclk;
	else
		rate = 0;
d851 6
a859 1
	getresp(ftp,200);
@
