head	1.23;
access;
symbols;
locks;
comment	@ * @;


1.23
date	93.05.06.10.07.56;	author karn;	state Exp;
branches;
next	1.22;

1.22
date	93.01.18.22.45.02;	author karn;	state Exp;
branches;
next	1.21;

1.21
date	93.01.06.22.32.24;	author karn;	state Exp;
branches;
next	1.20;

1.20
date	93.01.04.10.19.40;	author karn;	state Exp;
branches;
next	1.19;

1.19
date	93.01.03.12.17.21;	author karn;	state Exp;
branches;
next	1.18;

1.18
date	93.01.02.00.06.16;	author karn;	state Exp;
branches;
next	1.17;

1.17
date	92.12.30.21.07.32;	author karn;	state Exp;
branches;
next	1.16;

1.16
date	92.12.28.09.08.23;	author karn;	state Exp;
branches;
next	1.15;

1.15
date	92.12.10.22.10.00;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	92.12.09.09.57.58;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	92.12.08.11.29.43;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.12.08.05.43.30;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.12.07.17.33.10;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.08.28.20.44.47;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.06.21.08.40.41;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.06.21.07.26.29;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.06.10.07.02.34;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.05.28.21.49.10;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.05.22.03.26.56;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.05.18.21.51.54;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.05.14.23.32.28;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	92.05.06.11.16.38;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	92.05.05.21.56.58;	author karn;	state Exp;
branches;
next	;


desc
@src0505
@


1.23
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* ANSI display emulation
 *
 * This file emulates the IBM ANSI terminal display. It maintains a
 * display buffer and descriptor for each virtual display, of which there
 * can be many. All writes occur first into this display buffer, and then
 * any particular display buffer can be copied onto the real screen.
 * This allows many background tasks to run without blocking even though
 * only one task's display is actually being shown.
 *
 * This display driver is substantially faster than even the NANSI.SYS
 * loadable screen driver, particularly when large blocks are written.
 *
 * Extensions to handle displaying multiple small virtual windows should
 * be pretty straightforward.
 *
 * Copyright 1992 Phil Karn, KA9Q
 * 
 */
#include <conio.h>
#include <alloc.h>
#include <string.h>
#include "global.h"
#include "display.h"
#include "proc.h"

int fgattr[] = { 0, 4, 2, 14, 1, 5, 3, 7 };	/* Foreground attribs */
int bgattr[] = { 0, 4, 2, 6, 1, 5, 3, 7 };	/* Background attribs */

static void dclrscr(struct display *dp);
static void desc(struct display *dp,char c);
static void darg(struct display *dp,char c);
static void dchar (struct display *dp,char c);
static void dclreol(struct display *dp,int row,int col);
static void dattrib(struct display *dp,int val);
static char *bufloc(struct display *dp,int row,int col);
static void dinsline(struct display *dp);
static void ddelline(struct display *dp);
static void ddelchar(struct display *dp);
static void dinsert(struct display *dp);
static void dclreod(struct display *dp,int row,int col);

extern struct proc *Display;

/* Create a new virtual display.
 * The "noscrol" flag, if set, causes lines to "wrap around" from the bottom
 * to the top of the screen instead of scrolling the entire screen upwards
 * with each new line. This can be handy for packet trace screens.
 */
struct display *
newdisplay(rows,cols,noscrol,sflimit)
int rows,cols;	/* Size of new screen. 0,0 defaults to whole screen */
int noscrol;	/* 1: old IBM-style wrapping instead of scrolling */
int sflimit;	/* Scrollback file size, lines */
{
	struct display *dp;
	struct text_info text_info;

	gettextinfo(&text_info);
	if(rows == 0)
		rows = text_info.screenheight;
	if(cols == 0)
		cols = text_info.screenwidth;

	dp = (struct display *)calloc(1,sizeof(struct display) + 2*rows*cols + rows);
	dp->cookie = D_COOKIE;
	dp->buf = (char *)(dp + 1);
	dp->dirty = dp->buf + 2*rows*cols;
	dp->rows = rows;
	dp->cols = cols;

	/* Default scrolling region is all but last line of display,
	 * which is reserved for a status display
	 */
	dp->slast = rows - 2;

	dp->attrib = 0x7;	/* White on black, no blink or intensity */
	dclrscr(dp);		/* Start with a clean slate */
	dclreol(dp,rows-1,0);	/* Clear status line too */
	dp->flags |= DIRTY_CURSOR;
	if(noscrol)
		dp->flags |= NOSCROL;
	if(sflimit != 0 && (dp->sfile = tmpfile()) == NULLFILE)
		sflimit = 0;	/* Out of handles? */

	dp->sflimit = sflimit;
	return dp;
}

/* Close a display - simply get rid of the memory */
void
closedisplay(dp)
struct display *dp;
{
	if(dp == NULLDISP || dp->cookie != D_COOKIE)
		return;
	if(dp->sfile != NULLFILE)
		fclose(dp->sfile);
	free(dp);
}

/* Write buffer to status line. Works independently of the ANSI
 * machinery so as to not upset a possible escape sequence in
 * progress. Maximum of one line allowed, no control sequences
 */
void
statwrite(dp,buf,cnt,attrib)
struct display *dp;	/* Virtual screen pointer */
char *buf;		/* Data to be written */
int cnt;		/* Count */
int attrib;
{
	char *cp;
	int dirty = 0;

	if(cnt > dp->cols)
		cnt = dp->cols;
	cp = bufloc(dp,dp->slast+1,0);
	while(cnt-- != 0){
		if(!dirty && *cp != *buf || cp[1] != attrib)
			dirty = 1;
		*cp++ = *buf++;
		*cp++ = attrib;
	}
	if(dirty)
		dp->dirty[dp->slast+1] = 1;
}
/* Write data to the virtual display. Does NOT affect the real screen -
 * dupdate(dp) must be called to copy the virtual screen to the real
 * screen.
 */
void
displaywrite(dp,buf,cnt)
struct display *dp;	/* Virtual screen pointer */
char *buf;		/* Data to be written */
int cnt;		/* Count */
{
	char c;

	if(dp == NULLDISP || dp->cookie != D_COOKIE)
		return;

	while(cnt-- != 0){
		c = *buf++;
		switch(dp->state){
		case ESCAPE:
			desc(dp,c);
			break;
		case ARG:
			darg(dp,c);
			break;
		case NORMAL:
			dchar(dp,c);
			break;
		}
	}
	psignal(dp,1);
}
/* Make the real screen look like the virtual one. It attempts to do as
 * little work as possible unless the "force" flag is set -- then
 * the entire screen is updated. (This is useful when switching between
 * virtual display screens.)
 *
 * Note the different row and column numbering conventions -- I start
 * at zero, the puttext() and gotoxy() library functions start at 1.
 */
void
dupdate(dp,force)
struct display *dp;	/* Virtual screen pointer */
int force;	/* Force complete update regardless of dirty bits */
{
	int row,rows;
	long sp;
	char *lbuf;

	if(dp == NULLDISP || dp->cookie != D_COOKIE)
		return;

	if(dp->sfoffs != 0 && force){
		/* Display from scrollback file */
		sp = dp->sfseek - 2*dp->sfoffs*dp->cols;
		if(sp < 0)
			sp += 2*dp->sfsize*dp->cols;	/* Wrap back */
		rows = min(dp->sfoffs,dp->slast+1);	/* # rows to read */
		lbuf = malloc(2*dp->cols*rows);
		fseek(dp->sfile,sp,SEEK_SET);
		/* row = actual # rows read */
		row = fread(lbuf,2*dp->cols,rows,dp->sfile);
		if(row != 0)
			puttext(1,1,dp->cols,row,lbuf);
		if(row != rows){
			/* Hit end of file; rewind and read the rest */
			fseek(dp->sfile,0L,SEEK_SET);
			fread(lbuf,2*dp->cols,rows-row,dp->sfile);
			puttext(1,row+1,dp->cols,rows,lbuf);
		}
		free(lbuf);
	}
	/* Display from memory image of current screen (if visible) */
	for(row = dp->sfoffs;row<=dp->slast;row++){
		if(force || dp->dirty[row]){
			puttext(1,row+1,dp->cols,row+1,bufloc(dp,row-dp->sfoffs,0));
			dp->dirty[row] = 0;
		}
	}
	/* Display unscrolled status region */
	for(row=dp->slast+1;row<dp->rows;row++){
		if(force || dp->dirty[row]){
			puttext(1,row+1,dp->cols,row+1,bufloc(dp,row,0));
			dp->dirty[row] = 0;
		}
	}
	if(force || (dp->flags & DIRTY_CURSOR)){
		/* Update cursor */
		if(dp->row+dp->sfoffs <= dp->slast){
			gotoxy(dp->col+1,dp->row+1+dp->sfoffs);
			_setcursortype(_NORMALCURSOR);
		} else {
			/* Turn off cursor entirely */
			_setcursortype(_NOCURSOR);
		}
	}
	dp->flags &= ~DIRTY_CURSOR;
}
void
dhome(dp)
struct display *dp;
{
	if(dp == NULLDISP || dp->cookie != D_COOKIE)
		return;

	if(dp->sfoffs != dp->sfsize){
		dp->sfoffs = dp->sfsize;
		alert(Display,1);
	}
}
void
dend(dp)
struct display *dp;
{
	if(dp == NULLDISP || dp->cookie != D_COOKIE)
		return;

	if(dp->sfoffs != 0){
		dp->sfoffs = 0;
		alert(Display,1);
	}
}
void
dpgup(dp)
struct display *dp;
{
	if(dp == NULLDISP || dp->cookie != D_COOKIE)
		return;

	dp->sfoffs += dp->slast + 1;
	if(dp->sfoffs > dp->sfsize)
		dp->sfoffs = dp->sfsize;

	alert(Display,1);
}
void
dpgdown(dp)
struct display *dp;
{
	if(dp == NULLDISP || dp->cookie != D_COOKIE)
		return;

	dp->sfoffs -= dp->slast + 1;
	if(dp->sfoffs < 0)
		dp->sfoffs = 0;

	alert(Display,1);
}
void
dcursup(dp)
struct display *dp;
{
	if(dp == NULLDISP || dp->cookie != D_COOKIE)
		return;

	if(dp->sfoffs < dp->sfsize){
		dp->sfoffs++;
		alert(Display,1);
	}
}
void
dcursdown(dp)
struct display *dp;
{
	if(dp == NULLDISP || dp->cookie != D_COOKIE)
		return;

	if(dp->sfoffs != 0){
		dp->sfoffs--;
		alert(Display,1);
	}
}

/* Process incoming character while in ESCAPE state */
static void
desc(dp,c)
struct display *dp;
char c;
{
	int i;

	switch(c){
	case '[':	/* Always second char of ANSI escape sequence */
		/* Get ready for argument list */
		dp->state = ARG;
		dp->argi = 0;
		for(i=0;i<MAXARGS;i++)
			dp->arg[i] = 0;

		break;
	case '7':	/* Save cursor location (VT-100) */
		dp->savcol = dp->col;
		dp->savrow = dp->row;
		dp->state = NORMAL;
		break;
	case '8':	/* Restore cursor location (VT-100) */
		dp->col = dp->savcol;
		dp->row = dp->savrow;
		dp->flags |= DIRTY_CURSOR;
		dp->state = NORMAL;
		break;
	case ESC:
		break;	/* Remain in ESCAPE state */
	default:
		dp->state = NORMAL;
		dchar(dp,c);
	}
}

/* Process characters after a ESC[ sequence */
static void
darg(dp,c)
struct display *dp;
char c;
{
	int i;

	switch(c){
	case ESC:
		dp->state = ESCAPE;
		return;
	case '?':	/* Ignored */
	case '=':
		return;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
		/* Collect decimal number */
		dp->arg[dp->argi] = 10*dp->arg[dp->argi] + (c - '0');
		return;
	case ';':	/* Next argument is beginning */
		if(dp->argi <= MAXARGS - 1)
			dp->argi++;
		dp->arg[dp->argi] = 0;
		return;
	case '@@':	/* Open up space for character */
		dinsert(dp);
		break;
	case 'A':	/* Cursor up */
		if(dp->arg[0] == 0)
			dp->arg[0] = 1;	/* Default is one line */
		if(dp->arg[0] < dp->row)
			dp->row -= dp->arg[0];
		else
			dp->row = 0;
		dp->flags |= DIRTY_CURSOR;
		break;
	case 'B':	/* Cursor down */
		if(dp->arg[0] == 0)
			dp->arg[0] = 1;	/* Default is one line */
		dp->row += dp->arg[0];
		if(dp->row > dp->slast)
			dp->row = dp->slast;
		dp->flags |= DIRTY_CURSOR;
		break;
	case 'C':	/* Cursor right */
		if(dp->arg[0] == 0)
			dp->arg[0] = 1;	/* Default is one column */
		dp->col += dp->arg[0];
		if(dp->col >= dp->cols)
			dp->col = dp->cols - 1;
		dp->flags |= DIRTY_CURSOR;
		break;
	case 'D':	/* Cursor left */
		if(dp->arg[0] == 0)
			dp->arg[0] = 1;	/* Default is one column */
		if(dp->arg[0] < dp->col)
			dp->col -= dp->arg[0];
		else
			dp->col = 0;
		dp->flags |= DIRTY_CURSOR;
		break;
	case 'f':
	case 'H':	/* Cursor motion - limit to scrolled region */
		i = (dp->arg[0] == 0) ? 0 : dp->arg[0] - 1;
		if(i > dp->slast)
			i = dp->slast;
		dp->row = i;

		i = (dp->arg[1] == 0) ? 0 : dp->arg[1] - 1;
		if(i >= dp->cols)
			i = dp->cols - 1;
		dp->col = i;
		dp->state = NORMAL;
		dp->flags |= DIRTY_CURSOR;
		break;
	case 'h':	/* Set mode */
		switch(dp->arg[0]){
		case 7:	/* Turn on wrap mode */
			dp->flags &= ~NOWRAP;
			break;
		}
		break;
	case 'J':	/* Clear screen */
		switch(dp->arg[0]){
		case 2:
			dclrscr(dp);	/* Clear entire screen, home cursor */
			break;
		case 0:
			dclreod(dp,dp->row,dp->col);	/* Clear to end of screen (VT-100) */
			break;
		}
		break;
	case 'K':	/* Erase to end of current line */
		dclreol(dp,dp->row,dp->col);
		break;
	case 'L':	/* Add blank line */
		dinsline(dp);
		break;		
	case 'l':	/* Clear mode */
		switch(dp->arg[0]){
		case 7:	/* Turn off wrap mode */
			dp->flags |= NOWRAP;
			break;
		}
		break;
	case 'M':	/* Delete line */
		ddelline(dp);
		break;
	case 'm':	/* Set screen attributes */
		for(i=0;i<=dp->argi;i++){
			dattrib(dp,dp->arg[i]);
		}
		break;
	case 'P':	/* Delete character */
		ddelchar(dp);
		break;
	case 's':	/* Save cursor position */
		dp->savcol = dp->col;
		dp->savrow = dp->row;
		break;
	case 'u':	/* Restore cursor position */
		dp->col = dp->savcol;
		dp->row = dp->savrow;
		dp->flags |= DIRTY_CURSOR;
		break;
	}
	dp->state = NORMAL;
}
/* Clear from specified location to end of screen, leaving cursor as is */
static void
dclreod(dp,row,col)
struct display *dp;
int row,col;
{
	dclreol(dp,row,col);	/* Clear current line */
	for(row = row + 1;row <= dp->slast;row++)
		dclreol(dp,row,0);	/* Clear all lines below */
}
/* Insert space at cursor, moving all chars on right to right one position */
static void
dinsert(dp)
struct display *dp;
{
	int i;
	char *cp;

	cp = bufloc(dp,dp->row,dp->col);
	i = 2*(dp->cols - dp->col - 1);
	if(i != 0)
		memmove(cp+2,cp,i);	/* handles overlapping blocks */
	*cp++ = ' ';
	*cp = dp->attrib;
	dp->dirty[dp->row] = 1;
}
/* Delete character at cursor, moving chars to right left one position */
static void
ddelchar(dp)
struct display *dp;
{
	char *cp;
	int i;

	cp = bufloc(dp,dp->row,dp->col);
	i = 2*(dp->cols-dp->col-1);
	/* Copy characters to right one space left */
	if(i != 0)
		memmove(cp,cp+2,i);	/* memmove handles overlapping blocks */
	/* Clear right most character on line */
	cp[i] = ' ';
	cp[i+1] = dp->attrib;
	dp->dirty[dp->row] = 1;
}
/* Delete line containing cursor, moving lines below up one line */
static void
ddelline(dp)
struct display *dp;
{
	char *cp1,*cp2;
	int row;

	for(row=dp->row;row < dp->slast;row++){
		cp1 = bufloc(dp,row,0);
		cp2 = bufloc(dp,row+1,0);
		memcpy(cp1,cp2,dp->cols*2);
		dp->dirty[row] = 1;
	}
	/* Clear bottom line */
	dclreol(dp,dp->slast,0);
	dp->dirty[dp->slast] = 1;
}		
/* Insert blank line where cursor is. Push existing lines down one */
static void
dinsline(dp)
struct display *dp;
{
	char *cp1,*cp2;
	int row;

	/* Copy lines down */
	for(row = dp->slast;row > dp->row;row--){
		cp1 = bufloc(dp,row-1,0);
		cp2 = bufloc(dp,row,0);
		memcpy(cp2,cp1,2*dp->cols);
		dp->dirty[row] = 1;
	}
	/* Clear current line */
	dclreol(dp,dp->row,0);
	dp->dirty[dp->row] = 1;
}

/* Process an argument to an attribute set command */
static void
dattrib(dp,val)
struct display *dp;
int val;
{
	switch(val){
	case 0:	/* Normal white on black */
		dp->attrib = 0x7;
		break;
	case 1:	/* High intensity */
		dp->attrib |= 0x8;
		break;
	case 5:	/* Blink on */
		dp->attrib |= 0x80;
		break;
	case 7:	/* Reverse video (black on white) */
		dp->attrib = 0x70;
		break;
	default:
		if(val >= 30 && val < 38){
			/* Set foreground color */
			dp->attrib = (dp->attrib & ~0x7) | fgattr[val - 30];
		} else if(val >= 40 && val < 48){
			/* Set background color */
			dp->attrib = (dp->attrib & ~0x70) | ((bgattr[val - 40]) << 4);
		}
		break;
	}
 }
/* Display character */
static void
dchar(dp,c)
struct display *dp;
char c;
{
	char *cp;
	int row,rowchange;

	rowchange = 0;
	switch(c){
	case ESC:
		dp->state = ESCAPE;
		return;
	case CTLQ:	/*****/
	case '\0':	/* Ignore nulls and bells */
	case BELL:
		break;
	case '\b':	/* Backspace */
		if(dp->col > 0){
			dp->col--;
			dp->flags |= DIRTY_CURSOR;
		}
		break;
	case FF:	/* Page feed */
		dclrscr(dp);
		break;
	case '\t':	/* Tab */
		if(dp->col < dp->cols - 8){
			dp->col = (dp->col + 8) & ~7;
			dp->flags |= DIRTY_CURSOR;
		}
		break;
	case '\n':	/* Move cursor down one row */
		dp->row++;
		rowchange = 1;
		dp->flags |= DIRTY_CURSOR;
		break;
	case '\r':	/* Move cursor to beginning of current row */
		dp->col = 0;
		dp->flags |= DIRTY_CURSOR;
		break;
	default:	/* Display character on screen */
		/* Compute location in screen buffer memory */
		cp = bufloc(dp,dp->row,dp->col);
		/* Normal display */
		if(c != *cp || cp[1] != dp->attrib)
			dp->dirty[dp->row] = 1;
		*cp++ = c;
		*cp = dp->attrib;
		dp->flags |= DIRTY_CURSOR;
		/* Update cursor position, wrapping if necessary */
		if(++dp->col == dp->cols){
			if(dp->flags & NOWRAP){
				dp->col--;
			} else {
				dp->col = 0;
				dp->row++;
				rowchange = 1;
			}
		}
	}
	/* Scroll screen if necessary */
	if(rowchange && dp->row > dp->slast){
		dp->row--;
		/* Scroll screen up */
		dp->scroll = (dp->scroll + 1) % (dp->slast + 1);
		if(!(dp->flags & NOSCROL)){
			for(row=0;row <=dp->slast;row++)
				dp->dirty[row] = 1;
		}
		if(dp->sfile != NULLFILE){
			char *cp;

			/* When scrolled back, leave screen stationary */
			if(dp->sfoffs != 0 && dp->sfoffs != dp->sflimit)
				dp->sfoffs++;

			/* Copy scrolled line to scrollback file */
			cp = bufloc(dp,dp->row,0);
			fseek(dp->sfile,dp->sfseek,SEEK_SET);
			fwrite(cp,2,dp->cols,dp->sfile);
			dp->sfseek += 2*dp->cols;
			if(dp->sfseek >= 2*dp->cols*dp->sflimit)
				dp->sfseek = 0;
			if(dp->sfsize < dp->sflimit)
				dp->sfsize++;
		}
		dclreol(dp,dp->row,0);
		dp->dirty[dp->row] = 1;
	}
}

/* Clear from specified location to end of line. Cursor is not moved */
static void
dclreol(dp,row,col)
struct display *dp;
int row,col;
{
	char *cp;
	int i;

	cp = bufloc(dp,row,col);
	for(i=dp->cols - col;i!=0;i--){
		*cp++ = ' ';
		*cp++ = dp->attrib;
	}
	dp->dirty[row] = 1;
}
/* Move cursor to top left corner, clear screen */
static void
dclrscr(dp)
struct display *dp;
{
	dclreod(dp,0,0);
	dp->row = dp->col = 0;
	dp->scroll = 0;
	dp->flags |= DIRTY_CURSOR;
}
/* Return pointer into screen buffer for specified cursor location.
 * Not guaranteed to be valid past the end of the current line due to
 * scrolling
 */
static char *
bufloc(dp,row,col)
struct display *dp;
int row,col;
{
#ifndef	notdef
	if(row < 0 || row >= dp->rows || col < 0 || col >= dp->cols){
		stktrace();
		cprintf("panic: bufloc(%p,%d,%d)\n",dp,row,col);
		exit(1);
	}
#endif
	if(row <= dp->slast)
		row = (row + dp->scroll) % (dp->slast + 1);
	return dp->buf + 2*(col + dp->cols*row);
}
@


1.22
log
@Check for tmpfile() when opening a scroll file
@
text
@d29 12
a40 12
static void dclrscr __ARGS((struct display *dp));
static void desc __ARGS((struct display *dp,char c));
static void darg __ARGS((struct display *dp,char c));
static void dchar  __ARGS((struct display *dp,char c));
static void dclreol __ARGS((struct display *dp,int row,int col));
static void dattrib __ARGS((struct display *dp,int val));
static char *bufloc __ARGS((struct display *dp,int row,int col));
static void dinsline __ARGS((struct display *dp));
static void ddelline __ARGS((struct display *dp));
static void ddelchar __ARGS((struct display *dp));
static void dinsert __ARGS((struct display *dp));
static void dclreod __ARGS((struct display *dp,int row,int col));
@


1.21
log
@Remove obsolete DIRTY SCREEN flag
Fix bug in display space allocation
@
text
@d82 4
a85 4
	if(sflimit != 0){
		dp->sflimit = sflimit;
		dp->sfile = tmpfile();
	}
@


1.20
log
@Set the row dirty bit only if a write actually changes something
@
text
@d64 1
a64 1
	dp = (struct display *)calloc(1,sizeof(struct display) + 2*rows*cols + cols);
d79 1
a79 1
	dp->flags |= DIRTY_SCREEN | DIRTY_CURSOR;
d200 1
a200 1
		if(force || (dp->flags & DIRTY_SCREEN) || dp->dirty[row]){
d207 1
a207 1
		if(force || (dp->flags & DIRTY_SCREEN) || dp->dirty[row]){
d222 1
a222 1
	dp->flags &= ~(DIRTY_SCREEN|DIRTY_CURSOR);
@


1.19
log
@Set dirty bit for status line when writing status
@
text
@d113 1
d119 2
d124 2
a125 1
	dp->dirty[dp->slast+1] = 1;
d630 2
a634 1
		dp->dirty[dp->row] = 1;
@


1.18
log
@Performance enhancement when displaying from scrollback file -
read as much as possible in single chunk, instead of fseeking
and reading a line at a time (noticeably slow on 286).
@
text
@d121 1
@


1.17
log
@Move fseek out of screen update loop when scrolled back -- really
slowed things down on slower machines, even with ram disk
@
text
@d166 1
a166 1
	int row;
d178 2
d181 9
a189 8
		lbuf = malloc(2*dp->cols);
		for(row=0;row<dp->sfoffs && row <= dp->slast;row++){
			if(sp >= 2*dp->cols*dp->sfsize)
				fseek(dp->sfile,sp,SEEK_SET);

			fread(lbuf,2,dp->cols,dp->sfile);
			sp += 2*dp->cols;
			puttext(1,row+1,dp->cols,row+1,lbuf);
@


1.16
log
@Major enhancement - scroll back feature added
Copies lines scrolled off top of screen to temp file, the size
of which is limited by a parameter at display creation time.
Functions added to hook into cursor control keys (home/end/pg up/pg dwn/
cursor up/cursor dwn).
@
text
@d178 1
d182 2
a183 2
				sp = 0;
			fseek(dp->sfile,sp,SEEK_SET);
@


1.15
log
@Calling newdisplay() with rows or cols = 0 invokes a default of
the physical screen's current size (as determined by a BIOS call)
@
text
@d42 2
d50 1
a50 1
newdisplay(rows,cols,noscrol)
d53 1
d82 4
d94 5
a98 2
	if(dp != NULLDISP && dp->cookie == D_COOKIE)
		free(dp);
a159 4
 *
 * The "dirty row" stuff is intended to allow updating of only a single
 * modified row instead of rewriting the entire screen -- it's not fully
 * implemented yet. I may replace it with a per-row flag.
d167 2
d173 25
a197 2
	/* Write it all to the screen */
	for(row=0;row<dp->rows;row++){
d205 7
a211 1
		gotoxy(dp->col+1,dp->row+1);
d215 75
d644 17
@


1.14
log
@Fix bug - not all args were cleared at start of arg list, so
command like \E[H, which normally takes two args, would get
garbage on the second.
@
text
@d49 1
a49 1
int rows,cols;	/* Size of new screen */
d53 1
d55 6
a60 2
	if(rows < 1 || cols < 1)
		return NULLDISP;	/* Bogus args */
d574 1
a574 1
	if(row < 0 || row >= NROWS || col < 0 || col >= NCOLS){
@


1.13
log
@Fix egregious bug in dinsert()
Reimplement status line write routine to not interfere with a
control sequence in progress
@
text
@d179 2
d186 3
a188 1
		dp->arg[0] = 0;
@


1.12
log
@Redo bounds checking on cursor control
@
text
@d86 4
a89 1
/* Write buffer to status line, saving and restoring cursor and attribute */
d91 1
a91 1
statwrite(dp,buf,cnt)
d95 1
d97 1
a97 2
	int rowsave,colsave;
	char attrsave;
d99 7
a105 10
	rowsave = dp->row;
	colsave = dp->col;
	attrsave = dp->attrib;

	dp->col = 0;
	dp->row = dp->rows-1;
	displaywrite(dp,buf,cnt);
	dp->col = colsave;
	dp->row = rowsave;
	dp->attrib = attrsave;
d414 2
a415 2
		cp1 = bufloc(dp,dp->row-1,0);
		cp2 = bufloc(dp,dp->row,0);
d566 1
@


1.11
log
@Major changes - completely redo scolling and screen buffer addressing
to support top scrolled region and bottom unscrolled region for status.
Also do more intelligent line updating. Probably fixed a few bugs in
screen buffer referencing, too.
@
text
@d253 3
a255 4
		if(dp->arg[0] + dp->row < dp->rows)
			dp->row += dp->arg[0];
		else
			dp->row = dp->rows - 1;
d261 2
a262 3
		if(dp->arg[0] + dp->col < dp->cols)
			dp->col += dp->arg[0];
		else
d276 10
a285 3
	case 'H':	/* Cursor motion */
		dp->row = (dp->arg[0] == 0) ? 0 : dp->arg[0] - 1;
		dp->col = (dp->arg[1] == 0) ? 0 : dp->arg[1] - 1;
d564 1
d569 1
@


1.10
log
@Get rid of automatic highlighting -- frequently occurred unintentionally.
Needs to be smarter if it is to be done at all...
@
text
@a28 1
static void dclrline __ARGS((struct display *dp));
d33 1
a33 1
static void dclreol __ARGS((struct display *dp));
d35 1
a35 1
static char *bufloc __ARGS((struct display *dp));
d40 1
a40 1
static void dclreod __ARGS((struct display *dp));
d56 1
a56 1
	dp = (struct display *)calloc(1,sizeof(struct display) + 2*rows*cols);
d59 1
d62 6
d70 1
d86 21
d155 2
d160 5
a164 10
	if(force || (dp->flags & (DIRTY_SCREEN | DIRTY_ROW))){
		/* Write it all to the screen */
		if(dp->flags & NOSCROL){
			puttext(1,1,dp->cols,dp->rows,dp->buf);
		} else {
			/* Scroll-mode update */
			puttext(1,1,dp->cols,dp->rows - dp->firstrow,
			 dp->buf + 2*dp->firstrow*dp->cols);
			if(dp->firstrow != 0)
				puttext(1,dp->rows-dp->firstrow+1,dp->cols,dp->rows,dp->buf);
d169 1
a169 4
		if(dp->flags & NOSCROL)
			gotoxy(dp->col+1,((dp->row + dp->firstrow) % dp->rows) +1);
		else
			gotoxy(dp->col+1,dp->row+1);
d171 1
a171 1
	dp->flags &= ~(DIRTY_SCREEN|DIRTY_ROW|DIRTY_CURSOR);
a248 2
		if(dp->flags & DIRTY_ROW)
			dp->flags |= DIRTY_SCREEN;
d253 3
a255 1
		if(dp->arg[0] + dp->row >= dp->rows)
a256 2
		else
			dp->row += dp->arg[0];
a257 2
		if(dp->flags & DIRTY_ROW)
			dp->flags |= DIRTY_SCREEN;
d262 3
a264 1
		if(dp->arg[0] + dp->col >= dp->cols)
a265 2
		else
			dp->col += dp->arg[0];
d297 1
a297 1
			dclreod(dp);	/* Clear to end of screen (VT-100) */
d302 1
a302 1
		dclreol(dp);
d337 1
a337 1
/* Clear from cursor to end of screen, leaving cursor as is */
d339 1
a339 1
dclreod(dp)
d341 1
d343 3
a345 10
	char *cp;
	int i;

	cp = bufloc(dp);
	i = (dp->rows - dp->row - 1) * dp->cols + (dp->cols - dp->col - 1);
	while(i-- != 0){
		*cp++ = ' ';
		*cp++ = dp->attrib;
	}
	dp->flags |= DIRTY_SCREEN;
d347 1
a347 1

d355 1
a355 1
	cp = bufloc(dp);
d361 1
a361 1
	dp->flags |= DIRTY_ROW;
d363 1
d371 1
a371 1
	cp = bufloc(dp);
d379 1
a379 1
	dp->flags |= DIRTY_ROW;
d381 1
d386 2
a387 4
	char *cp;
	int i;
	int colsave;
	int rowsave;
d389 6
a394 7
	colsave = dp->col;
	rowsave = dp->row;
	cp = bufloc(dp);
	/* Copy up lines below this one */
	i = 2*dp->cols*(dp->rows-dp->row-1);
	if(i != 0)
		memmove(cp,cp+2*dp->cols,i);
d396 2
a397 5
	dp->row = dp->rows - 1;
	dclrline(dp);
	dp->col = colsave;
	dp->row = rowsave;
	dp->flags |= DIRTY_SCREEN;
d404 2
a405 8
	char *cp;
	int colsave;
	int i;

	colsave = dp->col; /* Supposed to be issued only at start of line */
	dp->col = 0;
	cp = bufloc(dp);
	i = 2*dp->cols*(dp->rows - dp->row - 1);
d407 10
a416 6
	/* Copy everything starting with current line down one line */
	if(i != 0)
		memmove(cp+2*dp->cols,cp,i);	/* does copy correctly */
	dclrline(dp);			/* Clear current line */
	dp->col = colsave;
	dp->flags |= DIRTY_SCREEN;
d448 1
a448 1
}
d456 1
d458 1
d484 1
a485 2
		if(dp->flags & DIRTY_ROW)
			dp->flags |= DIRTY_SCREEN;
d493 1
a493 1
		cp = bufloc(dp);
d497 2
a498 1
		dp->flags |= DIRTY_CURSOR | DIRTY_ROW;
d506 1
a506 2
				if(dp->flags & DIRTY_ROW)
					dp->flags |= DIRTY_SCREEN;
d511 1
a511 1
	if(dp->row == dp->rows){
d514 7
a520 4
		dp->firstrow = (dp->firstrow + 1) % dp->rows;
		if(!(dp->flags & NOSCROL))
			dp->flags |= DIRTY_SCREEN;
		dclrline(dp);
d524 1
a524 20
/* Clear entire line containing cursor, leaving cursor alone */
static void
dclrline(dp)
struct display *dp;
{
	char *cp;
	int i;
	int colsave;

	colsave = dp->col;
	dp->col = 0;
	cp = bufloc(dp);
	for(i=dp->cols;i!=0;i--){
		*cp++ = ' ';
		*cp++ = dp->attrib;
	}
	dp->col = colsave;
	dp->flags |= DIRTY_ROW;
}
/* Clear from cursor to end of line. Cursor is not moved */
d526 1
a526 1
dclreol(dp)
d528 1
d533 2
a534 2
	cp = bufloc(dp);
	for(i=dp->cols - dp->col;i!=0;i--){
d538 1
a538 1
	dp->flags |= DIRTY_ROW;
d545 1
a545 3
 	char *cp;
	int i;

d547 2
a548 7
	dp->firstrow = 0;
	cp = bufloc(dp);
	for(i=dp->rows*dp->cols;i!=0;i--){
		*cp++ = ' ';
		*cp++ = dp->attrib;
	}
	dp->flags |= (DIRTY_CURSOR|DIRTY_SCREEN);
d550 4
a553 1
/* Return pointer into screen buffer for current cursor location */
d555 1
a555 1
bufloc(dp)
d557 1
d559 7
a565 4
	int offset;

	offset = dp->col + dp->cols*((dp->row + dp->firstrow) % dp->rows);
	return dp->buf + 2*offset;
@


1.9
log
@Remove control char defs
@
text
@d487 3
a489 17
		if(c == '_' && *cp != ' '){
			/* We'd like to underline the existing char,
			 * but we can't except on a monochrome display.
			 * So highlight it instead. (char-backspace-underscore)
			 */
			*++cp = dp->attrib | 0x8;
		} else if(c != ' ' && *cp == '_'){
			/* underscore-backspace-char sequence;
			 * also intensify the char
			 */
			*cp++ = c;
			*cp = dp->attrib | 0x8;
		} else {
			/* Normal display */
			*cp++ = c;
			*cp = dp->attrib;
		}
@


1.8
log
@Get rid of control char definitions
@
text
@d457 1
a457 1
	case BEL:
@


1.7
log
@s920612
@
text
@a25 5
#define	ESC	0x1b		/* ASCII ESCAPE */
#define	FF	0x0c		/* ASCII ^L (form feed) */
#define	BEL	0x7		/* ASCII ^G (bell) */
#define	CTLQ	0x11		/* CTL-Q (XON) */

@


1.6
log
@s920528
@
text
@d29 1
d460 1
@


1.5
log
@src0521a
@
text
@d490 17
a506 2
		*cp++ = c;
		*cp = dp->attrib;
@


1.4
log
@src0518
@
text
@d28 1
d459 2
a460 1
	case '\0':	/* Ignore nulls */
@


1.3
log
@src0514
@
text
@d346 1
@


1.2
log
@src0506
@
text
@d40 5
d61 1
d78 2
a79 1
	free(dp);
d94 3
d130 3
d167 11
d219 2
a220 6
	case 'H':	/* Cursor motion */
	case 'f':
		dp->row = (dp->arg[0] == 0) ? 0 : dp->arg[0] - 1;
		dp->col = (dp->arg[1] == 0) ? 0 : dp->arg[1] - 1;
		dp->state = NORMAL;
		dp->flags |= DIRTY_CURSOR;
d262 5
a266 7
	case 's':	/* Save cursor position */
		dp->savcol = dp->col;
		dp->savrow = dp->row;
		break;
	case 'u':	/* Restore cursor position */
		dp->col = dp->savcol;
		dp->row = dp->savrow;
a268 7
	case 'J':	/* Clear screen */
		if(dp->arg[0] == 2)
			dclrscr(dp);
		break;
	case 'K':	/* Erase to end of current line */
		dclreol(dp);
		break;
d276 16
d299 3
d307 12
d321 92
@


1.1
log
@Initial revision
@
text
@d1 18
a18 1
/* ANSI display emulation */
d26 2
a27 2
#define	ESC	0x1b
#define	FF	0x0c
d29 2
a30 2
int fgattr[] = { 0, 4, 2, 14, 1, 5, 3, 7 };
int bgattr[] = { 0, 4, 2, 6, 1, 5, 3, 7 };
d41 5
d48 2
a49 2
int rows,cols;
int noscrol;
a50 1

d53 2
d60 1
a60 1
	dclrscr(dp);
d67 1
d75 4
d81 3
a83 3
struct display *dp;
char *buf;
int cnt;
d103 12
d117 2
a118 2
struct display *dp;
int force;
a119 1

d141 1
d148 1
a148 1
	case '[':
d154 1
a154 1
	case ESC:	
d187 1
d190 1
a190 1
	case ';':	/* Additional argument is beginning */
d197 2
a198 2
		dp->row = dp->arg[0] == 0 ? 0 : dp->arg[0] - 1;
		dp->col = dp->arg[1] == 0 ? 0 : dp->arg[1] - 1;
d276 1
d281 1
d398 1
a398 3
/* Clear to end of current line, beginning with cursor.
 * Cursor is not moved
 */
a412 1

d418 1
a418 1
	char *cp;
@
