head	1.14;
access;
symbols;
locks;
comment	@ * @;


1.14
date	93.05.06.10.07.10;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	93.04.12.00.17.37;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.10.07.19.44.00;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.07.07.19.06.06;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.05.15.10.02.24;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.05.01.08.19.42;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.04.19.06.50.10;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.04.06.13.56.04;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.03.31.12.08.34;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.03.27.12.57.22;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.09.21.12.25.32;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.03.16.15.35.04;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.03.08.11.16.40;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.28.03.10.08;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.14
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* Generic serial line interface routines
 * Copyright 1992 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "proc.h"
#include "iface.h"
#include "netuser.h"
#include "slhc.h"
#include "n8250.h"
#include "asy.h"
#include "ax25.h"
#include "kiss.h"
#include "nrs.h"
#include "pktdrvr.h"
#include "slip.h"
#include "ppp.h"
#include "commands.h"

static int asy_detach(struct iface *ifp);

/* Attach a serial interface to the system
 * argv[0]: hardware type, must be "asy"
 * argv[1]: I/O address, e.g., "0x3f8"
 * argv[2]: vector, e.g., "4", or "fp1" for port 1 on a 4port card
 * argv[3]: mode, may be:
 *		"slip" (point-to-point SLIP)
 *		"kissui" (AX.25 UI frame format in SLIP for raw TNC)
 *		"ax25ui" (same as kissui)
 *		"kissi" (AX.25 I frame format in SLIP for raw TNC)
 *		"ax25i" (same as kissi)
 *		"nrs" (NET/ROM format serial protocol)
 *		"ppp" (Point-to-Point Protocol, RFC1171, RFC1172)
 * argv[4]: interface label, e.g., "sl0"
 * argv[5]: receiver ring buffer size in bytes
 * argv[6]: maximum transmission unit, bytes
 * argv[7]: interface speed, e.g, "9600"
 * argv[8]: optional flags,
 *		'v' for Van Jacobson TCP header compression (SLIP only,
 *		    use ppp command for VJ compression with PPP);
 *		'c' for cts flow control
 *		'r' for rlsd (cd) detection
 */
int
asy_attach(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct iface *ifp;
	int dev;
	int trigchar = -1;
	int cts,rlsd;
	struct asymode *ap;
	char *cp;
	int base;
	int irq;
	struct asy *asyp;
	int i,n;
	int chain;

	if(if_lookup(argv[4]) != NULLIF){
		printf("Interface %s already exists\n",argv[4]);
		return -1;
	}
	if(setencap(NULLIF,argv[3]) == -1){
		printf("Unknown encapsulation %s\n",argv[3]);
		return -1;
	}
	/* Find unused asy control block */
	for(dev=0;dev < ASY_MAX;dev++){
		if(Asy[dev].iface == NULLIF)
			break;
	}
	if(dev >= ASY_MAX){
		printf("Too many asynch controllers\n");
		return -1;
	}
	asyp = &Asy[dev];

	base = htoi(argv[1]);
	if(*argv[2] == 's'){
		/* This is a port on a 4port card with shared interrupt */
		for(i=0;i<FPORT_MAX;i++){
			if(base >= Fport[i].base && base < Fport[i].base+32){
				n = (base - Fport[i].base) >> 3;
				Fport[i].asy[n] = asyp;
				break;
			}
		}
		if(i == FPORT_MAX){
			printf("%x not a known 4port address\n");
			return -1;
		}
		irq = -1;
	} else
		irq = atoi(argv[2]);

	/* Create interface structure and fill in details */
	ifp = (struct iface *)callocw(1,sizeof(struct iface));
	ifp->addr = Ip_addr;
	ifp->name = strdup(argv[4]);
	ifp->mtu = atoi(argv[6]);
	ifp->dev = dev;
	ifp->stop = asy_detach;
	setencap(ifp,argv[3]);

	/* Look for the interface mode in the table */
	for(ap = Asymode;ap->name != NULLCHAR;ap++){
		if(stricmp(argv[3],ap->name) == 0){
			trigchar = uchar(ap->trigchar);
			if((*ap->init)(ifp) != 0){
				printf("%s: mode %s Init failed\n",
				 ifp->name,argv[3]);
				if_detach(ifp);
				return -1;
			}
			break;
		}
	}
	if(ap->name == NULLCHAR){
		printf("Mode %s unknown for interface %s\n",argv[3],argv[4]);
		if_detach(ifp);
		return -1;
	}
	/* Link in the interface */
	ifp->next = Ifaces;
	Ifaces = ifp;

	cts = rlsd = 0;
	if(argc > 8){
		if(strchr(argv[8],'c') != NULLCHAR)
			cts = 1;
		if(strchr(argv[8],'r') != NULLCHAR)
			rlsd = 1;
	}
	if(strchr(argv[2],'c') != NULL)
		chain = 1;
	else
		chain = 0;
	asy_init(dev,ifp,base,irq,(uint16)atol(argv[5]),
		trigchar,atol(argv[7]),cts,rlsd,chain);
	cp = if_name(ifp," tx");
	ifp->txproc = newproc(cp,768,if_tx,0,ifp,NULL,0);
	free(cp);
	return 0;
}

static int
asy_detach(ifp)
struct iface *ifp;
{
	struct asymode *ap;

	if(ifp == NULLIF)
		return -1;
	asy_stop(ifp);

	/* Call mode-dependent routine */
	for(ap = Asymode;ap->name != NULLCHAR;ap++){
		if(ifp->iftype != NULLIFT
		 && stricmp(ifp->iftype->name,ap->name) == 0
		 && ap->free != NULLFP){
			(*ap->free)(ifp);
		}
	}
	return 0;
}


@


1.13
log
@Add 4-port card support
Change args to asy_init for base and irq to be numbers rather than
ascii strings, make chain an explicit arg to asy_init (all to help
4-port support)
@
text
@d20 1
a20 1
static int asy_detach __ARGS((struct iface *ifp));
d141 1
a141 1
	asy_init(dev,ifp,base,irq,(int16)atol(argv[5]),
@


1.12
log
@'v' option to specify vj header compression and "mode" command
to specify datagram/connected mode AX.25 encapsulation both removed
in favor of having explicit encapsulation types.
@
text
@d25 1
a25 1
 * argv[2]: vector, e.g., "4"
d56 5
d79 1
d81 18
d122 1
a122 2
		printf("Mode %s unknown for interface %s\n",
		 argv[3],argv[4]);
d137 6
a142 2
	asy_init(dev,ifp,argv[1],argv[2],(int16)atol(argv[5]),
		trigchar,atol(argv[7]),cts,rlsd);
@


1.11
log
@Remove erroneous cast to 16 bits in speed parameter
@
text
@d28 4
a31 1
 *		"ax25" (AX.25 frame format in SLIP for raw TNC)
a54 1
	int vj;
d61 4
d82 1
a82 4
	if(argc > 8 && strchr(argv[8],'v') != NULLCHAR)
		vj = 1;
	else
		vj = 0;
d88 1
a88 1
			if((*ap->init)(ifp,vj) != 0){
@


1.10
log
@src0515
@
text
@d112 1
a112 1
		trigchar,(int16)atol(argv[7]),cts,rlsd);
@


1.9
log
@src0501
@
text
@d10 1
a10 1
#include "8250.h"
@


1.8
log
@src0419
@
text
@d56 1
a56 1
		tprintf("Interface %s already exists\n",argv[4]);
d65 1
a65 1
		tprintf("Too many asynch controllers\n");
d86 1
a86 1
				tprintf("%s: mode %s Init failed\n",
d95 1
a95 1
		tprintf("Mode %s unknown for interface %s\n",
@


1.7
log
@src0406
@
text
@d53 1
d113 3
a115 1
	ifp->txproc = newproc("asy tx",768,if_tx,0,ifp,NULL,0);
@


1.6
log
@src0331
@
text
@d2 1
a2 1
 * Copyright 1991 Phil Karn, KA9Q
a5 1
#include "config.h"
a47 2
	struct asy *asyp;
	char *ifn;
a48 1
	int xdev;
d51 2
a52 6
#if	defined(SLIP) || defined(AX25)
	struct slip *sp;
#endif
#ifdef	NRS
	struct nrs *np;
#endif
d60 1
a60 2
		asyp = &Asy[dev];
		if(asyp->iface == NULLIF)
d75 16
a90 7

#ifdef	SLIP
	if(stricmp(argv[3],"SLIP") == 0) {
		for(xdev = 0;xdev < SLIP_MAX;xdev++){
			sp = &Slip[xdev];
			if(sp->iface == NULLIF)
				break;
d92 2
a93 108
		if(xdev >= SLIP_MAX) {
			tprintf("Too many slip devices\n");
			return -1;
		}
		setencap(ifp,"SLIP");
		ifp->ioctl = asy_ioctl;
		ifp->raw = slip_raw;
		ifp->show = slip_status;
		ifp->flags = 0;
		ifp->xdev = xdev;

		sp->iface = ifp;
		sp->send = asy_send;
		sp->get = get_asy;
		sp->type = CL_SERIAL_LINE;
		trigchar = FR_END;
#ifdef VJCOMPRESS
		if((argc > 8) && (strchr(argv[8],'v') != NULLCHAR)) {
			sp->escaped |= SLIP_VJCOMPR;
			sp->slcomp = slhc_init(16,16);
		}
#else
		sp->slcomp = NULL;
#endif	/* VJCOMPRESS */
		ifp->rxproc = newproc( ifn = if_name( ifp, " rx" ),
			256,asy_rx,xdev,NULL,NULL,0);
		free(ifn);
	} else
#endif
#ifdef	AX25
	if(stricmp(argv[3],"AX25") == 0) {
		/* Set up a SLIP link to use AX.25 */
		for(xdev = 0;xdev < SLIP_MAX;xdev++){
			sp = &Slip[xdev];
			if(sp->iface == NULLIF)
				break;
		}
		if(xdev >= SLIP_MAX) {
			tprintf("Too many slip devices\n");
			return -1;
		}
		setencap(ifp,"AX25");
		ifp->ioctl = kiss_ioctl;
		ifp->raw = kiss_raw;
		ifp->show = slip_status;

		if(ifp->hwaddr == NULLCHAR)
			ifp->hwaddr = mallocw(AXALEN);
		memcpy(ifp->hwaddr,Mycall,AXALEN);
		ifp->xdev = xdev;

		sp->iface = ifp;
		sp->send = asy_send;
		sp->get = get_asy;
		sp->type = CL_KISS;
		trigchar = FR_END;
		ifp->rxproc = newproc( ifn = if_name( ifp, " rx" ),
			256,asy_rx,xdev,NULL,NULL,0);
		free(ifn);
	} else
#endif
#ifdef	NRS
	if(stricmp(argv[3],"NRS") == 0) {
		/* Set up a net/rom serial iface */
		for(xdev = 0;xdev < SLIP_MAX;xdev++){
			np = &Nrs[xdev];
			if(np->iface == NULLIF)
				break;
		}
		if(xdev >= SLIP_MAX) {
			tprintf("Too many nrs devices\n");
			return -1;
		}
		/* no call supplied? */
		setencap(ifp,"AX25");
		ifp->ioctl = asy_ioctl;
		ifp->raw = nrs_raw;

		ifp->hwaddr = mallocw(AXALEN);
		memcpy(ifp->hwaddr,Mycall,AXALEN);
		ifp->xdev = xdev;
		np->iface = ifp;
		np->send = asy_send;
		np->get = get_asy;
		trigchar = ETX;
		ifp->rxproc = newproc( ifn = if_name( ifp, " nrs" ),
			256,nrs_recv,xdev,NULL,NULL,0);
		free(ifn);
	} else
#endif
#ifdef	PPP
	if(stricmp(argv[3],"PPP") == 0) {
		/* Setup for Point-to-Point Protocol */
		trigchar = HDLC_FLAG;
		setencap(ifp,"PPP");
		ifp->ioctl = asy_ioctl;
		ifp->flags = FALSE;

		/* Initialize parameters for various PPP phases/protocols */
		if (ppp_init(ifp) != 0) {
			tprintf("Cannot allocate PPP control block\n");
			free(ifp->name);
			free((char *)ifp);
			return -1;
		}
	} else
#endif
	{
d95 2
a96 3
			argv[3],argv[4]);
		free(ifp->name);
		free(ifp);
a98 1

d105 1
a105 1
		if(strchr(argv[8],'c'))
d107 1
a107 1
		if(strchr(argv[8],'r'))
a115 1

d120 4
d126 7
a132 32
#ifdef	SLIP
	if(stricmp(ifp->iftype->name,"SLIP") == 0) {
		Slip[ifp->xdev].iface = NULLIF;
#ifdef VJCOMPRESS
		slhc_free( Slip[ifp->xdev].slcomp );
		Slip[ifp->xdev].slcomp = NULL;
#endif	/* VJCOMPRESS */
	} else
#endif
#ifdef	AX25
	if(stricmp(ifp->iftype->name,"AX25") == 0
	 && Slip[ifp->xdev].iface == ifp ) {
		Slip[ifp->xdev].iface = NULLIF;
	} else
#endif
#ifdef	NRS
	if(stricmp(ifp->iftype->name,"AX25") == 0
	 && Nrs[ifp->xdev].iface == ifp ) {
		Nrs[ifp->xdev].iface = NULLIF;
	} else
#endif
#ifdef	PPP
	if(stricmp(ifp->iftype->name,"PPP") == 0) {
		ppp_free(ifp);
	} else
#endif
	{
		tprintf("invalid type %s for interface %s\n",
			ifp->iftype->name, ifp->name);
		free(ifp->name);
		free(ifp);
		return -1;
@


1.5
log
@src0327
@
text
@a22 1

d39 2
d54 1
a54 1
	char monitor = FALSE;
a185 1
		monitor = TRUE;
d211 7
d219 2
a220 2
		trigchar,monitor,(int16)atol(argv[7]));
	ifp->sendproc = newproc("asy tx",768,if_tx,0,ifp,NULL,0);
@


1.4
log
@src0922
@
text
@d213 1
@


1.3
log
@src0318
@
text
@a37 2
 *		'c' for cts flow control;
 *		'r' for RLSD (RS232 pin 8, CD) physical link up/down;
d53 1
a53 2
	char cts = FALSE;
	char rlsd = FALSE;
d98 1
a98 1
		ifp->status = slip_status;
d135 1
a135 1
		ifp->status = slip_status;
d185 1
a190 3
		if((argc > 8) && (strchr(argv[8],'r') != NULLCHAR))
			rlsd = TRUE;

a210 3
	if((argc > 8) && (strchr(argv[8],'c') != NULLCHAR))
		cts = TRUE;

d212 1
a212 1
		trigchar,cts,rlsd,(int16)atol(argv[7]));
@


1.2
log
@src0308
@
text
@d7 1
a8 1
#include "pktdrvr.h"
d10 2
a12 1
#include "8250.h"
d15 3
a18 4
#include "slip.h"
#include "nrs.h"
#include "config.h"
#include "proc.h"
d20 2
a21 1
#include "slcomp.h"
d23 1
d29 4
a32 4
 *	    "slip" (point-to-point SLIP)
 *	    "ax25" (AX.25 frame format in SLIP for raw TNC)
 *	    "nrs" (NET/ROM format serial protocol)
 *	    "ppp" (Point-to-Point Protocol, RFC1171, RFC1172)
d37 5
a41 6
 * argv[8]: optional flags, e.g., 'c' for cts flow control;
 *          'v' for Van Jacobson TCP header compression (SLIP only,
 *          use 'ppp ipcomp' command for VJ compression with PPP);
 *	    'r' for RLSD (RS232 pin 8, CD) physical link up/down
 *	    indicator (PPP only); 'a' for autobaud message handling
 *	    (PPP only)
d49 3
a51 1
	register struct iface *if_asy;
a52 1
	int mode;
d55 3
a57 5
	char cts;
	struct asy *asyp;
	char rlsd = 0;
	unsigned long autospeed = 0L;
#if	defined(SLIP) || defined(AX25) || defined(PPP)
d64 4
a77 14
	if(if_lookup(argv[4]) != NULLIF){
		tprintf("Interface %s already exists\n",argv[4]);
		return -1;
	}
	if(strcmp(argv[3],"slip") == 0)
		mode = SLIP_MODE;
	else if(strcmp(argv[3],"ax25") == 0)
		mode = AX25_MODE;
	else if(strcmp(argv[3],"nrs") == 0)
		mode = NRS_MODE;
	else if(strcmp(argv[3],"ppp") == 0)
		mode = PPP_MODE;
	else 
		mode = UNKNOWN_MODE;
d80 6
a85 6
	if_asy = (struct iface *)callocw(1,sizeof(struct iface));
	if_asy->addr = Ip_addr;
	if_asy->name = strdup(argv[4]);
	if_asy->mtu = atoi(argv[6]);
	if_asy->dev = dev;
	if_asy->stop = asy_stop;
a86 1
	switch(mode){
d88 1
a88 1
	case SLIP_MODE:
d98 6
a103 5
		setencap(if_asy,"SLIP");
		if_asy->ioctl = asy_ioctl;
		if_asy->raw = slip_raw;
		if_asy->flags = 0;
		if_asy->xdev = xdev;
d105 1
a105 1
		sp->iface = if_asy;
d113 1
a113 2
			sp->slcomp = (struct slcompress *)mallocw(sizeof(struct slcompress));
			sl_compress_init(sp->slcomp);
d116 1
a116 1
		sp->slcomp = 0L;
d118 4
a121 2
		if_asy->rxproc = newproc("asy rx",256,asy_rx,xdev,NULL,NULL,0);
		break;
d124 2
a125 1
	case AX25_MODE:  /* Set up a SLIP link to use AX.25 */
d135 4
a138 7
		setencap(if_asy,"AX25");
		if_asy->ioctl = kiss_ioctl;
		if_asy->raw = kiss_raw;
		if(if_asy->hwaddr == NULLCHAR)
			if_asy->hwaddr = mallocw(AXALEN);
		memcpy(if_asy->hwaddr,Mycall,AXALEN);
		if_asy->xdev = xdev;
d140 6
a145 1
		sp->iface = if_asy;
d150 4
a153 2
		if_asy->rxproc = newproc("asy rx",256,asy_rx,xdev,NULL,NULL,0);
		break;
d156 2
a157 1
	case NRS_MODE: /* Set up a net/rom serial iface */
d168 8
a175 7
		setencap(if_asy,"AX25");
		if_asy->ioctl = asy_ioctl;
		if_asy->raw = nrs_raw;
		if_asy->hwaddr = mallocw(AXALEN);
		memcpy(if_asy->hwaddr,Mycall,AXALEN);
		if_asy->xdev = xdev;
		np->iface = if_asy;
d179 4
a182 2
		if_asy->rxproc = newproc("nrs rx",256,nrs_recv,xdev,NULL,NULL,0);
		break;
d185 6
a190 15
	case PPP_MODE:	/* Setup for Point-to-Point Protocol */
		for(xdev = 0;xdev < SLIP_MAX;xdev++){
			sp = &Slip[xdev];
			if(sp->iface == NULLIF)
				break;
		}
		if(xdev >= SLIP_MAX) {
			tprintf("Too many slip/ppp devices\n");
			return -1;
		}
		setencap(if_asy,"PPP");
		if_asy->ioctl = asy_ioctl;
		if_asy->raw = ppp_raw;
		if_asy->flags = 0;
		if_asy->xdev = xdev;
a191 15
		sp->iface = if_asy;
		sp->send = asy_send;
		sp->get = get_asy;
		sp->type = CL_PPP;
		sp->get_rlsd = get_rlsd_asy;
		sp->escaped = 0;
		trigchar = HDLC_FLAG;
		/* Allocate PPP control structure */
		sp->pppio = (struct pppctl *)calloc(1,sizeof(struct pppctl));
		if (sp->pppio == NULLPPPCTL) {
			tprintf("Cannot allocate PPP control block\n");
			free(if_asy->name);
			free((char *)if_asy);
			return -1;
		}
d194 6
a199 12
			rlsd = 1;
		else
			rlsd = 0;
		if((argc > 8) && (strchr(argv[8],'a') != NULLCHAR)) {
			autospeed = atoi(argv[7]);
		} else {
			autospeed = 0;
		}
		/* Initialize parameters for various PPP phases/protocols */
		if (ppp_init(xdev,rlsd,autospeed) == -1) {
			free(if_asy->name);
			free((char *)if_asy);
d202 3
a204 13
		if (autospeed != 0) {
			if_asy->rxproc = newproc("ppp autobaud", 256,
			 ppp_autobaud, xdev, NULL, NULL,0);
		} else {
			if_asy->rxproc = newproc("ppp recv", 256,
			 ppp_recv, xdev, NULL, NULL,0);
		}
		if (rlsd)
			if_asy->txproc = newproc("ppp rlsd", 256, ppp_rlsd,
			 xdev, (void *)autospeed, NULL,0);
		break;
#endif /* PPP */
	default:
d207 2
a208 2
		free(if_asy->name);
		free((char *)if_asy);
d211 5
a215 3
	if_asy->txproc = newproc("asy tx",256,asy_tx,dev,NULL,NULL,0);
	if_asy->next = Ifaces;
	Ifaces = if_asy;
d217 47
a263 5
		cts = 1;
	else
		cts = 0;
	asy_init(dev,if_asy,argv[1],argv[2],(unsigned)atoi(argv[5]),trigchar,cts,rlsd);
	asy_speed(dev,atol(argv[7]),autospeed);
d266 2
@


1.1
log
@Initial revision
@
text
@d20 1
a20 1
#include "slcompress.h"
@
