head	1.17;
access;
symbols;
locks;
comment	@ * @;


1.17
date	93.05.06.10.07.00;	author karn;	state Exp;
branches;
next	1.16;

1.16
date	93.03.08.00.48.03;	author karn;	state Exp;
branches;
next	1.15;

1.15
date	92.08.28.18.37.52;	author karn;	state Exp;
branches;
next	1.14;

1.14
date	92.08.20.15.21.58;	author karn;	state Exp;
branches;
next	1.13;

1.13
date	92.08.11.13.11.12;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	92.07.09.08.19.55;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.05.21.09.12.48;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.05.19.22.26.34;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.05.05.11.19.06;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.05.03.02.31.18;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.05.01.08.19.30;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.04.21.00.47.22;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	92.04.15.11.51.10;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	92.04.11.06.36.02;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.12.16.16.44.26;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.02.04.08.31.20;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.11.30.54;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.17
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* memory allocation routines
 * Copyright 1991 Phil Karn, KA9Q
 *
 * Adapted from alloc routine in K&R; memory statistics and interrupt
 * protection added for use with net package. Must be used in place of
 * standard Turbo-C library routines because the latter check for stack/heap
 * collisions. This causes erroneous failures because process stacks are
 * allocated off the heap.
 */

#include <stdio.h>
#include <dos.h>
#include <alloc.h>
#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "cmdparse.h"

static unsigned long Memfail;	/* Count of allocation failures */
static unsigned long Allocs;	/* Total allocations */
static unsigned long Frees;	/* Total frees */
static unsigned long Invalid;	/* Total calls to free with garbage arg */
static int Memwait;		/* Number of tasks waiting for memory */
static unsigned long Yellows;	/* Yellow alert garbage collections */
static unsigned long Reds;	/* Red alert garbage collections */
unsigned long Availmem;		/* Heap memory, ABLKSIZE units */
static unsigned long Morecores;
static int Memdebug;
static unsigned long Sizes[16];

/* This debugging pattern MUST be exactly equal in size to the "header"
 * union defined later
 */
static char Debugpat[] = { 0xfe,0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef };

static int domdebug(int argc,char *argv[],void *ptr);
static int dostat(int argc,char *argv[],void *p);
static int dofreelist(int argc,char *argv[],void *p);
static int dothresh(int argc,char *argv[],void *p);
static int dosizes(int argc,char *argv[],void *p);

struct cmds Memcmds[] = {
	"debug",	domdebug,	0, 0, NULLCHAR,
	"freelist",	dofreelist,	0, 0, NULLCHAR,
	"sizes",	dosizes,	0, 0, NULLCHAR,
	"status",	dostat,		0, 0, NULLCHAR,
	"thresh",	dothresh,	0, 0, NULLCHAR,
	NULLCHAR,
};

#ifdef	LARGEDATA
#define	HUGE	huge
#else
#define	HUGE
#endif

union header {
	struct {
		union header HUGE *ptr;
		unsigned long size;
	} s;
	char c[8];	/* For debugging; also ensure size is 8 bytes */
};

typedef union header HEADER;
#define	NULLHDR	(HEADER HUGE *)NULL

#define	ABLKSIZE	(sizeof (HEADER))
#define	BTOU(nb)	((((nb) + ABLKSIZE - 1) / ABLKSIZE) + 1)

static HEADER HUGE *morecore(unsigned nu);

static HEADER Base;
static HEADER HUGE *Allocp = NULLHDR;
static unsigned long Heapsize;


/* Memory blocks obtained from MS-DOS by allocmem() call */
struct sysblock {
	unsigned seg;
	unsigned npar;
};
#define	NSYSBLOCK	5
struct sysblock Sysblock[NSYSBLOCK];

/* Allocate block of 'nb' bytes */
void *
malloc(nb)
unsigned nb;
{
	int i;
	int i_state;
	register HEADER HUGE *p, HUGE *q;
	register unsigned nu;

	if(nb == 0)
		return NULL;

	Allocs++;
	/* Record the size of this request */
	if((i = log2(nb)) >= 0)
		Sizes[i]++;
	
	/* Round up to full block, then add one for header */
	nu = BTOU(nb);

	i_state = dirps();
	/* Initialize heap pointers if necessary */
	if((q = Allocp) == NULLHDR){
		Base.s.ptr = Allocp = q = &Base;
		Base.s.size = 1;
	}
	/* Search heap list */
	for(p = q->s.ptr; ; q = p, p = p->s.ptr){
		if(p->s.size >= nu){
			/* This chunk is at least as large as we need */
			if(p->s.size <= nu + 1){
				/* This is either a perfect fit (size == nu)
				 * or the free chunk is just one unit larger.
				 * In either case, alloc the whole thing,
				 * because there's no point in keeping a free
				 * block only large enough to hold the header.
				 */
				q->s.ptr = p->s.ptr;
			} else {
				/* Carve out piece from end of entry */
				p->s.size -= nu;
				p += p->s.size;
				p->s.size = nu;
			}
#ifdef	circular
			Allocp = q;
#endif
			p->s.ptr = p;	/* for auditing */
			Availmem -= p->s.size;
			p++;
			break;
		}
		/* We've searched all the way around the list without
		 * finding anything. Try to get more core from the system,
		 * unless we're in an interrupt handler
		 */
		if(p == Allocp && (!i_state || (p = morecore(nu)) == NULLHDR)){
			p = NULLHDR;
			Memfail++;
			break;
		}
	}
	restore(i_state);
#ifdef	LARGEDATA
	/* On the brain-damaged Intel CPUs in "large data" model,
	 * make sure the pointer's offset field isn't null
	 * (unless the entire pointer is null).
	 * The Turbo C compiler and certain
	 * library functions like strrchr() assume this.
	 */
	if(FP_OFF(p) == 0 && FP_SEG(p) != 0){
		/* Return denormalized but equivalent pointer */
		return (void *)MK_FP(FP_SEG(p)-1,16);
	}
#endif
	return (void *)p;
}
/* Get more memory from the system and put it on the heap */
static HEADER HUGE *
morecore(nu)
unsigned nu;
{
	char HUGE *cp;
	HEADER HUGE *up;
	unsigned size;
	unsigned segp;
	unsigned npar;
	struct sysblock *sp;
	int i;

	Morecores++;
	size = nu * ABLKSIZE;
	/* First try to expand our main memory block */
	if((int)(cp = (char HUGE *)sbrk(size)) != -1){
		up = (HEADER *)cp;
		up->s.size = nu;
		up->s.ptr = up;	/* satisfy audit */
		free((void *)(up + 1));
		Heapsize += size;
		Frees--;	/* Nullify increment inside free() */
		return Allocp;
	}
	/* That failed; the main memory block must have grown into another
	 * allocated block, or something else (e.g., the increase handles
	 * call in ioinit()) must have allocated memory just beyond it.
	 * Allocate or extend an additional memory block.
	 */
	npar = (size+16)/16;	/* Convert size from bytes to paragraphs */
	cp = NULL;
	for(sp=Sysblock,i=0;i < NSYSBLOCK;i++,sp++){
		if(sp->npar != 0){
			/* Try to expand this block */
			if(setblock(sp->seg,sp->npar + npar) != -1){
				/* Failed (-1 == SUCCESS; strange!) */
				continue;
			}
			/* Block expansion succeeded */
			cp = MK_FP(sp->seg + sp->npar,0);
			sp->npar += npar;
		} else {
			/* Allocate new block */
			if(allocmem(npar,&segp) != -1){
				return NULL;	/* Complete failure */
			}
			/* -1 indicates SUCCESS (strange) */
			sp->seg = segp;
			sp->npar = npar;
			cp = MK_FP(segp,0);
		}
		break;
	}
	if(cp != (char HUGE *)NULL){
		/* Expand or create succeeded, add to heap */
		up = (HEADER *)cp;
		up->s.size = (npar*16)/ABLKSIZE;
		up->s.ptr = up;	/* satisfy audit */
		free((void *)(up + 1));
		Heapsize += npar*16;
		Frees--;	/* Nullify increment inside free() */
		return Allocp;
	}
	return NULL;
}

/* Put memory block back on heap */
void
free(blk)
void *blk;
{
	register HEADER HUGE *p, HUGE *q;
	unsigned short HUGE *ptr;
	int i_state;
	int i;

	if(blk == NULL)
		return;		/* Required by ANSI */
	Frees++;
	p = ((HEADER HUGE *)blk) - 1;
	/* Audit check */
	if(p->s.ptr != p){
		Invalid++;
		if(istate()){
			ptr = (unsigned short *)&blk;
			printf("free: WARNING! invalid pointer (0x%lx) proc %s\n",
			 ptol(blk),Curproc->name);
			stktrace();

			log(-1,"free: WARNING! invalid pointer (0x%lx) pc = 0x%x %x proc %s\n",
			 ptol(blk),ptr[-1],ptr[-2],Curproc->name);
		}
		return;
	}
	Availmem += p->s.size;
	if(Memdebug){
		/* Fill data area with pattern to detect later overwrites */
		for(i=1;i<p->s.size;i++){
			memcpy(p[i].c,Debugpat,sizeof(Debugpat));
		}
	}
	i_state = dirps();
 	/* Search the free list looking for the right place to insert */
	for(q = Allocp; !(p > q && p < q->s.ptr); q = q->s.ptr){
		/* Highest address on circular list? */
		if(q >= q->s.ptr && (p > q || p < q->s.ptr))
			break;
	}
	if(p + p->s.size == q->s.ptr){
		/* Combine with front of this entry */
		p->s.size += q->s.ptr->s.size;
		p->s.ptr = q->s.ptr->s.ptr;
		if(Memdebug){
			memcpy(q->s.ptr->c,Debugpat,sizeof(Debugpat));
		}
	} else {
		/* Link to front of this entry */
		p->s.ptr = q->s.ptr;
	}
	if(q + q->s.size == p){
		/* Combine with end of this entry */
		q->s.size += p->s.size;
		q->s.ptr = p->s.ptr;
		if(Memdebug){
			memcpy(p->c,Debugpat,sizeof(Debugpat));
		}
	} else {
		/* Link to end of this entry */
		q->s.ptr = p;
	}
#ifdef	circular
	Allocp = q;
#endif
	restore(i_state);
	if(Memwait != 0)
		psignal(&Memwait,0);
}

/* Move existing block to new area */
void *
realloc(area,size)
void *area;
unsigned size;
{
	unsigned osize;
	HEADER HUGE *hp;
	void *new;

	hp = ((HEADER *)area) - 1;
	osize = (hp->s.size -1) * ABLKSIZE;

	/* We must copy the block since freeing it may cause the heap
	 * debugging code to scribble over it.
	 */
	if((new = malloc(size)) != NULL)
		memcpy(new,area,size>osize? osize : size);
	free(area);
	return new;
}

/* Allocate block of cleared memory */
void *
calloc(nelem,size)
unsigned nelem;	/* Number of elements */
unsigned size;	/* Size of each element */
{
	register unsigned i;
	register char *cp;

	i = nelem * size;
	if((cp = malloc(i)) != NULL)
		memset(cp,0,i);
	return cp;
}
/* Version of malloc() that waits if necessary for memory to become available */
void *
mallocw(nb)
unsigned nb;
{
	register void *p;

	while((p = malloc(nb)) == NULL){
		Memwait++;
		pwait(&Memwait);
		Memwait--;
	}
	return p;
}
/* Version of calloc that waits if necessary for memory to become available */
void *
callocw(nelem,size)
unsigned nelem;	/* Number of elements */
unsigned size;	/* Size of each element */
{
	register unsigned i;
	register char *cp;

	i = nelem * size;
	cp = mallocw(i);
	memset(cp,0,i);
	return cp;
}
/* Return 0 if at least Memthresh memory is available. Return 1 if
 * less than Memthresh but more than Memthresh/2 is available; i.e.,
 * if a yellow garbage collection should be performed. Return 2 if
 * less than Memthresh/2 is available, i.e., a red collection should
 * be performed.
 */
int
availmem()
{
	void *p;

	if(Availmem*ABLKSIZE >= Memthresh)
		return 0;	/* We're clearly OK */

	/* There's not enough on the heap; try calling malloc to see if
	 * it can get more from the system
	 */
	if((p = malloc(Memthresh)) != NULL){
		free(p);
		return 0;	/* Okay */
	}
	if((p = malloc(Memthresh/2)) != NULL){
		free(p);
		return 1;	/* Yellow alert */
	}
	return 2;		/* Red alert */
}

/* Print heap stats */
static int
dostat(argc,argv,envp)
int argc;
char *argv[];
void *envp;
{
	struct sysblock *sp;
	int i;

	printf("heap size %lu avail %lu (%lu%%) morecores %lu\n",
	 Heapsize,Availmem * ABLKSIZE,100L*Availmem*ABLKSIZE/Heapsize,
	 Morecores);
	if(Sysblock[0].npar != 0){
		printf("Extra blocks:");
		for(i=0,sp=Sysblock;i< NSYSBLOCK;i++,sp++){
			if(sp->npar == 0)
				break;
			printf(" (%x0-%x0)",sp->seg,sp->seg+sp->npar);
		}
		printf("\n");
	}
	printf("allocs %lu frees %lu (diff %lu) alloc fails %lu invalid frees %lu\n",
		Allocs,Frees,Allocs-Frees,Memfail,Invalid);
	printf("pushdown calls %lu pushdown calls to malloc %lu\n",
		Pushdowns,Pushalloc);
	printf("garbage collections yellow %lu red %lu\n",Yellows,Reds);
	return 0;
}

/* Print heap free list */
static int
dofreelist(argc,argv,envp)
int argc;
char *argv[];
void *envp;
{
	HEADER HUGE *p;
	int i = 0;
	int j;
	unsigned corrupt;
	int i_state;

	for(p = Base.s.ptr;p != (HEADER HUGE *)&Base;p = p->s.ptr){
		corrupt = 0;
		if(Memdebug){
			i_state = dirps();
			for(j=1;j<p->s.size;j++){
				if(memcmp(p[j].c,Debugpat,sizeof(Debugpat)) != 0){
					corrupt = j;
					break;
				}
			}
			restore(i_state);
		}
		if(corrupt)
			printf("%5lx %6lu C: %u",ptol((void *)p),p->s.size * ABLKSIZE,corrupt);
		else
			printf("%5lx %6lu",ptol((void *)p),p->s.size * ABLKSIZE);

		if(++i == 4){
			i = 0;
			if(printf("\n") == EOF)
				return 0;
		} else
			printf(" | ");
	}
	if(i != 0)
		printf("\n");
	return 0;
}
static int
dosizes(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	int i;

	for(i=0;i<16;i += 4){
		printf("N>=%5u:%7ld| N>=%5u:%7ld| N>=%5u:%7ld| N>=%5u:%7ld\n",
		 1<<i,Sizes[i],	2<<i,Sizes[i+1],
		 4<<i,Sizes[i+2],8<<i,Sizes[i+3]);
	}
	return 0;
}
int
domem(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(Memcmds,argc,argv,p);
}

static int
dothresh(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setlong(&Memthresh,"Free memory threshold (bytes)",argc,argv);
}
static int
domdebug(argc,argv,ptr)
int argc;
char *argv[];
void *ptr;
{
	int prev,j,i_state;
	HEADER HUGE *p;

	prev = Memdebug;
	setbool(&Memdebug,"Heap debugging",argc,argv);
	if(prev == 1 || Memdebug == 0)
		return 0;

	/* Turning debugging on; reinitialize free areas to debug pattern */
	i_state = dirps();
	for(p = Base.s.ptr;p != (HEADER HUGE *)&Base;p = p->s.ptr){
		for(j=1;j<p->s.size;j++){
			memcpy(p[j].c,Debugpat,sizeof(Debugpat));
		}
	}
	restore(i_state);
	return 0;
}

/* Background memory compactor, used when memory runs low */
void
gcollect(i,v1,v2)
int i;	/* Args not used */
void *v1;
void *v2;
{
	void (**fp)(int);
	int red;

	for(;;){
		pause(1000L);	/* Run every second */
		/* If memory is low, collect some garbage. If memory is VERY
		 * low, invoke the garbage collection routines in "red" mode.
		 */
		switch(availmem()){
		case 0:
			continue;	/* All is well */
		case 1:
			red = 0;
			Yellows++;
			break;
		case 2:
			red = 1;
			Reds++;
			break;
		}
		for(fp = Gcollect;*fp != NULL;fp++)
			(**fp)(red);
	}
}
@


1.16
log
@Add prototype to function pointer
@
text
@d36 5
a40 5
static int domdebug __ARGS((int argc,char *argv[],void *ptr));
static int dostat __ARGS((int argc,char *argv[],void *p));
static int dofreelist __ARGS((int argc,char *argv[],void *p));
static int dothresh __ARGS((int argc,char *argv[],void *p));
static int dosizes __ARGS((int argc,char *argv[],void *p));
d71 1
a71 1
static HEADER HUGE *morecore __ARGS((unsigned nu));
d530 1
a530 1
	void (**fp) __ARGS((int));
@


1.15
log
@Make heap free pattern debugging a run-time flag (memory debug on/off)
@
text
@d530 1
a530 1
	void (**fp)();
@


1.14
log
@Rip out heap caching - probably still buggy (revisit later?)
@
text
@a0 1
#define	DEBUG	1
d28 2
d31 4
a34 1
static unsigned long Sizes[16];
d36 1
d43 1
d62 1
a62 1
	long l[2];
a238 1
#ifdef	DEBUG
a239 1
#endif
d260 5
a264 5
#ifdef	DEBUG
	/* Fill data area with pattern to detect later overwrites */
	for(i=1;i<p->s.size;i++){
		p[i].l[0] = 0xfeedface;
		p[i].l[1] = 0xdeadbeef;		
a265 1
#endif
d277 3
a279 4
#ifdef	DEBUG
		q->s.ptr->l[0] = 0xfeedface;
		q->s.ptr->l[1] = 0xdeadbeef;		
#endif
d288 3
a290 4
#ifdef	DEBUG
		p->l[0] = 0xfeedface;
		p->l[1] = 0xdeadbeef;		
#endif
d311 1
a311 2
	char HUGE *cp;
	int i_state;
d316 5
a320 1
	i_state = dirps();
d322 1
a322 4
	if((cp = malloc(size)) != NULL && cp != area)
		memcpy((char *)cp,(char *)area,size>osize? osize : size);
	restore(i_state);
	return cp;
a433 1
#ifdef	DEBUG
d437 1
a437 1
#endif
a438 1
#ifdef	DEBUG
d440 7
a446 5
		i_state = dirps();
		for(j=1;j<p->s.size;j++){
			if(p[j].l[0] != 0xfeedface || p[j].l[1] != 0xdeadbeef){
				corrupt = j;
				break;
d448 1
d450 1
a450 2
		restore(i_state);
		if(corrupt != 0)
d454 1
a454 3
#else
		printf("%5lx %6lu",ptol((void *)p),p->s.size * ABLKSIZE);
#endif
d498 8
d507 15
@


1.13
log
@Alloc with extensive block caching. Still crashes randomly, so this
check-in is just to log the work before I rip it all out again...
@
text
@d1 1
a28 3
static int32 Ifails;		/* Count of failed interrupt-time mallocs */
static int32 Chits;		/* Cache hits */
static int32 Refills;		/* Cache replenishments by refiq() */
a65 1
static void *dmalloc __ARGS((unsigned nb));
a70 20
/* Entry on memory cache list, one for each size cached */
struct heapcache {
	union header HUGE *list;	/* List of memory blocks */
	int16 size;		/* Size of each entry, bytes */
	int16 cnt;		/* Current number on list */
	int16 target;		/* Count to maintain on list */
	int16 lowwat;		/* Low water mark */
};
#define	SMALL	48		/* mbufs containing TCP or IP headers, etc */
#define	MEDIUM	1048		/* mbuf + stdio buffers */
#define	BIG	2048		/* Pkt driver, HDLC buffers */

/* List of cached sizes. Must be in ascending size order! */
struct heapcache Heapcache[] = {
	NULLHDR, SMALL,		0,	20,	20,
	NULLHDR, MEDIUM,	0,	10,	10,
	NULLHDR, BIG,		0,	10,	10,
	NULLHDR, 0,		0,	0,	0,
};	
static union header HUGE *Garbq;
a85 3
	struct heapcache *hp;
	union header HUGE *p;
	void *ptr;
d87 2
a97 55
	if(nb < SMALL)
		nb = SMALL;
	/* Check the cache, protecting against interrupts doing the same */
	i_state = dirps();
	for(hp=Heapcache;hp->size != 0;hp++){
		if(nb > hp->size)
			continue;	/* Keep looking */

		if(i_state && (hp->cnt < 2 || nb != hp->size)){
			/* Regular users must hit the exact size, and must
			 * not take the last entry
			 */
			break;
		} else if(!i_state && hp->cnt == 0){
			/* Interrupt users can use any available buffer
			 * larger than that requested. So keep looking.
			 */
			continue;
		}
		/* Take entry off list and hand to user. */
		p = hp->list;
		hp->list = p->s.ptr;
		p->s.ptr = p;
		hp->cnt--;
		Availmem -= p->s.size;

		if(hp->cnt < hp->lowwat)
			hp->lowwat = hp->cnt;
		Chits++;

		restore(i_state);
		return (void *)(p + 1);
	}
	if(!i_state){
		/* Don't call regular heap malloc at interrupt time */
		Ifails++;
		return NULL;	/* Interrupts were already off */
	}
	/* Re-enable interrupts and call regular heap malloc */
	restore(i_state);

	if((ptr = dmalloc(nb)) != NULL){
		p = ((union header HUGE *)ptr) - 1;
		Availmem -= p->s.size;
	}	
	return ptr;
}
/* Direct entry to heap manager */
static void *
dmalloc(nb)
unsigned nb;
{
	register HEADER HUGE *p, HUGE *q;
	register unsigned nu;

d101 1
d129 1
d137 2
a138 1
		if(p == Allocp && (p = morecore(nu)) == NULLHDR){
d143 1
d174 1
a174 1
	if ((int)(cp = (char HUGE *)sbrk(size)) != -1){
a231 1
	struct heapcache *hp;
d233 3
d256 7
a262 1
	/* Put on heap cache if right size. Protect against interrupts */
d264 1
a264 25
	for(hp=Heapcache;hp->size != 0;hp++){
		if(p->s.size > BTOU(hp->size))
			continue;	/* Ascending order list, keep looking */
		if(p->s.size < BTOU(hp->size))
			break;		/* Not a cached size */
		if(hp->cnt >= hp->target)
			break;	/* Right size, but cache already full */

		/* Put back on cache list */
		p->s.ptr = hp->list;
		hp->list = p;
		hp->cnt++;
		Chits++;
		restore(i_state);
		return;
	}
	if(!i_state){
		/* Interrupts were off, put on garbage queue for later */
		p->s.ptr = Garbq;
		Garbq = p;
		return;	/* Interrupts were already off */
	}
	/* Re-enable interrupts and call regular heap free */
	restore(i_state);
	/* Search the free list looking for the right place to insert */
d274 4
d286 4
d297 1
d311 1
d316 1
d320 1
a401 1
	struct heapcache *hp;
a417 8
	printf("Cache refills %lu hits %lu (%lu%%) int level fails %lu\n",
		Refills,Chits,Chits*100/(Allocs+Frees),Ifails);
	printf("Cache low water marks:");
	for(hp=Heapcache;hp->size !=0;hp++){
		printf(" (%u,%u)",hp->size,hp->lowwat);
		hp->lowwat = hp->cnt;
	}
	printf("\n");
d433 5
a437 1

d439 15
d455 1
a499 36
/* Function called periodically to take out the garbage and replenish
 * the allocator cache
 */
void
refiq()
{
	union header HUGE *p;
	void *ptr;
	struct heapcache *hp;
	int i_state;

	while(Garbq != NULLHDR){
		i_state = dirps();
		p = Garbq;
		Garbq = p->s.ptr;
		restore(i_state);
		p->s.ptr = p;	/* Re-establish audit pointer */
		free((void *)(p+1));
		Frees--;	/* Already decremented */
	}
	for(hp=Heapcache;hp->size != 0;hp++){
		while(hp->cnt < hp->target){
			if((ptr = dmalloc(hp->size)) == NULL)
				return;	/* Out of heap memory! */

			Refills++;
			p = ((union header HUGE *)ptr) - 1;
			/* Put on cache list */
			i_state = dirps();
			p->s.ptr = hp->list;
			hp->list = p;
			hp->cnt++;
			restore(i_state);
		}
	}
}
@


1.12
log
@enable realloc() (Borland's stat() routine calls it)
@
text
@a22 2
static unsigned long Intalloc;	/* Calls to malloc with ints disabled */
static unsigned long Intfree;	/* Calls to free with ints disabled */
d28 3
a35 2
static int doibufsize __ARGS((int argc,char *argv[],void *p));
static int donibufs __ARGS((int argc,char *argv[],void *p));
a40 2
	"ibufsize",	doibufsize,	0, 0, NULLCHAR,
	"nibufs",	donibufs,	0, 0, NULLCHAR,
d65 1
d68 1
d74 21
a107 2
	register HEADER HUGE *p, HUGE *q;
	register unsigned nu;
d109 4
a113 2
	if(!istate())
		Intalloc++;
d117 1
d122 55
d178 3
a180 1
	nu = ((nb + ABLKSIZE - 1) / ABLKSIZE) + 1;
d185 1
a206 2
			Allocs++;
			Availmem -= p->s.size;
d210 5
a214 1
		if(p == Allocp && ((p = morecore(nu)) == NULLHDR)){
d307 2
a309 2
	if(!istate())
		Intfree++;
d312 2
a313 1
	p = (HEADER HUGE *)blk - 1;
a315 4
		ptr = (unsigned short *)&blk;
		printf("free: WARNING! invalid pointer (0x%lx) proc %s\n",
		 ptol(blk),Curproc->name);
		stktrace();
d317 9
a325 2
		log(-1,"free: WARNING! invalid pointer (0x%lx) pc = 0x%x %x proc %s\n",
		 ptol(blk),ptr[-1],ptr[-2],Curproc->name);
d329 26
a379 1
	Frees++;
d481 1
d498 8
a507 1
	printf("interrupts-off calls to malloc %lu free %lu\n",Intalloc,Intfree);
a508 1
	iqstat();
d560 1
a560 1
donibufs(argc,argv,p)
d565 1
a565 9
	return setint(&Nibufs,"Interrupt pool buffers",argc,argv);
}
static int
doibufsize(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return setuns(&Ibufsize,"Interrupt buffer size",argc,argv);
d568 5
a572 5
static int
dothresh(argc,argv,p)
int argc;
char *argv[];
void *p;
d574 29
a602 1
	return setlong(&Memthresh,"Free memory threshold (bytes)",argc,argv);
@


1.11
log
@src0521
@
text
@a273 1
#ifdef	notdef	/* Not presently used */
d292 1
a292 1
#endif
@


1.10
log
@src0519
@
text
@d382 1
a382 1
			printf(" (%u,%u)",sp->seg,sp->seg+sp->npar);
@


1.9
log
@src0505
@
text
@d75 8
d157 7
a163 2
	register char HUGE *cp;
	register HEADER HUGE *up;
d166 51
a216 9
	if ((int)(cp = (char HUGE *)sbrk(nu * ABLKSIZE)) == -1)
		return NULLHDR;
	up = (HEADER *)cp;
	up->s.size = nu;
	up->s.ptr = up;	/* satisfy audit */
	free((void *)(up + 1));
	Heapsize += nu*ABLKSIZE;
	Frees--;	/* Nullify increment inside free() */
	return Allocp;
d336 7
a342 2
/* Return available memory on our heap plus available system memory */
unsigned long
d345 17
a361 1
	return Availmem * ABLKSIZE + coreleft();
d371 4
a374 1
	printf("heap size %lu avail %lu (%lu%%) morecores %lu coreleft %lu\n",
d376 10
a385 1
	 Morecores,coreleft());
d406 1
a406 1
	for(p = Base.s.ptr;p != &Base;p = p->s.ptr){
d484 11
a494 10
		if(availmem() < Memthresh){
			if(availmem() < Memthresh/2){
				red = 1;
				Reds++;
			} else {
				red = 0;
				Yellows++;
			}
			for(fp = Gcollect;*fp != NULL;fp++)
				(**fp)(red);
d496 2
@


1.8
log
@src0503
@
text
@d180 1
a180 1
		cprintf("free: WARNING! invalid pointer (0x%lx) proc %s\n",
@


1.7
log
@src0501
@
text
@d180 1
a180 1
		printf("free: WARNING! invalid pointer (0x%lx) proc %s\n",
d182 1
a182 1
/*		stktrace(); */
@


1.6
log
@s920423
@
text
@d295 1
a295 1
	tprintf("heap size %lu avail %lu (%lu%%) morecores %lu coreleft %lu\n",
d298 1
a298 1
	tprintf("allocs %lu frees %lu (diff %lu) alloc fails %lu invalid frees %lu\n",
d300 1
a300 1
	tprintf("pushdown calls %lu pushdown calls to malloc %lu\n",
d302 2
a303 2
	tprintf("interrupts-off calls to malloc %lu free %lu\n",Intalloc,Intfree);
	tprintf("garbage collections yellow %lu red %lu\n",Yellows,Reds);
d319 1
a319 1
		tprintf("%5lx %6lu",ptol((void *)p),p->s.size * ABLKSIZE);
d322 1
a322 1
			if(tprintf("\n") == EOF)
d325 1
a325 1
			tprintf(" | ");
d328 1
a328 1
		tprintf("\n");
d340 1
a340 1
		tprintf("N>=%5u:%7ld| N>=%5u:%7ld| N>=%5u:%7ld| N>=%5u:%7ld\n",
@


1.5
log
@src0415
@
text
@d182 1
a182 1
		stktrace();
@


1.4
log
@src0411
@
text
@d300 2
@


1.3
log
@src1216
@
text
@d180 3
a182 2
		printf("free: WARNING! invalid pointer (0x%lx) pc = 0x%x %x proc %s\n",ptol(blk),
		 ptr[-1],ptr[-2],Curproc->name);
d184 2
a185 2
		log(-1,"free: WARNING! invalid pointer (0x%lx) pc = 0x%x %x proc %s\n",ptol(blk),
		 ptr[-1],ptr[-2],Curproc->name);
@


1.2
log
@src0221
@
text
@a28 1
static int Garbstate;		/* 0 = normal, 1 = yellow, 2 = red */
a34 1
static int dogarbage __ARGS((int argc,char *argv[],void *p));
a41 1
	"garbage",	dogarbage,	0, 0, NULLCHAR,
a82 1
	void (**fp)();
a85 17
	/* If memory is low, collect some garbage. If memory is VERY
	 * low, invoke the garbage collection routines in "red" mode.
	 * The Garbstate == 0 check is to prevent infinite recursion
	 * when we're called again by the mbuf_crunch routine.
	 */
	if(availmem() < Memthresh && Garbstate == 0){
		if(availmem() < Memthresh/2){
			Garbstate = 2;
			Reds++;
		} else {
			Garbstate = 1;
			Yellows++;
		}
		for(fp = Gcollect;*fp != NULL;fp++)
			(**fp)(Garbstate == 2);
		Garbstate = 0;
	}
d378 6
a383 5
static int
dogarbage(argc,argv,p)
int argc;
char *argv[];
void *p;
d386 1
a386 1
	int red = 0;
d388 17
a404 11
	if(argc > 1)
		red = atoi(argv[1]);

	if(red)
		Reds++;
	else
		Yellows++;

	for(fp = Gcollect;*fp != NULL;fp++)
		(**fp)(red);
	return 0;
@


1.1
log
@Initial revision
@
text
@a85 1
	unsigned foo;
d111 2
a112 7
	foo = nb;
	for(i=0;i<16;i++){
		if(foo >= 32768)
			break;
		foo <<= 1;
	}
	Sizes[15-i]++;
@
