head	1.3;
access;
symbols;
locks;
comment	@ * @;


1.3
date	93.05.09.01.12.09;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	93.05.06.10.12.19;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	93.03.25.09.35.55;	author karn;	state Exp;
branches;
next	;


desc
@Initial version, thought to be working, not yet fully tested
@


1.3
log
@Fix worst-case estimate of encoded packet length
@
text
@/* Asynchronous HDLC routines */
#include "ahdlc.h"
#include "crc.h"

static char *putbyte(char *,char);

void
init_hdlc(hp,maxsize)
struct ahdlc *hp;
int maxsize;
{
	hp->escaped = 0;
	hp->hunt = 0;
	hp->inframe = NULLBUF;
	hp->maxsize = maxsize;
	hp->fcs = FCS_START;
	hp->rxframes = 0;
	hp->aborts = 0;
	hp->toobigs = 0;
	hp->crcerrs = 0;
}

/* Process incoming data. Return completed packets, NULLBUF otherwise */
struct mbuf *
ahdlcrx(ap,buf,len)
struct ahdlc *ap;	/* HDLC Receiver control block */
char *buf;		/* Raw incoming data */
int len;
{
	int c;
	struct mbuf *bp;

	while(len-- != 0){
		c = *buf++;
		if(c == HDLC_ESC_ASYNC){
			ap->escaped = 1;
		} else if(c != HDLC_FLAG){
			if(ap->hunt)
				continue;	/* Ignore until next flag */
			/* Normal character within packet */
			if(ap->escaped){
				c ^= HDLC_ESC_COMPL;
				ap->escaped = 0;
			}
			if(ap->inframe == NULLBUF)
				ap->inframe = ambufw(ap->maxsize);
			if(ap->inframe->cnt == ap->maxsize){
				/* Frame too large */
				ap->toobigs++;
				free_p(ap->inframe);
				ap->inframe = NULLBUF;
				ap->escaped = 0;
				ap->fcs = FCS_START;
				ap->hunt = 1;
			} else {
				/* Store character, update FCS */
				ap->inframe->data[ap->inframe->cnt++] = c;
				ap->fcs = FCS(ap->fcs,c);
			}
		} else if(ap->escaped){
			/* ESC, FLAG is frame abort */
			ap->aborts++;
			ap->hunt = 1;
			ap->escaped = 0;
			free_p(ap->inframe);
			ap->inframe = NULLBUF;
			ap->fcs = FCS_START;
		} else if(ap->hunt){
			/* Found flag in hunt mode. Reset for new frame */
			ap->hunt = 0;
		} else if(ap->inframe == NULLBUF){
			/* Padding flags, ignore */
		} else if(ap->fcs != FCS_FINAL){
			/* CRC error */
			ap->crcerrs++;
			free_p(ap->inframe);
			ap->inframe = NULLBUF;
			ap->fcs = FCS_START;
		} else if(ap->inframe->cnt < 2){
			/* Runt frame */
			ap->runts++;
			free_p(ap->inframe);
			ap->inframe = NULLBUF;
			ap->fcs = FCS_START;
		} else {
			/* Normal end-of-frame */
			ap->rxframes++;
			bp = ap->inframe;
			ap->inframe = NULLBUF;
			ap->fcs = FCS_START;
			bp->cnt -= 2;
			return bp;
		}
	}
	return NULLBUF;
}
/* Encode a packet in asynchronous HDLC for transmission */
struct mbuf *
ahdlctx(bp)
struct mbuf *bp;
{
	struct mbuf *obp;
	char *cp;
	int c;
	uint16 fcs;

	fcs = FCS_START;
	obp = ambufw(5+2*len_p(bp));	/* Allocate worst-case */
	cp = obp->data;
	while((c = PULLCHAR(&bp)) != -1){
		fcs = FCS(fcs,c);
		cp = putbyte(cp,c);
	}
	free_p(bp);	/* Shouldn't be necessary */
	fcs ^= 0xffff;
	cp = putbyte(cp,fcs);
	cp = putbyte(cp,fcs >> 8);
	*cp++ = HDLC_FLAG;

	obp->cnt = cp - obp->data;
	return obp;
}
static char *
putbyte(cp,c)
char *cp;
char c;
{
	switch(c){
	case HDLC_FLAG:
	case HDLC_ESC_ASYNC:
		*cp++ = HDLC_ESC_ASYNC;
		*cp++ = c ^ HDLC_ESC_COMPL;
		break;
	default:
		*cp++ = c;
	}
	return cp;
}
@


1.2
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@d108 1
a108 1
	obp = ambufw(3+2*len_p(bp));	/* Allocate worst-case */
@


1.1
log
@Initial revision
@
text
@d5 1
a5 1
static char *putbyte __ARGS((char *,char));
a31 1
	int plen;
d105 1
a105 1
	int16 fcs;
@
