;
; PackeTwin 8530 interrupt handler routine
;
;%   .MODEL  MEMMOD,C
include asmgloba.h        
	LOCALS
	%MACS
	.LALL

    extrn   Stktop,Spsave,Sssave,tsync_entpt:proc,eoi:proc,doret:proc

	.DATA

	.CODE
dbase   dw      @Data           ; save loc for ds (must be in code segment)
	
	public  twinvec;

	label   twinvec far
;       cli
	push    ds              ; save on user stack
	mov     ds,cs:dbase     ; establish interrupt data segment

	mov     Sssave,ss       ; stash user stack context
	mov     Spsave,sp

	mov     ss,cs:dbase
	lea     sp,Stktop

    ; push    ax              ; save user regs on interrupt stack
    ; push    bx
    ; push    cx
    ; push    dx
    ; push    bp
    ; push    si
    ; push    di
    PUSHALL
	push    es
	call    eoi
	mov     ax,0            ; arg for service routine
	push    ax
	call    tsync_entpt
	pop     ax
;       sti
    jmp     doret

; Write an 8530 register. Called from C as
; Twin_write_scc(int ctl,char reg,char val);
	public  Twin_write_scc
Twin_write_scc  proc
	arg     ctl:word,reg:byte,val:byte
	pushf
	mov     dx,ctl
	mov     al,reg
	cmp     al,0
	jz      @@doit          ; no need to set register 0

;       cli                     ;9/22/91 DGL... don't do this... APPLICATIONS code MUST
;                               ;                               make sure they have ints disabled before
;                               ;                               calling us.

	out     dx,al   ; select the appropriate write register.

				;This code fixes a tiny race in the SCC Recovery Time Pal
				;on the Twin
	jmp @@doit      ;flush execution pipeline on 286/386    9/22/91 DGL
	nop                     ;NOP is NECCESSARY so the jmp actually does the pipeline!!!!!
@@doit: mov     al,val
	out     dx,al
	popf
	ret
Twin_write_scc  endp

; Read an 8530 register. Called from C as
; Twin_read_scc(int ctl,char reg);
	public  Twin_read_scc
Twin_read_scc   proc
	arg     ctl:word,reg:byte
	pushf
	mov     dx,ctl
	mov     al,reg
	cmp     al,0
	jz      @@doit  ; no need to set reg if R0

;       cli                     ;9/22/91 DGL... don't do this... APPLICATIONS code MUST
;                               ;                               make sure they have ints disabled before
;                               ;                               calling us.

	out     dx,al   ; select the appropriate write register.

				;This code fixes a tiny race in the SCC Recovery Time Pal
				;on the Twin
	jmp @@doit      ;flush execution pipeline on 286/386    9/22/91 DGL
	nop                     ;NOP is NECCESSARY so the jmp actually does the pipeline!!!!!
@@doit: in      al,dx
	mov     ah,0
	popf
	ret
Twin_read_scc   endp

	end


