  
/****************************************************************************
*
*            COPYRIGHT 1990,91,92 BY GRACILIS INC.
*
*              623 Palace St.
*            Aurora, Il. 60506
*
* GRACILIS, INC., MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS
* SOFTWARE FOR ANY PURPOSE.
*
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
*
* Permission is granted for non-commercial distribution only.
*
******************************************************************************/
  
  
  
/********************************************************************
*                        TWIN.H                                     *
*                                                                   *
* File: twin.h                                                      *
* Rev : 3.0                                                         *
*                                                                   *
*********************************************************************
*
*
* DESCRIPTION:
* -----------
* This section defines PackeTwin card's hardware interface regs etc.
*
*
*
*****************************************************************/
#ifndef _TWIN_H
#define _TWIN_H
  
#define    PKTWIN_IO_BASE    0x230        /* default base address */
  
#define SCCB_CMD    0x00
#define SCCB_DATA   0x01
#define SCCA_CMD    0x02
#define SCCA_DATA   0x03
#define TMR_CNT0    0x04
#define TMR_CNT1    0x05
#define TMR_CNT2    0x06
#define TMR_CTRL    0x07
  
/* READ ONLY REGS */
#define INT_REG        0x08
#define CLR_TMR1       0x09
#define CLR_TMR2       0x0a
#define SPARE_1        0x0b
  
/* WRITE ONLY REGS */
#define    DMA_CFG        0x08
#define    SERIAL_CFG     0x09
#define    INT_CFG        0x09    /* port shared with serial config */
#define    DMA_CLR_FF     0x0a
#define    SPARE_2        0x0b
  
  
/* INT_REG mask values for pending ints */
#define PKTWIN_SCC_MSK  0x01
#define PKTWIN_TMR1_MSK 0x02
#define PKTWIN_TMR2_MSK 0x04
  
  
/* SERIAL_CFG /  INT_CFG values */
#define PKTWIN_DTRA_ON    0x01
#define PKTWIN_DTRB_ON    0x02
#define PKTWIN_EXTCLKA    0x04
#define PKTWIN_EXTCLKB    0x08
#define PKTWIN_LOOPA_ON   0x10
#define PKTWIN_LOOPB_ON   0x20
#define PKTWIN_EI         0x80
  
  
/*=======================================================================
DMA_CFG reg bit definitions
  
    7       6       5       4       3       2       1       0
   Aux1    Aux0     X     DMA3     DMA1    Sel1   Sel0    HDX/FDX
                         Enable   Enable
  
Aux1,Aux0       configuration bits for DE Modems.
  
  
DMA3 Enable     0 = DMA channel 3 disabled
                1 = Enabled
  
DMA1 Enable     0 = DMA channel 1 disabled
                1 = Enabled
  
  
               DMA3    DMA1    Sel1    Sel0  HDX/FDX
Tx Chan 1 HDX   0       1       0       0       0
Rx Chan 1 HDX   0       1       0       1       0
Tx Chan 3 HDX   1       0       1       0       0
Rx Chan 3 HDX   1       0       1       1       0
ILLEGAL!!!      X       X       0       0       1
Rx1 Tx3 FDX     1       1       0       1       1
Rx3 Tx1 FDX     1       1       1       0       1
ILLEGAL!!!      X       X       1       1       1
  
=======================================================================*/
  
/* DMA_CFG values */
/* Half Duplex settings for channels */
#define PKTWIN_DMA_HDX_T1    0x08    /* Tx on channel 1 */
#define PKTWIN_DMA_HDX_R1    0x0a    /* Rx on channel 1 */
#define PKTWIN_DMA_HDX_T3    0x14    /* Tx on channel 3 */
#define PKTWIN_DMA_HDX_R3    0x16    /* Rx on channel 3 */
/* Full Duplex settings... */
#define PKTWIN_DMA_FDX_T3R1    0x01b    /* Tx on channel 3, Rx on channel 1 */
#define PKTWIN_DMA_FDX_T1R3    0x01d    /* Tx on channel 1, Rx on channel 3 */
  
  
/* 8237 stuff */
#define BASE8237    0x00
  
#define DMA0ADR    BASE8237 + 0x00
#define DMA0CNT    BASE8237 + 0x01
#define DMA1ADR    BASE8237 + 0x02
#define DMA1CNT    BASE8237 + 0x03
#define DMA2ADR    BASE8237 + 0x04
#define DMA2CNT    BASE8237 + 0x05
#define DMA3ADR    BASE8237 + 0x06
#define DMA3CNT    BASE8237 + 0x07
#define DMACTRL    BASE8237 + 0x08
#define DMASTA     BASE8237 + 0x08
#define DMAWRRG    BASE8237 + 0x09
#define DMAWSMR    BASE8237 + 0x0a
#define DMAMODE    BASE8237 + 0x0b
#define DMAFFCL    BASE8237 + 0x0c
#define DMAMCLR    BASE8237 + 0x0d
#define DMATMPR    BASE8237 + 0x0d
#define DMACLRM    BASE8237 + 0x0e
#define DMAWAMR    BASE8237 + 0x0f
  
#define    RX_DMA    0x44        /* Write Xfers, Autoinitialization OFF, */
                                 /* increment addresses, single transfer mode */
#define    TX_DMA    0x48        /* Read Xfers, Autoinitialization OFF, */
                                 /* increment addresses, single transfer mode */
  
  
  
/*
* Description:
*
*   This section contains the data structures used by drivers.
*
*/
  
#define TSYNC_DEBUG  1      /* generate debugging trace of 8530 reg usage */
#undef  TSYNC_DEBUG_PRT     /* turn on runtime printf's */
  
  
#define TWINCOMM1       0   /*  Twin_udcb[0] is for PackeTwin port #1 */
#define TWINCOMM2       1   /*  Twin_udcb[1] is for PackeTwin port #2 */
  
  
/* Supported driver Types for the PackeTwin driver */
#define ASYNC_8530  1   /* its a 8530 SCC driver */
#define SYNC_8530   2
  
  
/*
 * 8530 SCC control and data registers' addresses
 */
  
typedef struct zscc_hw {
    int16   ctl;    /* address of Channel's control reg */
    int16   data;   /* address of Channel's data reg */
} HW_REGS_8530;
  
  
/*
 * SZ_DRIVER'S I/O Control Parameters
 */
struct tsync_ioctl {
    int16   xmitdelay;  /* Transmit delay 1 ms/count */
    int16   persist;    /* Persistance, as a percent from 0 to 255 */
    int16   slotime;    /* Delay to wait for persistance hit */
    int16   squelch;    /* Squelch delay */
    int16   rxavailbufs;    /* num of pre-allocated RX mbufs' to have */
    int16   cputype;    /* CPU type defaults to 8086 (0) */
                        /*                      80186(1) */
                        /*                      80286(2) */
                        /*                      80386(3) */
};
  
/* Driver Control Block */
typedef struct dcblock {
    char    txstate;    /* transmit state */
    char    rxstate;    /* receive state */
    char    dev;        /* device number, i.e. COMMA_8530,COMMB_8530 */
    char    extsts;     /* current mask value for WR15 */
    char    extreg;     /* current READ register value for RR15 */
    struct  drvbuf *xmtq;   /* xmit queue of packets this one is being */
                            /* transmitted!!! */
    struct  drvbuf *xmtqtail; /* tail ptr to xmit queue of packets */
    char    *cur_xbufp; /* address of current xmit packet */
    int16   cur_xbytes; /* num. bytes left to transmit */
    struct  drvbuf *freem;  /* queue of packets to free - from task level */
  
    struct mbuf_qhat rxqhat; /* FIFO Head And Tail control structure for */
                /*  received packets */
    struct  mbuf *rxbufp;   /* address of current receive buffer */
    int16   rxbufsize;  /* size of rxbufp */
    char    *rxcurp;    /* addr of spot in rxbufp where last received */
                /* char was put */
    struct mbuf *rxavailq;  /* queue of pre-allocated mbufs */
                /* used to get rid of alloc_mbuf */
                /* while in sz_rxisr */
    ulong   rxavailcount;   /* num. of mbufs in rxavailq */
    ulong   rxnqued;    /* packets received and sent up */
    ulong   rxpackcnt;  /* received packet count */
    ulong   rxbytecnt;  /* received chars count */
    ulong   txpackcnt;  /* transmitted packet count */
    ulong   txbytecnt;  /* transmitted chars count */
    ulong   txunderun;  /* transmitted underrun count */
    ulong   txctslost;  /* CTS went away during xmit */
    ulong   rxtruncnt;  /* receive packet exceeds rxbufp, truncated rx*/
    ulong   rxovercnt;  /* receiver overuns */
    ulong   rxabortcnt; /* receiver aborts */
    ulong   rxcrcerrcnt;    /* receiver CRC error count */
    ulong   nobufs;     /* no memory for pre-allocated */
                /* receive buffers */
    ulong   baud;       /* e.g. 300, 19200, 4000000 */
    bool    hduplex;    /* TRUE half-duplex, FALSE full-duplex */
    bool    dma_flg;    /* TRUE DMA used, FALSE int per char */
    uint    dma_rx_chan;
    uint    dma_rx_mode;    /* value to use in the DMA MODE reg for receive */
    uint    dma_rx_pagereg;
    uint    dma_rx_cnt_reg;
    uint    dma_rx_addr_reg;
    uint    dma_tx_chan;
    uint    dma_tx_mode;    /* value to use in the DMA MODE reg for transmit */
    uint    dma_tx_pagereg;
    uint    dma_tx_cnt_reg;
    uint    dma_tx_addr_reg;
    bool    txclk_extrn;    /* Tx clock source: (internal-external) */
    bool    rxclk_extrn;    /* Rx clock source: (internal-external) */
    bool    nrzi_flg;   /* NRZ/NRZI mode spec */
    struct tsync_ioctl  *ioctlparams;   /* address to driver specific params */
    HW_REGS_8530 zhwmap;    /* address of 8530 SCC control data structure */
    uchar   wr0;        /* WR0 current values... */
    uchar   wr1;        /* WR1 current values... */
    uchar   wr2;        /* WR2 current values... */
    uchar   wr3;        /* WR3 current values... */
    uchar   wr4;        /* WR4 current values... */
    uchar   wr5;        /* WR5 current values... */
    uchar   wr6;        /* WR6 current values... */
    uchar   wr7;        /* WR7 current values... */
    uchar   wr9;        /* WR9 current values... */
    uchar   wr10;       /* WR10 current values... */
    uchar   wr11;       /* WR11 current values... */
    uchar   wr12;       /* WR12 current values... */
    uchar   wr13;       /* WR13 current values... */
    uchar   wr14;       /* WR14 current values... */
    uchar   wr15;       /* WR15 current values... */
    int     maxtxbytes; /* Highest number of bytes loaded into */
                        /* the TX FIFO at one time */
    struct drv_timer *timer1; /* driver control block */
    struct iface *iface;     /* For NOS need iface's address */
    struct proc *rxavproc; /* addr of created process for sz_rxavget() */
    struct proc *txkickproc; /* addr of created process for sz_txkick() */
    struct proc *freetxproc; /* addr of created process for sz_freetx() */
} DCB;
  
/* Gracilis Universal driver control block */
/* UNI_DCB's are declared as an array; each entry is initialized */
/* by an "attach" routine.   */
  
typedef struct udcbblock {
    unsigned char   attached;   /* TRUE then type TenPackSwitch hw is */
                                /* attached, FALSE it is not attached */
                                /* MUST BE INITIALIZED TO FALSE */
    char    type;               /* ASYNC_8530, SYNC_8530, */
    void (*prev_vec1)(DCB *);   /* previous vectors, i.e. an address */
    void (*prev_vec2)(DCB *);   /* for the vector's ISR */
    void (*prev_vec3)(DCB *);   /* Allow for up to 4 vectors/channel */
    void (*prev_vec4)(DCB *);
    char *dcbp;                 /* address of driver specific control block */
  
} UNI_DCB;
  
/*
 *  DCB txstate values
 */
#define IDLE                0
#define DEFER               1
#define TX_ACTIVE           2
#define KEYED_UP            3
#define CRCING              4
#define TX_KEYUP_DELAY      5
#define TX_KEYDOWN_DELAY    6
#define TX_PERSIST          7
#define TX_DONE             8
  
  
  
/* Normal state is ACTIVE if Receive enabled */
#define RXNORM 0x55
#define RXERROR 2       /* Error -- Aborting current Frame */
#define RXABORT 3       /* ABORT sequence detected */
#define TOOBIG 4        /* too large a frame to store */
#define TXDELAY 0       /* Transmit Delay 10 ms/cnt */
#define PERSIST 1       /* Persistence (0-255) as a % */
#define SLOTIME 2       /* Delay to wait on persistence hit */
#define SQUELDELAY 3    /* Delay after XMTR OFF for squelch tail */
  
  
#define OFF 0
#define ON  1
  
/* 8530 clock/frequency  */
#define XTAL    ((long) 6144000L)     /* 8530's baud rate clock */
  
/* Special stuff in addition to the stuff in 8530.h */
  
/* Vector Masks for Interrupt vector as read from RR2 Channel B */
/* This are the masks if the part is programed for "status low" */
  
#define VEC_CHB_TBE     0x00
#define VEC_CHB_XTS     0x02
#define VEC_CHB_RCAV    0x04
#define VEC_CHB_SRC     0x06
#define VEC_CHA_TBE     0x08
#define VEC_CHA_XTS     0x0A
#define VEC_CHA_RCAV    0x0C
#define VEC_CHA_SRC     0x0E
  
  
/* image copies of i/o control regs */
extern uchar Twin_sercfg;
extern uchar Twin_dmacfg;
  
  
/* The pwait/psignal inter-process communication wake-up array */
/* for getting pre-allocated receive buffers */
  
extern int  Twin_bufpp[];
  
  
/* The pwait/psignal inter-process communication wake-up array */
/* for kicking the transmitter */
  
extern int  Twin_kickpp[];
  
/* The pwait/psignal inter-process communication wake-up array */
/* for free-ing transmitted messages */
  
extern int  Twin_freetxpp[];
  
void tsync_rxavget __ARGS((int,void *,void *));
void tsync_txkick __ARGS((int,void *,void *));
void tsync_freetx __ARGS((int,void *,void *));
  
unsigned char Twin_read_scc __ARGS((int,char));
void Twin_write_scc __ARGS((int,char,char));
int  tsync_hwinit __ARGS((DCB *));
void rxprime_dma __ARGS((DCB *));
void txprime_dma __ARGS((DCB *));
int  tsync_rxdmaisr __ARGS((DCB *));
  
#endif /* _TWIN_H */
