/***************************************************************

  BayCom(R)           Packet-Radio fuer IBM PC

  BayCom-Terminal


  -----------------------
  Terminal Video Routines
  -----------------------

  Copyright (C) 1999 Flori Radlherr, DL8MBT, flori@baycom.org
      
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ***************************************************************/

#include "bct.h"

// ************************************************************************
// * 179=  180=  181=  182=  183=  184=  185=  186=  187=  188= *
// * 189=  190=  191=  192=  193=  194=  195=  196=  197=  198= *
// * 199=  200=  201=  202=  203=  204=  205=  206=  207=  208= *
// * 209=  210=  211=  212=  213=  214=  215=  216=  217=  218= *
// ************************************************************************


char *fr[2]={"ڿ","ȼɻ"};

unsigned vseg=0xb800;
int art=0;
wndstruc wndarr[MAXWND];
int lastwnd=0;
int linlen=80;

void setlinlen(int len)
{ linlen=len;
}

int xpos(wind w)
{ return wndarr[w].curx;
}

int ypos(wind w)
{ return wndarr[w].cury;
}

void cset(wind w,int curx,int cury)
{ wndarr[w].curx=curx;
  wndarr[w].cury=cury;
}

void wc(int x,int y,int attr,char c)
{ poke(vseg,(x<<1)+(2*linlen)*y,c|attr);
}

void ws(int x,int y,int attr,char *s)
{ while(*s)
    poke(vseg,((x++)<<1)+(2*linlen)*y,*(s++)|attr);
}

void wf(int x,int y,int attr,char *format,...)
{ va_list argpoint;
  char cbuf[80];
  va_start(argpoint,format);
  vsprintf(cbuf,format,argpoint);
  va_end(argpoint);
  ws(x,y,attr,cbuf);
}

void wstr(wind w,int line,int col,char *s)
{ int x=wndarr[w].x+1;
  int xmax=wndarr[w].xlen+wndarr[w].x;

  line+=wndarr[w].y+1;
  wc(x++,line,col,' ');
  while(*s)
    wc(x++,line,col,*(s++));
  while(x<xmax)
    wc(x++,line,col,' ');
}


void whelp(wind w,int line,int col,int hcol,char *s)
{ int x=wndarr[w].x+1;
  int xmax=wndarr[w].xlen+wndarr[w].x;
  int fa=col;

  line+=wndarr[w].y+1;
  wc(x++,line,col,' ');
  while(*s && (x<xmax))
  { if(*s=='^')
    { if(fa==col)
        fa=hcol;
      else
        fa=col;
      s++;
    }
    else
      wc(x++,line,fa,*(s++));
  }

  while(x<xmax)
    wc(x++,line,col,' ');
}

video rc(wind w,int x,int y)
{ x+=wndarr[w].x;
  y+=wndarr[w].y;

  return peek(vseg,(x<<1)+(2*linlen)*y);
}

void sc(wind w,int x,int y,video ch)
{ x+=wndarr[w].x;
  y+=wndarr[w].y;

  poke(vseg,(x<<1)+(2*linlen)*y,ch);
}

int lookfor(wind w,int hcol)
{ int xx=wndarr[w].curx,yy=wndarr[w].cury;

  while((rc(w,xx,yy)&0xff00)==hcol) xx++;

  for(;yy<wndarr[w].ylen;yy++)
  { for(;xx<wndarr[w].xlen;xx++)
    { if((rc(w,xx,yy)&0xff00)==hcol)
      { while((rc(w,xx-1,yy)&0xff00)==hcol) xx--;
	wndarr[w].curx=xx;
	wndarr[w].cury=yy;
	return 1;
      }
    }
    xx=0;
  }
  return 0;
}

int lookback(wind w,int hcol)
{ int xx=wndarr[w].curx,yy=wndarr[w].cury;

  while((rc(w,xx,yy)&0xff00)==hcol) xx--;

  for(;yy>=0;yy--)
  { for(;xx>=0;xx--)
    { if((rc(w,xx,yy)&0xff00)==hcol)
      { while((rc(w,xx-1,yy)&0xff00)==hcol) xx--;
	wndarr[w].curx=xx;
	wndarr[w].cury=yy;
	return 1;
      }
    }
    xx=wndarr[w].xlen;
  }
  return 0;
}

int lookdown(wind w,int hcol)
{ int xr=wndarr[w].curx+2,yy=wndarr[w].cury;
  int i,xx,xl=xr+1;

  if(yy<wndarr[w].ylen)
    yy++;
  else
    return 0;

  for(i=0;i<wndarr[w].xlen;i++)
  { if(((i&1)||(xl<1))&&(xr<wndarr[w].xlen))
    { xr++;
      xx=xr;
    }
    else if(xl)
    { xl--;
      xx=xl;
    }
    for(;yy<wndarr[w].ylen;yy++)
    { if((rc(w,xx,yy)&0xff00)==hcol)
      { while((rc(w,xx-1,yy)&0xff00)==hcol) xx--;
        wndarr[w].curx=xx;
        wndarr[w].cury=yy;
        return 1;
      }
    }
    yy=wndarr[w].cury+1;
  }
  return 0;
}

int lookup(wind w,int hcol)
{ int xr=wndarr[w].curx+2,yy=wndarr[w].cury;
  int i,xx,xl=xr+1;

  if(yy>0)
    yy--;
  else
    return 0;

  for(i=0;i<wndarr[w].xlen;i++)
  { if(((i&1)||(xl<1))&&(xr<wndarr[w].xlen))
    { xr++;
      xx=xr;
    }
    else if(xl)
    { xl--;
      xx=xl;
    }
    for(;yy>=0;yy--)
    { if((rc(w,xx,yy)&0xff00)==hcol)
      { while((rc(w,xx-1,yy)&0xff00)==hcol) xx--;
        wndarr[w].curx=xx;
	wndarr[w].cury=yy;
        return 1;
      }
    }
    yy=wndarr[w].cury-1;
  }
  return 0;
}

void selectset(wind w,int hcol,int scol)
{ int ch;
  int x=wndarr[w].curx;

  while(((ch=rc(w,x,wndarr[w].cury))&0xff00)==hcol)
  { ch&=0xff;
    sc(w,x,wndarr[w].cury,ch|scol);
    x++;
  }
}

void selectbefehl(wind w,int hcol,char *befehl)
{ int ch;
  int i=0;
  int x=wndarr[w].curx;

  while((((ch=rc(w,x,wndarr[w].cury))&0xff00)==hcol)&&(i<10))
  { befehl[i++]=ch&0xff;
    befehl[i]=0;
    x++;
  }
}

void menuselect(wind w,int hcol,int scol,char *befehl)
{ int taste=0;

  if(!befehl[0])
  { wndarr[w].curx=wndarr[w].xlen;
    wndarr[w].cury=wndarr[w].ylen;
    lookback(w,hcol);
    lookback(w,hcol);
  }

  while((taste!=0x1c0d)&&(taste!=0x011b)&&(taste!=0x1265))
  { switch(taste)
    { case 0x4b00:     /* cursor links */
	lookback(w,hcol);
	break;
      case 0x4800:     /* cursor rauf  */
      { if(!lookup(w,hcol))
       /*   lookback(w,hcol)*/;
      } break;
      case 0x4d00:     /* cursor rechts */
	lookfor(w,hcol);
	break;
      case 0x5000:     /* cursor runter */
      { if(!lookdown(w,hcol))
	/*  lookfor(w,hcol)*/;
      } break;
      case 0x6800:     /* Alt-F1 */
      case 0x157a:     /* z */
      case 0x1970:     /* p */
      { strcpy(befehl,"#");
	return;
      }
      case 0x3b00:     /* F1 */
      case 0x2368:
      { strcpy(befehl,"HELP");
	return;
      }
      case 0x1769:     /* i */
      { strcpy(befehl,"INDEX");
	return;
      }
      case 0x4900:     /* page up */
      { strcpy(befehl,"-");
	return;
      }
      case 0x5100:     /* page down */
      { strcpy(befehl,"+");
	return;
      }
    }
    selectbefehl(w,hcol,befehl);
    selectset(w,hcol,scol);
    while(!kbhit())
    { mausein();
      if(mausknopf()||mausrechts())
      { unsigned xx=mausspalte()-wndarr[w].x;
	unsigned yy=mauszeile()-wndarr[w].y;
	mausaus();
	if((xx>wndarr[w].xlen)||(yy>wndarr[w].ylen))
	{ befehl[0]=0;
	  while(mausknopf()||mausrechts());
	  return;
	}
	if(yy==(wndarr[w].ylen))
	{ if(xx>61)
	    strcpy(befehl,"+");
	  else
	    strcpy(befehl,"-");
	  while(mausknopf()||mausrechts());
	  return;
	}
	selectset(w,scol,hcol);
	if((rc(w,xx,yy)&0xff00)==hcol)
	{ while((rc(w,xx-1,yy)&0xff00)==hcol) xx--;
	  wndarr[w].curx=xx;
	  wndarr[w].cury=yy;
	  selectbefehl(w,hcol,befehl);
	  while(mausknopf()||mausrechts());
	  return;
	}
	selectset(w,hcol,scol);
	mausein();
      }
    }
    mausaus();
    taste=bioskey(0);
    selectset(w,scol,hcol);
  }
  if(taste!=0x1c0d)
    befehl[0]=0;
}

void wframe(wind w,int col,char *headerln)
{ int i;
  char *f=fr[art];
  int x=wndarr[w].x;
  int y=wndarr[w].y;
  int xlen=wndarr[w].xlen;
  int ylen=wndarr[w].ylen;
  int xoff=x+(xlen-strlen(headerln))/2;

  wc(x,y,col,f[4]);
  wc(x+xlen,y,col,f[5]);
  wc(x,y+ylen,col,f[2]);
  wc(x+xlen,y+ylen,col,f[3]);
  for(i=x+1;i<(x+xlen);i++)
  { wc(i,y,col,f[1]);
    wc(i,y+ylen,col,f[1]);
  }
  for(i=y+1;i<(y+ylen);i++)
  { wc(x,i,col,f[0]);
    wc(x+xlen,i,col,f[0]);
  }
  wc(xoff-1,y,col,' ');
  ws(xoff,y,col,headerln);
  wc(xoff+strlen(headerln),y,col,' ');
}

void wclear(wind w,int col)
{ int i,j;
  int x=wndarr[w].x;
  int y=wndarr[w].y;
  int xlen=wndarr[w].xlen;
  int ylen=wndarr[w].ylen;

  for(j=y;j<=(y+ylen);j++)
  { for(i=x;i<=(x+xlen);i++)
      wc(i,j,col,' ');
  }
}

wind wopen(int x,int y,int xlen,int ylen,video *save)
{ int i,j,z=0;
  wndarr[lastwnd].x=x;
  wndarr[lastwnd].xlen=xlen;
  wndarr[lastwnd].y=y;
  wndarr[lastwnd].ylen=ylen;
  wndarr[lastwnd].save=NULL;
  if(save)
  { wndarr[lastwnd].save=save;
    for(i=x;i<(x+xlen+1);i++)
      for(j=y;j<(y+ylen+1);j++)
	save[z++]=peek(vseg,(i+linlen*j)<<1);
  }
  lastwnd++;
  return lastwnd-1;
}

void wclose(wind w)
{ video far *save;
  int i,j,z=0;
  if(wndarr[w].save)
  { int x=wndarr[w].x;
    int xlen=wndarr[w].xlen;
    int y=wndarr[w].y;
    int ylen=wndarr[w].ylen;
    save=wndarr[w].save;
    for(i=x;i<(x+xlen+1);i++)
      for(j=y;j<(y+ylen+1);j++)
	poke(vseg,(i+linlen*j)<<1,save[z++]);
  }
  if(lastwnd>w) lastwnd--;
}

