/***************************************************************

  BayCom(R)           Packet-Radio Terminal for DOS

  BayCom-Terminal

  
  ---------------------
  Terminal Main Program
  ---------------------

  
  Copyright (C) 1999 Flori Radlherr, DL8MBT, flori@baycom.org
      
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ***************************************************************/

#include "bct.h"


static char far *beftab[]=
{ "CHANNEL","MONITOR","TRACE","MYCALL",
  "BOXCALLS","CTEXT","QTEXT","RCMD",
  "CNOT","MODE",

  "LOG","REMOTE","GERMAN","COMMAND",
  "ECHO","KNAX","CBELL",
  "AUTOBIN","7PSAVE","COLOR","VGALINES",

  "TXDELAY","XMITOK",

  "CRTSAVE",
  NULL
};

static enum befnum
{ unsinn,
  channel,m,trace,my,
  boxcalls,ct,qt,rcmd,
  cnot,mode,

  xlog,xremote,xgerman,xcommand,
  xecho,xknax,xcbell,
  xautobin,x7psave,xcolor,xvgalines,
  txdelay,xmitok,

  dezwerte
}cmd=unsinn;

static char wasbuf[REMLEN];
static char far *outbuf;
static int index=0;
static int wasindex=0;
static int wasdisp=0;
static int was=0;

#if ENGLISCH
static char *ontxt  = "ON ";
static char *offtxt = "OFF";
#else
static char *ontxt  = "EIN";
static char *offtxt = "AUS";
#endif

int setuprun=0;

static void putvsetup(int x)
{ if(was)
  { wasbuf[wasindex]=x;
    wasbuf[wasindex+1]=0;
    if(wasindex<REMLEN-2) wasindex++;
    else wasbuf[REMLEN-2]=13;
  }
  else
  { outbuf[index]=x;
    outbuf[index+1]=0;
    if(index<(REMLEN*2)-2) index++;
    else outbuf[(REMLEN*2)-2]=13;
  }
}

void putvsetup1(int x)
{ static int column=0;
  if(x>1000)
  { while(column%(x-1000))
    { putvsetup(' ');
      column++;
    }
  }
  else
    putvsetup(x);

  if(x==13)
    column=0;
  else
    column++;
}
/*

static void putbt(char *sx)
{ char s[80];
  int sl;
  strcpy(s,sx);
  sl=strlen(s)-1;
  if(s[sl]==13) s[sl]=0;
  putvs(s);
}

static void callinput(char *call,char *befbuf)
{ putcall(call,0);
  readcall(befbuf,call);
  was=0;
  putcall(call,0);
}

static void clistinput(char *clist,char *befbuf)
{ putclist(clist);
  readclist(befbuf,clist,8);
  was=0;
  putclist(clist);
}
*/
static void putctchar(char c)
{ if(c)
    putv(c);
  else
#if ENGLISCH
    putvs("OFF");
#else
    putvs("AUS");
#endif
}

/*
static unsigned far *l1par(int kanal,befnum cmd)
{ switch(cmd)
  { case txdelay:      return &l1_mode[kanal].txdelay;
    case txtail:       return &l1_mode[kanal].txtail;
    case dwait:        return &l1_mode[kanal].dwait;
    case btime:        return &l1_mode[kanal].btime;
    case tchannel:     return &l1_mode[kanal].tchannel;
    case maxframe:     return &l1_mode[kanal].maxframe;
    case linkexclusiv: return &l1_mode[kanal].linkexcl;
    case xmitok:       return &l1_mode[kanal].xmitok;
  }
  return &l1_mode[0].txdelay;
}
*/

void setup(char *xbuf,int befgleich)
{ static char bf[100];

  char *befbuf=bf;
  int i,j;
  /*int channels=get_channels();*/

  static unsigned *vartab[45];
  int x=0;

  setuprun=1;

  vartab[x++]=&wt->crtsave;

  outbuf=xbuf;
  for(i=0;i<80;i++)
  { befbuf[i]=xbuf[i];
  }

  befbuf+=blkill(befbuf);

  if(!(*befbuf)) return;     /* kein Kommando eingegeben */
  cmd=(befnum)readcmd(beftab,&befbuf,1);
  if(cmd==unsinn)
  { *outbuf=0;
    return;
  }

  strcpy(outbuf,beftab[cmd-1]);
  strcat(outbuf," ");
  index=strlen(outbuf);

  wasbuf[0]=wasindex=0;
  was=1;
  wasdisp=(*befbuf);

  switch(cmd)
  {
    case mode:
    { char *s;
      for(i=0;i<16;i++)
      { s=get_l1_mode(i);
        if(s[0])
        { if(i) putvs(", ");
          putf("%u %s",i,s);
        }
      }
      while(befbuf[0])
      { int kanal=nextdez(&befbuf);
        s=strchr(befbuf,',');
        if(s) s[0]=0;
        set_l1_mode(kanal,befbuf);
        mode_changed=1;
        while(befbuf[0]>' ') befbuf++;
        if(s) befbuf=s+1;
        befbuf+=blkill(befbuf);
      }
      was=0;
      for(i=0;i<16;i++)
      { s=get_l1_mode(i);
        if(s[0])
        { if(i) putvs(", ");
          putf("%u %s",i,s);
        }
      }
      /*
      for(i=0;i<channels;i++)
      { putf("%u %u",i,l1_mode[i].hbaud);
        if(l1_mode[i].t) putv('t');
        if(l1_mode[i].r) putv('r');
        if(l1_mode[i].z) putv('z');
        if(l1_mode[i].d) putv('d');
        if(l1_mode[i].c) putv('c');
        if(i<channels-1)
          putvs(", ");
      }
      while(befbuf[0])
      { int kanal=nextdez(&befbuf);
        l1_mode_t *m=&l1_mode[kanal];

        m->t=m->r=m->z=m->d=m->c=0;
        m->hbaud=nextdez(&befbuf);
        while(befbuf[0])
        { switch(toupper(befbuf[0]))
          { case 'T': m->t=1; break;
            case 'R': m->r=1; break;
            case 'Z': m->z=1; break;
            case 'D': m->d=1; break;
            case 'C': m->c=1; break;
          }
          if(befbuf[0]==' ' || befbuf[0]==',') break;
          befbuf++;
        }
        befbuf+=blkill(befbuf);
      }
      was=0;
      for(i=0;i<channels;i++)
      { putf("%u %u",i,l1_mode[i].hbaud);
        if(l1_mode[i].t) putv('t');
        if(l1_mode[i].r) putv('r');
        if(l1_mode[i].z) putv('z');
        if(l1_mode[i].d) putv('d');
        if(l1_mode[i].c) putv('c');
        if(i<channels-1)
          putvs(", ");
      }
      */
    } break;

    case m:
    case trace:
    { putf(get_monitor());
      was=0;
      if(befbuf[0])
      {
        strupr(befbuf);
        befbuf[20]=0;
        set_monitor(befbuf);
      }
      putf(get_monitor());

    /*
      long unsigned mm=l2_val->monitor;
      for(i=0;i<KANAELE;i++)
      { if(mm&1) putf("%d ",i);
	mm>>=1;
      }
      mm=was=0;
      while(*befbuf)
      { mm|=1<<(nextdez(&befbuf));
	l2_val->monitor=mm;
      }
      mm=l2_val->monitor;
      for(i=0;i<KANAELE;i++)
      { if(mm&1) putf("%d ",i);
	mm>>=1;
      }
    */
    } break;

    /*
    case dc:
      callinput(l2_val->dcall,befbuf);
      break;

    case mcalls:
      clistinput(l2_val->mcalls,befbuf);
      break;

    case cnot:
      clistinput(l2_val->cnot,befbuf);
      break;
    */

    case my:
      for(i=0;i<4;i++)
        putf("%s ",wt->mycall[i]);
      strupr(befbuf);
      sscanf(befbuf,"%s %s %s %s",
             wt->mycall[0],wt->mycall[1],wt->mycall[2],wt->mycall[3]);
      was=0;
      for(i=0;i<4;i++)
        putf("%s ",wt->mycall[i]);

      /*clistinput(l2_val->mycall,befbuf);*/
      break;

    /*
    case l2ct:
    { putbt(l2_val->l2ctext);
      was=0;
      sprintf(l2_val->l2ctext,"%0.79s\r",befbuf);
      putbt(l2_val->l2ctext);
    } break;
    */

    case qt:
    { putctchar(wt->qtext);
      was=0;
      if(*befbuf)
      { if(strlen(befbuf)==1)
	  wt->qtext=toupper(befbuf[0]);
	else
	  wt->qtext=0;
      }
      putctchar(wt->qtext);
    } break;

    case ct:
    { putctchar(wt->ctext);
      was=0;
      if(*befbuf)
      { if(strlen(befbuf)==1)
	  wt->ctext=toupper(befbuf[0]);
	else
	  wt->ctext=0;
      }
      putctchar(wt->ctext);
    } break;

    case rcmd:
    { putvs(wt->rcmdstring+1);
      was=0;
      strupr(befbuf);
      if(*befbuf) strcpy(wt->rcmdstring+1,befbuf);
      putvs(wt->rcmdstring+1);
    } break;

    /*
    case bt:
    { if(*befbuf)
      { if(channels>1)
	{ i=nextdez(&befbuf);
	  if(*befbuf)
	  { putf("%d ",i);
	    putbt(l1_mode[i].btext);
	  }
	}
	else
	{ if(*befbuf)
	    putbt(l1_mode[0].btext);
	  i=0;
	}
	was=0;
        sprintf(l1_mode[i].btext,"\xf0%0.77s\r",befbuf);
	if(channels>1) putf("%d ",i);
	putbt(l1_mode[i].btext);
      }
      else
      { index=was=0;
	for(i=0;i<channels;i++)
	{ if(i>0)
	    putf("\r:");
	  if(channels>1)
	    putf("BTEXT %d ",i);
	  else
	    putf("BTEXT ");
	  putbt(l1_mode[i].btext);
	}
      }
    } break;


    case ba:
    { if(*befbuf)
      { if(channels>1)
	{ i=*befbuf&15;
	  befbuf++;
	  befbuf+=blkill(befbuf);
	  if(*befbuf)
	  { putf("%d ",i);
	    putclist(l1_mode[i].badress);
	  }
	}
	else
	{ i=0;
	  if(*befbuf)
	    putclist(l1_mode[0].badress);
	}
	was=0;
	readclist(befbuf,l1_mode[i].badress,8);
	if(channels>1)
	  putf("%d ",i);
	putclist(l1_mode[i].badress);
      }
      else
      { index=was=0;
	for(i=0;i<channels;i++)
	{
	  if(i>0) putf("\r:");
	  if(channels>1)
	    putf("BADRESS %d ",i);
	  else
	    putf("BADRESS ");
	  putclist(l1_mode[i].badress);
	}
      }
    } break;
    */

    /*
    case btime:
    */
    case txdelay:
    { int c=0;
      for(i=0;i<16;i++)
      { int txd=get_l1_txdelay(i);
        if(txd)
        { if(c) putvs(", ");
          putf("%u %u",i,txd);
          c=1;
        }
      }
      while(*befbuf)
      { i=nextdez(&befbuf);
	j=nextdez(&befbuf);
	if(i<0) break;

	if(j<0)
	  putvs("\rSyntax 'TXDELAY <channel> <value>'");
	else
	{ if(j<0)
          { j=i;
            i=0;
          }
	  set_l1_txdelay(i,j);
          mode_changed=1;
	}
      }
      c=was=0;
      for(i=0;i<16;i++)
      { int txd=get_l1_txdelay(i);
        if(txd)
        { if(c) putvs(", ");
          putf("%u %u",i,txd);
          c=1;
        }
      }
    } break;

    case xmitok:
    { int c=0;
      for(i=0;i<16;i++)
      { int txd=get_l1_xmitok(i);
        if(txd>=0)
        { if(c) putvs(", ");
          putf("%u %u",i,txd);
          c=1;
        }
      }
      while(*befbuf)
      { i=nextdez(&befbuf);
	j=nextdez(&befbuf);
	if(i<0) break;

	if(j<0)
	  putvs("\rSyntax 'XMITOK <channel> <value>'");
	else
	{ if(j<0)
          { j=i;
            i=0;
          }
	  set_l1_xmitok(i,j);
	}
      }
      c=was=0;
      for(i=0;i<16;i++)
      { int txd=get_l1_xmitok(i);
        if(txd>=0)
        { if(c) putvs(", ");
          putf("%u %u",i,txd);
          c=1;
        }
      }
    } break;

    /*
    case channel:
    { putf("%d",l2_val->trx_channel);
      was=0;

      if(befbuf[0])
	l2_val->trx_channel=!!(befbuf[0]&1);
      putf("%d",l2_val->trx_channel);
    } break;
    */

    default:
    { if(cmd>=dezwerte)
      { putf("%d",*vartab[cmd-dezwerte]);
	sscanf(befbuf,"%d",vartab[cmd-dezwerte]);
	was=0;
	putf("%d",*vartab[cmd-dezwerte]);
      }
      else if(cmd>=xlog)
      { unsigned *var;
	switch(cmd)
	{ case xlog:      var=&wt->logfileon; break;
	  case xremote:   var=&wt->remoteon;  break;
	  case xgerman:   var=&wt->germanon;  break;
	  case xcommand:  var=&wt->command;   break;
	  case xecho:     var=&wt->echo;      break;
	  case xknax:     var=&wt->knax;      break;
	  case xcbell:    var=&wt->cbell;     break;
	  case xautobin:  var=&wt->autobin;   break;
          case x7psave:   var=&wt->p7psave;   break;
          case xcolor:    var=&wt->colordisp; break;
          case xvgalines: var=&wt->vgalines;  break;
          default:        var=NULL;
	}
        if(var)
	{ if(*var>1) putf("%d",*var);
	  else if(*var) putvs(ontxt);
	  else putvs(offtxt);
	  was=0;
	  if(*befbuf)
	  { strupr(befbuf);
	    if((befbuf[0]=='A')||(befbuf[0]=='N')||(befbuf[1]=='F'))
	      *var=0;
	    else
	      *var=1;
	  }
	  if(*var>1) putf("%d",*var);
	  else if(*var) putvs(ontxt);
	  else putvs(offtxt);
        }
      }
    }
  }
  putv(13);
  was=0;
  if(*wasbuf && wasdisp)
  {
#if ENGLISCH
    putf(">>> was %s\r",wasbuf);
#else
    putf(">>> war %s\r",wasbuf);
#endif
  }
}

