/***************************************************************

  BayCom(R)           Packet-Radio fuer IBM PC

  BayCom-Terminal

  
  --------------------------------------------
  Auswertung/Erzeugung des Konfigurationsfiles
  --------------------------------------------

  Copyright (C) 1999 Flori Radlherr, DL8MBT, flori@baycom.org
      
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ***************************************************************/

#include "bct.h"

int mode_changed=0;

static char *beftab[]=
  { "MYCALL","MODE","TXDELAY","TRACE","MONITOR",
    "VGALINES","COLOR","D1LINES","D2LINES","CRTSAVE",
    "SA_COLOR","SA_MONO",
    "REMOTE","RCMD","BOXCALLS",
    "KNAX","CBELL","ECHO","CTEXT","QTEXT",
    "WRITE",
    "AUTOBIN","7PSAVE","LOG","GERMAN","COMMAND",
    "ST","QSO","FILE","DEFAULTDIGI","LINK",
    NULL
  };

static enum befnum
  { unsinn,
    mycall_,mode,txdelay,trace,monitor,
    vgalines,color,d1lines,d2lines,crtsave,
    sa_color,sa_mono,
    remote,rcmd,boxcalls,
    knax,cbell,echo,ctext,qtext,
    write_,
    autobin,p7psave,log,german,command,
    st_,qso,file_,defaultdigi,link
  }cmd=unsinn;


//Deti 04/96
static int lockhd;

/*---------------------------------------------------------------------------*/

int onoff(char *s)
{
  strupr(s);
  if(s[1]=='F')
    return 0;
  switch(s[0])
  { case 'O':
    case 'E':
    case '1':
      return 1;
    case '2':
      return 2;
  }
  return 0;
}

/*---------------------------------------------------------------------------*/

//Deti 02/96
char *nextarg(char *prevarg)
{
  int i;
  for(i=0;prevarg[i];i++)
    if(prevarg[i]==32)
      break;

  prevarg+=i;

  if(prevarg[0]==0)
    return prevarg;

  for(i=0;prevarg[i];i++)
    if(prevarg[i]!=32)
      break;
	prevarg+=i;

  return prevarg;
}

/*---------------------------------------------------------------------------*/

//Deti 02/96
void setcolor(char *s,int color)
{ unsigned i,c;

  color&=1;

  for(i=0;i<maxcolor;i++)
    if(sscanf(s,"%x",&c)!=1)
      break;
    else
    {
      wt->attr[i+(maxcolor*color)]=c<<8;
      s=nextarg(s);
    }
}

/*---------------------------------------------------------------------------*/

int mbinitbef(char *befbuf,int inifile)
{
  int i,j,qsonum,lstate,filejob;
  char s[80];
  char myc[80];
  long pos,length;
  unsigned crc;

  befbuf+=blkill(befbuf);
  if((befbuf[0]==0) || (befbuf[0]==';') || (befbuf[0]=='['))
    return 1;
  cmd=(befnum)readcmd(beftab,&befbuf,0);
  if(befbuf[0]=='=') befbuf++;
  befbuf+=blkill(befbuf);

  if(befbuf[0])
  { switch(cmd)
    { case unsinn:
	return 0;

      case p7psave:
        wt->p7psave=onoff(befbuf);
        break;

      case autobin:
        wt->autobin=onoff(befbuf);
        break;

      case knax:
        wt->knax=onoff(befbuf);
        break;

      case cbell:
        wt->cbell=onoff(befbuf);
        break;

      case remote:
        wt->remoteon=onoff(befbuf);
        break;

      case color:
        wt->colordisp=onoff(befbuf);
        break;

      case vgalines:
        wt->vgalines=onoff(befbuf);
        break;

      case log:
        wt->logfileon=onoff(befbuf);
        break;

      case german:
        wt->germanon=onoff(befbuf);
        break;

      case command:
        wt->command=onoff(befbuf);
        break;

      case echo:
        wt->echo=atoi(befbuf);
        break;

      case d1lines:
        wt->txwinlen=atoi(befbuf);
        break;

      case d2lines:
        wt->divline=atoi(befbuf);
        break;

      case crtsave:
        wt->crtsave=atoi(befbuf);
        break;

      case mycall_:
        strupr(befbuf);
        sscanf(befbuf,"%s %s %s %s",
               wt->mycall[0],wt->mycall[1],wt->mycall[2],wt->mycall[3]);
        break;

      case ctext:
        if(strlen(befbuf)==1)
	  wt->ctext=toupper(befbuf[0]);
	else
	  wt->ctext=0;
        break;

      case qtext:
        if(strlen(befbuf)==1)
	  wt->qtext=toupper(befbuf[0]);
	else
	  wt->qtext=0;
        break;

      case st_:
        stinput(befbuf);
        break;

      case sa_color:
        setcolor(befbuf,1);
        break;

      case sa_mono:
        setcolor(befbuf,0);
        break;

      case rcmd:
        strupr(befbuf);
        wt->rcmdstring[0]=' ';
        strcpy(wt->rcmdstring+1,befbuf);
        break;

      case write_:
        if(sscanf(befbuf,"%d %s",&i,s)==2)
        { strupr(s);
          if(i>=0 && i<maxports)
          { set_context(i);
            if(strcmp(s,"OFF")==0)
              b->defaultfilename[0]=0;
            else
              strcpy(b->defaultfilename,s);
          }
          else return 0;
        }
        else return 0;
        break;

      case mode:
        if(!nol1par)
        { if(sscanf(befbuf,"%d %s",&i,s)==2)
          { if(i>=0 && i<=15)
              set_l1_mode(i,s);
            else return 0;
            mode_changed=1;
          }
          else return 0;
        }
        break;

      case txdelay:
        if(!nol1par)
        { if(sscanf(befbuf,"%d %d",&i,&j)==2)
          { if(i>=0 && i<=15)
              set_l1_txdelay(i,j);
            else return 0;
            mode_changed=1;
          }
          else return 0;
        }
        break;

      case trace:
      case monitor:
        set_monitor(befbuf);
        break;

      case defaultdigi:
        sscanf(befbuf,"%9s",wt->defdigi);
        strupr(wt->defdigi);
        break;

      case link:
        for(i=0;wt->linkcall[i][0];i++);
        sscanf(befbuf,"%9s %d",wt->linkcall[i],&wt->linkkanal[i]);
        strupr(wt->linkcall[i]);
        break;

      case qso:
        if(sscanf(befbuf,"%d %d %s %s %d",&i,&qsonum,s,myc,&lstate)==5)
        { set_context(i);
          set_qsonum(qsonum,lstate);
          set_partner(s);
        }
        break;

      case file_:
        if(sscanf(befbuf,"%d %d %s %ld %ld %u",
	          &i,&filejob,s,&pos,&length,&crc)>=5)
        { set_context(i);
          strcpy(b->filename,s);
          b->filejob=filejob;
          b->filepos=pos;
          b->filelen=length;
          b->crcword=crc;
        }
        else return 0;
        break;

    }
  }
  return 1;
}

/*---------------------------------------------------------------------------*/
  
char *on(int x)
{ if(x)
    return "ON";
  else
    return "OFF";
}

/*---------------------------------------------------------------------------*/

char *txt(int x)
{ static char ret[]=" ";
  ret[0]=x;
  if(x)
    return ret;
  else
    return "OFF";
}

/*---------------------------------------------------------------------------*/

int unlock(int handle)
{
  return close(handle);
}

/*---------------------------------------------------------------------------*/

//Deti 04/96
int lock(char *name)
{
  return sopen(name, O_RDONLY, SH_DENYRW, S_IREAD);
}

/*---------------------------------------------------------------------------*/

//Deti 04/96
int islocked(char *name)
{
  char filename[60];
  int hd;
  struct stat st;
  filepath(name,filename);
  if(stat(filename,&st)==-1)
    return 0;
  hd=sopen(filename, O_RDONLY, SH_DENYRW, S_IREAD);
  if(hd==-1)
    return 1;
  close(hd);
  return 0;
}

/*---------------------------------------------------------------------------*/

void savepar(void)
{ FILE *f;
  int i;
  char ch;
  char *s;
  int tx;
  char bakname[80];
  char tmpname[80];
  char initname[80];

  // do not write parameters without L2 interface attached
  if(get_version()[0]==0)
    return;

  strcpy(bakname,syspath(INITBAKNAME));
  strcpy(tmpname,syspath(INITTMPNAME));
  strcpy(initname,syspath(INITNAME));
  //Deti 04/96
  unlock(lockhd);
  f=fopen(tmpname,"wt");
  if(f)
  { fprintf(f,"; --- packet interface ---\n");
    fprintf(f,"mycall");
    for(i=0;wt->mycall[i][0];i++) fprintf(f," %s",wt->mycall[i]);
    fprintf(f,"\n");
    fprintf(f,"monitor %s\n",get_monitor());
    if(mode_changed)
    { for(i=0;i<16;i++)
      { s=get_l1_mode(i);
        if(s[0]) fprintf(f,"mode %d %s\n",i,s);
      }
      for(i=0;i<16;i++)
      { tx=get_l1_txdelay(i);
        if(tx) fprintf(f,"txdelay %d %u\n",i,tx);
      }
    }
    for(i=0;wt->linkcall[i][0];i++)
      fprintf(f,"link %s %d\n",wt->linkcall[i],wt->linkkanal[i]);
    if(wt->defdigi[0])
      fprintf(f,"defaultdigi %s\n",wt->defdigi);
    fprintf(f,"; --- screen outline ---\n");
    fprintf(f,"vgalines %s\n",on(wt->vgalines));
    fprintf(f,"color %s\n",on(wt->colordisp));
    fprintf(f,"d1lines %u\n",wt->txwinlen);
    fprintf(f,"d2lines %u\n",wt->divline);
    fprintf(f,"crtsave %u\n",wt->crtsave);
    fprintf(f,"sa_color");
    for(i=0;i<maxcolor;i++)
      fprintf(f," %02X",(unsigned char)(wt->attr[i+maxcolor]>>8));
    fprintf(f,"\nsa_mono ");
    for(i=0;i<maxcolor;i++)
      fprintf(f," %02X",(unsigned char)(wt->attr[i]>>8));
    fprintf(f,"\n; --- remote ---\n");
    fprintf(f,"remote %s\n",on(wt->remoteon));
    fprintf(f,"rcmd %s\n",wt->rcmdstring+1);
    fprintf(f,"boxcalls %s\n",wt->boxcalls);
    fprintf(f,"; --- signals ---\n");
    fprintf(f,"echo %u\n",wt->echo);
    fprintf(f,"knax %s\n",on(wt->knax));
    fprintf(f,"cbell %s\n",on(wt->cbell));
    fprintf(f,"ctext %s\n",txt(wt->ctext));
    fprintf(f,"qtext %s\n",txt(wt->qtext));
    fprintf(f,"; --- input behaviour ---\n");
    fprintf(f,"german %s\n",on(wt->germanon));
    fprintf(f,"command %s\n",on(wt->command));
    fprintf(f,"; --- file parameters ---\n");
    fprintf(f,"autobin %s\n",on(wt->autobin));
    fprintf(f,"7psave %s\n",on(wt->p7psave));
    fprintf(f,"log %s\n",on(wt->logfileon));
    fprintf(f,"; --- default save files ---\n");
    for(i=0;i<maxports;i++)
    { set_context(i);
      if(b->defaultfilename[0])
        fprintf(f,"write %d %s\n",i,b->defaultfilename);
      else
        fprintf(f,"write %d OFF\n",i);
    }
    set_tnc_context(b->port);

    fprintf(f,"; --- standard text ---");
    i=1;
    while((ch=st[i])!=0)
    { if(st[i-1]==13)
        fprintf(f,"\nst ");
      i++;
      if(ch!=13)
        fputc(ch,f);
    }
    fprintf(f,"\n; --- save qso context (do not edit!) ---\n");
    for(i=1;i<maxports;i++)
    { set_context(i);
      if(get_lstate()!=disconnected)
      { fprintf(f,"qso  %d %d %s %s %d\n",i,
                get_qsonum(),get_partner(),get_mycall(),get_lstate());
      }
    }
    for(i=0;i<maxports;i++)
    { set_context(i);
      if(b->filejob!=nofile && strcmp(b->defaultfilename,b->filename)!=0)
      { fprintf(f,"file %d %d %s %ld %ld %u\n",i,b->filejob,b->filename,
                b->filepos,b->filelen,b->crcword);
      }
    }
    if(fprintf(f,"; --- end ---\n")<0) goto fehler;;
    fclose(f);
    unlink(bakname);
    rename(initname,bakname);
    rename(tmpname,initname);
  }
  return;

  fehler:
    fclose(f);
}

/*---------------------------------------------------------------------------*/

void initparameter(void)
{ int i;

  unsigned attini[]=
  {
    a(LIGHTGRAY,BLACK),    /* txcolor     */       /* LCD */
    a(BLACK,LIGHTGRAY),    /* stat1normal */
    a(BLACK,WHITE),        /* stat1stop   */
    a(LIGHTGRAY,BLACK),    /* rxcolor     */
    a(BLACK,LIGHTGRAY),    /* stat2active */
    a(BLACK,LIGHTGRAY),    /* stat2idle   */
    a(WHITE,BLACK),        /* stat2on     */
    a(LIGHTGRAY,BLACK),    /* monheader   */
    a(WHITE,BLACK),        /* moninfo     */
    a(BLACK,LIGHTGRAY),    /* help        */
    a(LIGHTGRAY,BLACK),    /* help hilight*/
    a(BLACK,LIGHTGRAY),    /* help select */
    a(BLACK,LIGHTGRAY),    /* ctrlzeichen */

    a(GREEN,BLACK),        /* txcolor     */       /* Color */
    a(LIGHTGRAY,RED),      /* stat1normal */
    a(WHITE,RED+8),       /* stat1stop   */
    a(LIGHTGRAY,BLACK),    /* rxcolor     */
    a(LIGHTGRAY,RED),      /* stat2active */
    a(BLACK,RED),          /* stat2idle   */
    a(LIGHTGRAY,MAGENTA),  /* stat2on     */
    a(CYAN,BLACK),         /* monheader   */
    a(GREEN,BLACK),        /* moninfo     */
    a(LIGHTGRAY,BLUE),     /* help        */
    a(YELLOW,BLUE),        /* help hilight*/
    a(YELLOW,MAGENTA),     /* help select */
    a(RED,BLACK),          /* ctrlzeichen */
  };

  // default terminal parameters
  memset(wt,0,sizeof(term_para_t));
  wt->remoteon=1;
  wt->mouseon=1;
  wt->command=1;
  wt->vgalines=1;
  wt->termlines=25;
  wt->termcolumn=80;
  wt->txwinlen=5;
  wt->divline=18;
  wt->wordwrap=80;
  wt->insmode=1;
  wt->cbell=1;
  wt->knax=1;
  wt->autobin=1;
  wt->p7psave=1;
  wt->colordisp=1;
  wt->ctext='Z';
  wt->qtext='Q';
  wt->kennung=0xaa55;
  strcpy(wt->boxcalls,"DB0??? OE?X?? ??????-8 ?????-8");
  strcpy(wt->rcmdstring," CSTATUS DIR QUIT READ RPRG RTT WRITE WPRG");
  for(i=0;i<2*maxcolor;i++)
    wt->attr[i]=attini[i];
  strcpy(st,
         "\rB BayCom-Terminal"
         "\rC \\x:c \\i"
         "\rD \\x:d"
         "\rG Gruss ... \\z"
         "\rQ Hawediehre!"
         "\rZ Default-CTEXT\r\0\0");
}

/*---------------------------------------------------------------------------*/

int loadpar(void)
{ FILE *f;
  static term_para_t wwt;
  char s[256];
  int line=0;
  struct text_info dosbildschirm;
  wt=&wwt;
  if(islocked(INITNAME))
    return -1;

  initparameter();
  f=sysopen(INITNAME,"rt");
  if(f)
  { while(fgets(s,255,f))
    { if(s[strlen(s)-1]=='\n')
	      s[strlen(s)-1]=0;
      if(!mbinitbef(s,1))
      {	printf("*** Syntax Error in "INITNAME" line %d:\n%s\n",line,s);
        exit(1);
      }
      line++;
    }
    fclose(f);
    lockhd=lock(INITNAME); //Deti 04/96
  }
  else
    unlink(syspath(VIDNAME));
  gettextinfo(&dosbildschirm);
  if(dosbildschirm.currmode==MONO || dosbildschirm.currmode==BW80)
    wt->colordisp=0;

  if(mynum)
    memcpy(wt->mycall,mycall,sizeof(mycall));

  return wt->mycall[0][0]!=0;
}

/*---------------------------------------------------------------------------*/
