/***************************************************************

  BayCom(R)           Packet-Radio fuer IBM PC

  BayCom-Terminal


  ----------------------
  Critical Error Handler
  ----------------------


  Copyright (C) 1999 Flori Radlherr, DL8MBT, flori@baycom.org
      
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ***************************************************************/

#include "bct.h"

/*---------------------------------------------------------------------------*/

#define IGNORE  0
#define RETRY   1
#define ABORT   2
#define XLEN 40
#define YLEN 5

/*---------------------------------------------------------------------------*/

int critical_error=0;

/*---------------------------------------------------------------------------*/

static char *err_msg[]=
{ "Write Protect",
  "Unknown Device",
  "Drive not ready",
  "Unknown Command",
  "Data Error (CRC)",
  "Wrong length",
  "Search Error",
  "Medium unknown",
  "Sector not found",
  "Paper out",
  "Write Error",
  "Read Error",
  "General Failure Error",
  "Unknown",
  "Unknown",
  "Disk changed"
};

/*---------------------------------------------------------------------------*/

int error_win(char *geraet,char *msg)
{ static video platz[(XLEN+1)*(YLEN+1)];

  int retval;
  wind wn;

  int att=wt->attr[colset+helpcolor];
  vseg=FP_SEG(vram);

  if(critical_error) return IGNORE;

  wn=wopen(18,9,XLEN,YLEN,platz);
  wclear(wn,att);
  wframe(wn,att,"Critical Error");
  wstr(wn,0,att,geraet);
  wstr(wn,1,att,msg);
  wstr(wn,3,att,"(A)bort, (R)etry, (I)gnore?");
  while(1)
  { retval= getch();
    if (retval=='a' || retval=='A' || retval==0x1b || retval==13)
    { retval = IGNORE;
      critical_error=TRUE;
      break;
    }
    if (retval == 'r' || retval == 'R')
    { retval = RETRY;
      break;
    }
    if (retval == 'i' || retval == 'I')
    { retval = IGNORE;
      break;
    }
  }
  wclose(wn);
  return(retval);
}

/*---------------------------------------------------------------------------*/

#pragma argsused
int crit_handler(int errval,int ax,int bp,int si)
{
  char msg[40];
  char geraet[40];
  unsigned di;
  int drive;
  int errorno;

  di= _DI;
  drive = ax & 0x00FF;
  errorno = di & 0x00FF;
  if(ax>0)
    sprintf(geraet,"Error at Drive %c:",'A' + drive);
  else
    strcpy(geraet,"Device Error");
  sprintf(msg,"%s",err_msg[errorno]);
  hardresume(error_win(geraet,msg));
  return ABORT;
}
