#include <sys/socket.h>
#ifdef _AIX 
#include <sys/socketvar.h>
#endif 
#include <netinet/in.h>
#ifdef hpux
#include <sys/file.h>
#define index(a,b) strchr(a,b)
#endif

#define MAX_TEXT	2048

#define MAX_SOCKET_PACKET_SIZE	1024	/* Wild guess. */
#define DESIRED_SOCKET_PACKET_SIZE 800

#define MESSAGE_FLUSH ((char*)NULL)

struct interactive {
    unsigned closing:1;		/* True when closing this socket. */
    unsigned do_close:1;	/* This is to be closed down. */
    unsigned silent_close:1;	/* Close connection with no further output */
    unsigned noecho:1;          /* Don't echo lines */
#ifdef PORTALS
    unsigned from_portal:1;/*True if this player has arrived through a portal */
    unsigned out_portal:1;	/* True if going out through a portal. */
#endif
    char text[MAX_TEXT];
    char trace_level; 
    struct sockaddr_in addr;
    int socket;
    int text_end;		/* first free char in buffer */
    int text_start;		/* where we are up to in player cmd buffer */
    int last_time;		/* Time of last command executed */
#ifdef PORTALS
    int portal_socket;	/*All messages should go through this socket, if open */
#endif
    char *trace_prefix;
    char *prompt;
    struct object *ob;		/* Points to the associated object */
    struct sentence *input_to;	/* To be called with next input line ! */
    struct interactive *snoop_on, *snoop_by;
    struct ed_buffer *ed_buffer;
#ifdef ACCESS_RESTRICTED
    void *access_class;
#endif
    int message_length;
    char message_buf[DESIRED_SOCKET_PACKET_SIZE+1];
    struct object *next_player_for_flush, *previous_player_for_flush;
#ifdef MUDWHO
    int login_time;
#endif
};

#define L_WAITING_FOR_NAME	1
#define L_LOGGED_ON		2

#define BACKEND_IN_BACKGROUND

#define HOST_NAME	"worf.tamu.edu"

#define MAX_SOCKET_PACKET_SIZE	1024	/* Wild guess. */

#define ULTRASNOOP 0
