#include "mb.h"
#include <dos.h>
#include <search.h>
#include <varargs.h>

#include "rose_ver.c"

#define	FREE -1
char l_date[7];
char l_time[5];

USER_HEADER *tufhs;
USER_RECORD *tuser, *user;
FILE  *ufl;

int	report		= FALSE;
int	dumpall		= FALSE;
int update		= FALSE;
int extended_wp	= FALSE;

struct tm *ctim;

main(argc,argv)
int argc;
char **argv;
{

	int		i, j, found;
	char	*cp, tline[LINELEN];
	char	tline2[LINELEN];
	FILE	*outfil = NULL;
	FILE	*infil  = NULL;
	char	*uhome, *ucall, *uqth, *uzip, *uhandle, *wpdat, *s, *fst, *p;
	char	*uaddrs, *uphone;
	int		haveline1 = FALSE;
	
	printf("\n WHITE PAGES Updater - ROSERVER/PRMBS");
	printf("\tver %s, %s\n",version,mbdate);

	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( s = argv[0]+1; *s != '\0'; s++) {
			switch (toupper(*s)) {
			case 'X':
				extended_wp++;
				break;
					
			case 'D':
				dumpall++;
			case 'R':
				report++;
				break;
			case 'U':
				update++;
				break;
			}
		}

	}	
	if ( argc < 2) {
		fprintf(stderr," usage: rswp {-r|-d|-u} [-x] userfile workfile\n");
		exit(1);
	}
		
	tufhs  = (USER_HEADER *) mballoc(USER_RECSIZE);
	tuser  = (USER_RECORD *) mballoc(USER_RECSIZE);
	user   = (USER_RECORD *) mballoc(USER_RECSIZE);

	if (report) {
		if ((ufl = fopen(argv[0], "r+b")) == NULL) {	
			printf("Error: can't open %s\n",argv[0]);
			return(0);
		}
		geturec(ufl, 0, (char *)tufhs);	/*  Read the mail file header */	

		for (i = 1; i <= tufhs->count ; i++) {
			geturec(ufl,i,(char *)tuser);
			if (dumpall || tuser->options & U_CHANGE_BBS) {
				if (outfil == NULL) {
					if ((outfil = fopen(argv[1], "wt")) == NULL) {
						printf("Error: can't create %s\n",argv[1]);
						return(0);
					}
				}
				if (tuser->zip[0] == '\0')
					uzip = "?";
				else
					uzip = tuser->zip;
					
				if (tuser->qth[0] == '\0')
					uqth = "?";
				else
					uqth = tuser->qth;

				if (tuser->handle[0] == '\0') {
					uhandle = "?";
				} else {
					strcpy(tline,tuser->handle);

					cp = tline;
					while(*cp) {
						if (*cp == ' ')	*cp = '_';
						cp++;
					}		
					uhandle = tline;
				}

				fprintf(outfil,"On %s %s/%c @ %s zip %s %s %s\n",
					tuser->date, tuser->call, 'U',
					strupr(tuser->home_bbs), uzip, uhandle, uqth);

				if (extended_wp)
					fprintf(outfil,"\\%s\\%s\\\n",
						tuser->address,tuser->phone);
					
					
				tuser->options &= ~U_CHANGE_BBS;
				puturec(ufl,i,(char *)tuser);
			}
		}
		curtim();
		strcpy(tufhs->wp_date,l_date);
		puturec(ufl,0,(char *)tufhs);
		if (outfil)
			fclose(outfil);
		fclose(ufl);
	}

	if (update) {
		if ((ufl = fopen(argv[0], "r+b")) == NULL) {	
			printf("Error: can't open %s\n",argv[0]);
			return(0);
		}
		if ((infil = fopen(argv[1], "rb")) == NULL) {	
			printf("Error: can't open %s\n",argv[1]);
			return(0);
		}
	
		geturec(ufl, 0, (char *)tufhs);	/*  Read the mail file header */	
		if ((fst = fgets(tline2,LINELEN,infil)) != NULL) {
			printf("line2i==>%s",tline2);
			while (!feof(infil)) {
	
				wpdat	= "";
				ucall	= "";
				uhandle	= "";
				uhome	= "";
				uqth	= "";
				uzip	= "";
				uaddrs	= "";
				uphone	= "";

					/* parsa da line */
				if (strncmp(tline2,"On ",3) != 0)
					continue;

				fill(user,'\0',USER_RECSIZE);
				wpdat = tline2 + 3;
				if (*(wpdat+6) == ' ') {
					p = wpdat + 6;
					*p++ = '\0';
				} else
					continue;
				strcpy(user->date,wpdat);
				ucall = p;

				if ((p = chop_at(p,'/')) == NULL)
					continue;

				strnxcat(user->call,pcall(ucall),CALLLEN);
				user->wp_update_type = *p++;
				if (strncmp(p," @ ",3) != 0)
					continue;
				else
					p += 3;
					
				uhome = p;

				if ((p = chop_at(p,' ')) == NULL)
					continue;

				strcpy(user->home_bbs, uhome);
	
				if (strncmp(p,"zip ",4) != 0)
					continue;
				else
					p += 4;
				if (*p != '?') {
					uzip = p;

					if ((p = chop_at(p,' ')) == NULL)
						continue;

					strcpy(user->zip,uzip);
				}				
	
				if (*p != '?') {
					uhandle = p;

					if ((p = chop_at(p,' ')) == NULL)
						continue;

					cp = uhandle;
					while(*cp) {
						if (*cp == '_')	
							*cp = ' ';
						cp++;
					}		
					strcpy(user->handle,uhandle);
				}				
	
				if (*p != '?') {
					uqth = p;
					p = chop_at(uqth,'\n');
					strcpy(user->qth,uqth);
				}				
					/* main line is parsed */
	
					/* get next line see if its  XWP */
				if ((fst = fgets(tline,LINELEN,infil)) != NULL) {
					printf("line==>%s",tline);
					if (*tline == '\\') {
	
						uaddrs = tline+1;

						if (cp = chop_at(uaddrs,'\\')) {
							uphone = cp;
						} else {
							continue;
						}
						strcpy(user->address,uaddrs);
							
						if ((cp = chop_at(uphone,'\\')) == NULL)
							continue;

						strcpy(user->phone,uphone);
					} else {
						haveline1 = TRUE;
					}	
				}					
					
				found = FALSE;
				for (i = 1; i <= tufhs->count ; i++) {
					geturec(ufl,i,(char *)tuser);
					if (strcmp(tuser->call,user->call) == 0) {
						found = TRUE;
						if (strcmp(tuser->date,user->date) <= 0) {
							if ((tuser->wp_update_type != 'P') 			||
								(stricmp(tuser->home_bbs,uhome) == 0)	){
								strcpy(tuser->date,user->date);
								if (*uhandle)
									strcpy(tuser->handle,uhandle);
								if (*uhome)
									strcpy(tuser->home_bbs,uhome);
								if (*uqth)
									strcpy(tuser->qth,uqth);
								if (*uzip)
									strcpy(tuser->zip,uzip);
								if (*uaddrs)
									strcpy(tuser->address,uaddrs);
								if (*uphone)
									strcpy(tuser->phone,uphone);
								tuser->log_count++;
								tuser->wp_update_type = 'U';
								puturec(ufl,tuser->rn,(char *)tuser);
							}
						}
						break;
					}
				}
				if (!found) {
					strcpy(user->cr_date, l_date);
					tufhs->count++;
					user->rn = tufhs->count;
					puturec(ufl,user->rn,(char *)user);
					puturec(ufl,0,(char *)tufhs);
				}
				curtim();
				if (haveline1) {
					strcpy(tline2,tline);
					haveline1 = FALSE;
				} else {
					fst = fgets(tline2,LINELEN,infil);
					printf("line2==>%s",tline2);
				}
			}
		}
		fclose(ufl);
		if (infil)
			fclose(infil);
	}
			
	printf("\7\t*** done\n");
}
				
/*
On 890926 KE0XS/G @ N0AN zip ? ? ?
On 890910 G3XYZ/U @ GB7HQQ zip _123 John Hertfordshire
On 890926 JR1YTD/I @ JR1YTD zip 1302 ? SMC-NET Kawagoe FWD-BBS
*/

/*****************************************************************
 *   curtim() - Fill the globals with the current date and time
 *              by reading the system clock.
 *****************************************************************/

curtim()
{
 long ltime;
	time(&ltime);
	ctim = gmtime(&ltime);	
	(void) sprintf(l_time,"%02d%02d",ctim->tm_hour,ctim->tm_min);
	(void) sprintf(l_date,"%02d%02d%02d",ctim->tm_year,ctim->tm_mon+1,
			ctim->tm_mday);

       		/* month returned by localtime is 0-11 */
}

/********************************************************************
 * geturec() - read a record from an USER file
 ********************************************************************/
geturec(fid, rec, buffer)
FILE *fid;
int rec;
char buffer[];
{
	long offs;
	int ret;
	offs = (long)rec * (long)USER_RECSIZE;
	if ( fseek(fid, offs, SEEK_SET)) {
		perror("geturec: fseek");
		exit(1);
	}
	ret = fread(buffer, USER_RECSIZE, 1, fid);
	if ( ret != 1 ) {
		printf("geturec: read err on $%04x\n",rec);
		exit(1);
	}
  return(0);
}

/********************************************************************
 * puturec() - write a record to a MB file
 ********************************************************************/
puturec(fid, rec, buffer)
FILE *fid;
int rec;
char buffer[];
{
	long offs, off_ret;
	int ret;

	offs = (long)rec * (long)USER_RECSIZE;
	if ( fseek(fid, offs, SEEK_SET)) {
		printf("puturec: fseek\n");
		exit(1);
	}
	ret = fwrite(buffer, USER_RECSIZE, 1, fid);
	fflush(fid);
	if ( ret != 1 ) {
		printf("puturec: fwrite\n");
		exit(1);
	}
	return (ret);
}

/**********************************************************************
 * pcall() - Parse trailing ssid from call.
 * store sid as small number in a character
 **********************************************************************/
char *pcall(cp)
char *cp;
{
	char *p;
	
	p = uc(cp);
	while(*p) {
		if (!isalnum(*p)) {
			*p = '\0';
			break;
		}
		p++;
	}
	return(cp);
}


