/* 
  RSMAKDIR.C - directory maintenance program for ROSERVER
  based upon:     <makedir.c>
 A program to create and fill-in a filedir.txt file for Citadel/Asgard
 ------------------------------<History>------------------------------------
 92Mar17 <br> ahh what a grand and glorious day ... and the code while not
              very clean looking - ain't too shabby - lotsa cleanup - at this
              point its not even close to Mr Barret's orginal so his name at
              startup banner is history
 92Mar16 <br> ver 1.2 - blechhh!!! what garbage - attempts to clean-up
              what really needs to be done is barf on it and start over!
 89Jan15 <br> ver 1.1 converted to Microsoft 5.1 added Bdale's fil_dir()
              to replace Borlund garbonzos - also tightened the code in
              the file get loop. Opened limit to 256 files
 89Jan13 <br> ver 1.0 as RSMAKDIR, also fixed bug corrupting strings
 89Jan03 <br> ver 1.4 changed array to 128 bytes each for old descriptions
 89Jan03 <br> ver 1.4 altered not to write FILENAME if no description is
              entered when prompted ... no point in it
 Original code from (c) 1988 by Brent Barrett
*/

#define LINELEN		256
#define MAXFILES	384
#define TRUE 1
#define FALSE 0
#define ERROR -1

#include <stdio.h>
#include <dos.h>
#include <process.h>
#include "rose_ver.c"
main(argc, argv)
int argc;
char *argv[];
{
    FILE 	*fs; 							/* output filestream 		*/
    static 	unsigned char files[MAXFILES][13]; 	/* array of filenames 		*/
    static 	char olddesc[MAXFILES][129]; 		/* array of old descriptions*/
    int 	c, i, c_save;
    int		done = FALSE; 					/* loop control flag 		*/
    int		fnum = 0; 						/* file number, loop variable */
    int		ftot = 0; 						/* total number of files	*/
	long int fil_xst();
	int continuation;
	int		auto_op = 0;
	char	*fname;
	char 	fnam[16];
    char 	line[2*LINELEN];				/* description string		*/
	char 	*cp, *desc;
    int 	strcmp();
	char *strstr();
	char *editchars = "\r\n\t\7 ,.:;{}[]<>|\\";

    printf("\nRSMAKDIR - FILES directory information utility\n");
	printf("\t   compatible with ROSERVER version %s, %s\n",version, mbdate);
    printf("\t   A MAXIMUM of %d Files will be handled. Descriptions\n",MAXFILES);
    printf("\t   for files no longer present will be dropped\n");
    printf("\n.. Loading directory information ...");


	if ((done = fil_dir(0,files[ftot])) == ERROR) {
		printf ("\7\n NO Files in this directory to Catalog!\n\7");
		exit(1);
	}
	if (argc > 1 && toupper(*argv[1]) == 'A')
		auto_op++;
	for (ftot = 0, done = FALSE ; ftot < MAXFILES && !done ;) {

	 	switch(fil_dir(1,fnam)) {
	 	case ERROR:
	 		done = TRUE;
			break;

		case TRUE:
			if (stricmp(fnam,"FILEDIR.TXT ") == 0	||
				stricmp(fnam,"FILEDIR.BAK ") == 0	||
				stricmp(fnam,"FILEDIR.$$$ ") == 0	||
				stricmp(fnam,"FILEDIR.~TX ") == 0	)
				break;
				
			strcpy(files[ftot++],fnam);

		case FALSE:
			break;
		}		

	}
	if (ftot == MAXFILES) {
		 		printf("\n\t\7*** Maximum of %d files reached!\n",MAXFILES); 
		 		printf("\t\7    Continuing, ignore remainder!\n\n"); 
	} else {
	    qsort(files, ftot, 13, strcmp);
	    printf(" %d files loaded\n\n", ftot);
	}
	
			/* clear the old descriptions array */
	for (c=0; c<ftot; c++) 
		*olddesc[c] = '\0';

	if (fs = fopen("filedir.txt", "r")) {

		while(!feof(fs)) {
	    	if (fgets(line, LINELEN, fs) == NULL)
	        	continue;
			if (strncmp(line,"             : ",15) != 0) {
				continuation = 0;
				fname = line;			/* form filename */
				line[12] = '\0';
	
				if (line[13] != ':')	/* form description */
					continue;
			} else {
				if (++continuation > 1 )
					continue;
			}

			desc = line+15;
			if (cp = strstr(desc," BYTES "))
				desc = cp + 7;
									/* cleanup description for extra spaces */
	
			for (cp = desc ; *cp && strchr(editchars,*cp) != NULL ; cp++);
			
			desc = cp;
			*(desc-1) = '\0';
			
			for (cp = desc + strlen(desc) - 1 ; *cp; cp--) {
				if (strchr(editchars,*cp) == NULL)
					break;
				*cp = '\0';
			}
	
			if (continuation) {
				strncat(olddesc[c_save],desc,64);
			} else {
		        for (c=0; c<ftot; c++) {
		        	if (stricmp(fname, files[c]) == 0) { /* same string */
	    	    		strncat(olddesc[c], desc,48);
	        			c_save = c;
						break;
					}
				}
			}
		}
	    fclose(fs);
	}

	unlink("filedir.$$$");

    if ((fs=fopen("filedir.$$$", "w")) == NULL) {
        printf("unable to open FILEDIR.$$$!\n");
        leave();
    }

	if ((done = auto_op) == 0) {
		printf("Type: \"DONE\" to finish update with old or no descriptions\n");
		printf("      \"DOS\"  to drop to dos shell and check file contents\n");
		printf("      \"EXIT\" to leave without updating file\n\n");
		printf(" *** If old description shown <ENTER> will retain ***\n\n");
	}
    while (fnum < ftot) {
    
		printf("File: %s\n",files[fnum]);
		if (*olddesc[fnum])
			printf("Old : %s\n", olddesc[fnum]);
			
		if (!done) {
			printf("New : ");
			gets(line);
	
			if (strlen(line)) {
				if (stricmp(line, "DONE") == 0) {
					done = TRUE;
				} else {
					if (stricmp(line, "EXIT") == 0) {
						fclose(fs);
						printf("action aborted by user\n");
						leave();
					}
					if (stricmp(line, "DOS") == 0) {
						spawnlp(P_WAIT, "COMMAND", NULL);
						continue;
					}

					for (cp = line ; *cp && strchr(editchars,*cp) != NULL ; cp++);
					desc = cp;
				
					if (strlen(desc)) {
						for (cp = desc + strlen(desc) - 1 ; cp > desc; cp--) {
							if (strchr(editchars,*cp) == NULL)
								break;
							*cp = '\0';
						}
					}
					
					if (strlen(desc)) {
						sprintf(olddesc[fnum],"%7ld BYTES %-114s\n", 
							fil_xst(files[fnum]), desc);
					}
				}
			}
		}
		if (*olddesc[fnum] == '\0') {
			fprintf(fs, "%-12.12s : %7ld BYTES \n", files[fnum], fil_xst(files[fnum]));
		} else {
			fprintf(fs, "%-12.12s : %-.64s\n", files[fnum], olddesc[fnum]);
			if (strlen(olddesc[fnum]) > 64)
				fprintf(fs, "%s : %-.64s\n", "            ", olddesc[fnum]+64);
		}
		fnum++;
    }
    fclose(fs);
	unlink("filedir.bak");	/* will return error most times, but no */
							/* use checking for it */
	rename("filedir.txt", "filedir.bak");
	rename("filedir.$$$", "filedir.txt");

    printf("\nDone.\n");
    leave();
}

leave()
{
    printf("[Exiting]");
    exit(TRUE);
}

/************************************************************************
 * fil_dir()  [dirutil.c]
 *	MS-Dos directory reading stuff.
 *	A.D. Barksdale Garbee II, aka Bdale, N3EUA
 *	Copyright 1986 Bdale Garbee, All Rights Reserved.
 *	Permission granted for non-commercial copying and use, provided
 *	this notice is retained.
 ************************************************************************
 *
 * Based on an idea or two from Bob Hartman.
 *
 * sends up file size or '<DIR>' in string		|br| 12/15/86
 ************************************************************************/

/************************************************************
 * fil_dir() - wildcard filename lookup
 ************************************************************/
	/* DOS file attribute byte status bits		*/
#define ARC_ST	0x20
#define SUB_DIR	0x10
#define	VOL_LBL	0x08
#define HIDDEN	0x02
#define READ_O	0x01

fil_dir (times, ret_str)
int times;
char *ret_str;
{
	char *name = "*.*";
	union REGS regs;
	static struct {
		char rsvd[21];
		char attr;
		long ftime;
		long fsize;
		char fname[13];
	} sbuf;
	char	fsize[7];

	bdos (0x1a,(unsigned) &sbuf,0);
	if (times == 0) {
		regs.h.ah = 0x4e;
		regs.x.dx = (unsigned int) name;
		regs.x.cx = (unsigned int) ~VOL_LBL;
		intdos(&regs,&regs);
		if (regs.x.cflag) {
			*ret_str = '\0';
			return (ERROR);
		}
	} else {
		regs.h.ah = 0x4f;
		intdos(&regs,&regs);
		if (regs.x.cflag) {
			*ret_str	= '\0';
			return (ERROR);
		}
	}
	if (sbuf.attr & SUB_DIR)
		return (FALSE);
	(void) sprintf(ret_str,"%-12.12s",sbuf.fname);
	return(TRUE);
}

