/*****************************************************************
 *  MBTNC.C - 11/14/86 - Deal with the tnc.
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for 
 *  reasonable reimbursement for expense of delivery, to include 
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *****************************************************************/

/*******************************************************************
 * cmdtnc() - issue ctrl_c to TNC to get it into "cmd:" mode
 * convtnc() - issue command to TNC to go to conversational mode
 * distnc() cause TNC to disconnect from the poor slob
 * iscon() - checks to see if connected
 * isdis() - tests for spurious disconnect or already disconnected
 * islink() - is this a link message from another BBS/SWITCH
 * is_MBL() - is it an MBL system with reverse forwarding
 * isreq() - is it a connect request
 * login() - whne we get a connect or link message do this
 * ret_to_node() - G8BPQ bios extension - instead of DISC - back to node
 * tncstate() - find out if we are in disconnected mode
 * waitcmd() - wait for  cmd: prompt from TNC
 *******************************************************************/


#include "mb.h"


/*******************************************************************
 * cmdtnc() - issue ctrl_c to TNC to get it into "cmd:" mode
 *******************************************************************/
cmdtnc()
{
	sendbreak(port->idn);
	waitcmd();
}

/*******************************************************************
 * convtnc() - issue command to TNC to go to data mode
 *******************************************************************/
convtnc(tm)
short tm;
{
	if (port->type & P_TNC) {
		cmdtnc();

		outstr("trans\n");

		if (tm) wwait(tm);
	}
}

/*******************************************************************
 * distnc() cause TNC to disconnect from the poor slob
 *******************************************************************/
distnc(pp,t)
PORTS *pp;
short t;
{

  	if (pp->type & P_TNC)
    	if (tncstate(pp, NULL) != ERROR)	
    		force_disc(pp,t);

	if (pp->type & P_MDM)   /* Modem and serial lines */
		DTR_OFF(pp->idn);

	pp->mode = IDLE;
}

/*******************************************************************
 * force_disc() - force a disconnect state . This is exactly what
 *	the title implies. A hard, fast, dirty (at times) procedure
 *	to garuntee the TNC is in DISCONNECTED state
 *******************************************************************/
force_disc(pp,tm)
int tm;
register PORTS *pp;
{
	char tline[LINELEN];

	ioport(pp); 

	cmdtnc();

	outstr("D\n");  /* 1st 'D' starts disconnect in case he really is */

	waitcmd();

	if (tm) {
		settmr(tm);
		while (chktmr())
			if (!havedcd(pp)) break;
	}

	if (havedcd(pp)) 
		outstr("D\n");

	waitcmd();

}

/*
	iscon() - checks to see if connected
*/

iscon(wait)
int wait;
{
	int ret;

	settmr(wait);
	
	while ( ( (ret = havedcd(port)) == FALSE) && wait) {
		if(chktmr() == 0)
			return (FALSE);
	}
	return(ret);

}
#ifndef NEEDSPACE

/*******************************************************************
 * isdis() - tests for spurious disconnect or already disconnected
 *******************************************************************/

isdis(cp)
char *cp;
{
  return (strncmp(cp,"*** DISCONNECTED",16) == 0);
}

/*
	isreq() - is it a connect request
*/
isreq(cp)
char *cp;
{
  return (strnicmp(cp,"*** connect request:",20) == 0);
}
#endif


extern short ext_resp;
extern int	flip_flop;
/*
	is_smart() - returns 3 for PRMBS, 2 for other, 1 for dumbkopf
				 0 for not a 'smartline, initialized at ERROR
*/
is_smart(cp)
char *cp;
{
	char *sys[6], *p;
	int systype = ERROR;
	int i = 0;
	int j = 0;
	    
	if ((p = strchr(cp,'[')) && strchr(p+1,']')) {
		uc(p);
		systype = TRUE;
	
		i = fsplit(p+1,'-',sys,6) - 1;
	
		if (strncmp(sys[0],"PRMBS",5) == 0) {
			systype = PRMBS;
/*
			rspace = atoi(sys[1]);
*/
		} else {
			if (strcmp(sys[0],"NET") == 0)
				systype = TCNET;
			else
				systype = OTHER;
		}
		if (i) {
			p = sys[i];
			while (*p) {
				switch (*p++) {
				case '0':
					systype = FALSE;
					*p = '\0';
					clear_parms();
					break;				
				case '$':
					bid_able = TRUE;
					break;
				case 'H':
					h_route	 = TRUE;
					break;
				case 'M':
					mid_able = TRUE;
					break;
				case 'R':
					ext_resp = TRUE;
					break;
				case 'P':
					flip_flop = TRUE;
					break;
				}
			}
		}
	}

	return (systype);
}

/*
	clear_parms() - clean and init the smart system paramters
*/
clear_parms()
{
	smart_sys	= ERROR;
	flip_flop	= FALSE;
	bid_able	= FALSE;
	mid_able	= FALSE;
	h_route		= FALSE;
	ext_resp 	= FALSE;

}



/*
	device_cmds()  - sends command strings to the TNC/MDM, counts \n's and 
				does that many waitcmd()'s/eatChars()
*/
device_cmds(pp,cp)
PORTS *pp;
char *cp;
{
    PORTS *was;
	
    was = port;

    ioport(pp);

	setcolor(col_out);
	
	if (port->type & P_TNC)
		cmdtnc();
	if (port->type & P_MDM)
		DTR_ON(port->idn);
		
	while (*cp) {
		outchar(*cp);
		if (*cp++ == '\n') {
		    setcolor(port->color);
		    if (port->type & P_TNC)
				waitcmd();
			eatChars();
			setcolor(col_out);
		}		
	}
    ioport(was);
}
/*
	ret_to_node() - when using a G8BPQ PC-Node a BYE gets you back to
	the NODE rather than disconnected. Conceptually, this io_bios call
	switches off the pipe from the physical port of the PC to the virtual
	TNC port the application is using. The port is idled and the BBS goes
	back to work. even if user connected to the BBS Alias, he winds up at
	the Node alias.
*/
ret_to_node(pp)
PORTS *pp;
{
	io_bios(pp->idn,BPQRETNODE);
	pp->mode = IDLE;
}
/*
	unACKed()  this uses an extended COMBIOS call in G8BPQ to see if there
	are outstanding unACKed packets
*/
unACKed(pp)
PORTS *pp;
{
		/* unACKed packet count in AH order is AL-AH god-damned Intel! */
		
	return(io_bios(pp->idn,BPQUNACK) >> 8 );
}

sendnl()
{
	outchar('\n');
}
/*******************************************************************
 * tncstate() - find out if we are in disconnected mode
 *		returns ERROR for DISC, NULL for "in PROGRESS" or a
 *      character pointer to station connected 
 *******************************************************************/

tncstate(pp,call)
PORTS *pp;
char *call;
{
	PORTS *was;
	char *p;
	char tline[LINELEN];

	was = port;
	ioport(pp);
	cmdtnc();
	outstr("C\n");
	while (TRUE) {
		if (getdat(tline, sizeof(tline)-1, port->timeout)) {
			uc(tline);
			if ((p = strstr(tline,"LINK STATE IS"))) {
				p += 13;	/* advance pointer beyond 'Link state' */
				waitcmd();
				ioport(was);

				if (strstr(p,"PROGRESS") == NULL) {
					if (strstr(p,"DISCONNECTED")) {
						return (ERROR);
					} else {
							/* " CONNECTED to XX1XXX" */
						if (p = strstr(p,"CONNECTED")) {
							if (call) 
								strcpy(call,p+13);
							return(TRUE);
						}
					}
				}
								 
				break;
			}

		} else {
			break;
		}
	}

	return(FALSE);
}

/*******************************************************************
 * waitcmd() - wait for  cmd: prompt from TNC
 *******************************************************************/
waitcmd()
{
  char *wanted = "cmd:";
  int i;
  int j = 16;

  settmr(2);
  for (i = 0; i < 4;) {
    if (instat()) 
    	if (inchar() == *(wanted+i))
    		i++;
		else
		 	i = 0;
    if (--j == 0 ) {
    	j = 16;
    	if (!chktmr())
    		break;
    }
  }
  eatChars();  
}
#include "rosecall.c"
