#include "mb.h"
#include "mbmail3.h"
#include "mbuser7.h"
#include "rose_ver.c"
#include <dos.h>
#include <varargs.h>

#define	FREE 	-1
#define INUSE	0
	

int trace_dmp   = 0;
int init        = 0;
int verbose     = 0;
char workfnam1[68];
char workfnam2[68];
char *tmpdir = ".";

unsigned strtno = 1;

char l_time[5];
char l_date[7];
char *line;
char *mbfile;

int next, nmfl, mfl;

main(argc,argv)
int argc;
char *argv[];
{

	char *s, *p;
	int	next;	
	
	MSG_HDR		*nmhs;
	OMSG_HDR	*mmhs;
	MAIL_HDR	*nfhs;
	OMAIL_HDR	*mfhs;

	OUSER_HEADER	*ufhs;
	USER_HEADER		*nufhs;
	OUSER_RECORD	*user;
	USER_RECORD		*nuser;

	FILE *ufl, *nufl;
		
	int curhdr, i, exitval = 0;
	
	printf("\n CONVERT - ROSERVER/PRMBS convert mailfile to Version 4");
	printf("\tver %s, %s\n",version,mbdate);


	line 		= mballoc(LINELEN);
	mbfile		= mballoc(64);

	mmhs = (OMSG_HDR  *) mballoc(ORECSIZE);
	nmhs = (MSG_HDR   *) mballoc(MAIL_RECSIZE) ;
	mfhs = (OMAIL_HDR *) mballoc(ORECSIZE);
	nfhs = (MAIL_HDR  *) mballoc(MAIL_RECSIZE) ;
	
	if ( argc < 5 ) {
		fprintf(stderr," usage: mbconvrt oldmfile newmfile oldufile newufile\n");
		exit(1);
	}
	

	
	if ((mfl = open(argv[1], O_RDWR|O_BINARY)) < 0 ) {
		printf("mailwork: ERR open %s\n",argv[1]);
		exit(1);
	}

	read_rec(mfl, 0, ORECSIZE,(char *)mfhs);

	if (mfhs->version == MFL_VERSN) {
		printf("\n\t\t\7Oopps, ya got da wrong file. This has already\n");
		printf("\t\tbeen converted to a version 4 Mail file\n");
	} else {
		curtim();	/* get time and date	*/
	
		if ((nmfl = open(argv[2], O_CREAT|O_TRUNC|O_RDWR|O_BINARY, 
		                          S_IREAD|S_IWRITE)) < 0 ) {
			printf("mailwork: ERR open %s\n",argv[2]);
			exit (1);	/* sayonara!						*/
		}
		  
		fill(nfhs,'\0',MAIL_RECSIZE);
	
		nfhs->next		= 1;
		nfhs->first		= 1;
		nfhs->last		= 0;
		nfhs->ffree		= 0;
		nfhs->lfree		= 0;
		nfhs->next_msg 	= mfhs->next_msg;
		nfhs->version 	= MFL_VERSN;
		nfhs->free		= 0;
		nfhs->count 	= 0;
		strncpy(nfhs->date, l_date, 6);
		strncpy(nfhs->time, l_time, 4);
		nfhs->unt_msg 	= mfhs->next_msg;
	
	
	
		write_rec(nmfl, 0,MAIL_RECSIZE, (char *)nfhs);
	
		for (curhdr = mfhs->first; curhdr ; curhdr = next) {
			read_rec(mfl,curhdr,ORECSIZE,(char *)mmhs);
			next	= mmhs->next;
	
			fill(nmhs,'\0',MAIL_RECSIZE);
			if ( curhdr == mfhs->first ) 
				nfhs->fmsgno = mmhs->number;
	
			nmhs->rn 	= nfhs->next;
			nmhs->prev	= nfhs->next - 1;
			nfhs->count++;
	
 			if (next)
				nmhs->next	= nfhs->next + 1;

			printf("Msg #%5d (from %3x to %3x) %u\n",
			  mmhs->number,curhdr,nfhs->next,nfhs->count);
	
			strncpy(nmhs->to,	mmhs->to,	CALLLEN);
			s = nmhs->to + 5;
			while (*s == ' ') *s-- = '\0';
							
			strncpy(nmhs->from,	mmhs->from,	CALLLEN);
			s = nmhs->from + 5;
			while (*s == ' ') *s-- = '\0';
				
			strncpy(nmhs->bbs,	mmhs->bbs,	CALLLEN);
			s = nmhs->bbs + 5;
			while (*s == ' ') *s-- = '\0';
	
			strncpy(nmhs->date,	mmhs->date,	6);
			strncpy(nmhs->time,	mmhs->time,	4);
			strncpy(nmhs->title,	mmhs->title, MHTITL);
			nmhs->alt_ptr	= mmhs->alt_ptr;
			nmhs->stat 		= mmhs->stat;
			nmhs->type		= mmhs->type;
			nmhs->fprty		= mmhs->fprty;
			nmhs->number	= mmhs->number;
			nmhs->read		= mmhs->read;
			nmhs->size		= mmhs->size;
			nmhs->flags		= mmhs->flags;
				
			write_rec(nmfl,nfhs->next,MAIL_RECSIZE,(char *)nmhs);
			nfhs->last 		= nfhs->next++;
		}
		close(mfl);
	
	
		/*	
			get the last record and put 0 in its next field
	       	for the case where last was killed record
	    */
		read_rec(nmfl,nfhs->last, MAIL_RECSIZE,(char *)nmhs);
		nmhs->next = 0;
		write_rec(nmfl,nfhs->last,MAIL_RECSIZE,(char *)nmhs);
	
		write_rec(nmfl, 0, MAIL_RECSIZE, (char *)nfhs);	/* update header		*/
	
		close(nmfl);
		free(mfhs);
		free(nfhs);
		free(mmhs);
		free(nmhs);

		printf("\n\t\7*** done\n");
	}
	printf("\n CONVERT - ROSERVER/PRMBS convert userfile to Version 8");
	printf("\tver %s, %s\n",version,mbdate);

	ufhs  = (OUSER_HEADER *) mballoc(sizeof(OUSER_HEADER));
	nufhs = (USER_HEADER  *) mballoc(sizeof(USER_HEADER));
	user  = (OUSER_RECORD *) mballoc(sizeof(OUSER_RECORD));
	nuser = (USER_RECORD  *) mballoc(sizeof(USER_RECORD));


	unlink(argv[4]);	/* erase USER.BAK, ignore error	*/
	ufl = fopen(argv[3], "rb");
	if ( ufl == NULL) {
		printf("Error: can't open %s\n",argv[3]);
		return(0);
	}
	geturec(ufl, 0, (char *)ufhs);	/*  Read the mail file header */
	curtim();
	nufl = fopen(argv[4], "wb");
	if ( nufl == NULL ) {
		printf("Error: can't create %s\n",argv[0]);
		return(0);
	}
	fill(nufhs,'\0',sizeof(USER_HEADER)); 

	nufhs->version = USFL_VERSN;
	if (ufhs->version != OUSFL_VERSN ) { 
		printf("\n\t\t\7Oopps, ya got da wrong file. This has already\n");
		printf("\t\tbeen converted to a version 8 User file\n");
		exit(0);
	}

	printf("\n\t*** Converting user file\n");
	nufhs->count = 0;
	strncpy(nufhs->date, l_date, 6);
	strncpy(nufhs->time, l_time, 4);
	nufhs->lmnr	= ufhs->lmnr;
	puturec(nufl, 0, (char *) nufhs);

	for (next = 1; (next <= ufhs->count) && (next <= MAXUSERS); next++) {
		geturec(ufl,next,(char *) user);

		fill ( nuser, '\0', sizeof(USER_RECORD)) ;

		strncpy(nuser->call, user->call, CALLLEN);
		p = nuser->call + CALLLEN - 1;
		while (*p == ' ') *p-- = '\0';

		strncpy(nuser->home_bbs,user->home_bbs,CALLLEN);
		p = nuser->home_bbs + CALLLEN - 1;
		while (*p == ' ') *p-- = '\0';

		strncpy(nuser->date, user->date, 6);
		strncpy(nuser->time, user->time, 4);
		strcpy(nuser->handle,user->handle);
		strcpy(nuser->pswd,user->pswd);
		nuser->msg_number	= user->msg_number;
		nuser->log_count	= user->log_count;
		nuser->rn		= next;
		nufhs->count 	= next;
		nuser->options		= user->options;
		puturec(nufl,nuser->rn,(char *) nuser);
		printf("%s written - %3x\n", nuser->call,nuser->rn);

	}
	puturec(nufl, 0, (char *) nufhs);
	fclose(nufl);
	printf("\7\t*** done\n");



	exit(0);
}


curtim()
{
 struct tm *cur_time;
 long ltime;
	time(&ltime);
	cur_time = localtime(&ltime);	
	(void) sprintf(l_time,"%02d%02d",cur_time->tm_hour,cur_time->tm_min);
	(void) sprintf(l_date,"%02d%02d%02d",cur_time->tm_year,cur_time->tm_mon+1,
			cur_time->tm_mday);
       		/* month returned by localtime is 0-11 */
}


/*
	read_rec() - read a record from an MB file
*/
read_rec(fid, rec, recsize,buffer)
int fid;
int rec, recsize;
char buffer[];
{
  long lseek();
  long offs;
  int ret;

  offs = (long)rec * (long) recsize;
  if ( lseek(fid, offs, 0) == -1 ) {
	perror("lseek");
	exit(1);
  }
  ret = read(fid, buffer, recsize);
  if ( ret != recsize ) {
	fatal("error read_rec 0x%x - expected %d bytes got %d bytes\n",
	rec, recsize,ret);
  }
  return(0);
}

/*
	write_rec() - write a record to a MB file
*/
write_rec(fid, rec, recsize, buffer)
int fid;
int rec, recsize;
char buffer[];
{
	long lseek();
	long offs, off_ret;

	offs = (long)rec * (long) recsize;
	off_ret = lseek(fid, offs, 0);
	if (offs != off_ret) {
		perror("lseek");
		fatal("\n\n\7WRITE_REC - offset[%ld][%03x]\n",offs, rec);
	}
  return (write(fid, buffer,  recsize) ==  recsize);
}

/********************************************************************
 * fill() - fills a space 'adr' of length  'l' with character 'ch'
 ********************************************************************/
fill(adr, ch, len)
char *adr;
char ch;
int len;

{
  register char *cp;

  for (cp = adr; cp < adr + len;) *cp++ = ch;
}


/*******************************************************
 * mballoc - calls alloc and checks for out of memory
 *******************************************************/
char *mballoc(n)
unsigned n;
{
	char *p;
	if ( ( p = malloc(n)) == NULL ) {
		perror("malloc: memory error\n");
	}
	return(p);
}

/* 
	err_string() - goes to message file and gets message to be sent
    with *'s and bell
*/
char *err_string(ndex)
int ndex;
{
	static char msg_line[128];
	char *p, *fst;
	FILE *errmfil;
	
	p = NULL;
	if ((errmfil = fopen("messages.rs","rt")) != NULL) {
		while(!feof(errmfil)) {
			if (((fst = fgets(line,LINELEN,errmfil)) == NULL) ||
			    (*line == '#'))
				continue;
			p = line+4;
			*(p-1) = '\0';
			if (atoi(line) == ndex)
				break;
		}
		fclose(errmfil);
	}
	if ( p == NULL)
		(void) sprintf(msg_line,"*** err msg # %d\n",ndex);
	else
		(void) strncpy(msg_line,p,127);
	
	return(msg_line);
}

/***************************************
 * fatal - printf to console  and exit 
 ***************************************/
/* VARARGS1 */
void
fatal(va_alist)
va_dcl
{
	char *fmt;
	va_list arg_ptr;
	extern int Debug;

	va_start(arg_ptr);
	fmt = va_arg(arg_ptr, char *);
	vprintf(fmt,arg_ptr);
	va_end(arg_ptr);
	exit(1);
}

/********************************************************************
 * geturec() - read a record from an USER file
 ********************************************************************/
geturec(fid, rec, buffer)
FILE *fid;
int rec;
char buffer[];
{
	long offs;
	int ret;
	offs = (long)rec * (long)sizeof(USER_RECORD);
	if ( fseek(fid, offs, SEEK_SET)) {
		perror("geturec: fseek");
		exit(1);
	}
	ret = fread(buffer, sizeof(USER_RECORD), 1, fid);
	if ( ret != 1 ) {
		fatal("geturec: read err on $%04x\n",rec);
	}
  return(0);
}


/********************************************************************
 * puturec() - write a record to a MB file
 ********************************************************************/
puturec(fid, rec, buffer)
FILE *fid;
int rec;
char buffer[];
{
	long offs, off_ret;
	int ret;

	offs = (long)rec * (long)sizeof(USER_RECORD);
	if ( fseek(fid, offs, SEEK_SET)) {
		perror("putrec: fseek");
		exit(1);
	}
	ret = fwrite(buffer, sizeof(USER_RECORD), 1, fid);
	if ( ret != 1 ) {
		perror("puturec: fwrite");
		exit(1);
	}
	return (ret);
}

