/*************************************************************
 * PRMBS - Packet Radio Mailbox System  Copyright 1987
 *   by  Brian B. Riley (ka2bqe)
 *       Dave Trulli    (nn2z)
 * This code was initially based on a pre-release of the CBBS
 * code by W0RLI and VE3GYQ. It has been re-worked to the point
 * that only some structural resemblance remains. It is for the
 * most part orginal work of the authors, where other code has 
 * been incorporated appropriate credit is given.
 *    This code is hereby freely placed into the public domain
 * for use by any and all with the stipulations that (1) credit
 * line must be retained, both ours and in the case of other
 * code the appropriate authors and (2) no fee may be charged
 * for this code beyond simple expenses in transfer of the code
 * to another person to include postage, phone charges, media 
 * costs, mailers, etc)
 *************************************************************
 * main()      - Mailbox routine
 * close_all() - shut down all ports, serial, modem, tnc
 * done()      - exit to operating system
 * logout()    - say goodbye to the nice person and log it
 * waitcon()   - waiting to see if we are loved and desired
 *********************************************************************/


#include "mb.h"


char *cmd = "";
char *line = "";
char *token_lin = "";
				/* SID ident string */
char *mprmbs  = "[PRMBS-$R-$Q-HMPR$$]\n";


extern USER_HEADER *ufhs;
extern FILE *ufl;

PORTS *porthd	= NULL;
PORTS *cport	= NULL;
PORTS *qport	= NULL;
PORTS *port;

char *fildir, *updir, *sysdir, *usrdir;
char *helpfile, *menufile, *infofile;

char *symenu, *rmenus;

char *tncrem, *tncsys, *mbbusy;

extern char *mperm, *mkilld;


short event_cycle	= 0;
short event_min		= 0;
short event_ofset	= 0;

int			multiuser = 0;
int			max_err = 10;
long int 	d_s;
int			min_disk;

short	break_in	= FALSE;
short	disk_full	= TRUE;	/* initializing it to true forces re-comp */
short	bid_able	= FALSE;
short	h_route		= FALSE;
short	mid_able	= FALSE;
short	ext_resp	= FALSE;
short	no_init		= FALSE;
short	smart_sys	= ERROR;
int		sys_type	= FALSE;
int 	kblok 		= FALSE;
int		sendtype	= FALSE;
int		open_sys	= FALSE;
int		reply_flag	= FALSE;
int		ev_preempt	= FALSE;
int		no_bbs		= FALSE;
/*
char *msgflp;
*/
char *msgs_fil;

/*
BBSPRM	*bbs_sys;
*/

char	*shutdown;
extern char h_loc_fil[128], xlat_fil[128], *xltFIL, *hlFIL;
extern unsigned int highread, new_highread;
extern long int high_seq;
extern char oreply[MTOLEN+1];
extern char *eat_white();

#include "rose_ver.c"


/*********************************************************************
 * main() - Mailbox routine
 *********************************************************************/
main(argc, argv)
int argc;
char *argv[];
{
	long	diskSpace();
	int err_cnt;
	int	i=1;
	int	initport = FALSE;
	int c, pmode;
	char *s, call[CALLLEN+1], *mak_alloc();
	char tline[LINELEN];  

	printf("\n\tROSErver/PRMBS: KA2BQE <br> RATS\n");

/*
	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( s = argv[0]+1; *s != '\0'; s++) {
			uc(argv[0]);
			switch (*s) {
			case 'M':
				multiuser++;
				pid = (int) *(s+1) & 0x07;
				break;
			}
		}
	}
*/
	if (strnicmp(argv[1],"-M",2) == 0) {
		multiuser++;
		pid = (int) argv[1][2] & 0x07;
		i = 2;
	}

  	init(argv[i]);


  /*--------------------------------------------------------------------*/

  while (TRUE) { /* main function loop */


    while (port->mode >= IDLE) { 
		switch(port->mode) {
		case	INPROCESS:		/* these need to be disconnected, but	*/
		case	EXCLUDE:		/* not logged out						*/
			distnc(port,EXCL_DISC);
			break;
		case	FORCED:			/* these were logged but forced off or	*/
		case	TIMEOUT:		/* or went bye bye all by themselves	*/
		case	DISCON:
			logout();
		case	IDLE:			/* this we ignore, and that covers the	*/
			break;				/* whole lot!							*/
		}
		waitcon();
/*
		rspace = ERROR;
*/
		err_cnt	= max_err;		/* init error counter counter */
		clear_parms();
		if (port->mode == INPROCESS) {
		
			while (getedit(err_string(MMDMLOG)) && !flds);
			
			if (flds) {
				strnxcat(call, pcall(fld[0]), CALLLEN);

				pmode = REMOTE;
				
				if (strcmp(ocall,call) == 0)
						pmode = SYSOP;
				
				port->type	&=	~P_ECHO; /* stop the echo for pwd */
				
				if (getedit(err_string(MMDMPWD))	&&
					login(port,call,fld[0],pmode)	)
					login_greet(port);

				port->type	|=	P_ECHO; /* restore echo */

			}
		}

    }
    
	if (ev_preempt && port->mode == REMOTE && time_for_event()) {
		prtx_err(MEVTIME);
		port->mode = FORCED;
		continue;
	}


	if (reply_flag)
		reply_to = oreply;
	else
		reply_to = NULL;
		
	if (smart_sys <= FALSE) {
		s = port->user->home_bbs;
		if ((*s != '\0') && (strl2cmp(thisHost,s) != 0))
			reply_to = s;	
	}
	
	if (disk_check(disk_full))
		prtx_err(MDFULL);

    dsp_status();

	if (smart_sys == ERROR) {
		sendnl();
	} else {
		if (no_bbs && !(port->user->options & U_PRIM_CON)) {
			prtx_err(MNOBBS);
			port->mode = FORCED;
			continue;
		}
	}
			
	
	if (port->mode == SYSOP) {
    	prtx(symenu);
	} else {
		if (smart_sys < FALSE) 
			prtx(rmenus);
		else
			outstr(">\n");
    }

	/****************************************************************
	 * The next construct must be followed carefully. It gets a line*
	 * and then tests for disconnect. If not it goes and tests first*
	 * to see if the line contains any remotely sent supervisory mes*
	 * sages, such as PRMBS at that point it checks trys it out as a*
	 * command.														*
	 *  The break is only issued to as successful command or an ap- *
	 * propriate supervisory message and it loops back and gets an-	*
	 * other line from the port and starts all over again.	|br|	*
 	 * redone by nn2z 4/22/87, and yet again by |br| 05/27/89       *										*
	 ****************************************************************/

	while (port->mode < IDLE) {			/* get a command line */

		break_in	= FALSE;
		if ( !getdat(tline, sizeof(tline)-1,port->timeout)) {
			if (break_in) {			/* was it break in by sysop ???? */
				otalk(port); 
			}
			break;
		}
/*
		if (*tline == ';')
			continue;
*/
		
		if ((sys_type = is_smart(tline)) == ERROR) { 
			if (docmd(tline) == ERROR) {
					/* no ERRORs from smart systems */
				if ((smart_sys != ERROR)					||	
					/* non-super-users get limited bad tries */
			    	((port->mode != SYSOP) && !err_cnt--)	 ) 
					port->mode = DISCON;
			
			} else {
				err_cnt	= max_err;		/* reset error counter counter */
			}
		} else {
			smart_sys = sys_type;
		}
		break;

	} /* command line get 	*/
  }   /* main function loop	*/
}

/*----------------------------------------------------------------------*/


/*
	close_ports() - shuts down TNCs and Modems
*/
close_ports(tp)
PORTS *tp;
{
	PORTS *pp, *was;
	was = port;
	
	for (pp = porthd; pp != NULL; pp = pp->next) {
		if (pp != tp) {
			if (pp->type & P_TNC) 
				device_cmds(pp,shutdown);
			if (pp->type & P_MDM)
				DTR_OFF(pp->idn);
		}
	}
	ioport(was);
		
}


/* 
	disk_check() - test disk space and set disk_full flag
*/	
disk_check(forced)
int forced;
{
    if (forced) {		/* re-calculate disk-space	*/
		d_s = (diskSpace(0) - (long) min_disk);
		disk_full 	= (d_s < 0);
    }
	return (disk_full);
}



/*
	done() - close up and log CONSOLE out,exit to operating system
*/
done(argc,argv)
int argc;
char **argv;
{
	if (port->mode == SYSOP)
		logout();
 	mb_exit(argc,argv);
}

/*
	event_init()- verifies and sets event timing parameters
*/
event_init(argc,argv)
int argc;
char **argv;
{
	/* do some checking to keep dum-dums in range !!! */

	int cycle;
	extern ev_preempt;
	char *status = "is not active!";

	char tline[LINELEN];
	
	if (argc > 3 && (cycle=atoi(argv[1])) >= 0 ) {
		event_cycle	= cycle;
		event_min	= atoi(argv[2]); 
		event_ofset	= atoi(argv[3]);
	}
	if (event_cycle) {
		sprintf(tline,"will occur at the %d minute every %d minutes\n  with a window of %d minute(s). This session WILL%sbe preempted.\n",
		event_min, event_cycle, event_ofset, ev_preempt ? " " : " NOT ");
		status = tline;
	}

	tprintf("\n System Event Processing %s\n",status);
	/* event_init */
}

/*
	login() - when we get a connect message or serial DCD do this
*/

login(pp,call,pwd,pmode)
PORTS *pp;
char *call, *pwd;
int pmode;
{
	register char *p, *q;
	extern char **hamcaltab, **servcaltab;
	int ptyp   = 0;
	int isham  = FALSE;
	int isothr = FALSE;
	char *tfld[8], *tail_ptr();
	char tline[LINELEN];
	char passwd[13], logcall[CALLLEN+1];

	USER_RECORD	*log_user;	/* use of this cuts down on pointer math! */
	
	log_user = pp->user;

	strnxcat(passwd,pwd,12);
	
	parse(cmd, call); 
	strnxcat(logcall,pcall(fld[0]),CALLLEN);	

	pp->mode = EXCLUDE;	/* default to EXCLUDE til proven otherwise */


	if (pp->type & (P_HAMCAL|P_OSRVCAL)) {
		while (TRUE) {
			if ((pp->type & P_HAMCAL)  && iscall(logcall,hamcaltab ))
					break;
			if ((pp->type & P_OSRVCAL) && iscall(logcall,servcaltab))
					break;			
			login_dump(4,MLOG1,'I',call);
			return (FALSE);
		}
	}

	if ((!open_sys && pp->type & (P_MDM|P_CONSOLE))	||
		pp->type & (P_BBS|P_REG)					){
		if (!lookup_usr(logcall,log_user)) {
			if (pp->type & P_BBS) {	/* is this a restricted BBS ONLY port?	*/
									/*  Check user is allowed to connect.	*/
				if ((log_user->options & (U_SYSOP|U_BBS|U_LOCAL)) == 0) {
					login_dump(4,MLOG3,'G',call);
				}
			} else {
				login_dump(4,MLOG2,'R',call);
			}
			return (FALSE);
		}
	} else {
		if (rduser(logcall, log_user)) {
			convtnc(1);
			docmd("HELP NEWUSER");
		}
	}
	if (log_user->options & U_EXCL) {		/* Check to see if he is excluded*/
		login_dump(4,FALSE,'E',call);
		return (FALSE);
	}

	if (pp->type & (P_MDM|P_CONSOLE)) {
		if (log_user->pswd[0] != '\0') {
		    if (stricmp(log_user->pswd,passwd) != 0 ) {
				login_dump(0,MLOG4,'P',call);
				return (FALSE);
			}
		}
	}
	
	
	log('C', port->id, ' ',call);
	pp->mode = pmode;
#ifndef NEEDSPACE
	set_msgfl(log_user->msg_fl);
#endif

	setlog_user(log_user->call);

	high_seq = log_user->msg_number; 	/* get high msg number read */
	rlock();
	highread = findmsg(high_seq);
	new_highread = highread;
	rulock();
	return (TRUE);
}

/*
	login_dump() - sequence to give a message to user just prior
				   to shit-canning him!
*/
login_dump(waitm,dmsg,lchar,lmsg)
int waitm, dmsg;
char lchar, *lmsg;
{
		if (dmsg) {
			convtnc(2);
			prtx_err(dmsg);
			wwait(waitm);
		}
		log('X',lchar, ' ',lmsg);
}


/* 
	login_greet() - greetings and new messages, etc to logged in user
*/
login_greet()
{
	sendnl();
	disk_check(TRUE);
	prtx(mprmbs);
	if (!(port->user->options & U_BBS)) 
		prtx_err((port->user->handle[0] == '\0') ? MGREETNEW : MGREETOLD );
	newmsg();
}



/*********************************************************************
 * logout() - say goodbye to the nice person and log it
 *********************************************************************/
logout()
{
	FILE *fdo_fil, *sysdir_open();
	USER_RECORD	*log_user;	/* use of this cuts down on pointer math! */
	
	char c = 'D';
		
	switch(port->mode) {
		case FORCED :
			c = 'F';
			break;
		case REMOTE :
		case SYSOP  :
			c = 'B';
			break;
		case TIMEOUT:
			c = 'T';  
			prtx_err(MTIME);
			break;
	}
	
	log('X', c, ' ', "");

	if ((port->type & P_BPQ_RET) && (c == 'B'))
		ret_to_node(port);
	else
		distnc(port,BYE_DISC);

	log_user = port->user;
	
	if (log_user->options & U_BBS && smart_sys != ERROR) {
		high_seq = mfhs->next_msg - 1;
		upduser(log_user);
		if (!time_for_event()) {
			if (fdo_fil = fopen(sys_name(log_user->call,"FDO"),"rt"))	{
				rs_evnt_strm(fdo_fil,"FDO",FALSE);
				fclose(fdo_fil);
			}
		}
		return;
	}
	upduser(log_user);
		

}


/*
	mb_exit() mailbox exit routine, shuts down all ports logs exit
*/
mb_exit(argc,argv)
int argc;
char **argv;
{
	char *err_lev	 = "0";

	close_ports(NULL);
	  

	if (argc > 1)
		err_lev = argv[1];

	log('S', 'Q', ' ', err_lev);	/* log system shutdown	*/

	exit(atoi(err_lev));			/* sayonara!		*/

}


/*
	waitcon() - waiting to see if we are loved and desired
*/
void
waitcon()
{
#define MDM ERROR

	register PORTS *pp;
	static int do_event = TRUE;

	int lmin, lhr;
	int immediate = FALSE;

	char tline[LINELEN];
	char c;

#ifndef NEEDSPACE
	set_msgfl("RS");

	if (lookup_usr(ocall, cport->user) == FALSE)
		fatal("No USER RECord for SYSOP\n"); 
#endif

			/* get sysops record in local port	*/
	lookup_usr(ocall, cport->user);
	
	while (TRUE) {
		bldfwd(tline);				/* set mail forward banner			*/

				/* send ONLINE commands to TNCs, raise DTR to MDM 	*/
		for (pp = porthd; pp != NULL ; pp = pp->next) {

			pp->mode = IDLE;

			if (!(pp->type & P_CONSOLE)) {
			
				setbaud(pp->idn,pp->baud);

				if (pp->type & P_TNC) 
					setfwd(pp,tline);

				device_cmds(pp,pp->online);
			}
		}
		while(TRUE) {
			clear_parms();	
			if (immediate || time_for_event()){
				if (do_event) {
					log('M','F','T',"");
					close_ports(NULL);
					setlog_user("DAEMON");
					parse_cmd(rs_event,"TIMED-EVENT");
					setlog_user("");
					do_event = FALSE;
					immediate = FALSE;
					break;
				}
			} else {
				do_event = TRUE;
			}

			/* Look for a connect. */
			for (pp = porthd; pp != NULL; pp = pp->next) {

				ioport(pp);
				
				if (pp->type & P_INACTIVE)		/*  ignore happenings on
													this port, may belong an-
													other process or just don't 
													want any inbound!
												*/
					continue;

				if (pp->type & P_TNC) {			/* handle TNC here */
					eatChars();
					if (iscon(NOWAIT)) {
						close_ports(pp);
						cmdtnc();
						device_cmds(pp,pp->conn);
						if ((tncstate(pp,tline))			&&
						 	login(pp,tline,"",REMOTE)		){
							convtnc(2);
							login_greet();
						}
						return;
					}
				}
				
				if (pp->type & P_MDM) {			/* handle Modem here         */
					if (havedcd(pp)) {
						close_ports(pp);
						wwait(1);				/* 	MUST give modem 2 seconds
													to settle, by Bell specs */
						eatChars();				/*  clean input to get login	 
													this will get Connect and
													baud rate message for use 
													later for auto baud      */
													
						pp->mode = INPROCESS;	/*  special case not logged in
													but have carrier and do not
													know who				 */
						return;
					} else {
						eatChars();  /* eat the modem RING message here */
					}
				}
				if (pp->type & P_CONSOLE) {		/* handle the console here */
					if (kbstat()) {
						c = bdos(7,0,0);
						if (c == CTRLL)
							kblok = ~kblok;
						if (!kblok) {
							pp->mode = SYSOP;
							switch(toupper(c)) {
							case ESC: 
								close_ports(pp);
								pp->mode = INPROCESS;
								return ;
							case 'X':
								parse_cmd(mb_exit,"X 100");

							case 'A':
								dos_cmd("dir a:");
								break;

							case '!':
								close_ports(pp);
								dos_cmd("");
								pp->mode = IDLE;
								return ;

							case 'K':
								docmd("LL -k 20");
								break;

							case 'L':
								docmd("LL 20");
								break;

							case 'M':
								docmd("LM -mn 1");
								break;

							case 'Q':
								immediate	= TRUE;
								do_event	= TRUE;
								break;

							case 'U':
								docmd("USERS");
								break;

							case 'W':
								docmd("WHO");
								prtx_err(MWINFO);
								break;

							case '?':
								prtx_err(MCONMEN);
								break;
							
							}
							pp->mode = IDLE;
						}
					}
				}
			}
			giveaway(4);
		}
	}
}

char *aloc_err(msgno)
int msgno;
{
	return(mak_alloc(err_string(msgno)));
}

/*********************************************************************
 * init() - actual system initialization - top level routine
 *********************************************************************/
init(cfname)
char *cfname;
{
	char tline[LINELEN];
	char tcmd[LINELEN];
	char *mak_alloc(), *q;
	extern int rsysp_len;
	extern char *rsys_pwd, *rdstrnl();
	extern char *user_con, pri_str[], *pri_strd;
	FILE *cfl, *tfil;
	PORTS *p = NULL;
	
	cmd		= (char *)   mballoc(CMDLEN);
	line	= (char *)   mballoc(LINELEN);
/*
	bbs_sys	= (BBSPRM *) mballoc(sizeof(BBSPRM));
*/
	user_con= (char *)	 mballoc((CALLLEN+4+10) * USRCONLEN);
	
	token_lin = line;
	  	

	if ((cfl = fopen(cfname, "rt")) == NULL) {
		printf("\n\7*** Cannot open %s\n",cfname);
		exit(2);
	}

	rdline(tline, LINELEN, cfl);	/* Eat Version line */
	
		/* read port structures in						*/
	while (TRUE) {
	
		if (rdport(cfl)) {
			if (p == NULL)
				porthd  = port; 
			else 
				p->next = port;
			p = port;
		} else {
			break;
		}
	} 
	
		/* read MailBox configuration information 		*/
	rdcnf(cfl);

	if (tfil = fopen(passwdf,"rt")) {
		rsysp_len 	= rdnumb(tfil) % 16;
		rsys_pwd	= rdstrnl(tfil);
		fclose(tfil);
	}

	aloc_mail();
	aloc_user();
		

	printf("\t\t%5u messages\n\t\t%5d users\n",
		msginit(), userinit());

	muinit();
		/* get sysop/system params from sysop's user record */

	lookup_usr(ocall,tuser);
	strcpy(ohandle,tuser->handle);
	strcpy(oqth,tuser->qth);
	strcpy(ozip,tuser->zip);
	strcpy(oreply,tuser->home_bbs);

	strcpy(h_loc_fil,sys_name(hlFIL,""));
	strcpy(xlat_fil,sys_name(xltFIL,""));

/*
	strcpy(msgfile,sys_name(msgfiln,""));
	msgflp = tail_ptr(msgfile) - 2;
*/

	if (rsysp_len)
		printf("\n\tRemote Sysop Password Installed\n");
	log('S', 'I', ' ', "");
	home_space(SET_HOME);

	disk_check(TRUE);
	ioport(cport);
	port->mode = SYSOP;

	mwhat	= aloc_err(MWHAT);
	mdone	= aloc_err(MDONE);
	mdupe	= aloc_err(MDUPE);
	mnend	= aloc_err(MNEND);
	mtorej	= aloc_err(MTOREJ);
	mnfind	= aloc_err(MNFIND);
	mlogin	= aloc_err(MMDMLOG);
	mpasswd	= aloc_err(MMDMPWD);
	mttl	= aloc_err(MTTL);
	mperm	= aloc_err(MPERM);
	mkilld	= aloc_err(MKILLD);
	mpasswd	= aloc_err(MMDMPWD);


	if (!rd_parse(tcmd,cfl) && strcmp(fld[0],"AUTO-EVENT") == 0)
		rs_evnt_strm(cfl,"AUTO-EVENT",FALSE);

	(void) fclose(cfl);		/* close CONFIG.RS file	*/

	port->mode = IDLE;
	strcpy(pri_str,pri_strd);

}



#ifndef NEEDSPACE
/*
	set_msgfl() - sets the name for the system message file
	
*/
set_msgfl(cp)
char *cp;
{
	strcpy(msgflp,cp);
	if (access(msgfile,0) == ERROR)
		strcpy(msgflp,"RS");
}
#endif

time_for_event()
{
	int now_time;

	if (event_cycle == 0)
		return(FALSE);
		
	curtim();

	now_time =	(((ctim->tm_hour * 60) + ctim->tm_min) % event_cycle);

	return (now_time >= event_min &&  now_time < (event_min + event_ofset));
}
