/****************************************************************************
 * From ka9q tcp/ip  and slight modified for PRMBS/ROSERVER. Modified to 
 * allow '*' in command table for 'port passing'
 * Parse command line, set up command arguments Unix-style, and call function.
 * Note: argument is modified (delimiters are overwritten with nulls)
 * Improved error handling by Brian Boesch of Stanford University
 ****************************************************************************/

int
cmdparse(cmds,helps,tlin)
struct cmds cmds[];
char *helps[];
char *tlin;
{
	struct cmds *cmdp;
	char *argv[NARG];
	char *p, *q, *r, *tcmd;
	int argc, clen, needlock;
	int rslt	= ERROR;
	
	tcmd = tlin;
	
	if (*tcmd == '#')	/* Lines beginning with "#" are comments */
		return (FALSE);

	if (argc = parse_line(argv,tcmd)) { /* argc==0 means empty command line */
	

		for (cmdp = cmds ; cmdp->name != NULLCHAR ; cmdp++) { /* ignore case */
			r = argv[0];	
	
			/* 
				special case for 'send message' disregards invalid Types 
				in essence it converts the type to ' ' to be determined
				by validation in sndmsg() process
			*/
			if ((clen = strlen(r)) == 2 		&& 
				*r == 'S' 						&& 
				strchr("TPBR",*(r+1)) == NULL	){
				*(r+1) = '\0';
			}
	
			if (strnicmp(argv[0],cmdp->name,clen) == 0 && 
				(port->mode & cmdp->privs)) {
				
					/* we have match - check for ambiguousity */
				if (clen != strlen(cmdp->name)) {
					cmdp++;
					if	(strl2cmp(cmdp->name,argv[0]) == 0 && 
						(port->mode & cmdp->privs)) {
						prtx_err(MUNIQ);
						return (ERROR);
					}
					cmdp--;
				}
					/*  not ambiguous, check for arg count if thats OK then
						execute command function and pray for the program!
					*/
				needlock = cmdp->needlock;
				
				if (argc >= cmdp->argcmin) {
					if (needlock > LKMSG) {
						prtx_err(needlock);
						return(0);
					}
					if (needlock)	/* need message file locking */
						rlock();			
					rslt = (*cmdp->func)(argc,argv);
					if (needlock)	/* lock and so shall ye unlock */
						rulock();
				} else {
					prtx_err(MFEWARG);
				}
				if (rslt == ERROR)
					tprintf("\7 *** usage: %s %s\n",
								cmdp->name, helps[cmdp->errmsg]);
				return(rslt);
			}
		}	/* main table search loop for command parse */
	}
	if (smart_sys == ERROR)
		prtx(mwhat);
	return (ERROR);
}

parse_line(argv,tlin)
char **argv, *tlin;
{
	register char *tline;
	char *cp, *tail_ptr();
	char *tline_end;
	extern char *eat_white();
	int argc;
	int	qflag	= FALSE;

	tline = tlin;		/* point to start of line		*/
	remnl(tline);		/* Remove cr/lf 				*/
	
	tline_end = tail_ptr(tline);
	

	for (argc = 0 ; argc < NARG ;) {

		argv[argc] = NULLCHAR;	/* initialize argument */
		if (*tline == '\0')
			break;

			/* Skip leading white space */
		tline = eat_white(tline);
			
			/* white space eaten, is anything left?? */
		if (*tline == '\0')
			break;

		qflag = FALSE;			/* clear quote flag					*/

		if (*tline == '"'){		/* Check for quoted token			*/
			tline++;			/* Suppress quote 					*/
			qflag = TRUE;
		}

		argv[argc++] = tline;	/* Beginning of token 				*/

			/*	Find terminating delimiter, if quote flag on look
				for quote, else look for 'white space' ( ' ' or '\t'
				end of line terminates in anycase
			*/
		if (qflag) {
			if (cp = strchr(tline,'"')) {	
				*cp++ = '\0';
				tline = cp;
			} else {
				tline = tline_end;
			}
		} else {
			if	((cp = strchr(tline,' ' ))	|| 
				 (cp = strchr(tline,'\t'))	){
				*cp++ = '\0';
				tline = cp;
			} else {
				tline = tline_end;
			}
			uc(argv[argc-1]);	/* upper case non-quoted arguments */
		}
	}
	return(argc);
}



#ifdef WHENWENEED

/* Call a subcommand based on the first token in an already-parsed line */
int
subcmd(tab,argc,argv)
struct cmds tab[];
int argc;
char *argv[];
{
	int rslt;
	register struct cmds *cmdp;

	/* Strip off first token and pass rest of line to subcommand */
	if (argc < 2) {
		if (argc < 1) 
			tprintf("SUBCMD - Don't know what to do?\r\n");
		 else 
			tprintf("\"%s\" - takes at least one argument\r\n",argv[0]);
		return -1;
	}
	argc--;
	argv++;
	for(cmdp = tab;cmdp->name != NULLCHAR;cmdp++){
		if(strl2cmp(cmdp->name,argv[0]) == 0){
			if(argc < cmdp->argcmin) {
				if (cmdp->errmsg != NULLCHAR)
					tprintf("Usage: %s\r\n",cmdp->errmsg);
				return -1;
			} else {
				strlwr(argv[0]);
				rslt = (*cmdp->func)(argc,argv);
				if ((rslt < 0) && (cmdp->errmsg != NULLCHAR))
					tprintf("%s\r\n",cmdp->errmsg);
				return(rslt);
			}
		}
	}
	if (cmdp->argc_errmsg != NULLCHAR) {
		tprintf("%s\r\n",cmdp->errmsg);
	}
	return -1;
}

#endif
