
/*****************************************************************
 *  RSSTATES.C  10/29/89
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for
 *  reasonable reimbursement for expense of delivery, to include
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *****************************************************************
 *  adapted to ROSERVER from 
 *****************************************************************
 *  STATES.C  5/14/89
 *  Makes a Hierarchical list from W9ZRX's bbs STATES file.
 *  Syntax < STATES [STATE.FILE] [COUNTRY] [CONTINENT] >
 *  Defaults are [LUSA0489.SRT] [USA] [NA].
 *  (C) 1989 by the CBBS Group
 *****************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <string.h>


#define LINELEN 256
#define CALLLEN 6
#define TRUE 1
#define FALSE 0

#include "rose_ver.c"

char buf[LINELEN];

char *infile 	= "LUSA1089.SRT";
char *outfile	= "H_LIST.RS";
char *contry 	= "USA";
char *contint	= "";

char *outmode	= "w";

main(argc, argv)
int argc;
char *argv[];
{
	FILE *in, *out;
	char call[11], call1[11], state[3], *s;
	int count, first;

	printf("  H-Route List Program - builds H-List from W9ZRX Format List\n");
	printf("  Compatible with ROSERVER ver %s %s,   ka2bqe <br> 9j29\n",
													version, mbdate); 
	printf("  (based on STATES.C, (c) 1989, by K3RLI and CBBS Group)\n");
	
	strupr(argv[1]);
	
	if ((argc == 1) || 
		(argc > 5)	||
		((*argv[1] != 'A') && (*argv[1] != 'W'))) {
		printf("\n\t\7usage: rsstates {A,W} [filename] [country] [continent]\n");
		printf("\n\t     A or W    (A)ppend or over(W)rite existing file");
		printf("\n\t     filename   name of inputfile (default %s)",infile);
		printf("\n\t     country    country to use    (default USA)");
		printf("\n\t     continent  insert continent  (default NONE)");
		printf("\n\t                (output to file H_LIST.RS)\n");
		exit(0);
	}
	
	if (*argv[1] = 'A')
		outmode = "at";
	else
		outmode = "wt";

	if (argc > 2)	
		infile	= argv[2];
	if (argc > 3)	
		contry	= strupr(argv[3]);
	if (argc > 4) {
		contint	= strupr(argv[4]);
		*(contint+2)	= '\0';	/* make sure its just two chars */
	}
	if ((in = fopen(infile, "rt")) == NULL) 	{
	  printf("Could not find input file - %s\n", infile);
	  exit(0);
	}

	if ((out = fopen(outfile, outmode)) == NULL) {
		printf("Could not open output file %s\n", outfile);
		exit(0);
	}
	count = 1;
	fill(call1, '\0', 11);
	fill(state, '\0', 3);
	first = TRUE;

	printf("\n");
	while(fgets(buf, LINELEN, in) != NULL) {
						 /* Buffer is not a CR. */
		if (buf[0] != '\n')
						 /* Must be a callsign. */
		if (isdigit(buf[2]) != 0)
						 /* No dups. 			*/
		if ((first) || (strncmp(call1, buf, CALLLEN) != 0)) {
			strncpy(state, buf+29, 2);
	    	strncpy(call1, buf, 10);
	    	pcall(call, call1);
			if (*contint)
		    	fprintf(out, "%s.%s.%s.%s\n", call, state, contry, strupr(contint));
			else
		    	fprintf(out, "%s.%s.%s\n", call, state, contry);
	    	printf("\tRecords read: %u\r", count);
	    	count++;
	     	first = FALSE;
	     }
	}
	printf("\n");

	fclose(in);
	fclose(out);

}

/*
 *  Fill memory with a character.
 */

fill(adr, ch, len)
char *adr;
char ch;
int len;
{
	while (len--) *adr++ = ch;
}

/*
 *  Parse a call. Blank pad the output field. Remove leading and
 *  trailing spaces and ssid.
 */

pcall(c,p)
char *c, *p;
{
	register short i;
	
	fill (c, '\0',(CALLLEN+1));
	while(*p && (*p == ' ')) p++;
	for (i = CALLLEN; i && *p; i--) {
	  if (*p == ' ') return;
	  if (*p == '-') return;
	  *c++ = *p++;
	}
}
