/*****************************************************************
 *  MSKLIBS.C Generalized Utility functions not using any
 *            gloabl variables, linkable in any module
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for
 *  reasonable reimbursement for expense of delivery, to include
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *****************************************************************/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <varargs.h>

#define TRUE	1
#define FALSE	0
#define LINELEN	256

#ifndef NULL
#define NULL 0
#endif

char *days[7] = {
    "Sun","Mon","Tue","Wed","Thu","Fri","Sat" };

char *months[12] = { 
		"Jan","Feb","Mar","Apr","May","Jun",
		"Jul","Aug","Sep","Oct","Nov","Dec" };


/*
	add2date() - add x number of days to a date in mmyydd format
*/
char *add2date(bdate,x)
char *bdate;
int x;
{
	int dtyr, dtmo, dtdy;
	static int montbl[13] = { 0,31,28,31,30,31,30,31,30,30,31,30,31 };
	static char newdate[7];


	sscanf(bdate,"%2d%2d%2d", &dtyr,  &dtmo, &dtdy);
	dtdy	+= (x % 365);  /* lets keep it realistic	*/
	
	while (dtdy > montbl[dtmo]) {
		dtdy	-= montbl[dtmo];
		dtmo++;
		if (dtmo > 12) {
			dtmo %= 12;
			dtyr ++;
			dtyr %= 100;
		}
	}
	sprintf(newdate,"%02d%02d%02d", dtyr, dtmo, dtdy);
	return(newdate);
}

/* Return Date/Time in Arpanet format in passed string */
char *arpadate(t)
time_t t;
{
	register struct tm *ltm;
	struct tm *gmtime();
	static char tz[4];
	static char str[64];
	time_t time();
	extern char *getenv();
	/* Print out the time and date field as
	 *		"DAY day MONTH year hh:mm:ss ZONE"
	 */

	char *p;


	/* Read the system time */

	ltm = localtime(&t);

	if (*tz == '\0')
		if ((p = getenv("TZ")) == NULL)
			strcpy(tz,"GMT");
		else
			strnxcat(tz,strupr(p),3);

	/* rfc 822 format */
	sprintf(str,"%s, %.2d %s %02d %02d:%02d:%02d %s",
		days[ltm->tm_wday],
		ltm->tm_mday,
		months[ltm->tm_mon],
		ltm->tm_year,
		ltm->tm_hour,
		ltm->tm_min,
		ltm->tm_sec,
		tz);
	return(str);
}

char *bbs_date(da)
char *da;
{
	static char dateline[9];
	
	sprintf(dateline,"%-2.2s-%-3.3s-%2.2s",
			da+4,months[(10 * (da[2] & 0x0f)) + (da[3] & 0x0f) - 1],da);
	return(dateline);
	
}	
unsigned atou(cp)
char *cp;
{
	unsigned x;
	if (!isdigit(*cp))
		return(0);
	sscanf(cp,"%u",&x);
	return(x);
}

char *chop_at(cp,c)
char *cp, c;
{
	char *p;
	
	if (p = strchr(cp,c)) 
		*p++ = '\0';
	return(p);
}
	

/*
	eat_line() - eats a file til it finds a line starting with char
*/
eat_line (buf,c,fptr)
char *buf, c;
FILE *fptr;
{
	char *fst;

	while (!rdline(buf,LINELEN,fptr)) {
		if (*buf == c)
			return (FALSE);
	}
	return (TRUE);
}

/*
	eat_white() - eats whitespace at strat of a string
*/
char *eat_white(cp)
char *cp;
{
	while (*cp && strchr(" \t",*cp))
		cp++;
	return(cp);
}

/********************************************************************
 * fill() - fills a space 'adr' of length  'l' with character 'ch'
 ********************************************************************/
fill(adr, ch, len)
char *adr;
char ch;
int len;

{
	while (len--) *adr++ = ch;
}

/********************************************************************
 * fil_xst() test for existance and return size.
 ********************************************************************/
long fil_xst(fname)
char	*fname;
{
  struct stat stbuf;

  if (stat(fname,&stbuf))
	 return(FALSE);
  return(stbuf.st_size);

}

/*
	fsplit() - split a line into array pointers. Each pointer wordv[i]
		points to the first character after the i'th occurence of c in
		buf. This, in essence sets pointer to the first char after each
		occurrence of the delimiter character and nulls out the delimiter.
		(<djt> from smail)
*/
fsplit(buf, c, ptr, maxargs)
register char *buf;		/* line to split up 		*/
char c;				/* character to split on	*/
char **ptr;			/* the resultant vector		*/
{
	int count = 0;
	int wasword = 0;

	for(; *buf && count < maxargs ; buf++) {
		if (!wasword) {
			count++;
			*ptr++ = buf;
		}
		if ( c == *buf ) {
			*buf = '\0';
			wasword = 0;
			while (*(buf+1) == c)	/* eat repeated adjacent delimiters */
				buf++;
		} else
			wasword = 1;
		
	}
	if (!wasword) {
		count++;
		*ptr++ = buf;
	}
	*ptr = NULL;
	return(count);
}

char *EOFstr = "*** EOF\n";

/********************************************************************
 * iseof() - test for '*** EOF' in config and fwd files
 ********************************************************************/
iseof(cp)
char *cp;
{
  return(stricmp(cp, EOFstr) == 0);
}

/*
	lc() - lowercase a string.
*/
/*
char *lc(p)
char *p;
{
	register char *q;

	for(q=p ; *q; q++)
		*q = tolower(*q);
	return(p);
}
*/

/*********************************************************************
 * ljsf() - copy from/to with left justify and blank padding trailer
 * all converted to upper case.
 *********************************************************************/

/*
ljsf(to, from, size)
register char *to;
register char *from;
int  size;
{
	short more;

	more = TRUE;
	for (; size != 0; size--) {
		if (more)
			more = (*from && (*from != '\n'));
		if (more) {
			*to++ = *from++;
		} else {
			*to++ = ' ';
		}
	}
}
*/

/*******************************************************
 * mballoc - calls alloc and checks for out of memory
 *******************************************************/
char *mballoc(n)
unsigned n;
{
	char *p;

	if ((p = malloc(n)) == NULL) {
		perror("\t\7 OUT of MEMORY ... Sayonara!\7");
		exit(7);
	}
	return(p);
}

/********************************************************************
 * not_num() - examines each char if anyone not digit, returns TRUE
 ********************************************************************/
not_num(cp)
char *cp;
{
	register char	*p;
	for (p = cp; *p; p++)
		if (!isdigit(*p))
			return (TRUE);
    return(FALSE);
}

/***************************************************************
 * passlst() - run out he list til you get next "*** EOF"
 ***************************************************************/
passlst(fptr)
FILE *fptr;
{
	char *fst;
	char tline[LINELEN];
		
	while ((fst = fgets(tline, LINELEN, fptr)) != NULL)
		if (iseof(tline))
			break;
} /* passlst */


/*
	prepend() - place a new string in front of an old string and leave
				in buffer of old string (maximum size LINELEN);
*/
prepend(new,old,maxlen)
char *new, *old;
int maxlen;
{
	char buf[2*LINELEN];
	
	sprintf(buf,"%s%s",new,old);
	strnxcat(old,buf,maxlen);
}

/*********************************************************************
 * rdline() - read a line or series discarding comments
 *********************************************************************/
rdline(cp,i,tfil)
FILE *tfil;
short i;
char *cp;
{
	char *fst, *p, *q;
 
	while (!feof(tfil)) {
  		if (((fst = fgets (cp, i, tfil)) == NULL) || (*cp == '#'))
			continue;
		if (*cp == '\\') 
			strcpy(cp,cp+1);
		return(FALSE);
	}
	return(TRUE);
}

/******************************************
 * remnl() - remove CR CRLF or LF
 ******************************************/
char *remnl(cp)
char *cp;
{
	char *p, *tail_ptr();
	
	p = tail_ptr(cp) - 1;
	while (*p == '\n' || *p == '\r') 
		*p-- = '\0';
	return(cp);
}

/*
	remove_trail_char() - finds last occurrence of char in string and
		replaces with null character
*/
remove_trail_char(cp,c)
char *cp, c;
{
	char *p;
	
	if (p = strrchr(cp,c))
		*p = '\0';
}


/*
	ssplit() - split a line into array pointers. Each pointer wordv[i]
		points to the first character after the i'th occurence of c in
		buf.  Note that each wordv[i] includes wordv[i+1]. This, in essence
		sets pointer to the first char of after each occurrence of the
		delimiter chracter without nulling the delimiter.
		(<djt> from smail)
*/

ssplit(buf, c, ptr)
register char *buf;		/* line to split up 		*/
char c;					/* character to split on	*/
char **ptr;				/* the resultant vector		*/
{
	int count = 0;
	int wasword = 0;

	for (; *buf; buf++) {
		if (!wasword) {
			count++;
			*ptr++ = buf;
		}
		wasword = (c != *buf);
    }
	if (!wasword) {
		count++;
		*ptr++ = buf;
	}
    *ptr = NULL;
    return(count);
}

/*
	strnxcat() - strncat with initial NULL
*/
strnxcat(dest,src,len)
char *dest, *src;
int len;
{
	*dest = '\0';
	strncat(dest,src,len);
}

/*
	strl2cmp() - strncmp-like where length is limited by length
	of cp2
*/
strl2cmp(cp1,cp2)
char *cp1,*cp2;
{
	return(strnicmp(cp1,cp2,strlen(cp2)));
}

/*
	tail_ptr() points to first char after a string 
*/
char *tail_ptr(cp)
char *cp;
{
	return(cp+strlen(cp));
}

/*
	uc() - Uppercase a string.
*/
/*
char *uc(p)
char *p;
{
	register char *q;

	for(q=p ; *q; q++)
		*q = toupper(*q);
	return(p);
}

*/

/*
	wildcard() - returns 0 or non-0 for presence of wildcard patterns (?,*)
*/
wildcard(cp)
char *cp;
{
		return( (int) strchr(cp,'*') || (int) strchr(cp,'?') );

}

/*
	wildmatch() - matches '?' in a match statement for discrete strings
		cp1 will be the 'wild string base' cp2 must conform to it
*/
wildmatch(cp1,cp2)
char *cp1, *cp2;
{
	int	not_null = FALSE;
		
	while (*cp1 && *cp2) {
		not_null++;
		if (*cp1 == '*')
			return (TRUE);
		if (*cp1 != *cp2 && *cp1 != '?') 
			return (FALSE);
		*cp1++;
		*cp2++;
	}
	return ((*cp1 == *cp2) || (not_null && *cp1 == '*'));
}

