#include "mb.h"
#include "rose_ver.c"
#include <dos.h>
#include <varargs.h>

#define	FREE -1

MAIL_HDR *mfhs;
MAIL_HDR *nfhs;
MSG_HDR  *mmhs;	

int compress    = 0;
int dohelp      = 0;
int fixer       = 0;
int init        = 0;
int killer      = 0;
int quik_renumb = 0;
int renumb      = 0;
int verbose     = 0;
char workfnam1[68];
char workfnam2[68];

long int strtno = 1L;

char l_time[5];
char l_date[7];
char *line;
char *mbfile;
char *msgdir = "mail";
char *typstr = NULL;

int next, nmfl, mfl;

main(argc,argv)
int argc;
char *argv[];
{

	char *p, *s, *msgname(), *arpadate();
	unsigned int kept, killed;
	unsigned bnumb, old_numb;
	int curhdr, curhdr2,i, exitval = 0;
	char tline[256];
	char oldname[64];
	char newname[64];

	int bypass = 0;
				
	printf("\n MAILWORK - ROSErver/PRMBS mail file compression");
	printf("\tver %s, %s\n",version,mbdate);

	if ( argc < 2) {
		fprintf(stderr," usage: mailwork [-?kv][-fir ##] [-c typstr] [mailfile] [msgdir]\n");
		fprintf(stderr,"   -c typstr - string with message types for compress - must be entered\n");
		fprintf(stderr,"   -f        - fix mail fileith \"read_rec()\" error\n");
		fprintf(stderr,"   -i        - initialize new mail file\n");
		fprintf(stderr,"   -k        - kill messages with no text file\n");
		fprintf(stderr,"   -v        - verbose mode (talking while you work!)\n");
		fprintf(stderr,"   mailfile  - name of the mail file - default: MAIL.DAT\n");
		fprintf(stderr,"   msgdir    - directory for message text files - default: MAIL\n");
		exit(1);
	}


	line 		= mballoc(LINELEN);
	mbfile		= mballoc(64);
	strcpy(mbfile,"mail.dat");
	
	mmhs = (MSG_HDR  *) mballoc(MAIL_RECSIZE);
	mfhs = (MAIL_HDR *) mballoc(MAIL_RECSIZE);
	nfhs = (MAIL_HDR *) mballoc(MAIL_RECSIZE);

		
	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( s = argv[0]+1; *s ; s++) {
			switch (tolower(*s)) {
			case 'c':
				typstr = argv[1];
				compress++;
				argc--;
				argv++;
				break;
			case 'f':
				fixer++;
				break;
			case 'i':
				init++;
				sscanf(argv[1],"%ld",&strtno);
				argc--;
				argv++;
				break;
			case 'k':
				killer++;
				break;
			case 'v':
				verbose++;
				break;
			case '?':
				dohelp++;
				break;


			}
		}
	}
	
	if (!(init || compress || fixer)) {
		printf(" mailwork: no action specified\7\n");
		exit(1);
	}

	switch (argc) {
	case 2:
		msgdir = argv[1];
	case 1:
		strcpy(mbfile,argv[0]);
		break;
	}

	curtim();	/* get time and date	*/

	/* fix munged mail file */
	
	if (fixer) {
		mbfixer(mbfile);
		exit(0);
	}

	/* initialize new mail file */

	if (init) {
		mbinit(mbfile,msgdir,
				"initialized - previous(if any) data file destroyed",strtno);
		exit(0);
	}

	/*
		for compress or renumber - prepare backup file names, open orginal
		file, get header record, prepare new header record, open work
		file
	*/
	
	strncpy(workfnam1,mbfile,63);
	if ((s = strchr(workfnam1,'.')) != NULL)
		*s = '\0';
	strcat(workfnam1,".$$");
	
	if ((mfl = open(mbfile, O_RDWR|O_BINARY)) < 0 ) {
		printf(" mailwork: ERR open %s\7\n",mbfile);
		exit(1);
	}
	read_rec(mfl, 0,(char *)mfhs);

	if ((int) mfhs->version != MFL_VERSN) {
		printf("\7 mailwork: wrong version mailfile\n\texpected ver %d found ver %d\7\n",
			MFL_VERSN, mfhs->version);
		exit(1);
	}
	

	if ((nmfl = open(workfnam1, O_CREAT|O_TRUNC|O_RDWR|O_BINARY, 
	                          S_IREAD|S_IWRITE)) < 0 ) {
		printf(" mailwork: ERR open %s\7\n",workfnam1);
		exit (1);	/* sayonara!						*/
	  }
	fill(nfhs,'\0',MAIL_RECSIZE);

	nfhs->last		= 0;
	nfhs->version 	= mfhs->version;
	
	if (mfhs->cr_date[0] == '\0') 
		strcpy(nfhs->cr_date,mfhs->date);
	else
		strcpy(nfhs->cr_date,mfhs->cr_date);
	
	strcpy(nfhs->up_date,mfhs->up_date);



	strcpy(nfhs->date, l_date);
	strcpy(nfhs->time, l_time);
	printf("\n");

	if (strtno < 1L)
		strtno = 1L;


	/* compress */

	if (compress) {
	
		if (typstr == NULL) {
			printf(" mailwork: type string must be explicitly specified\7\n");
			exit(1);
		}
		if (mfhs->next_msg == 0) {
			mfhs->next_msg  = (long) mfhs->next_msgo;
		} else {
			mfhs->next_msgo	= (unsigned) (mfhs->next_msg % 0xffff);
		}
		nfhs->next_msg 	= mfhs->next_msg;
		nfhs->next_msgo = mfhs->next_msgo;	
		write_rec(nmfl, 0, (char *)nfhs);

		kept  =  0;
		killed =  0;
		for (curhdr = 1 ; curhdr <= mfhs->last ; curhdr++) {
			read_rec(mfl,curhdr,(char *)mmhs);
			bypass = FALSE;
			if (*typstr != '\0' && *typstr != '*') {
				if (strchr(typstr,mmhs->type) == NULL)			
					if (mmhs->fprty != '$' || (strchr(typstr,'$') == NULL))
						bypass = TRUE;
			}
				
			if ((bypass == FALSE && mmhs->stat == 'K') || 
				(killer && (access(msgname(msgdir,mmhs->number),0) != 0)	)){
				killed++;
				if (mmhs->fprty != '$')
					unlink(msgname(msgdir,mmhs->number));
			} else {
				kept++;
				nfhs->last++;
				mmhs->rn 	= nfhs->last;
				if (verbose)
					printf("Msg #%06ld (from %4x to %4x)\n",
					  mmhs->number,curhdr,nfhs->last);		

				write_rec(nmfl,mmhs->rn,(char *)mmhs);
			}
			printf("\t...working ( kept: %5u   removed: %5u )\r",kept,killed);
		}
		printf("\n");
	}
	close(mfl);

	/*	
		get the last record and put 0 in its next field
       	for the case where last was killed record
    */

	write_rec(nmfl, 0, (char *)nfhs);	/* update header		*/
	close(nmfl);
	strncpy(workfnam2,mbfile,63);
	if ((s = strchr(workfnam2,'.')) != NULL)
		*s = '\0';
	
	strcat(workfnam2,".BAK");
	unlink(workfnam2);

	if ( rename(mbfile,workfnam2)) {
		printf("ERR rename of %s to %s failed\n",mbfile,workfnam2);
		exitval= 1;
	}

	if ( rename(workfnam1, mbfile)) {
		printf("ERR rename of %s to %s failed\n",workfnam1, mbfile);
		exitval= 1;
	}

	if (nfhs->last == 0) {		/* If there's no messages, start fresh */
		unlink(mbfile);
		mbinit(mbfile,"empty - destroy and re-initialize", nfhs->next_msg);		
	}
	printf("\n\t\7*** done\n");
	exit(exitval);
}
/*******************************************************************
 * msgname() - get name of file given its message number
 *******************************************************************/
char *msgname(msgd,nr)
char *msgd;
long int nr;
{
	static char buf[80];
	(void) sprintf(buf,"%s\\M_%06ld.MAI",msgd,nr);
	return (buf);
} /* msgname */


/*
	mbfixer() - fixe munged mail file prone to 'read_rec() errors
	
*/
mbfixer(mfname) 
char *mfname;
{

		if ((mfl = open(mfname, O_RDWR|O_BINARY)) < 0 ) {
			printf(" mailwork: ERR open %s\7\n",mfname);
			exit(1);
		}
		
		read_rec(mfl, 0, (char *)mfhs);	/* read header record to get count	*/

		if (mfhs->version != MFL_VERSN) {
			printf(" mailwork: wrong Mail File (%s) version!\7\n",mfname);
			printf("           found Ver %2d,expected Ver %2d\n",
				mfhs->version, MFL_VERSN);
			exit(1);
		}
		fill(mmhs,'\0',MAIL_RECSIZE);	/* zero the dummy record			*/
		
				/*  by writing a dummy record one past the last apparent
					record we can force the file size back to where it 
					should be plus 256 bytes ... no big FD!  <br>
				*/
				
		write_rec(mfl, mfhs->last+1, (char *)mmhs);

		close(mfl);


}

mbinit(mfname,msgd, cp,strtno) 
char *mfname, *msgd, *cp;
long int strtno;
{
		char tline[LINELEN];

		printf("\n\t\07%s %s\n",mfname, cp);
		mfl = open(mfname,O_CREAT|O_TRUNC|O_RDWR|O_BINARY, S_IREAD|S_IWRITE);
		
		fill(mfhs,'\0',MAIL_RECSIZE);	/* zero the record 			*/
		fill(mmhs,'\0',MAIL_RECSIZE);	/* zero the record 			*/
		write_rec(mfl, 0, (char *)mfhs);	/* write two blank records	*/
		write_rec(mfl, 1, (char *)mmhs);
		
		mfhs->last = 1;
		mfhs->next_msg = strtno+1;
		mfhs->version = MFL_VERSN;
		strcpy(mfhs->date, l_date);
		strcpy(mfhs->cr_date, l_date);
		strcpy(mfhs->time, l_time);
		write_rec(mfl, 0, (char *)mfhs);

		strcpy(mmhs->to,"SYSOP");
		strcpy(mmhs->from,"DAEMON");
		strcpy(mmhs->title,"System Mail File Started");
		strcpy(mmhs->date, l_date);
		strcpy(mmhs->time, l_time);
		sprintf(tline,"%s at %s on %s",mmhs->title, l_time, l_date);
		fappend(tline,msgname(msgd,strtno));
		mmhs->number = strtno;
		mmhs->stat = 'N';
		mmhs->type = 'P';
		mmhs->fprty= ' ';
		mmhs->rn   = 1;
		write_rec(mfl, 1, (char *)mmhs);

		close(mfl);


}

curtim()
{
 struct tm *cur_time;
 long ltime;
	time(&ltime);
	cur_time = localtime(&ltime);	
	(void) sprintf(l_time,"%02d%02d",cur_time->tm_hour,cur_time->tm_min);
	(void) sprintf(l_date,"%02d%02d%02d",cur_time->tm_year,cur_time->tm_mon+1,
			cur_time->tm_mday);
       		/* month returned by localtime is 0-11 */
}


/********************************************************************
 * read_rec() - read a record from an MB file
 ********************************************************************/
read_rec(fid, rec, buffer)
int fid;
int rec;
char buffer[];
{
  long lseek();
  long offs;
  int ret;

  offs = (long)rec * (long)MAIL_RECSIZE;
  if ( lseek(fid, offs, 0) == -1 ) {
	perror("lseek");
	exit(1);
  }
  ret = read(fid, buffer, MAIL_RECSIZE);
  if ( ret != MAIL_RECSIZE ) {
	printf("error read_rec 0x%x - expected %d bytes got %d bytes\7\n",
	rec,MAIL_RECSIZE,ret);
	exit(1);
  }
  return(0);
}

/********************************************************************
 * write_rec() - write a record to a MB file
 ********************************************************************/
write_rec(fid, rec, buffer)
int fid;
int rec;
char buffer[];
{
	long lseek();
	long offs, off_ret;

	offs = (long)rec * (long)MAIL_RECSIZE;
	off_ret = lseek(fid, offs, 0);
	if (offs != off_ret) {
		perror("lseek");
		printf("\n\n\7WRITE_REC - offset[%ld][%03x]\7\n",offs, rec);
		exit(1);
	}
  return (write(fid, buffer, MAIL_RECSIZE) == MAIL_RECSIZE);
}


/*******************************************************************
 * fappend() - append a string to a text file
 *******************************************************************/
 fappend(cp,fname)
 char *cp, *fname;
 {
	FILE *sfl;

	if ((sfl = fopen(fname,"at+")) == NULL ) 
		return (FALSE);

 	fprintf(sfl, "%s\n",cp);
    (void) fclose(sfl);
	return (TRUE);
 }


