/*****************************************************************
 * MBCMD.C - 11/13/86 - Command parser and dispatch.
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for
 *  reasonable reimbursement for expense of delivery, to include
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *****************************************************************/

#include "mb.h"
#include "cmdparse.h"


#define	 UHELPNULL	0 
#define	 UHELPRANG	1 
#define	 UHELPNUMB	2 
#define	 UHELPRMAI	3 
#define	 UHELPMAKE	4 
#define	 UHELPCALL	5 
#define	 UHELPCLHS	6 
#define	 UHELPHELP	7 
#define	 UHELPGETD	8 
#define	 UHELPDIST	9 
#define	 UHELPGETF	10 
#define	 UHELPFILE	11 
#define	 UHELPFILN	12 
#define	 UHELPFILS	13 
#define	 UHELPIDFL	14 
#define	 UHELPNFIL	15 
#define	 UHELPGETM	16 
#define	 UHELPEXPO	17 
#define	 UHELPTERM	18 
#define	 UHELPSCRP	19 
#define	 UHELPSWAP	20 
#define	 UHELPTOAT	21 
#define	 UHELPOMSG  22
#define	 UHELPSETM	23 
#define	 UHELPLIS1	24 
#define	 UHELPLIS2	25 
#define	 UHELPLIS3	26 
#define	 UHELPEVNT	27 
#define	 UHELPIMPO	28 
#define	 UHELPMAIL	29 
#define	 UHELPCLEN	30 
#define	 UHELPKILL	31 
#define	 UHELPKILD	32 
#define	 UHELPRMBO	33 
#define	 UHELPONOF	34 
#define	 UHELPPARM	35 
#define	 UHELPUORR	36 
#define	 UHELPGETQ	37
#define	 UHELPOCAL	38
#define	 UHELPUORS	39 
#define  UHELPLUC	40
#define  UHELPBAUD	41
#define  UHELPSETU  42
#define  UHELPSTTN  43
#define	 UHELPXLAT	44
#define	 UHELPCAL2	45 
#define	 UHELPUOR2	46 
#define  UHELPHOST  47
#define  UHELPNOMS  48
#define  UHELPCMPR  49
#define  UHELPNEWS  50
#define	 UHELPGTDB	51
#define	 UHELPCOPY	52
#define	 UHELPADR	53

extern int do_copy();
extern int event_init();
extern int sys_token();
extern int sys_msg();
extern int open_sys;
extern int chk_adr();
extern int list_user();
extern int print_log();
extern int print_who();
extern int fwd_type();
extern char *eat_white();

static struct cmds ucmds[] = {
	"@",		mksys,		0,	NOLOK,	UHELPNULL,		SYSOP+REMOTE,
	"?",		cmdlist,	0,	NOLOK,	UHELPUOR2,		SYSOP+REMOTE,
	"a@",		lstmsg,		2,  LKMSG,	UHELPSTTN,		EVENT+SYSOP,
	"a>",		lstmsg,		2,  LKMSG,	UHELPSTTN,		EVENT+SYSOP,
	"a<",		lstmsg,		2,  LKMSG,	UHELPSTTN,		EVENT+SYSOP,
	"address",	mkstring,	0,	NOLOK,	UHELPOCAL,		SYSOP+REMOTE,
	"archive",	lstmsg,		2,	LKMSG,	UHELPRANG,		EVENT+SYSOP,
	"bye",		logout,		0,	NOLOK,	UHELPNULL,		EVENT+SYSOP+REMOTE,
	"c",		lterm,		2,	NOLOK,  UHELPSCRP,		SYSOP,
	"c@",		lstmsg,		2,  LKMSG,	UHELPSTTN,		SYSOP+REMOTE,
	"c>",		lstmsg,		2,  LKMSG,	UHELPSTTN,		SYSOP+REMOTE,
	"c<",		lstmsg,		2,  LKMSG,	UHELPSTTN,		SYSOP+REMOTE,
	"chat",		utalk,		0,	NOLOK,	UHELPNULL,		REMOTE,
	"cmds",		cmdlist,	0,	NOLOK,	UHELPUORR,		REMOTE,
	"cmds",		cmdlist,	0,	NOLOK,	UHELPUORS,		SYSOP,
	"compress",	untmsg,		2,	NOLOK,	UHELPCMPR,		EVENT+SYSOP,
	"copy",		do_copy,	2,	NOLOK,	UHELPCOPY,		EVENT+SYSOP,
	"count",	lstmsg,		0,  LKMSG,	UHELPLIS3,		SYSOP+REMOTE,
	"cp",		lstmsg,		0,  LKMSG,	UHELPLIS3,		SYSOP+REMOTE,
	"cr",		lstmsg,		0,  LKMSG,	UHELPSTTN,		SYSOP,
	"d",		dnload,		2,	NOLOK,  UHELPFILN,		SYSOP+REMOTE,
	"da",		dnload,		2,	NOLOK,  UHELPFILE,		SYSOP+REMOTE,
/*
	"db",		dnload,		2,	NOLOK,  UHELPFILE,		SYSOP+REMOTE,
*/
	"dir",		mbDir,		0,	NOLOK,	UHELPNULL,		SYSOP+REMOTE,
	"distrib",	do_dist,	0,  LKMSG,	UHELPNULL,		EVENT+SYSOP,
#ifdef DOORWAY
	"door",		doDoors,	0,	NOLOK,	UHELPNULL,		SYSOP,
#endif
	"do",		rs_event,	0,	NOLOK,	UHELPEVNT,		EVENT+SYSOP,
	"dx",		dnload,		2,	NOLOK,  UHELPFILE,		SYSOP+REMOTE,
	"dy",		dnload,		2,	NOLOK,  UHELPFILE,		SYSOP+REMOTE,
	"dz",		dnload,		2,	NOLOK,  UHELPFILE,		SYSOP+REMOTE,
	"e",		lstmsg,		0,  LKMSG,	UHELPLIS3,		EVENT+SYSOP+REMOTE,
	"e@",		lstmsg,		0,  LKMSG,	UHELPSTTN,		EVENT+SYSOP,
	"e<",		lstmsg,		0,  LKMSG,	UHELPSTTN,		EVENT+SYSOP,
	"e>",		lstmsg,		0,  LKMSG,	UHELPSTTN,		EVENT+SYSOP,
	"el",		lstmsg,		0,  LKMSG,	UHELPLIS2,		EVENT+SYSOP+REMOTE,
	"ep",		lstmsg,		0,  LKMSG,	UHELPLIS3,		EVENT+SYSOP,
	"er",		lstmsg,		0,  LKMSG,	UHELPSTTN,		EVENT+SYSOP,
	"erase",	delfiles,	2,	NOLOK,	UHELPFILS,		EVENT+SYSOP,
	"event",	event_init,	0,	NOLOK,	UHELPEVNT,		EVENT+SYSOP,
	"exit",		done,		0,	NOLOK,	UHELPOMSG,		EVENT+SYSOP,
	"export",	export,		3,	LKMSG,	UHELPEXPO,		EVENT+SYSOP,
	"eu",		list_user,	0,	NOLOK,	UHELPCALL,		SYSOP,
	"f>",		reverse,	0,	LKMSG,	UHELPNULL,		REMOTE,
	"f@",		lstmsg,		2,  LKMSG,	UHELPSTTN,		EVENT+SYSOP,
	"f>",		lstmsg,		2,  LKMSG,	UHELPSTTN,		EVENT+SYSOP,
	"f<",		lstmsg,		2,  LKMSG,	UHELPSTTN,		EVENT+SYSOP,
	"file",		lstmsg,		2,	LKMSG,	UHELPRANG,		EVENT+SYSOP,
	"fileinfo",	fil_info,	0,	NOLOK,	UHELPNULL,		SYSOP+REMOTE,
	"finger",	make_req,	2,	LKMSG,	UHELPGETQ,		EVENT+SYSOP+REMOTE,
	"flood",	lstmsg,		0,	LKMSG,	UHELPLIS3,		EVENT+SYSOP,
	"fwd",		swap,		3,	LKMSG,	UHELPSWAP,		EVENT+SYSOP+FORWARD,
	"getbbs",	make_req,	3,	LKMSG,	UHELPGETD,		EVENT+SYSOP+REMOTE,
	"getdbf",	make_req,	3,	LKMSG,	UHELPGTDB,		EVENT+SYSOP+REMOTE,
	"getdig",	make_req,	3,	LKMSG,	UHELPGETD,		EVENT+SYSOP+REMOTE,
	"getdir",	make_req,	3,	LKMSG,	UHELPGETD,		EVENT+SYSOP+REMOTE,
	"getfile",	make_req,	3,	LKMSG,	UHELPGETF,		EVENT+SYSOP+REMOTE,
	"getlst",	make_req,	3,	LKMSG,	UHELPGETM,		EVENT+SYSOP+REMOTE,
	"getmsg",	make_req,	3,	LKMSG,	UHELPGETM,		EVENT+SYSOP+REMOTE,
	"getqth",	make_req,	3,	LKMSG,	UHELPGETQ,		EVENT+SYSOP+REMOTE,
	"getusr",	make_req,	3,	LKMSG,	UHELPGETQ,		EVENT+SYSOP+REMOTE,
	"getver",	make_req,	2,	LKMSG,	UHELPGETQ,		EVENT+SYSOP+REMOTE,
	"h",		do_help,	0,	NOLOK,	UHELPNULL,		EXCLUDE+SYSOP+REMOTE,
	"help",		do_help,	0,	NOLOK,	UHELPHELP,		EXCLUDE+SYSOP+REMOTE,
	"homebbs",	mkstring,	0,	NOLOK,	UHELPOCAL,		SYSOP+REMOTE,
	"import",	import_msgs,2,	LKMSG,	UHELPIMPO,		EVENT+SYSOP,
	"info",		list_user,	0,	NOLOK,	UHELPNULL,		SYSOP+REMOTE,
	"k",		multi_msg,	2,	LKMSG,	UHELPKILL,		EVENT+SYSOP+REMOTE,
	"k@",		lstmsg,		2,  LKMSG,	UHELPSTTN,		EVENT+SYSOP,
	"k>",		lstmsg,		2,  LKMSG,	UHELPSTTN,		EVENT+SYSOP+REMOTE,
	"k<",		lstmsg,		2,  LKMSG,	UHELPSTTN,		EVENT+SYSOP+REMOTE,
	"kl",		lstmsg,		0,  LKMSG,	UHELPLIS2,		EVENT+SYSOP+REMOTE,
	"km",		lstmsg,		0,	LKMSG,	UHELPRMBO,		EVENT+SYSOP+REMOTE,
	"kr",		lstmsg,		0,  LKMSG,	UHELPSTTN,		EVENT+SYSOP,
	"kt",		multi_msg,	2,	LKMSG,	UHELPKILL,		EVENT+SYSOP+REMOTE,
	"l",		lstmsg,		0,  LKMSG,	UHELPLIS3,		SYSOP+REMOTE,
	"l@",		lstmsg,		2,  LKMSG,	UHELPSTTN,		SYSOP+REMOTE,
	"l>",		lstmsg,		2,  LKMSG,	UHELPSTTN,		SYSOP+REMOTE,
	"l<",		lstmsg,		2,  LKMSG,	UHELPSTTN,		SYSOP+REMOTE,
	"lines",	mkstring,	0,	NOLOK,	UHELPNULL,		SYSOP+REMOTE,
	"list",		lstmsg,		0,  LKMSG,	UHELPLIS3,		SYSOP+REMOTE,
	"ll",		lstmsg,		0,  LKMSG,	UHELPLIS3,		SYSOP+REMOTE,
	"lm",		lstmsg,		0,  LKMSG,	UHELPLIS3,		SYSOP+REMOTE,
	"lp",		lstmsg,		0,  LKMSG,	UHELPLIS3,		SYSOP+REMOTE,
	"lr",		lstmsg,		0,  LKMSG,	UHELPSTTN,		SYSOP,
	"lt",		lstmsg,		0,  LKMSG,	UHELPLIS3,		SYSOP+REMOTE,
	"lu",		list_user,	0,	NOLOK,	UHELPCAL2,		SYSOP+REMOTE,
	"m",		mail,		0,	LKMSG,	UHELPMAIL,		SYSOP+REMOTE,
	"mail",		mail,		0,	LKMSG,	UHELPMAIL,		SYSOP+REMOTE,
    "make",		make_msg,	3,  LKMSG,	UHELPMAKE,		EVENT+SYSOP,
	"name",		mkstring,	0,	NOLOK,	UHELPNULL,		SYSOP+REMOTE,
	"password",	mkstring,	0,	NOLOK,	UHELPNULL,		SYSOP+REMOTE,
	"poll",		swap,		3,	LKMSG,	UHELPSWAP,		EVENT+SYSOP+FORWARD,
	"port",		port_dump,	3,	NOLOK,	UHELPIDFL,		EVENT+SYSOP,
	"push",		swap,		3,	LKMSG,	UHELPSWAP,		EVENT+SYSOP+FORWARD,
	"putfile",	make_msg,   3,	LKMSG,	UHELPGETF,		EVENT+SYSOP,
	"qth",		mkstring,	0,	NOLOK,	UHELPNULL,		SYSOP+REMOTE,
	"r",		multi_msg,	2,	LKMSG,	UHELPRANG,		SYSOP+REMOTE,
	"r>",		lstmsg,		2,  LKMSG,	UHELPSTTN,		SYSOP+REMOTE,
	"r<",		lstmsg,		2,  LKMSG,	UHELPSTTN,		SYSOP+REMOTE,
	"read",		multi_msg,	2,	LKMSG,	UHELPRANG,		SYSOP+REMOTE,
	"readnews",	readnews,	1,	LKMSG,	UHELPNEWS,		SYSOP+REMOTE,
	"reply",	snd_reply,	2,	LKMSG,	UHELPOMSG,		SYSOP+REMOTE,
	"rl",		lstmsg,		0,  LKMSG,	UHELPLIS2,		SYSOP+REMOTE,
	"rm",		lstmsg,		0,	LKMSG,	UHELPNULL,		SYSOP+REMOTE,
	"rmail",	mail,		2,	LKMSG,	UHELPRMAI,		SYSOP+REMOTE,
	"rn",		readnews,	1,	LKMSG,	UHELPNEWS,		SYSOP+REMOTE,
	"routes",	chk_adr,	2,	NOLOK,	UHELPADR,		SYSOP+REMOTE,
	"s",		sndmsg,		2,  LKMSG,	UHELPTOAT,		SYSOP+REMOTE+FORWARD,
	"sb",		sndmsg,		2,  LKMSG,	UHELPTOAT,		SYSOP+REMOTE+FORWARD,
/*
	"send",		sndmsg,		2,  LKMSG,	UHELPTOAT,		SYSOP+REMOTE+FORWARD,
*/
	"set",		usys_file,	2,	NOLOK,	UHELPSETU,		REMOTE,
	"set",		parm_chang, 1,	NOLOK,	UHELPPARM,		EVENT+SYSOP,
	"setbaud",	ch_baud,	3,	NOLOK,	UHELPBAUD,		EVENT+SYSOP,
	"setmsg",	mkstring,	0,	LKMSG,  UHELPSETM,		EVENT+SYSOP+REMOTE,
	"sp",		sndmsg,		2,  LKMSG,	UHELPTOAT,		SYSOP+REMOTE+FORWARD,
	"sr",		snd_reply,	2,	LKMSG,	UHELPOMSG,		SYSOP+REMOTE,
	"st",		sndmsg,		2,  LKMSG,	UHELPTOAT,		SYSOP+REMOTE+FORWARD,
	"status",	stats,		0,  LKMSG,	UHELPNULL,		EVENT+SYSOP+REMOTE,
	"swap",		swap,		3,	LKMSG,	UHELPSWAP,		EVENT+SYSOP+FORWARD,
#ifndef NEEDSPACE
	"sysmsg",	sys_msg,	2,	NOLOK,  UHELPNULL,		EVENT+SYSOP,
	"system",	sys_token,	2,	NOLOK,  UHELPNULL,		EVENT+SYSOP,
#endif
	"telephone",mkstring,	0,	NOLOK,	UHELPNULL,		SYSOP+REMOTE,
	"terminal",	lterm,		2,	NOLOK,  UHELPTERM,		SYSOP,
	"time",		stats,		0,	MARPD,	UHELPNULL,		EVENT+SYSOP+REMOTE,
	"translate",multi_msg,	2,  LKMSG,	UHELPRANG,		EVENT+SYSOP,
    "typeprty",	fwd_type,	0,  NOLOK,	UHELPNULL,		EVENT+SYSOP,
	"u",		upload,		2,	NOLOK,	UHELPFILE,		SYSOP+REMOTE,
	"users",	print_log,	0,	NOLOK,  UHELPNULL,		SYSOP+REMOTE,
	"ux",		upload,		2,	NOLOK,  UHELPFILE,		SYSOP+REMOTE,
	"uxc",		upload,		2,	NOLOK,  UHELPFILE,		SYSOP+REMOTE,
	"uy",		upload,		2,	NOLOK,  UHELPFILE,		SYSOP+REMOTE,
	"uz",		upload,		2,	NOLOK,  UHELPFILE,		SYSOP+REMOTE,
	"v",		multi_msg,	2,	LKMSG,	UHELPRANG,		SYSOP+REMOTE,
	"v>",		lstmsg,		2,  LKMSG,	UHELPSTTN,		SYSOP+REMOTE,
	"v<",		lstmsg,		2,  LKMSG,	UHELPSTTN,		SYSOP+REMOTE,
	"vl",		lstmsg,		0,  LKMSG,	UHELPLIS2,		SYSOP+REMOTE,
	"vm",		lstmsg,		0,	LKMSG,	UHELPNULL,		SYSOP+REMOTE,
	"ver",		stats,		0,	MROSVER,UHELPNULL,		EVENT+SYSOP+REMOTE,
	"view",		multi_msg,	0,	LKMSG,	UHELPRANG,		SYSOP+REMOTE,
	"who",		print_who,	0,	NOLOK,  UHELPNULL,		SYSOP+REMOTE,
	"x",		done,		0,	NOLOK,	UHELPOMSG,		EVENT+SYSOP,
	"zip",		mkstring,	0,	NOLOK,	UHELPNULL,		SYSOP+REMOTE,
	NULLCHAR,	NULLFP,		0,	FALSE,	UHELPNULL,		0
};


char *uhelps[] = {
	/* UHELPNULL (00) */	"",
	/* UHELPRANG (01) */	"[-bdhiklmnoprstxz$] ALL | BACK | # [# #-# ... #]",
	/* UHELPNUMB (02) */	"###",
	/* UHELPRMAI (03) */	"@bbs addr [addr .. addr]",
	/* UHELPMAKE (04) */	"infile addr \"title\"",
	/* UHELPCALL (05) */	"call",
	/* UHELPCLHS (06) */	"call[,call....,call] fromhost",
	/* UHELPX_FT (07) */	"subject",
	/* UHELPGETD (08) */	"dir host",
	/* UHELPDIST (09) */	"",
	/* UHELPGETF (10) */	"file addr",
	/* UHELPFILE (11) */	"filename",
	/* UHELPFILN (12) */	"[- ###] filename",
	/* UHELPFILS (13) */	"files",
	/* UHELPIDFL (14) */	"port filename",
	/* UHELPNFIL (15) */	"### filename",
	/* UHELPGETM (16) */	"### [,###,...###] fromhost",	
	/* UHELPEXPO (17) */	"outfile route1 [route2 route3 .... route#]",
	/* UHELPTERM (18) */	"port [filename]",
	/* UHELPSCRP (19) */	"portscr call [filename]",
	/* UHELPSWAP (20) */	"portscr destcall call [call call ... call",
	/* UHELPTOAT (21) */	"tocall @ bbscall",
	/* UHELPOMSG (22) */	"[###]",
	/* UHELPSETM (23) */	"[ top | ###]",
	/* UHELPLIS1 (24) */	"[-bdhiklmnoprstxz$] [call] [optional range]",
	/* UHELPLIS2 (25) */	"[-bdhiklmnoprstxz$] [number of messages]",
	/* UHELPLIS3 (26) */	"[-bdhiklmnoprstxz$] [optional range]",
	/* UHELPEVNT (27) */	"cycle min offs",
	/* UHELPIMPO (28) */	"[-i] inpfile [inpfile inpfile .. inpfile]",
	/* UHELPMAIL (29) */	"[-n] [addr .. addr]",
	/* UHELPCLEN (30) */	"",
	/* UHELPKILL (31) */	"[-zpbm] ALL | BACK | # [# #-# ... #]",
	/* UHELPKILD (32) */	"[-z] ###",
	/* UHELPRMBO (33) */	"[-z]",
	/* UHELPPONG (34) */	"",
	/* UHELPPARM (35) */	"parameter [on | off | ##]",
	/* UHELPUORR (36) */	"[command spec]",
	/* UHELPGETQ (37) */	"call [\"call,call,...call\"] fromhost",
	/* UHELPOCAL (38) */	"call [call,call,...call]",
	/* UHELPUORS (39) */	"[-u|-s|-e] [command spec]",
	/* UHELPLUC  (40) */	"[-s|-l|-b|-e|-m|call]",
	/* UHELPBAUD (41) */	"port baudrate",
	/* UHELPSETU (42) */	"[translate | signature | finger]",
	/* UHELPSTTN (43) */	"string [-bdhklmnoprstxz] [optional range]",
	/* UHELPXLAT (44) */	"[call] [optional range]",
	/* UHELPCALO (45) */	"[call]",
	/* UHELPUOR2 (46) */	"[command spec | ALL]",
	/* UHELPHOST (47) */	"host",
	/* UHELPNOMS (48) */	" - Command Failure or Syntax Error see HELP",
	/* UHELPCMPR (49) */	"typestring",
	/* UHELPNEWS (50) */	"[-dhiklnorsx] [-# ALL|BACK|#|#-#] subject [subject...subject]",
	/* UHELPGTDB (51) */	"\"commands to DBSERV\" fromhost",
	/* UHELPCOPY (52) */	"fromfile [tofile]",
	/* UHELPADR	 (53) */	"bbscall [bbscall bbscall ..... bbscall]"
};


char *passwdf;
short rsysp_len = 0;
char *rsys_pwd;
int	pong_max = 4;
int chatmode;

#define EVNTLINE	128



/***********************************
 * docmd - main command processor
 ***********************************/
docmd(cmdbuf)
char *cmdbuf;
{
	int cmpdparse();
	int ret = FALSE;

	char tline[LINELEN];
	char *cp;
	int back_online = FALSE;
	
	strcpy(tline,cmdbuf);
	

	cp 			= tline;
	token_lin	= cmdbuf;
	
			/*
				if this user marked for profile, record his action
			*/

	if (port->user->options & U_PROFILE)
		fappend(fmt_token("$D/$T [$S]"),usr_name(port->user->call,"PRF"));
	
	if (*cp == '%') {
		cp++;
		back_online = TRUE;
	}

		
	if (*cp == '!') {
			/* DOS command from console - local console only command */
		if ((port->mode & (SYSOP+EVENT)) && (port->type & P_CONSOLE)) 
			dos_cmd(cp+1);
	} else {
		ret = cmdparse(ucmds,uhelps,cp);
	}
	
	if (ret != ERROR && back_online)
		port->mode = DISCON;

	return (ret);
}

#ifndef NEEDSPACE
sys_msg(argc,argv)
int argc;
char **argv;
{
	prtx_err(atoi(argv[1]));
}	

sys_token(argc,argv)
int argc;
char **argv;
{
	char *fmt_token();
	
	docmd(fmt_token(argv[1]));
}	
#endif

/*
	cmdlist() - displays all commands
*/
cmdlist(argc, argv)
int argc;
char **argv;
{

	char *p;
	register struct cmds *cmdp;

	int i,j;
	int mode, lines, menumd;

	int found = FALSE;
	int tmode = 0;
	
	lines = port->user->lines;
	
	if (menumd = (*argv[0] == '?')) {
		if (argc == 1)
			menumd = FALSE;
		else
			if (stricmp(argv[1],"all") == 0) 
				argc = 1;
	}
	
	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( p = argv[0]+1; *p != '\0'; p++) {
			switch(*p) {
			case 'E':
				tmode = EVENT;
				break;
			case 'U':
				tmode = REMOTE;
				break;
			}
		}
	}
    if (((mode = port->mode) != REMOTE) && tmode)
    	mode = tmode;

#ifndef NEEDSPACE
	tprintf("\nAvailable commands: %s\n\n",(argc) ? lc(argv[0]) : "");
#endif
	
	for (i=0, cmdp = ucmds ; cmdp->name != NULL ; cmdp++){
		if (abort_dl())
			break;
			
		if ((mode & cmdp->privs) 							&& 
			(!argc || wildmatch(lc(argv[0]), cmdp->name))	){
			tprintf("  %-10.10s",cmdp->name);
			found++;
			if (menumd) {
				if (paging(&lines, found, (smart_sys == ERROR)))
					break;
				tprintf(" %s\n", uhelps[cmdp->errmsg]);
			} else {
				if ((i % 6) == 5) {
					sendnl();
				} 
				i++;
			}
		}
	}
	if (!found)
		prtx_err(MFIND);
	sendnl();
}


/*
	delfiles() - sysop delete fil commands
*/
delfiles(argc,argv)
int argc;
char **argv;
{
	int i;
	for ( i = 1 ; i < argc ; i++ ) {
		token_lin = argv[i];
		if (unlink(argv[i]))
			prtx_err(MNODEL);
		else
			prtx_err(MFLDEL);
	}
	disk_full	= TRUE;	/* 	to force disk space re-compute. */
	return(0);
}

/*
	rs_event() - event scheduling procedure
*/
rs_event(argc,argv)
int argc;
char **argv;
{
	PORTS 	*was;
	FILE 	*evfl;
	char 	*p, *fname, *label;
	short	onebbs;
	short	igtime  = FALSE;
	int		save_mode;
	
	label = argv[0];

	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( p = argv[0]+1; *p != '\0'; p++) {
			switch(*p) {
			case 'I':
				igtime++;
				break;
			}
		}
	}
	
	if (argc)							/* determine which event file	*/
		fname  = argv[0];				/* user designated				*/
	else
		fname = sys_name(event_fil,"");	/* default name from config file*/
		
	if (evfl = sys_open(fname, "rt")) {	/* open the chosen event file	*/

		save_mode	= port->mode;		/* save the port mode			*/
		was 		= port;				/* save current port pointer	*/

		rs_evnt_strm(evfl, label, igtime);	/* process open event stream	*/
		fclose(evfl);					/* close the event file			*/
		disk_full = TRUE;				/* force disk space re-comp		*/

		port		= was;				/* return from whence we came	*/
		port->mode = save_mode;
					
	}
	
	return(0);
					
} /* event */

/*
	rs_evnt_strm() - given a stream and an ignore time flag, process
					 an open event file
*/

rs_evnt_strm(tfil,label,igtime)
FILE *tfil;
int igtime;
char *label;
{

	char 	*comnd, ev_line[LINELEN];
	int	exec_flag;
	
	while (!rdline(ev_line,LINELEN, tfil) && !abort_dl()) {

		ioport(cport);
		curtim();
		printf("\n%s (%4.4sz) %s",label,l_time,ev_line);
		comnd = ev_line;
		exec_flag = TRUE;
		if (*comnd == '(') {
			exec_flag	= (igtime || chktime(comnd+1));
			comnd = eat_white(comnd+7);
		}
		if (*comnd == '>') {
			uc(comnd);
			if (exec_flag)
				dopar(tfil,*++comnd);
			else
				passlst(tfil);
		} else {
			if (exec_flag) {
				port->mode = EVENT;
				docmd(comnd);
			}
		}
	}

}

/****************************************************************
 * findport() - find port structure for pid
 ****************************************************************/
PORTS *findport(portid)
char portid;
{
	PORTS *p;

	for (p = porthd; p != NULL; p = p->next) {
		if (p->id == portid) 
			return(p);
	}
		/* 
			If specific port not found, return first BPQ port 
			structure pointer
		*/
	if (qport)
		return(qport);
	
	prtx_err(MPORTNF);
	return (NULL);
}

/*
	mksys() - toggles port->mode & SYSOP
*/
mksys()
{
	
	if (port->user->options & U_SYSOP)	{
		switch (port->mode) {
		case SYSOP:
			port->mode = REMOTE;
			if (port->type & P_TNC) {
				device_cmds(port,tncrem);
				convtnc(1);
			}
			break;
		
		case REMOTE:
			if (port->type & P_TNC) 
				if (rsysp_len)
					if (check_pwd(rsys_pwd,rsysp_len) == FALSE)
						return(ERROR);

			port->mode = SYSOP;
			if (port->type & P_TNC) {
				device_cmds(port,tncsys);
				convtnc(1);
			}
				break;
		}
	} else {
		return(ERROR);
	}
}

extern int chatmode, alow_bell;

/*
	stats() - show system info statistics
*/
stats()
{
	prtx_err(MSTATS);
	parse_cmd(event_init,"EVENT");	/* display event cycle parameters */
}


char *setcomnds[] = {	"AUTOFLOOD",	/* 00 */
						"BELL",			/* 01 */
						"CHAT",			/* 02 */
						"COLOR",		/* 03 */
						"EVENTPREEMPT",	/* 04 */
						"FORCETYPE",	/* 05 */
						"FORCETRAFFIC",	/* 06 */
						"FORWARDKILL",  /* 07 */
						"HOLDLOCAL",	/* 08 */
						"HOLDMAIL",  	/* 09 */
						"HOLDSYSOPMAIL",/* 10 */
						"LOGGING",		/* 11 */
						"LOGMSGSONLY",	/* 12 */
						"LOGLOCAL",		/* 13 */
						"LONGIHEADER",	/* 14 */
						"NOBBSCONNECTS",/* 15 */
						"OPENLOGIN",	/* 16 */
						"REPLYTO",		/* 17 */
						"BULLEXPIRE",	/* 18 */
						"MAXERROR",		/* 19 */
						"MAXFCOUNT",	/* 20 */
						"MAXFSIZE",		/* 21 */
						"MINDISKSIZE",	/* 22 */
						"PONGMAX",		/* 23 */
						"REQFILMAX",	/* 24 */
						""};			/* 25 */
#define PARMCHANG1	17						
#define PARMCHANG2	PARMCHANG1 + 1
						
parm_chang(argc,argv)
int argc;
char **argv;
{
	int *parm, i;
	extern int loopval, max_err;
	extern int logging, logmsgsonly, loglocal, holdsysopmail;
	extern int reqFilSiz;
	extern int reply_flag, bull_exp, longiheader, ev_preempt, no_bbs;
	extern int fwd_kill, hold_local, hold_mail, force_traf;
	extern int max_fwd_cnt;
	extern int max_fwd_size;
	
	int j = 0;
	char *p = NULL;
	
	
 	while (*setcomnds[j]) {
 		if (abort_dl())
 			return(0);
 			
		switch (j) {
		case 0:
			parm = &fldopt;
			break;		
		case 1:
			parm = &alow_bell;
			break;
		case 2:
			parm = &chatmode;
			break;
		case 3:
			parm = &color;
			break;
		case 4:
			parm = &ev_preempt;
			break;
		case 5:
			parm = &sendtype;
			break;		
		case 6:
			parm = &force_traf;
			break;		
		case 7:
			parm = &fwd_kill;
			break;		
		case 8:
			parm = &hold_local;
			break;		
		case 9:
			parm = &hold_mail;
			break;		
		case 10:
			parm = &holdsysopmail;
			break;		
		case 11:
			parm = &logging;
			break;		
		case 12:
			parm = &logmsgsonly;
			break;		
		case 13:
			parm = &loglocal;
			break;		
		case 14:
			parm = &longiheader;
			break;		
		case 15:
			parm = &no_bbs;
			break;
		case 16:
			parm = &open_sys;
			break;		
		case 17:
			parm = &reply_flag;
			break;
					
		/* change from T/F to values */

		case 18:
			parm = &bull_exp;
			break;		
		case 19:
			parm = &max_err;
			break;		
		case 20:
			parm = &max_fwd_cnt;
			break;		
		case 21:
			parm = &max_fwd_size;
			break;		
		case 22:
			parm = &min_disk;
			break;		
		case 23:
			parm = &pong_max;
			break;		
		case 24:
			parm = &reqFilSiz;
			break;		
		}
	
		if (argc < 2) {
			tprintf("    %-13s ( ",setcomnds[j]);
			if (j < PARMCHANG2) {
					outstr(*parm ? "  ON )" : " OFF )");
			} else {
				tprintf("%4d )",*parm);
			}
			if (j%2 == 1)
				sendnl();
		} else {
			if (strl2cmp(setcomnds[j],argv[1]) == 0) {
				p = setcomnds[j];
				break;
			}
		}
		j++;
	}
	
	if (p == NULL) {
		if (j%2 == 1)
			sendnl();
		return (argc == 1 ? 0 : ERROR);	
	}	

	tprintf(" %s ",p);
	
	if (j > PARMCHANG1) {
		if (argc > 2) {
			tprintf("was %d ",*parm);
			i = atoi(argv[2]);
			*parm = i;
		}
		tprintf("is now %d\n",*parm);
	} else {
		if ( argc > 2 ) {
			tprintf("was %s ", *parm ? "ON" : "OFF");
			if ( stricmp(argv[2],"on") == 0 ) {
				*parm = 1;
			} else {
				if ( stricmp(argv[2],"off") == 0 ) {
					*parm = 0;
				} else {
					return(ERROR);
				}
			}
		}
		tprintf("is now %s\n", *parm ? "ON" : "OFF");
	}
	return(0);
}

ch_baud(argc,argv)
int argc;
char **argv;
{
	PORTS *pp;

	if (pp = findport(*argv[1])) {
		if (setbaud(pp->idn,atou(argv[2]))) {
			return(0);
		} else {
			prtx_err(MINVBD);
		}
	}

	return(ERROR);
	
}

#include "cmdparse.c"
