/* Copyright (C) 1999 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef KEYBOARD_FUNCS_H
#define KEYBOARD_FUNCS_H

#include <unistd.h>
#include <iostream.h>
#include <iomanip.h>
#include <strstream.h>
#include <fstream.h>
#include <ncurses.h>
// we don't want to use the 'clear' macro in ncurses.h - it will interfere with iostream::clear()
#undef clear
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <stdio.h>
#include "tnc.h"
#include "screen.h"
#include "buffers.h"
#include "filesend.h"
#include "prog_defs.h"
#include "pipes.h"

typedef unsigned char uchar;

extern Prog_func prog_func;

class Keyboard_input_with_data;
class Autocq_query;
class Send_message_query;
class Openfile;
class Input_command;
class Connect;
class Send_parms_query;
class Keyboard_controller;

class Keyboard_funcs {
public:
    enum Running_flag{not_running, running};
private:
    ifstream message_file;
    ifstream script_file;
    ifstream parm_file;
    Running_flag connect_script_flag;
    Running_flag send_parms_flag;
    MainScreen* mainscreen_ptr;
    SendWin* sendwin_ptr;
    ReceiveWin* receivewin_ptr;
    DList<Screen>* screenform_ptr;
    Transmit_buffer* tr_buffer_ptr;
    Tnc* tnc_ptr;
    BufferList* buffer_list_ptr;
    char wordwrap_buffer[WORDWRAP + 1];
    int wordwrap_buffer_count;
    int line_lettercount;
    int space_flag;
    struct{int port, stream;} upload_stream;

    void send_message(char);
    void run_connect_script(const char* script = 0);
    void send_parms(const char* file = 0);
    int wordwrap_buffer_add(uchar); // returns letter added, or -1 if tr_buffer full (or we are
                                    // at beginning of a line after a backspace entered)
    void flush_wordwrap_buffer(void);
public:
    friend Keyboard_input_with_data;
    friend Send_message_query;
    friend Input_command;
    friend Connect;
    friend Send_parms_query;
    friend Keyboard_controller;
    Keyboard_funcs(void): connect_script_flag(not_running), send_parms_flag(not_running),
      wordwrap_buffer_count(0), line_lettercount(0), space_flag(FALSE) {}
};

#endif


