/*
 * The Linux BAYCOM driver for the Baycom serial 1200 baud modem
 * and the parallel 9600 baud modem
 * (C) 1996 by Thomas Sailer, HB9JNX
 */

#ifndef _BAYCOM_H
#define _BAYCOM_H

/* -------------------------------------------------------------------- */

/* first number from the experimental range */
#define BAYCOM_MAJOR 		60	

/* maximum packet length, excluding CRC */
#define BAYCOM_MAXFLEN 		400	

#define KISS_FEND   ((unsigned char)0300)
#define KISS_FESC   ((unsigned char)0333)
#define KISS_TFEND  ((unsigned char)0334)
#define KISS_TFESC  ((unsigned char)0335)

#define KISS_CMD_DATA       0
#define KISS_CMD_TXDELAY    1
#define KISS_CMD_PPERSIST   2
#define KISS_CMD_SLOTTIME   3
#define KISS_CMD_TXTAIL     4
#define KISS_CMD_FULLDUP    5

/*
 * modem types
 */

#define BAYCOM_MODEM_INVALID 0
#define BAYCOM_MODEM_SER12   1
#define BAYCOM_MODEM_PAR96   2

/*
 * modem options; bit mask
 */
#define BAYCOM_OPTIONS_SOFTDCD  1


/*
 * ioctl constants
 */
#define BAYCOMCTL_BASE      0x310500

#define BAYCOMCTL_GETPACKET        (BAYCOMCTL_BASE)
#define BAYCOMCTL_SENDPACKET       (BAYCOMCTL_BASE+1)
#define BAYCOMCTL_GETDCD           (BAYCOMCTL_BASE+2)
#define BAYCOMCTL_GETPTT           (BAYCOMCTL_BASE+3)
#define BAYCOMCTL_PARAM_TXDELAY    (BAYCOMCTL_BASE+4)
#define BAYCOMCTL_PARAM_PPERSIST   (BAYCOMCTL_BASE+5)
#define BAYCOMCTL_PARAM_SLOTTIME   (BAYCOMCTL_BASE+6)
#define BAYCOMCTL_PARAM_TXTAIL     (BAYCOMCTL_BASE+7)
#define BAYCOMCTL_PARAM_FULLDUP    (BAYCOMCTL_BASE+8)

#define BAYCOMCTL_GETSTAT          (BAYCOMCTL_BASE+9)

#define BAYCOMCTL_GETPARAMS        (BAYCOMCTL_BASE+10)
#define BAYCOMCTL_SETPARAMS        (BAYCOMCTL_BASE+11)

#define BAYCOMCTL_CALIBRATE        (BAYCOMCTL_BASE+12)

#ifdef BAYCOM_DEBUG
/*
 * these are mainly for debugging purposes
 */
#define BAYCOMCTL_GETSAMPLES       (BAYCOMCTL_BASE+16)
#define BAYCOMCTL_GETBITS          (BAYCOMCTL_BASE+17)

#define BAYCOMCTL_DEBUG1           (BAYCOMCTL_BASE+18)
#define BAYCOMCTL_DEBUG2           (BAYCOMCTL_BASE+19)
#define BAYCOMCTL_DEBUG3           (BAYCOMCTL_BASE+20)
#endif /* BAYCOM_DEBUG */

/* -------------------------------------------------------------------- */

struct baycom_statistics {
	unsigned long rx_packets, tx_packets;
	unsigned long ptt_keyed;
	unsigned long rx_bufferoverrun, tx_bufferoverrun;
};

struct baycom_params {
	int modem_type;
	int iobase;
	int irq;
	int options;
	int tx_delay;  /* the transmitter keyup delay in 10ms units */
	int tx_tail;   /* the transmitter keyoff delay in 10ms units */
	int slottime;  /* the slottime in 10ms; usually 10 = 100ms */
	int ppersist;  /* the p-persistence 0..255 */
	int fulldup;   /* the driver does not support full duplex, setting */
	               /* this just makes the driver send even if DCD is on */
};	

/* -------------------------------------------------------------------- */
#endif /* _BAYCOM_H */

/* --------------------------------------------------------------------- */

/*
 * Overrides for Emacs so that we follow Linus's tabbing style.
 * Emacs will notice this stuff at the end of the file and automatically
 * adjust the settings for this buffer only.  This must remain at the end
 * of the file.
 * ---------------------------------------------------------------------------
 * Local variables:
 * c-indent-level: 8
 * c-brace-imaginary-offset: 0
 * c-brace-offset: -8
 * c-argdecl-indent: 8
 * c-label-offset: -8
 * c-continued-statement-offset: 8
 * c-continued-brace-offset: 0
 * End:
 */
