/* Main network program - provides both client and server functions */


#define HOSTNAMELEN 64
unsigned restricted_dev=1000;
extern char *startup;	/* File to read startup commands from */
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include "config.h"
#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "timer.h"
#include "icmp.h"
#include "iface.h"
#include "ip.h"
#include "tcp.h"
#include "ax25.h"
#include "netrom.h"
#include "ftp.h"
#include "telnet.h"
#include "remote.h"
#include "session.h"
#include "cmdparse.h"

#ifdef	ASY
#include "asy.h"
#include "slip.h"
#endif

#ifdef	NRS
#include "nrs.h"
#endif

#include "unix.h"
int	background = 0;

#ifdef	TRACE
#include "trace.h"
/* Dummy structure for loopback tracing */
struct interface loopback = { NULLIF, "loopback" };
#endif

extern struct interface *ifaces;
extern char version[];
extern struct mbuf *loopq;
extern FILE *trfp;
extern char trname[];

int mode;
FILE *logfp;
char badhost[] = "Unknown host %s\n";
char hostname[HOSTNAMELEN];	
unsigned nsessions = NSESSIONS;
int32 resolve();
int16 lport = 1001;
char prompt[] = "net> ";
char nospace[] = "No space!!\n";	/* Generic malloc fail message */
int io_active = 0;
static char escape = 0x1d;	/* default escape character is ^] */

/* Command lookup and branch table */
static int doexit(),dohostname(),dolog(),dohelp(),dotrace(),doescape(),
	doremote();
int go(),doax25(),cmdmode(),doconnect(),dotelnet(),doclose(),
	doreset(),dotcp(),doroute(),doecho(),doip(),
	doarp(),dosession(),doftp(),dostart(),dostop(),doattach(),
	dosmtp(),doudp(),doparam(),doeol(),
	dodump(),dorecord(),doupload(),dokick(),domode(),
	doatstat(),doping(),doforward(),donetrom(),
	donrstat(),dombox(),mulport();

#ifdef _FINGER
int dofinger();
#endif

static struct cmds cmds[] = {
	/* The "go" command must be first */
	"",		go,		0, NULLCHAR,	NULLCHAR,
#if	AX25
	"arp",		doarp,		0, NULLCHAR,	NULLCHAR,
	"ax25",		doax25,		0, NULLCHAR,	NULLCHAR,
#endif	
	"attach",	doattach,	2,
		"attach <hardware> <hw specific options>", NULLCHAR,
/* This one is out of alpabetical order to allow abbreviation to "c" */
#ifdef	AX25
	"connect",	doconnect,	3,"connect <interface> <callsign> [digipeaters]",
		NULLCHAR,
#endif
	"close",	doclose,	0, NULLCHAR,	NULLCHAR,
	"disconnect",	doclose,	0, NULLCHAR,	NULLCHAR,
	"echo",		doecho,		0, NULLCHAR,	"echo [refuse|accept]",
	"eol",		doeol,		0, NULLCHAR,
		"eol options: unix, standard",
	"escape",	doescape,	0, NULLCHAR,	NULLCHAR,   
	"exit",		doexit,		0, NULLCHAR,	NULLCHAR,
#ifdef _FINGER
	"finger",	dofinger,	0, NULLCHAR, NULLCHAR,
#endif
	"forward",	doforward,	0, NULLCHAR,	NULLCHAR,
	"ftp",		doftp,		2, "ftp <address>",	NULLCHAR,
	"help",		dohelp,		0, NULLCHAR,	NULLCHAR,
	"hostname",	dohostname,	0, NULLCHAR,	NULLCHAR,
	"kick",		dokick,		0, NULLCHAR,	NULLCHAR,
	"log",		dolog,		0, NULLCHAR,	NULLCHAR,
	"ip",		doip,		0, NULLCHAR,	NULLCHAR,
#ifdef	AX25
	"mbox",		dombox,		0, NULLCHAR,	NULLCHAR,
	"mode",		domode,		2, "mode <interface>",	NULLCHAR,
#endif
#ifdef	MULPORT
	"mulport",	mulport,	2, "mulport <on|off>",	NULLCHAR,
#endif
#ifdef	NETROM
	"netrom",	donetrom,	0, NULLCHAR,	NULLCHAR,
#ifdef	NRS
	"nrstat",	donrstat,	0, NULLCHAR,	NULLCHAR,
#endif
#endif
	"param",	doparam,	2, "param <interface>", NULLCHAR,
	"ping",		doping,		0, NULLCHAR,	NULLCHAR,
	"record",	dorecord,	0, NULLCHAR,	NULLCHAR,
	"remote",	doremote,	4, "remote <address> <port> <command>",
							NULLCHAR,
	"reset",	doreset,	0, NULLCHAR,	NULLCHAR,
	"route",	doroute,	0, NULLCHAR,	NULLCHAR,
	"session",	dosession,	0, NULLCHAR,	NULLCHAR,
	"smtp",		dosmtp,		0, NULLCHAR,	NULLCHAR,
#ifdef	SERVERS
	"start",	dostart,	2, "start <servername>",NULLCHAR,
	"stop",		dostop,		2, "stop <servername>",	NULLCHAR,
#endif
	"tcp",		dotcp,		0, NULLCHAR,	NULLCHAR,
	"telnet",	dotelnet,	2, "telnet <address>",	NULLCHAR,
#ifdef	TRACE
	"trace",	dotrace,	0, NULLCHAR,	NULLCHAR,
#endif
	"udp",		doudp,		0, NULLCHAR,	NULLCHAR,
	"upload",	doupload,	0, NULLCHAR,	NULLCHAR,
	"?",		dohelp,		0, NULLCHAR,	NULLCHAR,
	NULLCHAR,	NULLFP,		0,
		"Unknown command; type \"?\" for list",   NULLCHAR, 
};

#ifdef	SERVERS
/* "start" and "stop" subcommands */
int dis1(),echo1(),ftp1(),smtp1(),tn1(),rem1();

int tnix1();

#ifdef _FINGER
int finger1();
#endif

static struct cmds startcmds[] = {
	"discard",	dis1,		0, NULLCHAR, NULLCHAR,
	"echo",		echo1,		0, NULLCHAR, NULLCHAR,
#ifdef _FINGER
	"finger",	finger1,	0, NULLCHAR, NULLCHAR,
#endif
	"ftp",		ftp1,		0, NULLCHAR, NULLCHAR,
	"smtp",		smtp1,		0, NULLCHAR, NULLCHAR,
	"telnet",	tn1,		0, NULLCHAR, NULLCHAR,
	"telunix",	tnix1,		0, NULLCHAR, NULLCHAR,
	"remote",	rem1,		0, NULLCHAR, NULLCHAR,
	NULLCHAR,	NULLFP,		0,
#ifdef _FINGER
		"start options: discard, echo, finger, ftp, remote, smtp, telnet, telunix", NULLCHAR,
#else
		"start options: discard, echo, ftp, remote, smtp, telnet, telunix", NULLCHAR,
#endif
};
int ftp_stop(),smtp_stop(),echo_stop(),dis_stop(),tn_stop();
int dis0(),echo0(),ftp0(),smtp0(),tn0(),rem0();

int tnix0();

#ifdef _FINGER
int finger0();
#endif

static struct cmds stopcmds[] = {
	"discard",	dis0,		0, NULLCHAR, NULLCHAR,
	"echo",		echo0,		0, NULLCHAR, NULLCHAR,
#ifdef _FINGER
	"finger",	finger0,	0, NULLCHAR, NULLCHAR,
#endif
	"ftp",		ftp0,		0, NULLCHAR, NULLCHAR,
	"smtp",		smtp0,		0, NULLCHAR, NULLCHAR,
	"telnet",	tn0,		0, NULLCHAR, NULLCHAR,
	"telunix",	tnix0,		0, NULLCHAR, NULLCHAR,
	"remote",	rem0,		0, NULLCHAR, NULLCHAR,
	NULLCHAR,	NULLFP,		0,
#ifdef _FINGER
		"stop options: discard, echo, finger, ftp, remote, smtp, telnet, telunix", NULLCHAR,
#else
		"stop options: discard, echo, ftp, remote, smtp, telnet, telunix", NULLCHAR,
#endif
};
#endif

void
keep_things_going()
{
	void check_time(), ip_recv();
	struct interface *ifp;
	struct timeval timeval;
	struct mbuf *bp;
	fd_set mask;

	/* Service the loopback queue */
	if((bp = dequeue(&loopq)) != NULLBUF){
		struct ip ip;
#ifdef	TRACE
		dump(&loopback,IF_TRACE_IN,TRACE_IP,bp);		
#endif
		/* Extract IP header */
		ntohip(&ip,&bp);
		ip_recv(&ip,bp,0);
	}
	/* Service the interfaces */
	do {
		io_active = 0;

		timeval.tv_usec = 250000;	/* 1/4 second */
		timeval.tv_sec  = 0;

		FD_ZERO(&mask);
		FD_SET(STDIN_FILENO, &mask);

		select(STDIN_FILENO + 1, &mask, NULL, NULL, &timeval);

		for(ifp = ifaces; ifp != NULLIF; ifp = ifp->next){
			if(ifp->recv != NULLVFP)
				(*ifp->recv)(ifp);
		}
	} while(io_active);

#ifdef	XOBBS
	/* service the W2XO PBBS code */
	axchk();
#endif
	/* Service the clock if it has ticked */
	check_time();

	/* Wait until interrupt, then do it all over again */
	eihalt();
}

main(argc,argv)
int argc;
char *argv[];
{
	static char inbuf[BUFSIZ];	/* keep it off the stack */
	int c;
	char *ttybuf,*fgets();
	int16 cnt;
	int ttydriv();
	int cmdparse();
	void check_time(),ip_recv();
	FILE *fp;
	struct interface *ifp;
	struct mbuf *bp;
	char *p;
	static char startfn[256];
	char *getenv();
#ifdef	FLOW
	extern int ttyflow;
#endif
	if (signal(SIGINT, SIG_IGN) == SIG_IGN) {
		background++;
		daemon();
	} else
		ioinit();
	if (!background) {
		printf("KA9Q Internet Protocol Package, v%s\n",version);
		printf("Copyright 1988 by Phil Karn, KA9Q\n");
#ifdef NETROM
		printf("NET/ROM Support Copyright 1989 by Dan Frank, W9NK\n") ;
#endif
	}
	fflush(stdout);
	sessions = (struct session *)calloc(nsessions,sizeof(struct session));
	if(argc > 1){
		/* Read startup file named on command line */
		fp = fopen(argv[1],"r");
	} else {
		fp = fopen(startup,"r");
	}
	if(fp != NULLFILE){
		while(fgets(inbuf,BUFSIZ,fp) != NULLCHAR){
			cmdparse(cmds,inbuf);
		}
		fclose(fp);
	}		
#ifdef XOBBS
	axinit();
#endif
	cmdmode();

	/* Main commutator loop */
	for(;;){
		/* Process any keyboard input */
		while((background == 0) && ((c = kbread()) != -1)){
			if(c == escape && escape != 0){
				if(mode != CMD_MODE){
					printf("\r\n");
					cmdmode();
				}
				continue;
			}
#ifndef	FLOW
			if ((cnt = ttydriv(c, &ttybuf)) == 0)
				continue;
#else
			cnt = ttydriv(c, &ttybuf);
			if (ttyflow && (mode != CMD_MODE))
				go();		/* display pending chars */
			if (cnt == 0)
				continue;
#endif	/* FLOW */
			if((ttybuf[0] == escape) && (escape != 0)) {
				if(mode != CMD_MODE){
					printf("\r\n");
					cmdmode();
				}
				continue;
			}
			switch(mode){
			case CMD_MODE:
				(void)cmdparse(cmds,ttybuf);
				fflush(stdout);
				break;
			case CONV_MODE:
				if(ttybuf[0] == escape && escape != 0){
					printf("\n");
					cmdmode();
				} else
					if(current->parse != NULLFP)
						(*current->parse)(ttybuf,cnt);
				break;
			}
			if(mode == CMD_MODE){
				printf(prompt);
				fflush(stdout);
			}
		}
		keep_things_going();
	}
}
/* Standard commands called from main */

/* Enter command mode */
int
cmdmode()
{
	if(mode != CMD_MODE){
		mode = CMD_MODE;
		cooked();
		printf(prompt);
		fflush(stdout);
	}
	return 0;
}
static
doexit()
{
	if(logfp != NULLFILE)
		fclose(logfp);
	if (!background)
		iostop();
#ifdef TRACE
	if (trfp != stdout) 
	  fclose(trfp);
#endif
	exit(0);
}
static
dohostname(argc,argv)
int argc;
char *argv[];
{
	char *strncpy();

	if(argc < 2)
		printf("%s\n",hostname);
	else 
		strncpy(hostname,argv[1],HOSTNAMELEN);
	return 0;
}
static
int
dolog(argc,argv)
int argc;
char *argv[];
{
	char *strncpy();
	static char logname[256];
	if(argc < 2){
		if(logfp)
			printf("Logging to %s\n",logname);
		else
			printf("Logging off\n");
		return 0;
	}
	if(logfp){
		fclose(logfp);
		logfp = NULLFILE;
	}
	if(strcmp(argv[1],"stop") != 0){
		strncpy(logname,argv[1],sizeof(logname));
		logfp = fopen(logname,"a+");
	}
	return 0;
}
static
int
dohelp()
{
	register struct cmds *cmdp;
	int i,j;

	printf("Main commands:\n");
	for(i=0,cmdp = cmds;cmdp->name != NULL;cmdp++,i++){
		printf("%s",cmdp->name);
		if((i % 4) == 3)
			printf("\n");
		else {
			for(j=strlen(cmdp->name);j < 16; j++)
				putchar(' ');
		}
	}
	if((i % 4) != 0)
		printf("\n");
	return 0;
}

doecho(argc,argv)
int argc;
char *argv[];
{
	extern int refuse_echo;

	if(argc < 2){
		if(refuse_echo)
			printf("Refuse\n");
		else
			printf("Accept\n");
	} else {
		if(argv[1][0] == 'r')
			refuse_echo = 1;
		else if(argv[1][0] == 'a')
			refuse_echo = 0;
		else
			return -1;
	}
	return 0;
}
/* set for unix end of line for remote echo mode telnet */
doeol(argc,argv)
int argc;
char *argv[];
{
	extern int unix_line_mode;

	if(argc < 2){
		if(unix_line_mode)
			printf("Unix\n");
		else
			printf("Standard\n");
	} else {
		if(strcmp(argv[1],"unix") == 0)
			unix_line_mode = 1;
		else if(strcmp(argv[1],"standard") == 0)
			unix_line_mode = 0;
		else {
			return -1;
		}
	}
	return 0;
}
/* Attach an interface
 * Syntax: attach <hw type> <I/O address> <vector> <mode> <label> <bufsize> [<speed>]
 */
doattach(argc,argv)
int argc;
char *argv[];
{
	extern struct cmds attab[];

	return subcmd(attab,argc,argv);
}
/* Manipulate I/O device parameters */
doparam(argc,argv)
int argc;
char *argv[];
{
	register struct interface *ifp;

	for(ifp=ifaces;ifp != NULLIF;ifp = ifp->next){
		if(strcmp(argv[1],ifp->name) == 0)
			break;
	}
	if(ifp == NULLIF){
		printf("Interface \"%s\" unknown\n",argv[1]);
		return 1;
	}
	if(ifp->ioctl == NULLFP){
		printf("Not supported\n");
		return 1;
	}
	/* Pass rest of args to device-specific code */
	return (*ifp->ioctl)(ifp,argc-2,argv+2);
}
/* Log messages of the form
 * Tue Jan 31 00:00:00 1987 44.64.0.7:1003 open FTP
 */
/*VARARGS2*/
log(tcb,fmt,arg1,arg2,arg3,arg4)
struct tcb *tcb;
char *fmt;
int arg1,arg2,arg3,arg4;
{
	char *cp;
	long t;
	int fd;

	if(logfp == NULLFILE)
		return;
	time(&t);
	cp = ctime(&t);
	rip(cp);
	fprintf(logfp,"%s %s - ",cp,psocket(&tcb->conn.remote));
	fprintf(logfp,fmt,arg1,arg2,arg3,arg4);
	fprintf(logfp,"\n");
	fflush(logfp);
}
/* Configuration-dependent code */

/* List of supported hardware devices */
int modem_init(),asy_attach(),pc_attach(),at_attach(),nr_attach();

struct cmds attab[] = {
#ifdef	ASY
	/* Ordinary PC asynchronous adaptor */
	"asy", asy_attach, 8, 
	"attach asy 0 <ttyname> slip|ax25|nrs <label> <buffers> <mtu> <speed>",
	"Could not attach asy",
#endif
#ifdef NETROM
	/* fake netrom interface */
	"netrom", nr_attach, 1,
	"attach netrom",
	"Could not attach netrom",
#endif
	NULLCHAR, NULLFP, 0,
	"Unknown device",
	NULLCHAR,
};

/* Protocol tracing function pointers */
#ifdef	TRACE
int ax25_dump(),ip_dump();

int (*tracef[])() = {
#ifdef	AX25
	ax25_dump,
#else
	NULLFP,
#endif
	NULLFP,
	ip_dump,
	NULLFP,
	NULLFP,
};
#else
int (*tracef[])() = { NULLFP };	/* No tracing at all */
dump(interface,direction,type,bp)
struct interface *interface;
int direction;
unsigned type;
struct mbuf *bp;
{
}
#endif

#ifdef	ASY

/* Attach a serial interface to the system
 * argv[0]: hardware type, must be "asy"
 * argv[1]: I/O address, e.g., "0x3f8"
 * argv[2]: vector, e.g., "4"
 * argv[3]: mode, may be:
 *	    "slip" (point-to-point SLIP)
 *	    "ax25" (AX.25 frame format in SLIP for raw TNC)
 *	    "nrs" (NET/ROM format serial protocol)
 * argv[4]: interface label, e.g., "sl0"
 * argv[5]: receiver ring buffer size in bytes
 * argv[6]: maximum transmission unit, bytes
 * argv[7]: interface speed, e.g, "9600"
 * argv[8]: optional ax.25 callsign (NRS only)
 *          optional modem L.sys style command (SLIP only)
 */
int
asy_attach(argc,argv)
int argc;
char *argv[];
{
	register struct interface *if_asy;
	extern struct interface *ifaces;
	int16 dev;
	int mode;
	int asy_init();
	int asy_send();
	int asy_ioctl();
	void doslip();
	int asy_stop();
	int ax_send();
	int ax_output();
	void kiss_recv();
	int kiss_raw();
	int kiss_ioctl();
	int slip_send();
	void slip_recv();
	int slip_raw();

#ifdef	AX25
	struct ax25_addr addr ;
#endif
	int ax_send(),ax_output(),nrs_raw(),asy_ioctl();
	void nrs_recv();

	if(nasy >= ASY_MAX){
		printf("Too many asynch controllers\n");
		return -1;
	}
	if(strcmp(argv[3],"slip") == 0)
		mode = SLIP_MODE;
#ifdef	AX25
	else if(strcmp(argv[3],"ax25") == 0)
		mode = AX25_MODE;
#endif
#ifdef	NRS
	else if(strcmp(argv[3],"nrs") == 0)
		mode = NRS_MODE;
#endif
	else {
		printf("Mode %s unknown for interface %s\n",
			argv[3],argv[4]);
		return(-1);
	}

	dev = nasy++;

	/* Create interface structure and fill in details */
	if_asy = (struct interface *)calloc(1,sizeof(struct interface));
	if_asy->name = malloc((unsigned)strlen(argv[4])+1);
	strcpy(if_asy->name,argv[4]);
	if_asy->mtu = atoi(argv[6]);
	if_asy->dev = dev;
	if_asy->recv = doslip;
	if_asy->stop = asy_stop;

	switch(mode){
#ifdef	SLIP
	case SLIP_MODE:
		if_asy->ioctl = asy_ioctl;
		if_asy->send = slip_send;
		if_asy->output = NULLFP;	/* ARP isn't used */
		if_asy->raw = slip_raw;
		if_asy->flags = 0;
		slip[dev].recv = slip_recv;
		break;
#endif
#ifdef	AX25
	case AX25_MODE:  /* Set up a SLIP link to use AX.25 */
		axarp();
		if(mycall.call[0] == '\0'){
			printf("set mycall first\n");
			free(if_asy->name);
			free((char *)if_asy);
			nasy--;
			return -1;
		}
		if_asy->ioctl = kiss_ioctl;
		if_asy->send = ax_send;
		if_asy->output = ax_output;
		if_asy->raw = kiss_raw;
		if(if_asy->hwaddr == NULLCHAR)
			if_asy->hwaddr = malloc(sizeof(mycall));
		memcpy(if_asy->hwaddr,(char *)&mycall,sizeof(mycall));
		slip[dev].recv = kiss_recv;
		break;
#endif
#ifdef	NRS
	case NRS_MODE: /* Set up a net/rom serial interface */
		if(argc < 9){
			/* no call supplied? */
			if(mycall.call[0] == '\0'){
				/* try to use default */
				printf("set mycall first or specify in attach statement\n");
				return -1;
			} else
				addr = mycall;
		} else {
			/* callsign supplied on attach line */
			if(setcall(&addr,argv[8]) == -1){
				printf ("bad callsign on attach line\n");
				free(if_asy->name);
				free((char *)if_asy);
				nasy--;
				return -1;
			}
		}
		if_asy->recv = nrs_recv;
		if_asy->ioctl = asy_ioctl;
		if_asy->send = ax_send;
		if_asy->output = ax_output;
		if_asy->raw = nrs_raw;
		if(if_asy->hwaddr == NULLCHAR)
			if_asy->hwaddr = malloc(sizeof(addr));
		memcpy(if_asy->hwaddr,(char *)&addr,sizeof(addr));
		nrs[dev].iface = if_asy;
		break;
#endif
	}
	if_asy->next = ifaces;
	ifaces = if_asy;
	asy_init(dev,argv[1],argv[2],(unsigned)atoi(argv[5]));
	asy_speed(dev,atoi(argv[7]));
/*
 * optional SLIP modem command?
 */
#if defined(SLIP) && defined(MODEM_CALL)
	if((mode == SLIP_MODE) && (argc > 8)) {
	    restricted_dev=dev;
	    if((modem_init(dev,argc-8,argv+8)) == -1) {
		printf("\nModem command sequence failed.\n");
		asy_stop(if_asy);
		ifaces = if_asy->next;
		free(if_asy->name);
		free((char *)if_asy);
		nasy--;
		restricted_dev=1000;
		return -1;
	    }
	    restricted_dev=1000;
	    return 0;
	}
#endif
	return 0;
}
#endif
#ifndef	NETROM
#ifdef	AX25
struct ax25_addr nr_nodebc;
#endif
nr_route(bp)
struct mbuf *bp;
{
	free_p(bp);
}
nr_nodercv(bp)
{
	free_p(bp);
}
#endif


/* Display or set IP interface control flags */
domode(argc,argv)
int argc;
char *argv[];
{
	register struct interface *ifp;

	for(ifp=ifaces;ifp != NULLIF;ifp = ifp->next){
		if(strcmp(argv[1],ifp->name) == 0)
			break;
	}
	if(ifp == NULLIF){
		printf("Interface \"%s\" unknown\n",argv[1]);
		return 1;
	}
	if(argc < 3){
		printf("%s: %s\n",ifp->name,
		 (ifp->flags & CONNECT_MODE) ? "VC mode" : "Datagram mode");
		return 0;
	}
	switch(argv[2][0]){
	case 'v':
	case 'c':
	case 'V':
	case 'C':
		ifp->flags = CONNECT_MODE;
		break;
	case 'd':
	case 'D':
		ifp->flags = DATAGRAM_MODE;
		break;
	default:
		printf("Usage: %s [vc | datagram]\n",argv[0]);
		return 1;
	}
	return 0;
}

#ifdef SERVERS
dostart(argc,argv)
int argc;
char *argv[];
{
	return subcmd(startcmds,argc,argv);
}
dostop(argc,argv)
int argc;
char *argv[];
{
	return subcmd(stopcmds,argc,argv);
}
#endif SERVERS

#ifdef	TRACE
static
int
dotrace(argc,argv)
int argc;
char *argv[];
{
        extern int notraceall;  /* trace only in command mode? */
	struct interface *ifp;

	if(argc < 2){
 		printf("trace mode is %s\n", (notraceall ? "cmdmode" : "allmode"));
	        printf("trace to %s\n",trfp == stdout? "console" : trname);
		showtrace(&loopback);
		for(ifp = ifaces; ifp != NULLIF; ifp = ifp->next)
			showtrace(ifp);
		return 0;
	}
	if(strcmp("to",argv[1]) == 0){
		if(argc >= 3){
			if(trfp != stdout)
				fclose(trfp);
			if(strncmp(argv[2],"con",3) == 0)
				trfp = stdout;
			else {
				if((trfp = fopen(argv[2],"a")) == NULLFILE){
					printf("%s: cannot open\n",argv[2]);
					trfp = stdout;
					return 1;
				}
			}
			strcpy(trname,argv[2]);
		} else {
			printf("trace to %s\n",trfp == stdout? "console" : trname);
		}
		return 0;
	}
	if(strcmp("loopback",argv[1]) == 0)
		ifp = &loopback;
 	else if (strcmp("cmdmode", argv[1]) == 0) {
 		notraceall = 1;
 		return 0;
 	} else if (strcmp("allmode", argv[1]) == 0) {
 		notraceall = 0;
 		return 0;
 	} else
		for(ifp = ifaces; ifp != NULLIF; ifp = ifp->next)
			if(strcmp(ifp->name,argv[1]) == 0)
				break;

	if(ifp == NULLIF){
		printf("Interface %s unknown\n",argv[1]);
		return 1;
	}
	if(argc >= 3)
		ifp->trace = htoi(argv[2]);

	showtrace(ifp);
	return 0;
}
/* Display the trace flags for a particular interface */
static
showtrace(ifp)
register struct interface *ifp;
{
	if(ifp == NULLIF)
		return;
	printf("%s:",ifp->name);
	if(ifp->trace & (IF_TRACE_IN | IF_TRACE_OUT)){
		if(ifp->trace & IF_TRACE_IN)
			printf(" input");
		if(ifp->trace & IF_TRACE_OUT)
			printf(" output");

		if(ifp->trace & IF_TRACE_HEX)
			printf(" (Hex/ASCII dump)");
		else if(ifp->trace & IF_TRACE_ASCII)
			printf(" (ASCII dump)");
		else
			printf(" (headers only)");
		printf("\n");
	} else
		printf(" tracing off\n");
	fflush(stdout);
}
#endif

static
int
doescape(argc,argv)
int argc;
char *argv[];
{
	if(argc < 2)
		printf("0x%x\n",escape);
	else 
		escape = *argv[1];
	return 0;
}

static
doremote(argc,argv)
int argc;
char *argv[];
{
	struct socket fsock,lsock;
	struct mbuf *bp;

	lsock.address = ip_addr;
	fsock.address = resolve(argv[1]);
	lsock.port = fsock.port = atoi(argv[2]);
	bp = alloc_mbuf(1);
	if(strcmp(argv[3],"reset") == 0){
		*bp->data = SYS_RESET;
	} else if(strcmp(argv[3],"exit") == 0){
		*bp->data = SYS_EXIT;
	} else {
		printf("Unknown command %s\n",argv[3]);
		return 1;
	}
	bp->cnt = 1;
	send_udp(&lsock,&fsock,0,0,bp,0,0,0);
	return 0;
}
