/* circuit.c - Report on number of circuits per interval.
   This module is part of report.exe
                  
   Language = Microsoft C version 4.0


   This source is distributed freely and may be copied and
   redistributed with the following provisos:
   
           You may not sell it, nor may you charge for making 
           copies beyond the actual cost of mailing and media.
                      
   Written by Skip Hansen WB6YMH and Harold Price NK6K.

   Feedback is desired.

   RCP/M (213) 541-2503 300/1200/2400 baud
   or via packet WB6YMH @ WB6YMH-2 or 
		 NK6K @ NK6K

   Modification history:

	8/10/87	 	NK6K: Initial release.	
	ver 1.0		 

   10/18/87     NK6K: First general release.
   ver 1.1
*/
/* circuit - report on number of circuits per interval */
#define LINT_ARGS
#include "monfile.h"
#include <stdio.h>
#include <memory.h>
static struct CIRCUIT_RECORD ccrec;
static struct FREQ_RECORD cfrec;

extern FILE *fin,*fout;
extern char *getrec();

static long total_packets;
static long total_retries;
static long total_poll;
static long total_final;
static long total_rej;
static long total_rnr;
static long total_bytes;
static long total_ubytes;

static char fbuf[257];
static char started;
static unsigned long time_stamp;
static unsigned int all_cir,user_cir;
static int tmp;
static long recnum;

void cdump_it();

void
report_circuit()
{
   started=0;
   recnum=0;
   total_bytes=total_ubytes=total_rej=total_rnr=total_poll=
       total_final=total_packets=total_retries=all_cir=user_cir=0;
   while (1){
	if (getrec(fbuf,256,fin)==NULL) {
		if (started) cdump_it();
		return;
		}
	recnum++;
	if (fbuf[0]=='T') {
		if (started) cdump_it();
		tmp=sscanf(fbuf+2,"%lu",&time_stamp);	
		if (tmp!=1) {
			fprintf(stderr,"*** bad Time rec, number %lu ***\n",recnum);
			}
		started=1;
		}

	else if (fbuf[0]== FREQ_TYPE) {
		tmp=sscanf(fbuf+2,"%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu",
			&cfrec.t_packets,
			&cfrec.t_bytes,
			&cfrec.u_packets,
			&cfrec.u_bytes,
			&cfrec.l32,
			&cfrec.l64,
			&cfrec.l128,
			&cfrec.l256,
			&cfrec.g256,
			&cfrec.dcd_on_ticks,
			&cfrec.dcd_off_ticks);

		if (tmp!=11) {
			fprintf(stderr,"*** bad Freq rec, number %lu ***\n",recnum); 
			continue;
			}
		}
		
	else if (fbuf[0]=='C') {
		all_cir++;
		tmp = sscanf(fbuf+2,
"%[^,],%[^,],%u,%u,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,\
%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu",
		ccrec.to,		
		ccrec.from,		
		&ccrec.digis,		
		&ccrec.pid,
		&ccrec.u_dpackets,	
		&ccrec.nd_dpackets,	
		&ccrec.t_dpackets,	
		&ccrec.nd_packets,	
		&ccrec.t_packets,	
		&ccrec.u_dbytes,		
		&ccrec.nd_dbytes,	
		&ccrec.t_dbytes,		
		&ccrec.nd_bytes,		
		&ccrec.t_bytes,		
		&ccrec.c_time,		
		&ccrec.sabm,
		&ccrec.ua,
		&ccrec.disc,
		&ccrec.dm,
		&ccrec.rej,
		&ccrec.rr,
		&ccrec.rnr,
		&ccrec.i,
		&ccrec.ui,
		&ccrec.frmr,
		&ccrec.poll,
		&ccrec.final,
		&ccrec.l32,	
		&ccrec.l64,	
		&ccrec.l128,
		&ccrec.l256,
		&ccrec.g256);

		if (tmp!=32) {
			fprintf(stderr,"*** bad Circuit rec, number %lu ***\n",recnum); 
			continue;
			}

		
			/* if only UI frames are sent, and if the
			   total number is less than 1 per minute, this
			   is probably a beacon.  Ignore it. */
		if ((ccrec.t_packets > ccrec.ui) || (ccrec.ui>5))  user_cir++;

/*n* fix this later */
		if ((ccrec.nd_dpackets-ccrec.u_dpackets) >= 0) {
			total_packets += ccrec.t_packets;
			total_retries += ccrec.nd_dpackets-ccrec.u_dpackets;
			total_poll += ccrec.poll;
			total_final += ccrec.final;
			total_rnr += ccrec.rnr;
			total_rej += ccrec.rej;
			total_bytes += ccrec.t_bytes;
			total_ubytes += ccrec.u_dbytes;
 			}
		}

	}
   }

		

void
cdump_it()
{
/*
	fprintf(fout,"%lu,%u,%u,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%u\n",
		time_stamp,all_cir,user_cir,total_packets,total_retries,
		total_poll, total_final, total_rej, total_rnr, total_bytes,
		total_ubytes,
		(int) (0.5+ (100.0 * ((float) cfrec.dcd_on_ticks /	
		  (float) (cfrec.dcd_on_ticks+cfrec.dcd_off_ticks))))  );
*/
	fprintf(fout,"%lu,%u,%u,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu\n",
		time_stamp,all_cir,user_cir,total_packets,total_retries,
		total_poll, total_final, total_rej, total_rnr, total_bytes,
		total_ubytes);

	if (total_packets != cfrec.t_packets)
		fprintf(stderr,"Mismatch in packet counts near record %ld, computed=%ld, f=%ld\n",
			recnum,total_packets,cfrec.t_packets);

	total_bytes=total_ubytes=total_rej=total_rnr=total_poll=
       		total_final=total_packets=total_retries=all_cir=user_cir=0;


	}

