/*
 *   Copyright 1992, 1993, 1994 John Melton (G0ORX/N6LYT)
 *              All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
	phs.c

	Wrapper to allow non PACSAT aware programs to be used with downloaded.

	John Melton
	G0ORX, N6LYT

	4 Charlwoods Close
	Copthorne
	West Sussex
	RH10 3QZ
	England

	INTERNET:	g0orx@amsat.org
			n6lyt@amsat.org
			john@images.demon.co.uk
			J.D.Melton@slh0613.icl.wins.co.uk

	History:

	0.1	Initial version. 			G4KLX
*/

#define VERSION_STRING "(version 0.1 by g4klx)"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <signal.h>
#include <ctype.h>
#include <time.h>

#include <X11/Intrinsic.h>

#include "header.h"

int main(int argc, char **argv)
{
	FILE *fpin, *fpout;
	char fileName[20], compFile[20], *pBuffer;
	char command[50];
	time_t time_now;
	int i, nBytes, headerSize;
	int pid, status;
	HEADER *pHeader;
	char *args[10];

	if (argc < 3)
	{
		fprintf(stderr, "usage: phs <infile> <program> args ...\n");
		return(1);
	}
	
	if ((fpin = fopen(argv[1], "r")) == NULL)
	{
		perror(argv[1]);
		return(1);
	}

	pBuffer = XtMalloc(1024);

	/* read in the header */
	nBytes = fread(pBuffer, 1, 1024, fpin);

	/* extracting the header */
	pHeader = ExtractHeader(pBuffer, nBytes, &headerSize);

	time(&time_now);

	switch (pHeader->fileType)
	{
	case 14:
		sprintf(fileName, "%x.gif", (int)time_now);
		break;
	case 15:
		sprintf(fileName, "%x.pcx", (int)time_now);
		break;
	case 16:
		sprintf(fileName, "%x.jpg", (int)time_now);
		break;
	case 221:
		sprintf(fileName, "%x.eis", (int)time_now);
		break;
	default:
		sprintf(fileName, "%x.txt", (int)time_now);
		break;
	}

	if (pHeader->compression != 0 && pHeader->compression != 255)
	{
		sprintf(compFile, "%x.comp", (int)time_now);
	
		fseek(fpin, pHeader->bodyOffset, SEEK_SET);

		if ((fpout = fopen(compFile, "w")) == NULL)
		{
			perror(compFile);
			return(1);
		}

		while ((nBytes = fread(pBuffer, 1, 1024, fpin)) > 0)
			fwrite(pBuffer, 1, nBytes, fpout);

		fclose(fpin);
		fclose(fpout);
	
		switch (pHeader->compression)
		{
		case 2:
			sprintf(command, "unzip -p %s > %s", compFile, fileName);
			break;
		case 3:
			sprintf(command, "lha -pq %s > %s", compFile, fileName);
			break;
		default:
			break;
		}

		status = system(command);

		unlink(compFile);

		if (status == 127 || status < 0)
		{
			perror(command);
			return(1);
		}
	}
	else
	{
		if ((fpout = fopen(fileName, "w")) == NULL)
		{
			perror(fileName);
			return(1);
		}

		fseek(fpin, pHeader->bodyOffset, SEEK_SET);
	
		while ((nBytes = fread(pBuffer, 1, 1024, fpin)) > 0)
			fwrite(pBuffer, 1, nBytes, fpout);
		
		fclose(fpout);
		fclose(fpin);
	}

	XtFree((char *)pHeader);
	XtFree(pBuffer);

	for (i = 0; i < argc - 2; i++)
		args[i] = argv[i + 2];
		
	args[i++] = fileName;
	args[i++] = NULL;

	if ((pid = fork()) == 0)
	{
		/* the child process */
		execvp(args[0], args);
	}
	else if (pid > 0)
	{
		/* success */
		wait(&status);
	}
	else
	{
		return(1);
	}

	unlink(fileName);
	
	return(0);
}

