#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "buckmstr.h"

//--------------------------------------------------------------------------
//------ Main function -----------------------------------------------------
//--------------------------------------------------------------------------
void main(int Argc, char * Argv[])
{
  char	sBuffer[300];
  char	sOutput[300];
  int	iInterrupt;

  //Check arguments
  if( Argc < 3 )
    goto Error;

  strupr(Argv[1]);
  Argv[1][1] = '\0';
  strupr(Argv[2]);

  //Check CD-ROM drive error
  if( *Argv[1] < 'D' || *Argv[1] > 'H' )
  {
    printf("*** Error : bad CD-ROM drive letter.\n");
    goto Error;
  }

  //Which interrupt ?
  if( Argc == 4 )
  {
    strupr(Argv[3]);
    if( strncmp(Argv[3], "/I", 2))
      goto Error;

    //Converts hex in decimal
    sscanf(Argv[3]+2, "%x", &iInterrupt);

    if( iInterrupt == 0 )
      goto Error;
  }
  else
    iInterrupt = 0x66;

  //Set CD-ROM drive letter
  Buck_SetDrive(*Argv[1], iInterrupt);

  //Set output string
  Buck_SetOutput(sBuffer, 300, iInterrupt);

  //Lookup callsign
  Buck_Lookup(Argv[2], iInterrupt);

  //Match found ?
  if( ! strchr(sBuffer, 181) )
  {
    //No ...
    printf("Callsign %s not found.\n", Argv[2]);
    exit(EXIT_FAILURE);
  }/*End IF*/

  //Callsign
  printf("%s", Argv[2]);

  //Class
  Buck_GetField(sOutput, sBuffer, BUCK_CLASS);
  if( *sOutput )
  {
    printf(", class : ");
    switch( *sOutput )
    {
      case 'E' :
	printf("Extra");
	break;
      case 'A' :
	printf("Advanced");
	break;
      case 'G' :
	printf("General");
	break;
      case 'P' :
	printf("Technician Plus");
	break;
      case 'T' :
	printf("Technician");
	break;
      case 'N' :
	printf("Novice");
	break;
      default :
	printf("Unknown");
    }/*End SWITCH*/
  }/*End IF*/

  printf("\n");

  //Names
  Buck_GetField(sOutput, sBuffer, BUCK_FIRSTNAME);
  if( *sOutput )
    printf("%s", sOutput);

  Buck_GetField(sOutput, sBuffer, BUCK_MIDDLENAME);
  if( *sOutput )
    printf("%s", sOutput);

  Buck_GetField(sOutput, sBuffer, BUCK_LASTNAME);
  if( *sOutput )
    printf("%s", sOutput);

  Buck_GetField(sOutput, sBuffer, BUCK_SUFFIX);
  if( *sOutput )
    printf("%s", sOutput);

  printf("\n");

  //Address
  Buck_GetField(sOutput, sBuffer, BUCK_STREET);
  printf("%s", sOutput);

  Buck_GetField(sOutput, sBuffer, BUCK_RECIPADDRESS);
  printf("%s", sOutput);

  printf("\n");

  //City, State, ZIP code
  Buck_GetField(sOutput, sBuffer, BUCK_CITY);
  printf("%s", sOutput);

  Buck_GetField(sOutput, sBuffer, BUCK_STATE);
  if( *sOutput )
    printf("%s", sOutput);

  Buck_GetField(sOutput, sBuffer, BUCK_POSTCODE);
  printf("%s", sOutput);

  printf("\n");

  //QSL Manager
  Buck_GetField(sOutput, sBuffer, BUCK_QSLMANAGER);
  if( *sOutput )
    printf("QSL Manager : %s\n", sOutput);

  //E-mail
  Buck_GetField(sOutput, sBuffer, BUCK_EMAIL);
  if( *sOutput )
    printf("E-mail : %s\n", sOutput);

  //Grid square
  Buck_GetField(sOutput, sBuffer, BUCK_GRID);
  if( *sOutput )
    printf("Grid square : %s\n", sOutput);

  //Previous call
  Buck_GetField(sOutput, sBuffer, BUCK_PREVCALL);
  if( *sOutput )
    printf("Previous call : %s\n", sOutput);

  //Birth date (DD-MM-YYYY)
  Buck_GetField(sOutput, sBuffer, BUCK_BIRTHDATE);
  if( *sOutput )
    printf("Birth date : %c%c-%c%c-%c%c%c%c\n", sOutput[6],
						sOutput[7],
						sOutput[4],
						sOutput[5],
						sOutput[0],
						sOutput[1],
						sOutput[2],
						sOutput[3]);

  exit(EXIT_SUCCESS);

Error:
  printf("Buckmaster's Hamcall CD-ROM interface for DxNet (requires BUCKTSR).\n");
  printf("Version 1.00 Copyright (c) 1997, F5MZN.\n");
  printf("\n");
  printf("Syntax  : BUCKMSTR <drive> <callsign> [/Ixx]\n");
  printf("          drive    : CD-ROM drive letter.\n");
  printf("          callsign : searched callsign.\n");
  printf("          /Ixx     : BUCKTSR interrupt number (hexadecimal) - default is 66h.\n");
  printf("\n");
  printf("Example : BUCKMSTR D: W1AW /I66\n");
  exit(EXIT_FAILURE);
}