
#ifndef CTIME_H
#define CTIME_H

#include <time.h>

enum dateformat_t {
	dmy, mdy, ydm, ymd
};

extern enum dateformat_t dateformat;
extern char datesep;

extern void ctime_init(void);		/* Initialize */
extern long int uptime(void);		/* Clusse uptime */

extern char *secs2str_l(long i);	/* Seconds => d hh:mm:ss */
extern char *secs2str_s(long i);	/* Seconds => d/h/m/s 3 chars */
extern char *mins2str_l(long i);	/* Minutes => d hh:mm */
extern char *mins2str_s(long i);	/* Minutes => d/h/m 3 chars */
extern char *datestr_l(time_t t);	/* Packed => 01/10/77 */
extern char *datestr_s(time_t t);	/* Packed => '1/1' */
extern char *datestr_s_pad(time_t t);	/* Packed => ' 1/1 ' (5chars) */
extern char *timestr_l(time_t t);	/* Packed => 02:30:12 */
extern char *timestr(time_t t);		/* Packed => 2:30 */
extern char *timestr_p(time_t t);	/* Packed => 02:30 */
extern char *timestr_s(time_t t);	/* Packed => 0230 */
extern char *datetimestr(time_t t);	/* Day, date, time */
extern char *tz2str(double tz);		/* Timezone to a string */

extern time_t pcstr2t(char *pcdate, char *pctime);	/* PC string to time_t */
extern char *pcdatestr(time_t t);			/* time_t to PC date */
extern char *pctimestr(time_t t);			/* time_t to PC time */

#endif
