
#ifndef LUSER_H
#define LUSER_H

#include <time.h>

#include "ctypes.h"
#include "cmath.h"
#include "version.h"
#include "cfile.h"
#include "csock.h"

#define F_BEEPS		1
#define F_TIMESTAMP	2
#define F_TIMER		4
#define F_PCCOMPAT	8
#define F_FILTER	16

#define M_DX		1
#define M_ANN		2
#define M_WWV		4
#define M_TALK		8
#define M_NUSER		16
#define M_LUSER		32
#define M_LINK		64
#define M_NODE		128

#define M_NULL 		0

#define MAX_GROUP	20
#define MAX_PROMPT	8

#define M2_NONE		0
#define M3_NONE		0

struct luserf_t {
	call_t call;		/* Callsign */
	char personal[41];	/* Some personal description */
	
	loc_t locator;		/* Mainhead locator */
	struct coord_t loc;	/* Coordinates */
	
	int group;		/* Privilege group */
	
	unsigned long messages;	/* Messages flags */
	unsigned long beeps;	/* Beeps flags */
	unsigned long flags;	/* General flags */
	unsigned long login_act; /* What to do on login */
	
	int charset;		/* Character conversion table */
	int prompt;		/* Prompt type */
	int page_length;	/* Page length */
	int page_width;		/* Page width */
	int language;		/* Which language */
	
	unsigned long logins;	/* How many connects */
	time_t time;		/* Last logged in/out (packed datetime) */
};

struct luser_t {
	struct csock_t		*sock;
	struct luserf_t		*f;
	struct nuser_t		*nu;
	struct filter_t		*fl;
	
	int			egid;	/* Effective group */
	
	int 			m2, m3;	/* Mode */
	long			m4, m_timer, seed; /* per-mode temp ints */
	char			*str;		/* per-mode string */
	char			path[PATHLEN];	/* current directory */
	
	char			last_talk_from[30];
	
	int			illegal_cmds;
	int			su_tries;
	
	int			locked;
	
	struct luser_t		*next;
	struct luser_t		**prevp;
};

extern int luser_count;
extern int luser_max;

extern struct luser_t *get_luser(call_t *call);

extern int send_us(int mtype, int mflag, char *s);

extern void luser_login(struct csock_t *s);
extern void luser_logout(struct csock_t *s);

extern int luser_handler(struct csock_t *s, void *data, int len);

#endif
