
#include "cluster.h"
#include "command.h"
#include "help.h"
#include "cmd_sys.h"
#include "cmd_cluster.h"
#include "cmd_net.h"
#include "network.h"
#include "net_ping.h"

/*
 *	Configuration file commands
 */

struct cmd cluster_cmds[] = {
	{ "bye",		cmd_bye			},
	{ "help",		cmd_help		},
	{ "memory",		cmd_memory		},
	{ "nodes",		cmd_nodes		},
	{ "sockets",		cmd_sockets		},
	{ "talk",		cmd_talk		},
	{ "treply",		cmd_treply		},
	{ "users",		cmd_users		},
	{ "ping",		cmd_ping		},
	{ "pstatus",		cmd_pstatus		},
	{ "version",		cmd_version		},
	{ "?",			cmd_help		},
	{ "!",			cmd_version		},
	{ NULL,			NULL,			}
};

/*
 *	Send a prompt
 */

void prompt(struct csock_t *s)
{
        csprintf(s, "c>\n");
}

/*
 *	Cluster events as sent to users
 */

void user_linkadd(struct link_t *l)
{
}

void user_linkdel(struct link_t *l, char *reason)
{
}

void user_nodeadd(struct node_t *n)
{
}

void user_nodedel(struct node_t *n, char *reason)
{
}

void user_useradd(struct nuser_t *u)
{
}

void user_userdel(struct nuser_t *u)
{
}

void user_userhere(struct nuser_t *u)
{
}

void user_useraway(struct nuser_t *u)
{
}

void user_dx(struct dx_t *dx)
{
}

void user_announce(struct ann_t *ann)
{
}

void user_wwv(struct wwv_t *wwv)
{
}

