
 (*

     Clusse - LPT port DAC unit (just an early beta version!)

     Heikki Hannikainen (OH7LZB) 1995, 1996

    With the greatest thanks to Sakari Nylund, OH1KH for the idea and
  the original source code. (Contact: OH1KH @ OH1RBF.FIN.EU )

  hessu@pspt.fi oh7lzb@gw.oh7rba.ampr.org oh7lzb@oh7rba.#kuo.fin.eu

    This source code may be used in amateur radio related applications
  which are donated to the public domain, as long as the original
  authors are acknowledged in the source code, the executable, it's user
  interface and the documentation of the application.

 *)

Unit Speech;

Interface

Type
  TLanguage    = (Finnish, English);
  TSoundHW     = (LptDac, sb);

Var
  SoundHW      : TSoundHW;   { Hardware type }
  { Note: LPT is always used for keying the transmitter! }
  LPTInt       : Byte;       { LPT port IRQ }
  LPTBase      : Word;       { LPT base address }

  sbInt        : Byte;
  sbBase       : Word;
  sbDMA        : Byte;

  Speaking     : Boolean;    { Speaking right now? }
  Language     : TLanguage;  { Language used }

Const
  { CW special characters }
  CWS_SK     : char = chr(1);

Procedure Cw(Str:String);               { Send a string in CW }
Procedure DX(Freq:LongInt;Call:String); { DX spot }

Function Install:Boolean;
Procedure UnInstall;         { Remove the interrupt handler }
Procedure ReadData;          { Read speech data from disk }

 { *********** *********** *********** *********** *********** *********** }

Implementation

Uses Dos, Crt;

Const

  sbDmaChannel : Array [0..3,1..3] of Byte
             = (($87,$0,$1),($83,$2,$3),($81,$2,$3),($82,$6,$7));

  Hw2SwInt   : Array [0..15] of Byte
             = ($08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
                $70, $71, $72, $73, $74, $75, $76, $77);

  QLen       = 2048;   { Size of the word queue buffer }
  CWSpeed    = 20;     { CW speed, in WPM (at least, nearly..) }

  { CW characters in the word queue }
  CW_Dot     : char = chr(35);
  CW_Space   : char = chr(36);   { length of one dot }
  CW_Dash    : char = chr(37);

  { Special words in the word queue }
  W_toista   : char = chr(38); { These ones only in Finnish }
  W_kymmenen : char = chr(39);
  W_kymmenta : char = chr(40);
  W_sata     : char = chr(41);
  W_sataa    : char = chr(42);
  W_tuhat    : char = chr(43);
  W_tuhatta  : char = chr(44);
  W_miljoona : char = chr(45);
  W_miljoonaa: char = chr(46);
  W_kautta   : char = chr(47);

  W_space01  : char = chr(60); { These ones in all languages }
  W_space1   : char = chr(61);
  W_dx       : char = chr(62);
  W_khz      : char = chr(63);
  W_jaksolla : char = chr(64);


Type
 SamplePosRec = Record
                Seg,
                Ofs : Word;
                End;
 PTTStateType = (On, off);

 IntBlock = Record { The original value of a changed int vector }
            IntOldIP  : Word;
            IntOldCS  : Word;
            IntNumber : Byte;
            End;

 TQueue   = Array[1..QLen] of Char; { Word queue type }

Var

 Words      : Array [35..90] of Pointer; { The words are stored here }
 WLength    : Array [35..90] of Word;    { The length of each word }

 Queue      : ^TQueue;                   { Words queued for playing }
 QWrite,                                 { pointers to the queue: writing }
 QRead      : Word;                      { ... reading }

 SamplePos  : SamplePosRec;              { Where is the player going }

 br         : Word;

 { Interrupts }

 SwInt      : Byte;                      { Software int }
 Block      : IntBlock;                  { Original int vector }

 PICPort    : Byte;
 IntStopMask, IntStartMask: Byte;

 { DMA }

 DMAMaskPort     : Word;
 DMAClrPtrPort   : Word;
 DMAModePort     : Word;
 DMABaseAddrPort : Word;
 DMACountPort    : Word;
 DMAPagePort     : Word;

 DMAStartMask    : Byte;
 DMAStopMask     : Byte;
 DMAMode         : Byte;

 { SoundBlaster }

 sbDataAvail,
 sbRead,
 sbWrite,
 sbReset    : Word;

 sbOfs,
 sbPage     : Word;

 { *********** *********** *********** *********** *********** *********** }
 { Read/Write a byte from/to the SB's DSP                                            }
 { *********** *********** *********** *********** *********** *********** }

Procedure sbWriteDSP(Data : Byte);
Begin
 While Port[sbWrite] and $80 <> 0 do;
 Port[sbWrite] := Data;
End;

Function sbReadDSP : Byte;
Begin
 While Port[sbDataAvail] and $80 = 0 do;
 sbReadDSP := Port[sbRead];
End;

 { *********** *********** *********** *********** *********** *********** }
 { Control the SB mixer                                                    }
 { *********** *********** *********** *********** *********** *********** }

Procedure sbSpeakerOn;
Begin
 sbWriteDSP($D1);
End;

Procedure SpeakerOff;
Begin
 sbWriteDSP($D3);
End;

 { *********** *********** *********** *********** *********** *********** }
 { Control the SB interrupts                                               }
 { *********** *********** *********** *********** *********** *********** }

Procedure sbIntStop;
Begin
  Port[PICPort] := Port[PICPort] or IntStopMask;
End;

Procedure sbIntStart;
Begin
  Port[PICPort] := Port[PICPort] and IntStartMask;
End;

 { *********** *********** *********** *********** *********** *********** }
 { Control the SB's DMA controller                                         }
 { *********** *********** *********** *********** *********** *********** }

Procedure sbDMAStop;
Begin
 sbWriteDSP($D0);
End;

Procedure sbDMAContinue;
Begin
 sbWriteDSP($D4);
End;

 { *********** *********** *********** *********** *********** *********** }
 { Play a sample through the SB:
    Size           Size of data block (Max. 64 Kb at a time!)
    Freq           Sampling rate in hertz                                  }
 { *********** *********** *********** *********** *********** *********** }

Procedure sbPlaySample(Sample : Pointer; Size : Word; Freq : Word);
Begin

 sbIntStart;
 Dec(Size);
 sbOfs := Seg(Sample^) Shl 4 + Ofs(Sample^);
 sbPage := (Seg(Sample^) + Ofs(Sample^) Shr 4) Shr 12;
 Port[DMAMaskPort]     := DMAStopMask;  (* Stop any DMA activity so far *)
 Port[DMAClrPtrPort]   := $00;
 Port[DMAModePort]     := DMAMode;
 Port[DMABaseAddrPort] := Lo(sbOfs);
 Port[DMABaseAddrPort] := Hi(sbOfs);
 Port[sbDMAChannel[1,1]] := sbPage;
 Port[sbDMAChannel[1,3]] := Lo(Size);
 Port[sbDMAChannel[1,3]] := Hi(Size);
 Port[DMAMaskPort] := sbDMA;
 sbWriteDSP($D1); {?}
 sbWriteDSP($40);
 sbWriteDSP(256 - (1000000 Div Freq));
 sbWriteDSP($14);
 sbWriteDSP(Lo(Size));
 sbWriteDSP(Hi(Size));

End;

 { *********** *********** *********** *********** *********** *********** }
 { Control the PTT line                                                    }
 { *********** *********** *********** *********** *********** *********** }

Procedure PTT(State:PTTStateType);
Begin

 Case State of
  On  : Port[LPTBase+2] := Port[LPTBase+2] and 254;
  Off : Port[LPTBase+2] := Port[LPTBase+2] or 1;
 End;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Start playing from word...                                              }
 { *********** *********** *********** *********** *********** *********** }

Procedure SpeakWord(ch:Char);
Var b : Byte;
Begin

 b := Ord(Ch);

 Case SoundHw of

   sb     : sbPlaySample(Words[b],WLength[b],10000);

   lptDac : Begin
            SamplePos.Seg := Seg(Words[b]^);  { Where shall we play from... }
            SamplePos.Ofs := Ofs(Words[b]^);

            Port[$21] := Port[$21] and $7F; { Enable interrupts... PIC }
            Port[LPTbase+2] := Port[LPTbase+2] or $10;
              { Enable interrupts, paraller port controller }
            End;

 End;

 Speaking := True;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Take the next word from the queue...                                    }
 { *********** *********** *********** *********** *********** *********** }

Procedure NextWord;
Begin

 If not (QRead = QWrite)
   then Begin { We still have words queued.. }
        Inc(QRead);
        If QRead > QLen then QRead := 1;
        SpeakWord(Queue^[QRead]);
        End
   else Begin { Finished. }
        Speaking := False;
        PTT(Off);
        End;

End;

 { *********** *********** *********** *********** *********** *********** }
 { This procedure is executed every time the ACK pin (10) of the LPT port  }
 { goes high. Puts one byte into the LPT port.                             }
 { *********** *********** *********** *********** *********** *********** }

Procedure lptIntHandler; Interrupt;
Var
  Out : Byte;
Begin

  Out := mem[SamplePos.Seg:SamplePos.Ofs];

  If out = 0               { When the word ends... }
    then Begin
         Port[$21] := Port[$21] or $80; { Disable interrupts, PIC }
         Port[LPTbase+2] := Port[LPTbase+2] and $EF; { Disable interrupts, LPT }
         NextWord; { Next word.. }
         End
    else Begin
         Port[LPTbase] := out;    { Next byte to the LPT port }
         Inc(SamplePos.Ofs);
         End;

  Inline($FA);             { CLI }
  Port[$20] := $20;        { clear interrupt flag }

End;

 { *********** *********** *********** *********** *********** *********** }
 { *********** *********** *********** *********** *********** *********** }

Procedure sbIntHandler; Interrupt;
Var
  Info : Byte;
Begin
  asm CLI end;  (* NO Interrupts while in this code! *)
  Writeln('in');
  Info := Port[sbDataAvail];
  sbIntStop;
  NextWord;
  Inline($FA);             { CLI }
  asm STI end;      (* Interupts are OK now! *)
  Port[PICPort - 1] := $20;
  Writeln('out');
end;

 { *********** *********** *********** *********** *********** *********** }
 { Start speaking, if not already speaking and if we have something to say }
 { *********** *********** *********** *********** *********** *********** }

Procedure KickSpeech;
Begin

 If not (speaking or (QRead = QWrite))
  then Begin
       Inc(QRead);
       If QRead > QLen then QRead := 1;
       PTT(On);
       SpeakWord(Queue^[QRead]);
       End;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Put a string to the queue                                               }
 { *********** *********** *********** *********** *********** *********** }

Procedure SpeakString(Str:String);
Var
  b : Byte;
Begin

 For b := 1 to Length(Str)
  do Begin
     Inc(QWrite);
     If QWrite > QLen then QWrite := 1;
     Queue^[QWrite] := Str[b];
     End;

 KickSpeech;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Spell a frequency                                                       }
 { *********** *********** *********** *********** *********** *********** }

Procedure Sataset(Var f:Byte; Var luku, jono:String; Lisa1, Lisa2:String);
Var
  Tyo : string;
Begin

  Tyo:='';
  { ykkoset }
  If f = 1
    then If luku[f] = '1'
           then Begin
                If Length(luku) = 1
                  then tyo := '1';
                Dec(f);
                End
           else Begin
                tyo := luku[f];
                Dec(f);
                End;

  If f > 1
    then If luku[f-1] = '1'
           then Begin
                If luku[f] <> '0'
                  then tyo := luku[f] + W_toista
                  else tyo := W_kymmenen;
                Dec(f,2);
                End
           else Begin
                If luku[f] <> '0'
                  then tyo := luku[f];
                Dec(f);
                If f > 0
                  then If luku[f] <> '0'
                         then Begin
                              tyo := luku[f] + W_kymmenta + tyo;
                              Dec(f);
                              End
                         else Dec(f);
                end;
  { sadat }
  If f > 0
    then If luku[f] <> '0'
           then Begin
                If luku[f]= '1'
                  then Begin
                       tyo := W_sata + tyo;
                       Dec(f);
                       End
                  else Begin
                       tyo := luku[f] + W_sataa + tyo;
                       Dec(f);
                       End;
                End
           else Dec(f);

  if tyo = ''
    then Begin
         If f = 0
           then jono := lisa1 + jono;
         end
    else If tyo = '1'
           then jono := tyo + lisa1 + jono
           else jono := tyo + lisa2 + jono;

End;


Procedure SpeakFreq(f:LongInt);
Var
  s    : String[8];
  Jono : String[20];
  b    : Byte;
  freq : Real;
Begin


 freq := f / 10;
 Str(Round(Freq),s);
 Case Language of

  English : Jono := s;
  Finnish : Begin { Not at all so simple... }

            b := Length(s);
            jono := '';

            SataSet(b,s,jono,'','');
            Jono := W_space01 + jono;

            If b > 0
              then Begin
                   SataSet(b,s,jono,W_tuhat,W_tuhatta);
                   Jono := W_space01+jono;
                   End;

            If b > 0
              then Begin
                   SataSet(b,s,jono,W_miljoona,W_miljoonaa);
                   Jono := W_space01 + jono;
                   End;

            If b > 0
              then Begin
                   SataSet(b,s,jono,W_tuhat,W_tuhatta);
                   Jono := W_space01 + jono;
                   End;

            End;

 End;

 SpeakString(Jono);
 KickSpeech;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Put a string in the queue, in CW                                        }
 { *********** *********** *********** *********** *********** *********** }

Procedure CW(Str:String);
Var
  b, p   : Byte;
  CWStr  : String[6];
  CWOStr : String;
Begin

 CWOStr := '';

 For b := 1 to Length(Str)
  do Begin
     Case Str[b] of
       '0' : CWStr := '-----';
       '1' : CWStr := '.----';
       '2' : CWStr := '..---';
       '3' : CWStr := '...--';
       '4' : CWStr := '....-';
       '5' : CWStr := '.....';
       '6' : CWStr := '-....';
       '7' : CWStr := '--...';
       '8' : CWStr := '---..';
       '9' : CWStr := '----.';
       'A' : CWStr := '.-';
       'B' : CWStr := '-...';
       'C' : CWStr := '-.-.';
       'D' : CWStr := '-..';
       'E' : CWStr := '.';
       'F' : CWStr := '..-.';
       'G' : CWStr := '--.';
       'H' : CWStr := '....';
       'I' : CWStr := '..';
       'J' : CWStr := '.---';
       'K' : CWStr := '-.-';
       'L' : CWStr := '.-..';
       'M' : CWStr := '--';
       'N' : CWStr := '-.';
       'O' : CWStr := '---';
       'P' : CWStr := '.--.';
       'Q' : CWStr := '--.-';
       'R' : CWStr := '.-.';
       'S' : CWStr := '...';
       'T' : CWStr := '-';
       'U' : CWStr := '..-';
       'V' : CWStr := '...-';
       'W' : CWStr := '..-';
       'X' : CWStr := '-..-';
       'Y' : CWStr := '-.--';
       'Z' : CWStr := '--..';
       '' : CWStr := '.--.-';
       '' : CWStr := '.-.-';
       '' : CWStr := '---.';
       '.' : CWStr := '.-.-.-';
       ',' : CWStr := '--,,--';
       '/' : CWStr := '-..-.';
       '-' : CWStr := '_...._';
       '=' : CWStr := '_..._';
       '?' : CWStr := '..--..';
       ' ' : CWStr := ',,';
       Chr(1) : CWStr := '...-.-';  { [SK] }
     End;

     CWOStr := CWOStr + CW_Space + CW_Space;
     For p := 1 to Length(CWStr)
      do Begin
         CWOStr := CWOStr + CW_Space;
         Case CWStr[p] of
          '.' : CWOStr := CWOStr + CW_Dot;
          '-' : CWOStr := CWOStr + CW_Dash;
          ',' : CWOStr := CWOStr + CW_Space + CW_Space;
         End;
         End;

     End;

 SpeakString(CWOStr);

End;

 { *********** *********** *********** *********** *********** *********** }
 { Add a DX spot to the queue                                              }
 { *********** *********** *********** *********** *********** *********** }

Procedure DX(Freq:LongInt;Call:String);
Begin

 SpeakString(W_Space01 + W_Dx + W_Space1 + Call + W_Space1
             + W_Jaksolla + W_Space1);
 SpeakFreq(Freq);
 SpeakString(W_Space01 + W_KHz + W_Space1);

End;

 { *********** *********** *********** *********** *********** *********** }
 { Read the speech data from disk to memory                                }
 { *********** *********** *********** *********** *********** *********** }
 { Does not include I/O error checking yet ... needs to be added ... }

Procedure ReadData;
Type
  IdxRec = Record
           Pos    : LongInt;
           Length : Word;
           End;
  Table  = Array[0..65534] of Byte;
Var
  Id    : IdxRec;
  IdF   : File of IdxRec;
  f     : File;
  b, w  : Word;
  g     : Byte;
  t     : ^Table;
Begin

 Assign(IdF,'all.idx');
 Reset(IdF);

 Assign(f,'all.voc');
 Reset(f,1);

 b := 37;

  While not eof(IdF)
    do Begin
       Inc(b);
       Read(IdF,Id);
       WLength[b] := Id.Length + 1;
       GetMem(Words[b],WLength[b]);
       BlockRead(f,Words[b]^,Id.Length); { hey, add some error checking! }
       end;

 Close(IdF);
 Close(f);

 { Recognize the language }
 g := 0;
 For b := 2 to 20 do g := g or mem[Seg(Words[38]^):b];
 If g = $80
   then Language := English
   else Language := Finnish;

 { Initialize CW data }
 { Not sure about the next line, but it's an approximation 8-) }
 w := Round(5000 / (CWSpeed / 1.2));  { Length of a dot, in bytes! }
 WLength[35] := w;
 GetMem(Words[35],w);
 t := Words[35];
 For b := 0 to w - 1
  do Begin
     g := Trunc((Sin(b / 1.95) + 1) * 127) + 1; { Sine wave... [1..255] }
     t^[b] := g;
     End;
 t^[w-1] := 0; { Set the last byte to 0! }

 GetMem(Words[36],w); { A pause, length of a dot }
 WLength[36] := w;
 t := Words[36];
 For b := 0 to w - 1
  do t^[b] := $80;
 t^[w-1] := 0;

 w := w * 3; { A dash is three times as long as a dot }
 WLength[37] := w;
 GetMem(Words[37],w);
 t := Words[37];
 For b := 0 to w - 1
  do Begin
     g := Trunc((Sin(b / 1.95) + 1) * 127) + 1;
     t^[b] := g;
     End;
 t^[w-1] := 0;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Initialize the lpt port.                                                }
 { *********** *********** *********** *********** *********** *********** }

Procedure lptPortInstall;
Begin

 Port[LPTBase+2] := 11; { All LPT control lines down }
 Port[LPTbase]   := $80; { LPT data lines down }
 Port[LPTBase+2] := 5;   { PTT down, others up (power the oscillator) }

End;

 { *********** *********** *********** *********** *********** *********** }
 { Install the interrupt handler and initialize the LPT port.              }
 { *********** *********** *********** *********** *********** *********** }

Procedure lptInstall;
Var
  Regs  : Registers;
  IntDS : Word;
Begin

 lptPortInstall;

 SwInt := Hw2SwInt[LPTInt];
 If lptInt <= 7 then PICPort := $21 else PICPort := $A1;

 IntStopMask  := 1 shl (lptInt mod 8);
 IntStartMask := not (IntStopMask);

 { Get the original interrupt vector }
 IntDS           := DSeg;
 Block.IntNumber := SwInt;
 Regs.AH         := $35;
 Regs.AL         := SwInt;
 MSDos(Regs);
 Block.IntOldCS  := Regs.ES;
 Block.IntOldIP  := Regs.BX;
 { and point it to our handler... }
 Regs.AH         := $25;
 Regs.AL         := SwInt;
 Regs.DS         := seg(lptIntHandler);
 Regs.DX         := ofs(lptIntHandler);
 MSDos(Regs);

End;

 { *********** *********** *********** *********** *********** *********** }
 { Removes the interrupt handler and turns off the LPT port.               }
 { *********** *********** *********** *********** *********** *********** }

Procedure lptUnInstall;
Var
  Regs : Registers;
Begin

  Port[$21] := Port[$21] or $80; { Disable interrupts, PIC }
  Port[LPTbase+2] := Port[LPTbase+2] and $EF; { Disable interrupts, LPT }

  Regs.AH := $25;
  Regs.AL := Block.IntNumber;
  Regs.DS := Block.IntOldCS;
  Regs.DX := Block.IntOldIP;
  MSDos(Regs);

  Port[LPTBase+2] := 11; { All LPT control lines down }

End;

 { *********** *********** *********** *********** *********** *********** }
 { Initialize the Sound Blaster, check if it's there                       }
 { *********** *********** *********** *********** *********** *********** }

Function sbInstall:Boolean;
Var
  Regs  : Registers;
  IntDS : Word;

Begin

 If sbInt <= 7 then PICPort := $21 else PICPort := $A1;

 IntStopMask  := 1 shl (sbInt mod 8);
 IntStartMask := not (IntStopMask);

 { DMA }
  DMAMaskPort     := $0A;
  DMAClrPtrPort   := $0C;
  DMAModePort     := $0B;
  DMABaseAddrPort := 2 * sbDMA;
  DMACountPort    := 2 * sbDMA + 1;
  Case sbDMA of
    0:  DMAPagePort := $87;
    1:  DMAPagePort := $83;
    2:  DMAPagePort := $81;
    3:  DMAPagePort := $82;
  end;
  DMAStopMask  := sbDMA + $04;
  DMAStartMask := sbDMA + $00;
  DMAMode      := sbDMA + $48;

 sbInstall := false;
 sbReset := sbBase + $06;
 sbRead := sbBase + $0A;
 sbWrite := sbBase + $0C;
 sbDataAvail := sbBase + $0E;
 Port[sbReset] := 1;
 Delay(1);
 Port[sbReset] := 0;
 Delay(1);
 If (Port[sbDataAvail] and $80 = $80) and (Port[sbRead] = $AA)
   then ;

 sbIntStop;
 SwInt := Hw2SwInt[sbInt];
 { Get the original interrupt vector }
 IntDS           := DSeg;
 Block.IntNumber := SwInt;
 Regs.AH         := $35;
 Regs.AL         := SwInt;
 MSDos(Regs);
 Block.IntOldCS  := Regs.ES;
 Block.IntOldIP  := Regs.BX;
 { and point it to our handler... }
 Regs.AH         := $25;
 Regs.AL         := SwInt;
 Regs.DS         := seg(sbIntHandler);
 Regs.DX         := ofs(sbIntHandler);
 MSDos(Regs);
 sbIntStart;
 sbSpeakerOn;

 sbInstall := True;

End;

 { *********** *********** *********** *********** *********** *********** }
 { Removes the sb interrupt handler                                        }
 { *********** *********** *********** *********** *********** *********** }

Procedure sbUnInstall;
Var
  Regs : Registers;
Begin

  sbIntStop;
  sbDMAStop;
  Regs.AH := $25;
  Regs.AL := Block.IntNumber;
  Regs.DS := Block.IntOldCS;
  Regs.DX := Block.IntOldIP;
  MSDos(Regs);

End;

 { *********** *********** *********** *********** *********** *********** }
 { Initialize hardware                                                     }
 { *********** *********** *********** *********** *********** *********** }

Function Install:Boolean;
Begin

 Install := False;
 ReadData;
 Case SoundHw of

   sb      : Begin
             lptPortInstall;
             If not sbInstall
               then Exit;
             End;

   lptDac  : lptInstall;

 End;
 Install := True;

End;

 { *********** *********** *********** *********** *********** *********** }
 { UnInstall the sound driver                                              }
 { *********** *********** *********** *********** *********** *********** }

Procedure UnInstall;
Begin

 Case SoundHw of

   sb      : sbUnInstall;
   lptDac  : lptUnInstall;

 End;

End;

 { *********** *********** *********** *********** *********** *********** }

Begin { Init }

 { These are set from outside the unit... }
 SoundHw := sb;

 sbBase  := $220;
 sbInt   := 5;
 sbDMA   := 1;

 LPTInt  := $7;
 LPTbase := $3bc;

 { Initial values... }
 Speaking := False;

 New(Queue);
 For QWrite := 1 to 2048 do Queue^[QWrite] := Chr(0);

 QWrite := 0;
 QRead := 0;

End. { Init }

