
Unit s_Exp;

Interface

Uses Drivers, Objects, Views, Dialogs, Strings, Validate, ConfFile, SetForm;

Type

   { User parameters }
  PExp = ^TExp;
  TExp = object(TDialog)
    Backup      : PConfig;
    Abandon     : Boolean;
    Usb_Timeout : PWordEntry;

    ExHour      : PByteEntry;
    E_Dx,
    E_Ann,
    E_WWV,
    E_Last,
    E_LUser,
    E_NUser,
    E_Node      : PWordEntry;

    b_Dx,
    b_Ann,
    b_WWV,
    b_Last,
    b_LUser,
    b_NUser,
    b_Node      : PWordEntry;

    constructor Init;
    destructor Done; virtual;
    constructor Load(var S: TStream);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
  end;

Const
  RExp: TStreamRec = (
     ObjType: 10046;
     VmtLink: Ofs(TypeOf(TExp)^);
     Load:    @TExp.Load;
     Store:   @TExp.Store
  );

Procedure RegisterExpForm;

Implementation { ********************************************************* }

Uses
  MsgBox;

 { *** TExp *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TExp.Init;
Var
  R : TRect;
  EntryXPos  : Byte;
Const
  InfoXEnd   = 26;
Begin

  R.Assign(0, 0, 51, 16);
  inherited Init(R,'Expiration');

  EntryXPos := 28;

  R.Assign(31,2,31 + 4,3);
  ExHour := New(PByteEntry, Init(R,@Conf^.Exp.ExpiryHour,2,0,11));
  Insert(ExHour);

  R.Assign(2, 2, 29, 3);
  Insert(New(PLabel, Init(R, '~H~our to run expiration at:', ExHour)));

  R.Assign(4,4,35,5);
  Insert(New(PStaticText, Init(R, 'Days to store data on disk:')));

  { Expiration }

  R.Assign(EntryXPos,5,EntryXPos + 7,6);
  E_Dx := New(PWordEntry, Init(R,@Conf^.Exp.Expirytimes.Dx,5,0,65535));
  Insert(E_Dx);

  R.Assign(2, 5, InfoXEnd, 6);
  Insert(New(PLabel, Init(R, '~D~x spots:', E_Dx)));

  R.Assign(EntryXPos,6,EntryXPos + 7,7);
  E_Ann := New(PWordEntry, Init(R,@Conf^.Exp.Expirytimes.Ann,5,0,65535));
  Insert(E_Ann);

  R.Assign(2, 6, InfoXEnd, 7);
  Insert(New(PLabel, Init(R, '~A~nnouncements:', E_Ann)));

  R.Assign(EntryXPos,7,EntryXPos + 7,8);
  E_WWV := New(PWordEntry, Init(R,@Conf^.Exp.Expirytimes.WWV,5,0,65535));
  Insert(E_WWV);

  R.Assign(2, 7, InfoXEnd, 8);
  Insert(New(PLabel, Init(R, '~W~WV data:', E_WWV)));

  R.Assign(EntryXPos,8,EntryXPos + 7,9);
  E_Last := New(PWordEntry, Init(R,@Conf^.Exp.Expirytimes.Last,5,0,65535));
  Insert(E_Last);

  R.Assign(2, 8, InfoXEnd, 9);
  Insert(New(PLabel, Init(R, '~L~ast connections list:', E_Last)));

  R.Assign(EntryXPos,9,EntryXPos + 7,10);
  E_LUser := New(PWordEntry, Init(R,@Conf^.Exp.Expirytimes.LUser,5,0,65535));
  Insert(E_LUser);

  R.Assign(2, 9, InfoXEnd, 10);
  Insert(New(PLabel, Init(R, 'Local ~u~sers:', E_LUser)));

  R.Assign(EntryXPos,10,EntryXPos + 7,11);
  E_NUser := New(PWordEntry, Init(R,@Conf^.Exp.Expirytimes.NUser,5,0,65535));
  Insert(E_NUser);

  R.Assign(2, 10, InfoXEnd, 11);
  Insert(New(PLabel, Init(R, 'N~e~twork users:', E_NUser)));

  R.Assign(EntryXPos,11,EntryXPos + 7,12);
  E_Node := New(PWordEntry, Init(R,@Conf^.Exp.Expirytimes.Node,5,0,65535));
  Insert(E_Node);

  R.Assign(2, 11, InfoXEnd, 12);
  Insert(New(PLabel, Init(R, '~N~odes:', E_Node)));

  { Buffer sizes }
  R.Assign(37,3,47,5);
  Insert(New(PStaticText, Init(R, 'Memory buffers:')));

  Inc(EntryXPos,10);
  R.Assign(EntryXPos,5,EntryXPos + 7,6);
  b_Dx := New(PWordEntry, Init(R,@Conf^.Buf.BufSizes.Dx,5,25,65500));
  Insert(b_Dx);

  R.Assign(EntryXPos,6,EntryXPos + 7,7);
  b_Ann := New(PWordEntry, Init(R,@Conf^.Buf.BufSizes.Ann,5,25,210));
  Insert(b_Ann);

  R.Assign(EntryXPos,7,EntryXPos + 7,8);
  b_WWV := New(PWordEntry, Init(R,@Conf^.Buf.BufSizes.WWV,5,10,540));
  Insert(b_WWV);

  R.Assign(EntryXPos,8,EntryXPos + 7,9);
  b_Last := New(PWordEntry, Init(R,@Conf^.Buf.BufSizes.Last,5,25,1000));
  Insert(b_Last);

  R.Assign(EntryXPos,10,EntryXPos + 7,11);
  b_NUser := New(PWordEntry, Init(R,@Conf^.Buf.BufSizes.NUser,5,10,700));
  Insert(b_NUser);

  R.Assign(EntryXPos,11,EntryXPos + 7,12);
  b_Node := New(PWordEntry, Init(R,@Conf^.Buf.BufSizes.Node,5,10,1800));
  Insert(b_Node);


  b_Dx^.SetState(sfDisabled, True);
  b_Ann^.SetState(sfDisabled, True);
  b_WWV^.SetState(sfDisabled, True);
  b_Last^.SetState(sfDisabled, True);
  b_NUser^.SetState(sfDisabled, True);
  b_Node^.SetState(sfDisabled, True);

  { -- }

  R.Assign(9, 13, 19, 15);
  Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
  Inc(R.A.X, 12); Inc(R.B.X, 12);
  Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));


  SelectNext(False);
  Options := Options or ofCentered or OfSelectable;
  EventMask := evKeyDown + evCommand + evBroadcast;
  Abandon := False;
  New(Backup);
  Backup^ := Conf^;

End;

Destructor TExp.Done;
Begin

 inherited Done;

 If Abandon
   then Begin
        Dispose(Conf);
        Conf := Backup;
        End
   else Dispose(Backup);

End;

Constructor TExp.Load(var S: TStream);
Begin
  inherited Load(S);
End;

Procedure TExp.HandleEvent(var Event: TEvent);
Begin

  Case Event.What of
    evCommand: Case Event.Command of
                 cmCancel : Abandon := True;
               End;
  End;
  inherited HandleEvent(Event);

End;

Procedure TExp.Store(var S: TStream);
Begin
  TView.Store(S);
{  S.Write(Status, SizeOf(Status) + SizeOf(Number) + SizeOf(Sign) +
    SizeOf(Operator) + SizeOf(Operand));}
End;


Procedure RegisterExpForm;
Begin
  RegisterType(RExp);
End;

End.
