
  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit Main;

  { Includes the main polling loop the program spins in. To figure out
    how the program works, start reading here. Also includes the main
    input multiplexer, and connection/disconnection handlers. }

Interface

Procedure Handle_Input(i:Byte);
Procedure MainLoop;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Implementation
Uses ExecwSwp, Crt, MultiTsk, BPQ, Cluster, Convers, Protocol, PCLink,
     Linker, Console, ConfFile
     {$IFDEF Speedometer} , Screen, cStrings {$ENDIF};

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Handle_Input(i:Byte);
Begin

  Idle := False;

  Case Sock[i]^.Mode of { Muksataan }
    SM_Clusse   : Clusse(i);
    SM_Convers  : Conffi(i);
    SM_CluLink  : Disconnect(i);
    SM_PCLink   : PCLink.PCRcv(i);
    SM_Linking  : Linkup(i);
{    SM_ConvLink : ConvLnk(i);}
    SM_Console  : Console.Recv(i);
  End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Forward the connection event wherever it belongs }

Procedure Handle_Connect(i:Byte);
Var
  ca : CallRec;
  l  : LinkRecP;
Begin

  Idle := False;

  Ca := StripSSID(Get_Callsign(i));
  l := Links;
  While assigned(l)
   do Begin
      With l^
        do Begin
           If (Mode = LM_Incoming) and (Ca = StripSSID(Call))
             then Begin
                  BPQ.Sock[i]^.Mode := SM_PCLink;
                  Protocol.Login(i,l);
                  Exit;
                  End;
           End;
      l := l^.Next;
      End;

  Case Sock[i]^.Mode of
    SM_Disc    : Cluster.Login(i);
    SM_Console : Console.Conn(i);
  else Linker.Login(i);
  End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Forward the disconnection event wherever it belongs }

Procedure Handle_Disconnect(i:Byte);
Begin

  Idle := False;

  Case Sock[i]^.Mode of
    SM_Clusse,
    SM_Convers,
    SM_ThrowOut : Cluster.LogOut(i);
    SM_CluLink,
    SM_PCLink   : Protocol.LogOut(i);
    SM_Linking  : Linker.LogOut(i);
    SM_Console  : Console.Disc(i);
  End;

  BPQ.logout(i); { Clear the socket }

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure MainLoop;
Var
 i, n : Byte;

{$Ifdef Speedometer}
  LoopCounter,
  IdleCounter           : LongInt;
  Counter_last_update   : Word;
{$Endif}

Begin

{$Ifdef Speedometer}

 Loopcounter := 0;
 Idlecounter := 0;
 Counter_last_update := Dt.Sec;

{$Endif}

  Repeat

    Repeat

      Console.Timer;

      If IfMonitor
        then Band_Monitor; { Monitor the interfaces }

      { Serve the public }
      Case Conf^.Ifc.IfType of

        G8BPQ : Begin
                For i := 1 to Conf^.Ifc.No_ports
                  do Begin

                     n := BPQ_CheckState(i);
                     Case n of
                      1 : Handle_Connect(i);
                      2 : If Assigned(Sock[i])
                             then Handle_Disconnect(i);
                     End;

                     If Assigned(Sock[i]) and Get_resp(i)
                       then Handle_input(i);
                     End;
                End;

        Flex :  Begin

                i := Flex_GetCon;
                If i > 0
                  then Handle_Connect(i);

                For i := 1 to Conf^.Ifc.No_Ports
                  do If not (Stream[i] = 0) then
                     Begin
                     n := Flex_CheckStream(i);

                     Case n of

                       1 : Handle_Input(i);
                       2 : Handle_Disconnect(i);

                     End;
                     End;
                End;
      End;

      If MultiTaskers and Idle then IdleTime;

      {$Ifdef Speedometer} { Update the Speed-o-meter }
      If Idle then Inc(IdleCounter);
      Inc(LoopCounter);

      If Counter_Last_Update <> Dt.Sec then begin
                                            Window(1,2,80,2);
                                            TextAttr := Pal^[cmStat2];
                                            Write(PadLeft(21,Int2Str(Idlecounter) + ' / ' + Int2Str(Loopcounter) + ' = '
                                                  + Int2Str(Round(Idlecounter/Loopcounter*100)) + ' %'));
                                            Window(1,25,80,25);
                                            GotoXY(EditXPos,1);
                                            Loopcounter := 0;
                                            Idlecounter := 0;
                                            Counter_last_update := Dt.Sec;
                                            end;
      {$Endif}

      Idle := True;

    Until Keypressed;

    { Whoa, a keypress on the console }
    Idle := False;
    Keyboard;

 until False;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

End.
