//--------------------------------------------------------------------------
//------ BUCKTSR for HamCall of BuckMaster functions -----------------------
//--------------------------------------------------------------------------
//------ by Olivier Le Cam F5MZN -------------------------------------------

#include <dos.h>
#include <string.h>
#include <stdio.h>
#include <process.h>

#define BUCK_CALLSIGN    181
#define BUCK_CLASS       182
#define BUCK_BMMODE      183
#define BUCK_FIRSTNAME   184
#define BUCK_MIDDLE      185
#define BUCK_LAST        186
#define BUCK_SUFFIX      187
#define BUCK_STREET      188
#define BUCK_RECIPADRESS 189
#define BUCK_ALIENADRESS 190
#define BUCK_CITY        191
#define BUCK_STATE       192
#define BUCK_POSTCODE    193
#define BUCK_BIRTHDATE   194
#define BUCK_DATEFIRST   195
#define BUCK_EXPDATE     196
#define BUCK_PROCESSDATE 197
#define BUCK_CONTRY      198
#define BUCK_HOURSGMT    199
#define BUCK_LATITUDE    200
#define BUCK_LONGITUDE   201
#define BUCK_GRID        202
#define BUCK_AREACODE    203
#define BUCK_PREVCALL    204
#define BUCK_PREVCLASS   205
#define BUCK_TRANSACTION 206


//--------------------------------------------------------------------------
//------ Service 1 - Set CD-ROM drive letter -------------------------------
//--------------------------------------------------------------------------
void Buck_SetDrive(char DriveLetter, int Int)
{
  union REGS regs;

  regs.x.ax = 1;
  regs.x.bx = (int) DriveLetter - 'A';

  int86(Int, &regs, &regs);
}

//--------------------------------------------------------------------------
//------ Service 2 - Set output String Details -----------------------------
//--------------------------------------------------------------------------
void Buck_SetOutput(char * String, int LenOfStr, int Int)
{
  union REGS regs;
//  struct SREGS sregs;
//  char string[340];

//  segread(&sregs);

//  strcpy(string, buffer);

  regs.x.ax = 2;
  regs.x.bx = FP_SEG(String);
  regs.x.cx = FP_OFF(String);
  regs.x.dx = LenOfStr;

  int86(Int, &regs, &regs);

}

//--------------------------------------------------------------------------
//------ Service 3 - Lookup Call -------------------------------------------
//--------------------------------------------------------------------------
void Buck_Lookup(char * CallSign, int Int)
{
  union REGS regs;

  regs.x.ax = 3;

  regs.x.bx = FP_SEG(CallSign);
  regs.x.cx = FP_OFF(CallSign);
  regs.x.dx = strlen(CallSign) + 1; //Includes trailing NULL

  int86(Int, &regs, &regs);
}

//--------------------------------------------------------------------------
//------ Extract a field ---------------------------------------------------
//--------------------------------------------------------------------------
//------ Input -------------------------------------------------------------
// char * String    : Records returning by BuckTsr
// char AsciiPrefix : Extract ASCII Prefic, defined by BuckMaster
//------ Output ------------------------------------------------------------
// Output : Extracted field
// Function return 1 if succes, 0 if no match.
//--------------------------------------------------------------------------
char * Buck_GetField(char * Output, char * String, char AsciiPrefix)
{
  unsigned char * FirstOccur;
  int  index = 0;

  FirstOccur = strchr(String, AsciiPrefix);

  if( FirstOccur )
  {
    FirstOccur++;
    while( FirstOccur[index] < 181 )
      Output[index] = FirstOccur[index++];
  }

  Output[index] = NULL;

  return( Output );
}

void main(void)
{
  char OutputString[255];
  char Call[20];
  char Field[255];

  Buck_SetDrive('F', 0x66);
  Buck_SetOutput(OutputString, 255, 0x66);


  while(1)
  {
    printf("\nEnter call (END to exit) > ");
    scanf("%s", Call);
    printf("\n");
    strupr(Call);

    if( ! strcmp(Call, "END") )
      exit(0);

    Buck_Lookup(Call, 0x66),

    printf("%s\n", OutputString);

    printf("Callsign : %s\n", Buck_GetField(Field, OutputString, BUCK_CALLSIGN));
    printf("Name : %s\n", Buck_GetField(Field, OutputString, BUCK_FIRSTNAME));
    printf("Last name : %s\n", Buck_GetField(Field, OutputString, BUCK_LAST));
    printf("Adress : %s\n", Buck_GetField(Field, OutputString, BUCK_STREET));
    printf("Postal code : %s\n", Buck_GetField(Field, OutputString, BUCK_POSTCODE));
    printf("City : %s\n", Buck_GetField(Field, OutputString, BUCK_CITY));
  }
}
