{$F-} {$R-} {$Q-} {$I-} {$V-} {$B-} {$X-}

  (*  Version 1.1

      A simple interface to use the HamCall CD-ROM by Buckmaster Publishing.
    Requires BuckTSR (Not supplied with pre-1995 CD-ROM's).

      Originally written for Clusse - the Free, Finnish DX-Cluster DX-Cluster
    and conference node software. See http://zone.pspt.fi/clusse/ or
    ftp://ftp.funet.fi/pub/ham/packet/cluster/clusse/ for details.

    (c) Heikki "Hessu" Hannikainen 1996

        Internet:   hessu@pspt.fi   (preferred)
        Amprnet:    oh7lzb@gw.oh7rba.ampr.org
        AX.25:      OH7LZB@OH7RBA.#KUO.FIN.EU

        Snail mail: Heikki Hannikainen
                    Blueberry Road 17
                    70280 Kuopijo
                    Finland

       THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND. THE
     ENTIRE RISK OF USING THIS PRODUCT IS ASSUMED BY YOU. IN NO EVENT WILL
     THE AUTHOR BE LIABLE FOR ANY DAMAGES WHATSOEVER ARISING OUT OF YOUR
     USE OR INABILITY TO USE THE SOFTWARE. BY USING THIS PRODUCT, YOU AGREE
     TO THE ABOVE LIMITATIONS.

       I hereby grant anyone to use this software free of charge in any
     product, which is distributed as free software with a similar
     licence to this software. If you think you could utilize this code
     in a commercial environment and you are ready to pay for it, contact
     the author.

       This source code is not for sale. You may not charge ANY money for
     a copy, except for the price of the media used for transferring (the
     disk or the phone bill). You can distribute this source code
     as long as it is unmodified and includes this copyright notice.
     This source code may be bundled on a CD-ROM or any other such
     commercial package, for the price of sending the original author
     mentioned above a copy of the product it is bundled with (1 copy
     per each different product).

     History:
        1.0 Initial release, seems to work OK.
        1.1 Longitude and latitude were swapped. Fixed.

  *)

{$IFDEF DPMI} This code does not work in DPMI or Windows! {$ENDIF}

Unit Buck;

Interface
Uses ConfFile, Database;

Var
  BuckInt     : Byte;          { BuckTSR interrupt (default 96) }
  BuckDrive   : Char;          { Buckmaster HamCall CD drive }

Procedure BuckInit;                                   { Initialize BuckTSR }
Function BuckLookUp(Key:CallRec;Res:ResProc):Boolean; { Call lookup }

 { ResProc is defined as:
     ResProc = Procedure(s:String);
   and is used for returning the result of the query, line by line. It
   was done this way to allow easy forwarding of the result to different
   interfaces (an user, or another node trough the linkinking protocol).
   CallRec is a String[9], but any string should be OK.
 }

 { * * * * * * * * * * * * * ** * * * * * * * * * * * * * * * * * * * * * }

Implementation
Uses Dos {$IFDEF Clusse}, cMath, cStrings{$ENDIF};

 { * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure BuckInit;            { Initialize BuckTSR }
Var
  Regs : Registers;
Begin

  { Set drive - Tell BuckTSR where to find the CD-ROM. }
  Regs.ax := 1;
  Regs.bx := Ord(BuckDrive) - 65;   { 0 is A:, 1 is B:, 2 is C: etc... }
  Intr(BuckInt,Regs);

End;

 { * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Function BuckLookUp(Key:CallRec;Res:ResProc):Boolean; { Call lookup }
Const
 BufLen  = 400;
Type
 BuckBuf = Array[1..BufLen] of Char;
Var
 Call   : Array[1..15] of Char;
 b      : Byte;
 Regs   : Registers;
 Str,
 St     : String;
 Buf    : ^BuckBuf;
{$IFDEF Clusse}
 coord  : CoordRec;
{$ENDIF}
Const
 DelReq : Boolean = False;

  { Get a field from the record. Result in Rec, returns False if the
    field is not present in this record. }
  Function GetStr(RecType:Byte;Var Rec:String):Boolean;
  Var
    w : Word;
  Begin
    w := 1;  { Search for it.... }
    While (w <= BufLen) and (Ord(Buf^[w]) <> RecType)
      do Inc(w);

    If w < BufLen
      then Begin { Ahh, we got it... }
           GetStr := True;
           Rec := '';
           Inc(w);
           While (w < BufLen) and (Ord(Buf^[w]) < 181)
             do Begin
                Rec := Rec + Buf^[w];
                Inc(w);
                End;
           End
      else GetStr := False;
  End;

Begin

 For b := 1 to Length(Key)
  do Call[b] := Key[b];
 Inc(b);
 Call[b] := #0; { Make it a C-type null-ended string }

 { Set buffer location - tell BuckTSR where to write the result. I do this
   again for every lookup. Otherwice, it wouldn't work if there were two
   programs under a multitasking OS, both doing lookups.... }

 New(Buf);
 Regs.ax := 2;
 Regs.bx := Seg(Buf^);
 Regs.cx := Ofs(Buf^);
 Regs.dx := BufLen;
 Intr(BuckInt,Regs);

 { Query BuckTSR }
 Regs.ax := 3;
 Regs.bx := Seg(Call);
 Regs.cx := Ofs(Call);
 Regs.dx := b; { Length }
 Intr(BuckInt,Regs);

 If GetStr(181,Str)
   then Begin { Lytyi }
        Res(Str + ':');

        { Get name }
        St := '';
        If GetStr(184,Str) then St := St + ' ' + Str;
        If GetStr(185,Str) then St := St + ' ' + Str;
        If GetStr(186,Str) then St := St + ' ' + Str;
        If GetStr(187,Str) then St := St + ' ' + Str;
        If GetStr(183,Str) then Begin
                                For b := 1 to Length(Str)
                                 do Case Str[b] of
                                     'C' : St := St + ' (club)';
                                     'M' : St := St + ' (military)';
                                     'R' : St := St + ' (RACES)';
                                     'D' : St := St + ' (FCC Delete)';
                                     'L' : DelReq := True; { This fellow has
                                              requested deletion from the CD }
                                    End;
                                End;
        Res(' Name:   ' + St);

        If DelReq { let's be nice to him... }
          then Begin
               Res(' The licence owner has requested deletion from the HamCall database,');
               Res(' no further information is available.');
               End
          else Begin
               If GetStr(188,Str) then Res(' Address: ' + Str);
               If GetStr(189,Str) then Res(' Recipr:  ' + Str);
               If GetStr(190,Str) then Res(' Alien:   ' + Str);
               If GetStr(191,Str) then Res(' City:    ' + Str);
               If GetStr(192,Str) then Res(' State:   ' + Str);
               If GetStr(193,Str) then Res(' Zip:     ' + Str);
               If GetStr(198,Str) then Res(' County:  ' + Str);

               If GetStr(182,Str)
                 then Begin
                      Case Str[1] of
                        'E' : St := 'Extra';
                        'A' : St := 'Advanced';
                        'G' : St := 'General';
                        'P' : St := 'Tech. Plus';
                        'T' : St := 'Technician';
                        'N' : St := 'Novice';
                      else  St := 'Unknown';
                      End;
                      Res(' Licence: ' + St + ' (' + Str + ')');
                      If GetStr(195,Str)
                        then Begin
                             If GetStr(196,St)
                               then Str := Str + ' - expires: ' + St;
                             Res(' Issued:  ' + Str);
                             End;
                      End;

               If GetStr(199,Str) then Res(' Time zone:  ' + Str);
               If GetStr(201,Str) then Begin
                                       St := '';
                                       {$IFDEF Clusse}
                                       If GetStr(200,St)
                                         then Begin
                                              coord.Lat := Str2Real(st);
                                              coord.Long := Str2Real(str);
                                              Res(' Location:   ' + Coord2Str(coord));
                                              End;
                                       {$ELSE}
                                       If GetStr(200,St)
                                         then Str := Str + ', latitude ' + St;
                                       Res(' Location:   Longitude ' + Str + ' deg');
                                       {$ENDIF}
                                       End;

               If GetStr(202,Str) then Res(' Grid sq:    ' + Str);
               If GetStr(204,Str) then Res(' Prev. call: ' + Str);
               If GetStr(194,Str) then Res(' Birthdate:  ' + Str);
               End;

        BuckLookUp := True;
        End
   else Begin
        Res('Callsign ' + Key + ' not found on the HamCall database.');
        BuckLookUp := False;
        End;

 Dispose(Buf);

End;

 { * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

End.
