#!/bin/sh

CONFDIR=/etc/ax25/fbb
DATADIR=/var/ax25/fbb
DOSDIR=$DATADIR/fbbdos
LIBDIR=/usr/lib/fbb
SBINDIR=/usr/sbin

	echo
	echo "creating configuration tree ..."
	echo "  $CONFDIR"
	echo "  $CONFDIR/lang"
	mkdir -p $CONFDIR/lang

	echo "creating pg directory ..."
	echo "  $LIBDIR/pg"
	mkdir -p $LIBDIR/pg

	echo "creating script directory ..."
	echo "  $LIBDIR/script"
	mkdir -p $LIBDIR/script
	
	for hk in maintenance rerun end_session stop_system error_return
	do
		echo "    $LIBDIR/script/$hk"
		if [ -e $LIBDIR/script/$k ] ; then
			if [ ! -d $LIBDIR/script/$hk ] ; then
				echo "file $LIBDIR/script/$hk found and renamed $LIBDIR/script/$hk.old"
				mv $LIBDIR/script/$hk $LIBDIR/script/$hk.old
				mkdir $LIBDIR/script/$hk
			fi
		else
			mkdir -p $LIBDIR/script/$hk
		fi
	done

	echo "creating filters directory ..."
	echo "  $LIBDIR/filter"
	mkdir -p $LIBDIR/filter

	echo "creating servers directory ..."
	echo "  $LIBDIR/server"
	mkdir -p $LIBDIR/server

	echo "creating tools directory ..."
	echo "  $LIBDIR/tool"
	mkdir -p $LIBDIR/tool

	echo "creating fbbdos directory ..."
	echo "  $DOSDIR"
	echo "  $DOSDIR/yapp"
	mkdir -p $DOSDIR/yapp

	if [ ! -d $SBINDIR ] ; then
		echo "creating sbin directory ..."
		echo "  $SBINDIR"
		mkdir -p $SBINDIR
	fi
	
	echo "creating data tree ..."
	echo "  $DATADIR"
	for n in 0 1 2 3 4 5 6 7 8 9 ; do
		echo "  $DATADIR/mail/mail$n"
		mkdir -p $DATADIR/mail/mail$n
	done

	for n in 0 1 2 3 4 5 6 7 8 9 ; do
		echo "  $DATADIR/binmail/mail$n"
		mkdir -p $DATADIR/binmail/mail$n
	done

	echo "  $DATADIR/docs"
	mkdir -p $DATADIR/docs
	echo "  $DATADIR/sat"
	mkdir -p $DATADIR/sat
	echo "  $DATADIR/wp"
	mkdir -p $DATADIR/wp
	echo "  $DATADIR/log"
	mkdir -p $DATADIR/log
	echo "  $DATADIR/oldmail"
	mkdir -p $DATADIR/oldmail
	
	echo "Done"


    cd etc-incoming
    for file in * */* */*/* */*/*/* ; do
     if [ -d $file ]; then # file is a directory
      if [ ! -d ../etc/$file ]; then # does the target directory exist?
       mkdir -p ../etc/$file # if not, create it.   
      fi
     else
      if [ ! -r ../etc/$file ]; then # file isn't already in /etc, so copy it.
       cp -av $file ../etc/$file
      fi
     fi
    done
    cd ..
    rm -rf etc-incoming
( cd etc/ax25 ; rm -rf fbb.conf.sample )
( cd etc/ax25 ; ln -sf /usr/doc/linfbb-7.03/fbb.conf.sample fbb.conf.sample )
