
/******************************************************
 *
 * KCTT-T project.
 *
 * Jean-Paul ROUBELAT - F6FBB - jpr@f6fbb.org
 *
 * Version 0.1 14/03/99 : Initial release
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************/

/******************************************************
 *                                                    *
 * kctest.c                                           *
 *                                                    *
 * kct library test program                           *
 *                                                    *
 ******************************************************/
 
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <kctlib.h>


int main(int argc, char **argv)
{
	kctdev dev;
	double freq;
	int rig;
	
	if (argc < 3)
	{
		fprintf(stderr, "usage : kctfr rig(1|2) frequency(MHz)\n");
		return 1;
	}
	
	rig = atoi(argv[1]);
	freq = atof(argv[2]);
	
	dev = KctOpen(0);
	if (dev == -1)
	{
		perror("Cannot open kctt0");
		return 1;
	}

	if (rig == 1)
	{
		if (KctSetFrequency(dev, KCTT_TRX1, freq * 1000.) == -1)
			fprintf(stderr, "kctfreq : frequency error (%f MHz)\n", freq);
	}
	else
	{
		if (KctSetFrequency(dev, KCTT_TRX2, freq * 1000.) == -1)
			fprintf(stderr, "kctfreq : frequency error (%f MHz)\n", freq);
	}
	
	sleep(1);
	
	KctClose(dev);
	
	return 0;
}
