
/******************************************************
 *
 * KCT-T project.
 *
 * Jean-Paul ROUBELAT - F6FBB - jpr@f6fbb.org
 *
 * Version 0.1 14/03/99 : Initial release
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************/

/******************************************************
 *                                                    *
 * kctcal.c                                           *
 *                                                    *
 * Displays the position of the rotor                 *
 *                                                    *
 ******************************************************/
 
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <kctlib.h>


int main(int ac, char **av)
{
	kctdev dev;
	kctstat kstat;
	
	dev = KctOpen(0);
	if (dev == -1)
	{
		perror("Cannot open /dev/kctt0");
		return 1;
	}

	while (1)
	{
		KctGetStatus(dev, &kstat);
		printf("\rPos : Azimuth=%-3d Elevation=%-3d Control=%02x", kstat.azim_pos, kstat.site_pos, kstat.control);
		fflush(stdout);
		sleep(1);
	}

	KctClose(dev);
	
	return 0;
}
