
/******************************************************
 *
 * KCT-T project.
 *
 * Jean-Paul ROUBELAT - F6FBB - jpr@f6fbb.org
 *
 * Version 0.1 14/03/99 : Initial release
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************/

/******************************************************
 *
 * icom.c
 *
 * icom(r) sequence generation for CI-V interface
 *
 ******************************************************/
 
#include <stdio.h>

/******************************************************
 *
 * Converts two ascii digits into a BCD byte
 *
 * Returns the converted byte
 *
 ******************************************************/
static char a2bcd (char *ptr)
{
  return (((*ptr - '0') << 4) + (*(ptr + 1) - '0'));
}

/******************************************************
 *
 * Converts the frequency into an icom(r) formatted string
 * The buffer must be large enough to hold the full string
 * Frequency is given in KHz
 * addr is the CI-V address of the rig
 *
 * Returns the length of the formatted string or -1 if error
 *
 ******************************************************/
int KctSetFrequencyIcom(char *buf, int buflen, int addr, double fr)
{
	int i;
	int pos = 0;
	int khz;
	int hz;
	char freq[20];
	
	/* Is the buffer large enough ? */
	if (buflen < 11)
		return -1;

	/* Creates the frequency string in Hz */
	khz = (int)fr;
	hz  = (int)(0.5 + 1000.0 * (fr - (double)khz));
	sprintf(freq, "%07d%03d", khz, hz);
	
	/* Preamble */
	buf[pos++] = 0xfe;
	buf[pos++] = 0xfe;
	buf[pos++] = addr;
	buf[pos++] = 0xe0;

	/* Command */
	buf[pos++] = 0x05;
	
	for (i = 8 ; i >= 0 ; i -= 2)
		buf[pos++] = a2bcd(freq+i);

	/* End of message */
	buf[pos++] = 0xfd;
	
	return pos;
}

