#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/kct.h>

int set_baud(int fd, int port, int baud)
{
	unsigned char buf[4];
	buf[0] = port;
	buf[1] = KCT_SETBAUD;
	buf[2] = 1;
	buf[3] = baud;	
	return write(fd, buf, 4);
}

int set_brake(int fd, int port, int tempo_rel, int tempo_set)
{
	int nb;
	unsigned char buf[4];
	buf[0] = port;
	buf[1] = KCT_RELBRAKE;
	buf[2] = 1;
	buf[3] = tempo_rel;	
	nb = write(fd, buf, 4);
	if (nb != 4)
		return nb;
		
	buf[0] = port;
	buf[1] = KCT_SETBRAKE;
	buf[2] = 1;
	buf[3] = tempo_set;	
	return write(fd, buf, 4);
}

int set_slew(int fd, int port, int val)
{
	unsigned char buf[4];
	buf[0] = port;
	buf[1] = KCT_SETSLEW;
	buf[2] = 1;
	buf[3] = val;	
	return write(fd, buf, 4);
}

int a2bcd (char *ptr)
{
  return (((*ptr - '0') << 4) + (*(ptr + 1) - '0'));
}

int set_frequency(int fd, int port, int addr, char *freq, int verbose)
{
	int i;
	int pos;
	unsigned char buf[20];

	/* Message header */
	buf[0] = port;
	buf[1] = KCT_SENDTRX;
	buf[2] = 11;
	
	/* Preamble */
	buf[3] = 0xfe;
	buf[4] = 0xfe;
	buf[5] = (unsigned char)addr;
	buf[6] = 0xe0;

	/* Command */
	buf[7] = 0x05;
	
	pos = 8;
	
	for (i = 8 ; i >= 0 ; i -= 2)
	/* for (i = 0 ; i < 10 ; i += 2) */
		buf[pos++] = a2bcd(freq+i);

	/* End of message */
	buf[13] = 0xfd;
	
	if (verbose)
		printf("Set frequency=%s port%d add=%d\n", freq, port, addr);
	
	return write(fd, buf, 14);
}

int set_position(int fd, int rotor, int pos, int verbose)
{
	unsigned char buf[4];

	if (pos < 0 || pos > 255)
		return -1;
		
	buf[0] = rotor;
	buf[1] = 0;
	buf[2] = 1;
	buf[3] = (unsigned char)pos;

	if (verbose)
		printf("Set position rotor=%d position=%d\n", rotor, pos);
	
	return write(fd, buf, 4);
}

int get_status(int fd, int verbose)
{
	int ret;
	unsigned char buf[12];

	ret = read(fd, buf, 12);
	if (ret != 12)
	{
		printf("read=%d control=%02x\n", ret, buf[3]);
		return -1;
	}
	
	if (verbose)
	{
		printf("read=%d control=%02x\n", ret, buf[3]);
		printf("site:\tpos=%3u\tslew=%3u\tbrel=%3u\tbset=%3u\n", buf[4], buf[5], buf[6], buf[7]);
		printf("azim:\tpos=%3u\tslew=%3u\tbrel=%3u\tbset=%3u\n", buf[8], buf[9], buf[10], buf[11]);
	}
	
	return 0xff & (int)buf[3];
}

main(int ac, char **av)
{
	int fd;
	int ret;
	
	fd = open("/dev/kct0", O_RDWR);
	if (fd == -1)
	{
		fprintf(stderr, "Cannot open kct device\n");
		return 1;
	}

	/* Baud rates = 1200 Bds */
	set_baud(fd, KCT_TRX1, KCT_B1200);
	set_baud(fd, KCT_TRX2, KCT_B1200);
	
	/* ic275 */
	/*set_frequency(fd, KCT_TRX2, 0x10, "0144111100", 1);
	sleep(1);
	set_frequency(fd, KCT_TRX2, 0x10, "0144222200", 1);
	sleep(1);
	set_frequency(fd, KCT_TRX2, 0x10, "0144333300", 1);
	sleep(1);
	set_frequency(fd, KCT_TRX1, 0x14, "0430111100", 1);
	sleep(1);
	set_frequency(fd, KCT_TRX1, 0x14, "0430222200", 1);
	sleep(1);
	set_frequency(fd, KCT_TRX1, 0x14, "0430333300", 1);
	sleep(1);
	*/
	
	set_brake(fd, KCT_AZIMUTH, 0, 100);	 
	
	set_slew(fd, KCT_AZIMUTH, 4);	 
	set_slew(fd, KCT_SITE, 3);	 
	
	set_position(fd, KCT_AZIMUTH, 64, 1);	 
	/* set_position(fd, KCT_SITE, 45, 1); */
	
	while (get_status(fd, 1) & 0x7f)
		sleep(1);

	get_status(fd, 1);
	
	/* set_position(fd, KCT_AZIMUTH, 45, 1);	  */
	/* set_position(fd, KCT_SITE, 10, 1); */
	
	while (get_status(fd, 1))
		sleep(1);

	get_status(fd, 1);
	
	sleep(2);
	
	close(fd);
	
	return 0;
}
