#include <stdio.h>
#include <ctype.h>
#include <string.h>

#define PROTOTYPES 1
#include "global.h"
#include "md5.h"

#define MDPASSWD "/etc/mdpasswd"

char *get_mdpass(char *mdhost, char *mduser)
{
	FILE *fptr;
	char *p = NULL;
	char buf[80], host[80], user[80];
	static char pass[80];
	
	fptr = fopen(MDPASSWD, "r");
	if (!fptr)
		return NULL;
		
	while (fgets(buf, sizeof(buf), fptr)) {
		char *ptr = buf;
		while (isspace(*ptr))
			++ptr;
		if (!isprint(*ptr) || *ptr == '#')
			continue;
		
		/* look for [hostname] */
		if (*ptr == '[') {
			if (sscanf(ptr, "[%s %s %[^\n]", host, user, pass) == 3) {
				host[strlen(host)-1] = '\0';
				if (!strcmp(host, mdhost) && !strcmp(user, mduser)) {
					p = pass;
					break;
				}
			}
		}
	}
	
	fclose(fptr);
	
	return p;
}

void mdpass(char *mdhost, char *mduser, char *mdkey, char *rcvbuf, int *rcvcnt)
{
	char *p;
	char source[256];
	char dest[80];
	
	p = get_mdpass(mdhost, mduser);
	if (!p) {
		*rcvcnt = 0;
		return;
	}
	
	strcpy(source, mdkey);
	strcat(source, p);
	MD5String(dest, source);
	sprintf(rcvbuf, "%s\r", dest);
	*rcvcnt = strlen(rcvbuf);
}

