
#ifndef NET_USER_H
#define NET_USER_H

#include <time.h>
#include "network.h"

extern struct nuser_t *nusers;	/* Users */

extern int nuser_count;		/* How many users on the network */
extern int kuser_count;		/* How many KNOWN users on the network */
extern int nuser_max;		/* Users high water mark */
extern int kuser_max;	

extern int away_strings;	/* Away strings allocated */

/* User list handling */
void free_nusersn(struct node_t *n);

extern void net_useradd(struct nuser_t *nu);
extern void net_userdel(struct nuser_t *nu);
extern struct nuser_t *lnuser_login(struct luser_t *lu);

extern int count_users(void);			/* Update user counts */

extern struct nuser_t *get_nuser(call_t *call);			/* Find user */
extern struct nuser_t *get_nuserh(call_t *call, struct node_t *node);	/* Find user on node */
extern struct nuser_t *guess_nuser(call_t *call);		/* guess user */

extern void net_here(struct link_t *forml, call_t *call);		/* User here */
extern void net_away(struct link_t *froml, call_t *call, char *reason);	/* User away */
extern void net_userdata(struct nuser_t *nu, struct link_t *froml, 
			call_t *usercall, int type, char *data);	/* User data */


#endif
