
#include <stdlib.h>
#include <stdio.h>

#include "f_luser.h"
#include "hmalloc.h"
#include "log.h"
#include "db.h"
#include "config.h"
#include "cstring.h"
#include "csock.h"

struct db_t *luser_db = NULL;

/*
 *	Get an entry from the local user file
 */

struct luserf_t *read_luserf(call_t *call)
{
	struct luserf_t *f;
	call_t tcall;
	datum key, content;
	
	strcpy(tcall, (char *)call);
	truncssid(&tcall);
	
	key.dptr = (void *)&tcall;
	key.dsize = strlen(tcall) + 1;
	
	content = db_fetch(luser_db, key);
	if (content.dptr) {
		if (content.dsize != sizeof(struct luserf_t)) {
			log(L_ERR, "read_luserf(): OUCH, db entry of wrong size: %d != %d", content.dsize, sizeof(struct luserf_t));
			hfree(content.dptr);
			return NULL;
		}
		f = (struct luserf_t *)content.dptr;
		return f;
	}
	
	return NULL;
}

/*
 *	Write an entry to the local user file
 */

void write_luserf(struct luserf_t *fp)
{
	call_t tcall;
	datum key, content;
	
	strcpy(tcall, fp->call);
	truncssid(&tcall);
	
	key.dptr = (void *)&tcall;
	key.dsize = strlen(tcall) + 1;
	
	content.dptr = (void *)fp;
	content.dsize = sizeof(struct luserf_t);
	
	db_store(luser_db, key, content, DB_REPLACE);
}

/*
 *	Open local user file
 */
 
int open_luserf(void)
{
	luser_db = db_open(luser_f);
	if (!luser_db) {
		log(L_CRIT, "open_luserf(): db_open() failed for %s, abandon ship.", luser_f);
		exit(1);
	}
	return 0;
}

/*
 *	Close local user file
 */
 
int close_luserf(void)
{
	db_close(luser_db);
	return 0;
}

/*
 *	ulist
 */

int cmd_ulist(struct csock_t *s, int argc, char **argv)
{
	char st[80];
	datum key;
	char **l;
	int llen = 20;
	int lent = 0;
	int n, i = 0;
	
	l = hmalloc(llen * sizeof(char *));
	
	csputs(s, "Local user file list:\n");
	
	/* Read keys to a array of pointers */
	key = db_firstkey(luser_db);
	while (key.dptr) {
		key.dptr[key.dsize - 1] = '\0'; /* just to be sure. */
		if (i == llen)
			llen += 20;
		l = hrealloc(l, llen * sizeof(char *));
		l[i] = key.dptr;
		lent++;
		i++;
		key = db_nextkey(luser_db, key);
	}
	
	/* Sort the array */
	qsort(l, lent, sizeof(char *), (int (*)(const void *, const void *))strpcmp);
	
	/* Print the array and free the data*/
	st[0] = '\0';
	n = 0;
	for (i = 0; i < lent; i++) {
		sprintf(st + strlen(st), " %-7.7s", l[i]);
		hfree(l[i]);
		n++;
		if (n == 9) {
			csprintf(s, "%s\n", st);
			st[0] = '\0';
			n = 0;
		}
	}
	if (n) {
		csprintf(s, "%s\n", st);
		st[0] = '\0';
		n = 0;
	}
	
	hfree(l); /* free the array too */
	
	return 0;
}

